/*
 * Decompiled with CFR 0.152.
 */
package org.demoiselle.signer.serpro.desktop.web;

import com.google.gson.Gson;
import java.util.ServiceLoader;
import org.bouncycastle.util.encoders.Base64;
import org.demoiselle.signer.core.keystore.loader.configuration.Configuration;
import org.demoiselle.signer.policy.impl.cades.AttachedContentValidation;
import org.demoiselle.signer.policy.impl.cades.pkcs7.impl.CAdESChecker;
import org.demoiselle.signer.serpro.desktop.SerproSignerConfigurations;
import org.demoiselle.signer.serpro.desktop.command.Command;
import org.demoiselle.signer.serpro.desktop.command.cert.LogoutPKCS11;
import org.demoiselle.signer.serpro.desktop.command.signer.SignRequest;
import org.demoiselle.signer.serpro.desktop.exception.InterpreterException;
import org.demoiselle.signer.serpro.desktop.web.requestResponse.Request;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Execute {
    private static final Logger logger = LoggerFactory.getLogger(Execute.class);

    private boolean testValidToken(SignRequest request) {
        String token = request.getToken();
        if (token.isEmpty()) {
            return false;
        }
        CAdESChecker checker = new CAdESChecker();
        byte[] signature = Base64.decode(token);
        if (checker.checkAttachedSignature(signature).size() > 0) {
            AttachedContentValidation varAttachedContentValidation = checker.getAttached(signature, false);
            byte[] timestamp = varAttachedContentValidation.getExtractedContent();
            if (new Long(new String(timestamp)) + 100000L > System.currentTimeMillis()) {
                return true;
            }
            logger.warn("Tempo do token expirado: ");
        }
        return false;
    }

    public String executeCommand(String messageData, String hostConnected) throws Exception {
        Gson gson = new Gson();
        Request request = null;
        try {
            request = gson.fromJson(messageData, Request.class);
        }
        catch (Throwable error) {
            throw new InterpreterException(error);
        }
        SignRequest signRequest = gson.fromJson(messageData, SignRequest.class);
        if (request.getCommand().toLowerCase().contains("sign")) {
            if (!this.testValidToken(signRequest)) {
                if (signRequest.getMscapiOff().booleanValue()) {
                    if (!SerproSignerConfigurations.getInstance().isMsCAPIOff()) {
                        Configuration.getInstance().setMSCAPI_ON(false);
                        new LogoutPKCS11().doCommand((Request)null);
                    }
                } else {
                    new LogoutPKCS11().doCommand((Request)null);
                }
            }
        } else if (signRequest.getMscapiOff().booleanValue()) {
            if (!SerproSignerConfigurations.getInstance().isMsCAPIOff()) {
                Configuration.getInstance().setMSCAPI_ON(false);
                new LogoutPKCS11().doCommand((Request)null);
            }
        } else {
            new LogoutPKCS11().doCommand((Request)null);
        }
        if (request == null || request.getCommand() == null || request.getCommand().isEmpty()) {
            throw new RuntimeException("Comando n\u00e3o informado, verifique.");
        }
        String varRetorno = null;
        ServiceLoader<Command> loader = ServiceLoader.load(Command.class);
        if (loader != null) {
            for (Command commandLoaded : loader) {
                if (!commandLoaded.getCommandName().equalsIgnoreCase(request.getCommand())) continue;
                varRetorno = commandLoaded.doCommand(messageData, hostConnected);
            }
        } else {
            varRetorno = "{\"error\" : \"Comando n\u00e3o localizado, verifique com o comando List\"}";
        }
        if (!SerproSignerConfigurations.getInstance().isMsCAPIOff()) {
            Configuration.getInstance().setMSCAPI_ON(true);
        }
        return varRetorno;
    }
}

