/*
 * Decompiled with CFR 0.152.
 */
package org.demoiselle.signer.serpro.desktop.utils;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.URI;
import java.security.KeyStore;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManagerFactory;
import javax.websocket.ClientEndpointConfig;
import javax.websocket.ContainerProvider;
import javax.websocket.DeploymentException;
import javax.websocket.Endpoint;
import javax.websocket.EndpointConfig;
import javax.websocket.MessageHandler;
import javax.websocket.Session;
import javax.websocket.WebSocketContainer;
import org.demoiselle.signer.serpro.desktop.cert.CertitficateHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WSConnection {
    private Session globalSession;
    private WebSocketContainer container = ContainerProvider.getWebSocketContainer();
    private ClientEndpointConfig config;
    private static final Logger logger = LoggerFactory.getLogger(WSConnection.class);

    public WSConnection() throws Exception {
        KeyStore localKeyStore = KeyStore.getInstance("PKCS12");
        FileInputStream is = new FileInputStream(new File(CertitficateHelper.HOST_KEYSTORE_PATH.toString()));
        localKeyStore.load(is, CertitficateHelper.PASS);
        this.config = ClientEndpointConfig.Builder.create().build();
        KeyManagerFactory kmf = KeyManagerFactory.getInstance("SunX509");
        kmf.init(localKeyStore, CertitficateHelper.PASS);
        TrustManagerFactory tmf = TrustManagerFactory.getInstance("SunX509");
        tmf.init(localKeyStore);
        SSLContext sslContext = SSLContext.getInstance("TLS");
        sslContext.init(kmf.getKeyManagers(), tmf.getTrustManagers(), null);
        this.config.getUserProperties().put("io.undertow.websocket.SSL_CONTEXT", sslContext);
    }

    public void connect(Endpoint endpoint, String strUri) throws DeploymentException, IOException {
        URI uri = URI.create(strUri);
        this.container.connectToServer(endpoint, this.config, uri);
    }

    public void wtiteMessage(String message) throws IOException {
        this.globalSession.getBasicRemote().sendText(message);
    }

    public Endpoint getOpenToolsEndpoint() {
        Endpoint endpoint = new Endpoint(){

            @Override
            public void onOpen(Session session, EndpointConfig config) {
                WSConnection.this.globalSession = session;
                try {
                    session.addMessageHandler(new MessageHandler.Whole<String>(){

                        @Override
                        public void onMessage(String message) {
                            if (message.contains("showed")) {
                                System.exit(0);
                            }
                        }
                    });
                    String command = "{\"command\": \"tools\",\"action\": \"show\"}";
                    session.getBasicRemote().sendText(command);
                    logger.info("WSConnection chamando o servi\u00e7o " + command);
                }
                catch (IOException e) {
                    logger.error("Erro na abertura da sess\u00e3o WS:  " + e.getMessage());
                }
            }
        };
        return endpoint;
    }
}

