/*
 * Decompiled with CFR 0.152.
 */
package org.demoiselle.signer.serpro.desktop.utils;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Properties;
import org.demoiselle.signer.serpro.desktop.AppVersion;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UtilInfo {
    private static final Logger logger = LoggerFactory.getLogger(UtilInfo.class);

    public static void logSystemInfo() {
        try {
            logger.info("Vers\u00e3o do Assinador Serpro: {}", (Object)AppVersion.VERSION);
        }
        catch (Exception e) {
            logger.error("Erro ao obter a vers\u00e3o do Assinador Serpro", e);
        }
        try {
            logger.info("Vers\u00e3o do Java: {}", (Object)System.getProperty("java.version"));
        }
        catch (Exception e) {
            logger.error("Erro ao obter a vers\u00e3o do Java", e);
        }
        try {
            Properties prop = new Properties();
            try (InputStream input = UtilInfo.class.getClassLoader().getResourceAsStream("agent-desktop.properties");){
                prop.load(input);
                logger.info("Vers\u00e3o do Demoiselle Signer: {}", (Object)prop.getProperty("signer.version"));
            }
            catch (Exception e) {
                logger.error("Erro ao ler a vers\u00e3o do Demoiselle Signer do agent-desktop.properties", e);
            }
        }
        catch (Exception e) {
            logger.error("Erro ao obter a vers\u00e3o do Demoiselle Signer", e);
        }
        try {
            logger.info("Processador: {}", (Object)System.getProperty("os.arch"));
        }
        catch (Exception e) {
            logger.error("Erro ao obter a arquitetura do processador", e);
        }
        try {
            String osName = System.getProperty("os.name");
            String osVersion = System.getProperty("os.version");
            logger.info("Sistema Operacional: {} {}", (Object)osName, (Object)osVersion);
            if (osName.toLowerCase().contains("linux")) {
                if (!UtilInfo.logFileContent("/etc/os-release")) {
                    UtilInfo.executeCommand("lsb_release", "-a");
                }
                UtilInfo.logDesktopEnvironment();
            } else if (osName.toLowerCase().contains("windows")) {
                UtilInfo.executeCommand("systeminfo");
            } else if (osName.toLowerCase().contains("mac")) {
                UtilInfo.executeCommand("sw_vers");
            }
        }
        catch (Exception e) {
            logger.error("Erro ao obter as informa\u00e7\u00f5es do sistema operacional", e);
        }
    }

    private static void logDesktopEnvironment() {
        try {
            String desktop = System.getenv("XDG_CURRENT_DESKTOP");
            if (desktop != null && !desktop.isEmpty()) {
                logger.info("Ambiente Gr\u00e1fico: {}", (Object)desktop);
                String command = "";
                if (desktop.toLowerCase().contains("gnome")) {
                    command = "gnome-shell --version";
                } else if (desktop.toLowerCase().contains("kde")) {
                    command = "plasmashell --version";
                }
                if (!command.isEmpty()) {
                    UtilInfo.executeCommand(command.split(" "));
                }
            }
        }
        catch (Exception e) {
            logger.error("Erro ao obter o ambiente gr\u00e1fico", e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static boolean logFileContent(String filePath) {
        File file = new File(filePath);
        if (!file.exists()) {
            return false;
        }
        try (BufferedReader reader = new BufferedReader(new FileReader(file));){
            String line;
            logger.info("Informa\u00e7\u00f5es de {}:", (Object)filePath);
            while ((line = reader.readLine()) != null) {
                logger.info("   {}", (Object)line);
            }
            boolean bl = true;
            return bl;
        }
        catch (Exception e) {
            logger.error("Erro ao ler o arquivo de informa\u00e7\u00f5es do SO: " + filePath, e);
            return false;
        }
    }

    private static void executeCommand(String ... command) {
        try {
            String line;
            Process process = new ProcessBuilder(command).start();
            BufferedReader reader = new BufferedReader(new InputStreamReader(process.getInputStream()));
            logger.info("Informa\u00e7\u00f5es do comando '{}':", (Object)String.join((CharSequence)" ", command));
            while ((line = reader.readLine()) != null) {
                logger.info("   {}", (Object)line);
            }
        }
        catch (Exception e) {
            logger.error("Erro ao executar o comando: " + String.join((CharSequence)" ", command), e);
        }
    }
}

