/*
 * Decompiled with CFR 0.152.
 */
package org.demoiselle.signer.serpro.desktop.utils;

import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.URL;
import java.security.SecureRandom;
import java.security.cert.X509Certificate;
import java.util.Base64;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;

public class TimeStampRequestUtil {
    public String[] requestToken(String url, String clientId, String clientSecret, boolean validarCertificado) {
        try {
            String inputLine;
            URL obj = new URL(url);
            HttpsURLConnection con = (HttpsURLConnection)obj.openConnection();
            if (!validarCertificado) {
                TrustManager[] trustAllCerts = new TrustManager[]{new X509TrustManager(){

                    @Override
                    public X509Certificate[] getAcceptedIssuers() {
                        return null;
                    }

                    @Override
                    public void checkClientTrusted(X509Certificate[] certs, String authType) {
                    }

                    @Override
                    public void checkServerTrusted(X509Certificate[] certs, String authType) {
                    }
                }};
                SSLContext sc = SSLContext.getInstance("TLSv1.2");
                sc.init(null, trustAllCerts, new SecureRandom());
                con.setSSLSocketFactory(sc.getSocketFactory());
            }
            con.setRequestMethod("POST");
            con.setDoOutput(true);
            String auth = clientId + ":" + clientSecret;
            String encodedAuth = Base64.getEncoder().encodeToString(auth.getBytes("UTF-8"));
            con.setRequestProperty("Content-Type", "application/x-www-form-urlencoded");
            con.setRequestProperty("Authorization", "Basic " + encodedAuth);
            String urlParameters = "grant_type=client_credentials";
            OutputStream os = con.getOutputStream();
            os.write(urlParameters.getBytes("UTF-8"));
            os.flush();
            os.close();
            int responseCode = con.getResponseCode();
            System.out.println("C\u00f3digo de resposta: " + responseCode);
            BufferedReader in = new BufferedReader(new InputStreamReader(con.getInputStream()));
            StringBuffer response = new StringBuffer();
            while ((inputLine = in.readLine()) != null) {
                response.append(inputLine);
            }
            in.close();
            System.out.println("Resposta:");
            System.out.println(response.toString());
            JsonObject jsonResponse = JsonParser.parseString(response.toString()).getAsJsonObject();
            String accessToken = jsonResponse.get("access_token").getAsString();
            String scope = jsonResponse.get("scope").getAsString();
            String tokenType = jsonResponse.get("token_type").getAsString();
            int expiresIn = jsonResponse.get("expires_in").getAsInt();
            System.out.println("Expires In: " + expiresIn);
            System.out.println("Access Token: " + accessToken);
            System.out.println("Scope: " + scope);
            String[] data = new String[]{accessToken, String.valueOf(expiresIn), scope, tokenType};
            return data;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException("Erro ao fazer a requisi\u00e7\u00e3o: " + e.getMessage());
        }
    }

    public String stamp(String url, String bearerToken, String hash, boolean validarCertificado) {
        try {
            String inputLine;
            URL urlObj = new URL(url);
            HttpsURLConnection con = (HttpsURLConnection)urlObj.openConnection();
            if (!validarCertificado) {
                TrustManager[] trustAllCerts = new TrustManager[]{new X509TrustManager(){

                    @Override
                    public X509Certificate[] getAcceptedIssuers() {
                        return null;
                    }

                    @Override
                    public void checkClientTrusted(X509Certificate[] certs, String authType) {
                    }

                    @Override
                    public void checkServerTrusted(X509Certificate[] certs, String authType) {
                    }
                }};
                SSLContext sc = SSLContext.getInstance("TLSv1.2");
                sc.init(null, trustAllCerts, new SecureRandom());
                con.setSSLSocketFactory(sc.getSocketFactory());
            }
            con.setRequestMethod("POST");
            con.setDoOutput(true);
            con.setRequestProperty("Authorization", "Bearer " + bearerToken);
            con.setRequestProperty("Content-Type", "application/json");
            con.setRequestProperty("Accept", "application/json");
            String jsonInputString = "{ \"hash\": \"" + hash + "\" }";
            OutputStream os = con.getOutputStream();
            byte[] input = jsonInputString.getBytes("UTF-8");
            os.write(input, 0, input.length);
            os.flush();
            os.close();
            int responseCode = con.getResponseCode();
            if (responseCode != 200) {
                throw new RuntimeException("Erro ao requisitar carimbo do tempo (desenv): HTTP " + responseCode);
            }
            BufferedReader in = new BufferedReader(new InputStreamReader(con.getInputStream(), "UTF-8"));
            StringBuilder response = new StringBuilder();
            while ((inputLine = in.readLine()) != null) {
                response.append(inputLine);
            }
            in.close();
            JsonObject jsonResponse = JsonParser.parseString(response.toString()).getAsJsonObject();
            String stamp = jsonResponse.get("stamp").getAsString();
            return stamp;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException("Erro ao requisitar carimbo do tempo (desenv): " + e.getMessage());
        }
    }
}

