/*
 * Decompiled with CFR 0.152.
 */
package org.demoiselle.signer.serpro.desktop.utils;

import java.io.IOException;
import org.apache.pdfbox.cos.COSArray;
import org.apache.pdfbox.cos.COSBase;
import org.apache.pdfbox.cos.COSDictionary;
import org.apache.pdfbox.cos.COSName;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.common.COSObjectable;
import org.apache.pdfbox.pdmodel.interactive.digitalsignature.PDSignature;

public class PDFBoxUtil {
    public static final int VALOR_DOC_MDP_PERMITE_EDICAO = 2;

    private PDFBoxUtil() {
    }

    public static boolean isPdfFreeForEditionByDocMDP(PDDocument pdOriginal) throws IOException {
        return pdOriginal.getVersion() < 1.5f || pdOriginal.getSignatureDictionaries().isEmpty() || PDFBoxUtil.getMDPPermission(pdOriginal) != 1;
    }

    public static void addDocMDPValue2IfNecessary(PDDocument doc, PDSignature pdfSignature) throws IOException {
        if (doc.getVersion() >= 1.5f && doc.getSignatureDictionaries().isEmpty() && PDFBoxUtil.getMDPPermission(doc) == 0) {
            PDFBoxUtil.setMDPPermission(doc, pdfSignature, 2);
        }
    }

    private static int getMDPPermission(PDDocument doc) {
        COSDictionary permsDict = doc.getDocumentCatalog().getCOSObject().getCOSDictionary(COSName.PERMS);
        if (permsDict == null) {
            return 0;
        }
        COSDictionary signatureDict = permsDict.getCOSDictionary(COSName.DOCMDP);
        if (signatureDict == null) {
            return 0;
        }
        COSArray refArray = signatureDict.getCOSArray(COSName.REFERENCE);
        if (refArray == null) {
            return 0;
        }
        for (int i = 0; i < refArray.size(); ++i) {
            COSDictionary sigRefDict;
            COSBase base = refArray.getObject(i);
            if (!(base instanceof COSDictionary) || !COSName.DOCMDP.equals((sigRefDict = (COSDictionary)base).getDictionaryObject(COSName.TRANSFORM_METHOD)) || !((base = sigRefDict.getDictionaryObject(COSName.TRANSFORM_PARAMS)) instanceof COSDictionary)) continue;
            COSDictionary transformDict = (COSDictionary)base;
            int accessPermissions = transformDict.getInt(COSName.P, 2);
            if (accessPermissions < 1 || accessPermissions > 3) {
                return 2;
            }
            return accessPermissions;
        }
        return 0;
    }

    private static void setMDPPermission(PDDocument doc, PDSignature signature, int accessPermissions) throws IOException {
        for (PDSignature sig : doc.getSignatureDictionaries()) {
            if (COSName.DOC_TIME_STAMP.equals(sig.getCOSObject().getItem(COSName.TYPE)) || !sig.getCOSObject().containsKey(COSName.CONTENTS)) continue;
            throw new IOException("DocMDP transform method not allowed if an approval signature exists");
        }
        COSDictionary sigDict = signature.getCOSObject();
        COSDictionary transformParameters = new COSDictionary();
        transformParameters.setItem(COSName.TYPE, (COSBase)COSName.TRANSFORM_PARAMS);
        transformParameters.setInt(COSName.P, accessPermissions);
        transformParameters.setName(COSName.V, "1.2");
        transformParameters.setNeedToBeUpdated(true);
        transformParameters.setDirect(true);
        COSDictionary referenceDict = new COSDictionary();
        referenceDict.setItem(COSName.TYPE, (COSBase)COSName.SIG_REF);
        referenceDict.setItem(COSName.TRANSFORM_METHOD, (COSBase)COSName.DOCMDP);
        referenceDict.setItem(COSName.DIGEST_METHOD, (COSBase)COSName.getPDFName("SHA1"));
        referenceDict.setItem(COSName.TRANSFORM_PARAMS, (COSBase)transformParameters);
        referenceDict.setNeedToBeUpdated(true);
        referenceDict.setDirect(true);
        COSArray referenceArray = new COSArray();
        referenceArray.add(referenceDict);
        sigDict.setItem(COSName.REFERENCE, (COSBase)referenceArray);
        referenceArray.setNeedToBeUpdated(true);
        referenceArray.setDirect(true);
        COSDictionary catalogDict = doc.getDocumentCatalog().getCOSObject();
        COSDictionary permsDict = new COSDictionary();
        catalogDict.setItem(COSName.PERMS, (COSBase)permsDict);
        permsDict.setItem(COSName.DOCMDP, (COSObjectable)signature);
        catalogDict.setNeedToBeUpdated(true);
        permsDict.setNeedToBeUpdated(true);
    }
}

