/*
 * Decompiled with CFR 0.152.
 */
package org.demoiselle.signer.serpro.desktop.utils;

import java.awt.Desktop;
import java.io.IOException;
import java.net.InetAddress;
import java.net.SocketException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.UnknownHostException;
import java.util.Date;
import org.apache.commons.net.ntp.NTPUDPClient;
import org.apache.commons.net.ntp.TimeInfo;
import org.apache.commons.net.ntp.TimeStamp;
import org.demoiselle.signer.serpro.desktop.SerproSignerConfigurations;
import org.demoiselle.signer.serpro.desktop.ui.commons.SignerDialog;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NetUtil {
    private static final Logger logger = LoggerFactory.getLogger(NetUtil.class);

    public static void openLink(String parmURL) {
        try {
            if (Desktop.isDesktopSupported()) {
                try {
                    Desktop.getDesktop().browse(new URI(parmURL));
                }
                catch (IOException e1) {
                    logger.error(e1.getMessage());
                    SignerDialog.showMessageDialog(null, "N\u00e3o foi poss\u00edvel abrir o link: " + parmURL, "Erro", 0);
                }
                catch (URISyntaxException e1) {
                    logger.error(e1.getMessage());
                    SignerDialog.showMessageDialog(null, "N\u00e3o foi poss\u00edvel abrir o link: " + parmURL, "Erro", 0);
                }
            } else {
                String[] browsers = new String[]{"firefox", "x-www-browser", "google-chrome", "opera", "epiphany", "konqueror", "conkeror", "midori", "kazehakase", "mozilla"};
                Runtime rt = Runtime.getRuntime();
                StringBuffer cmd = new StringBuffer();
                for (int i = 0; i < browsers.length; ++i) {
                    cmd.append((i == 0 ? "" : " || ") + browsers[i] + " \"" + parmURL + "\" ");
                }
                try {
                    rt.exec(new String[]{"sh", "-c", cmd.toString()});
                }
                catch (IOException e1) {
                    logger.error(e1.getMessage());
                    SignerDialog.showMessageDialog(null, "N\u00e3o foi poss\u00edvel abrir o link: " + parmURL, "Erro", 0);
                }
            }
        }
        catch (Exception e1) {
            logger.error(e1.getMessage());
            SignerDialog.showMessageDialog(null, "N\u00e3o foi poss\u00edvel abrir o link: " + parmURL, "Erro", 0);
        }
    }

    public static Date NTPDate() {
        String SERVER_NAME = SerproSignerConfigurations.getInstance().getNtpServerWeb();
        TimeInfo timeInfo = null;
        NTPUDPClient client = new NTPUDPClient();
        client.setDefaultTimeout(10000);
        try {
            logger.debug("Conectando com" + SERVER_NAME);
            client.open();
            InetAddress hostAddr = InetAddress.getByName(SERVER_NAME);
            timeInfo = client.getTime(hostAddr);
            TimeStamp refNtpTime = timeInfo.getMessage().getReferenceTimeStamp();
            client.close();
            return refNtpTime.getDate();
        }
        catch (SocketException e) {
            logger.warn("Sem conex\u00e3o com:" + SERVER_NAME + e.getMessage());
            client.close();
        }
        catch (IOException ioe) {
            logger.warn("Erro ao consultar: " + SERVER_NAME + ioe.getMessage());
            client.close();
        }
        SERVER_NAME = SerproSignerConfigurations.getInstance().getNtpServerLocal();
        timeInfo = null;
        client.setDefaultTimeout(10000);
        try {
            logger.info("Conectando com" + SERVER_NAME);
            client.open();
            InetAddress hostAddr = InetAddress.getByName(SERVER_NAME);
            timeInfo = client.getTime(hostAddr);
            TimeStamp refNtpTime = timeInfo.getMessage().getReferenceTimeStamp();
            client.close();
            return refNtpTime.getDate();
        }
        catch (SocketException e) {
            logger.warn("Sem conex\u00e3o com:" + SERVER_NAME + e.getMessage());
            client.close();
            return null;
        }
        catch (IOException ioe) {
            logger.warn("Erro ao consultar: " + SERVER_NAME + ioe.getMessage());
            client.close();
            return null;
        }
    }

    public static String getLocalHostName() {
        try {
            return InetAddress.getLocalHost().getHostName();
        }
        catch (SecurityException | UnknownHostException ex) {
            logger.warn("N\u00e3o foi poss\u00edvel obter o hostname da m\u00e1quina: {}", (Object)ex.getMessage());
            return null;
        }
    }
}

