/*
 * Decompiled with CFR 0.152.
 */
package org.demoiselle.signer.serpro.desktop.utils;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import javax.swing.JFileChooser;
import javax.swing.filechooser.FileNameExtensionFilter;
import javax.swing.filechooser.FileSystemView;
import org.demoiselle.signer.serpro.desktop.ui.commons.SignerDialog;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileUtil {
    private static final Logger logger = LoggerFactory.getLogger(FileUtil.class);

    public static byte[] readContent(String arquivo) {
        byte[] result = null;
        try {
            File file = new File(arquivo);
            FileInputStream is = new FileInputStream(file);
            result = new byte[(int)file.length()];
            is.read(result);
            is.close();
        }
        catch (IOException ex) {
            logger.error(ex.getMessage());
        }
        return result;
    }

    public static boolean writeContent(byte[] content, String fileName) {
        boolean ret = false;
        File file = new File(fileName);
        try {
            FileOutputStream os = new FileOutputStream(file);
            os.write(content);
            os.flush();
            os.close();
            ret = true;
        }
        catch (FileNotFoundException e) {
            logger.error(e.getMessage());
        }
        catch (IOException e) {
            logger.error(e.getMessage());
        }
        return ret;
    }

    public static File selectA1Certificate() {
        File selectedFile = null;
        try {
            JFileChooser fileChooserCert = new JFileChooser(FileSystemView.getFileSystemView().getHomeDirectory());
            fileChooserCert.setDialogTitle("Selecione seu Certificado A1 com as extens\u00f5es: .p12 ou .pfx");
            fileChooserCert.setAcceptAllFileFilterUsed(false);
            FileNameExtensionFilter filter = new FileNameExtensionFilter("Arquivo de Certificado(.p12 ou pfx )", "p12", "P12", "pfx", "PFX");
            fileChooserCert.addChoosableFileFilter(filter);
            int returnValue = fileChooserCert.showOpenDialog(null);
            if (returnValue == 0) {
                selectedFile = fileChooserCert.getSelectedFile();
            } else if (returnValue == 1) {
                SignerDialog.showMessageDialog(null, "A\u00e7\u00e3o cancelada pelo usu\u00e1rio", "Cancelado", 1);
            }
        }
        catch (Throwable e1) {
            SignerDialog.showMessageDialog(null, "Erro", "Erro ao buscar arquivo do certificado:" + e1.getMessage(), 0);
        }
        return selectedFile;
    }
}

