/*
 * Decompiled with CFR 0.152.
 */
package org.demoiselle.signer.serpro.desktop.utils;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EnvUtil {
    private static final Logger logger = LoggerFactory.getLogger(EnvUtil.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String get(String varName) {
        String userHome = System.getProperty("user.home");
        File envFile = new File(userHome, ".env-assinador");
        if (!envFile.exists()) {
            logger.warn("Arquivo .env-assinador n\u00e3o encontrado em {}", (Object)envFile.getAbsolutePath());
            return null;
        }
        BufferedReader reader = null;
        try {
            String line;
            reader = new BufferedReader(new FileReader(envFile));
            while ((line = reader.readLine()) != null) {
                String key;
                if ((line = line.trim()).isEmpty() || line.startsWith("#")) continue;
                int idx = line.indexOf(61);
                if (idx <= 0 || !(key = line.substring(0, idx).trim()).equalsIgnoreCase(varName)) continue;
                String string = line.substring(idx + 1).trim();
                return string;
            }
        }
        catch (Exception e) {
            logger.error("Erro ao ler .envAssinador: {}", (Object)e.getMessage(), (Object)e);
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (Exception e) {
                    logger.warn("Erro ao fechar reader: {}", (Object)e.getMessage());
                }
            }
        }
        logger.info("Vari\u00e1vel '{}' n\u00e3o encontrada em {}", (Object)varName, (Object)envFile.getAbsolutePath());
        return null;
    }
}

