/*
 * Decompiled with CFR 0.152.
 */
package org.demoiselle.signer.serpro.desktop.utils;

import java.awt.Dimension;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import org.demoiselle.signer.serpro.desktop.utils.EnvUtil;

public class DebugUtil {
    private DebugUtil() {
    }

    private static boolean debugEnabled() {
        String debug = EnvUtil.get("DEBUG");
        return debug != null && !debug.isEmpty() && Boolean.parseBoolean(debug);
    }

    public static void logToFile(Object obj) {
        String message;
        if (!DebugUtil.debugEnabled()) {
            return;
        }
        if (obj == null) {
            message = "null";
        } else {
            try {
                message = obj.toString();
            }
            catch (Exception e) {
                message = "Error converting object to string: " + e.getMessage();
            }
        }
        DebugUtil.logToFile(message);
    }

    public static void logToFile(Object obj, String variableName) {
        String objectString;
        if (!DebugUtil.debugEnabled()) {
            return;
        }
        if (obj == null) {
            objectString = "null";
        } else {
            try {
                objectString = obj.toString();
            }
            catch (Exception e) {
                objectString = "Error converting object to string: " + e.getMessage();
            }
        }
        String prefix = variableName != null && !variableName.isEmpty() ? variableName + ": " : "Object: ";
        DebugUtil.logToFile(prefix + objectString);
    }

    public static void showObjectValue(Object obj) {
        String valueString;
        if (!DebugUtil.debugEnabled()) {
            return;
        }
        if (obj == null) {
            JOptionPane.showMessageDialog(null, "Object is null", "Debug Object Value", 1);
            return;
        }
        try {
            valueString = obj.toString();
        }
        catch (Exception e) {
            valueString = "Error converting object to string: " + e.getMessage();
        }
        JTextArea textArea = new JTextArea(valueString);
        textArea.setEditable(false);
        textArea.setLineWrap(true);
        textArea.setWrapStyleWord(true);
        JScrollPane scrollPane = new JScrollPane(textArea);
        scrollPane.setPreferredSize(new Dimension(400, 300));
        JDialog dialog = new JDialog();
        dialog.setAlwaysOnTop(true);
        dialog.setModal(true);
        dialog.setTitle("Debug Object Value");
        JOptionPane.showMessageDialog(dialog, scrollPane, "Debug Object Value", 1);
        dialog.dispose();
    }

    public static void showObjectValue(Object obj, String variableName) {
        String valueString;
        if (!DebugUtil.debugEnabled()) {
            return;
        }
        String dialogTitle = "Debug: " + (variableName != null && !variableName.isEmpty() ? variableName : "Object");
        if (obj == null) {
            JOptionPane.showMessageDialog(null, "Value of " + (variableName != null && !variableName.isEmpty() ? variableName : "object") + ": null", dialogTitle, 1);
            return;
        }
        try {
            valueString = obj.toString();
        }
        catch (Exception e) {
            valueString = "Error converting object to string: " + e.getMessage();
        }
        JTextArea textArea = new JTextArea(valueString);
        textArea.setEditable(false);
        textArea.setLineWrap(true);
        textArea.setWrapStyleWord(true);
        JScrollPane scrollPane = new JScrollPane(textArea);
        scrollPane.setPreferredSize(new Dimension(400, 300));
        JDialog dialog = new JDialog();
        dialog.setAlwaysOnTop(true);
        dialog.setModal(true);
        dialog.setTitle(dialogTitle);
        JOptionPane.showMessageDialog(dialog, scrollPane, dialogTitle, 1);
        dialog.dispose();
    }

    public static void logToFile(String message) {
        if (!DebugUtil.debugEnabled()) {
            return;
        }
        String homeDir = System.getProperty("user.home");
        File logFile = new File(homeDir, ".assinador-debug.log");
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS");
        String timestamp = sdf.format(new Date());
        try (FileWriter fw = new FileWriter(logFile, true);
             BufferedWriter bw = new BufferedWriter(fw);
             PrintWriter out = new PrintWriter(bw);){
            out.println(timestamp + " - " + message);
        }
        catch (IOException e) {
            System.err.println("Error writing to debug log file: " + e.getMessage());
        }
    }

    public static void logToFile(String message, Throwable throwable) {
        if (!DebugUtil.debugEnabled()) {
            return;
        }
        String homeDir = System.getProperty("user.home");
        File logFile = new File(homeDir, ".assinador-debug.log");
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS");
        String timestamp = sdf.format(new Date());
        try (FileWriter fw = new FileWriter(logFile, true);
             BufferedWriter bw = new BufferedWriter(fw);
             PrintWriter out = new PrintWriter(bw);){
            out.println(timestamp + " - " + message);
            if (throwable != null) {
                throwable.printStackTrace(out);
            }
        }
        catch (IOException e) {
            System.err.println("Error writing to debug log file: " + e.getMessage());
        }
    }
}

