/*
 * Decompiled with CFR 0.152.
 */
package org.demoiselle.signer.serpro.desktop.ui.pdf;

import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.PDPageTree;
import org.apache.pdfbox.rendering.PDFRenderer;
import org.demoiselle.signer.serpro.desktop.Main;
import org.demoiselle.signer.serpro.desktop.SerproSignerConfigurations;
import org.demoiselle.signer.serpro.desktop.command.signer.BatchSignatureContext;
import org.demoiselle.signer.serpro.desktop.ui.pdf.SignerPDF;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WebIntegratedSignature {
    private static final Logger logger = LoggerFactory.getLogger(WebIntegratedSignature.class);
    PDPageTree pages;
    private int actualPage = 0;
    BufferedImage imagePage = null;
    BufferedImage imgStamp = null;
    int posX = 0;
    int posY = 0;
    private boolean settedPositions = false;
    PDDocument doc;
    String policy = "RB";
    private byte[] byteArrayOriginalInputData = null;
    private byte[] byteArraySigned = null;
    private int[] replaceStampPos = new int[]{-1, -1};
    private int[] stampPosition = new int[]{-1, -1};
    private boolean invisibleSignature = false;
    private BatchSignatureContext batchSignatureContext;

    public WebIntegratedSignature(String parmPolicy, byte[] parmByteArrayOriginalInputData, BatchSignatureContext batchSignatureContext) {
        if (parmPolicy != null && !parmPolicy.trim().isEmpty()) {
            this.policy = parmPolicy;
        }
        this.setByteArrayOriginalInputData(parmByteArrayOriginalInputData);
        this.batchSignatureContext = batchSignatureContext;
    }

    public WebIntegratedSignature(String parmPolicy, byte[] parmByteArrayOriginalInputData, BatchSignatureContext batchSignatureContext, int parmPosX, int parmPosY, int parmPage) {
        if (parmPolicy != null && !parmPolicy.trim().isEmpty()) {
            this.policy = parmPolicy;
        }
        this.posX = parmPosX;
        this.posY = parmPosY;
        this.actualPage = parmPage - 1;
        this.settedPositions = true;
        this.setByteArrayOriginalInputData(parmByteArrayOriginalInputData);
        this.batchSignatureContext = batchSignatureContext;
    }

    public WebIntegratedSignature(String parmPolicy, byte[] parmByteArrayOriginalInputData, boolean parmInsivibleSignature, BatchSignatureContext batchSignatureContext) {
        if (parmPolicy != null && !parmPolicy.trim().isEmpty()) {
            this.policy = parmPolicy;
        }
        this.settedPositions = true;
        this.invisibleSignature = parmInsivibleSignature;
        this.setByteArrayOriginalInputData(parmByteArrayOriginalInputData);
        this.batchSignatureContext = batchSignatureContext;
    }

    private void signaturePosition() throws Exception {
        if (SerproSignerConfigurations.getInstance().isFixedStamp() && this.replaceStampPos[0] > 0) {
            int[] pos = this.replaceStampPos;
            this.posX = (int)((double)pos[0] * 2.54);
            this.posY = (int)((double)pos[1] * 2.54);
            return;
        }
        if (this.settedPositions) {
            return;
        }
        this.actualPage = this.doc.getNumberOfPages() - 1;
        PDFRenderer pdfRenderer = new PDFRenderer(this.doc);
        int STAMPW = 145;
        int STAMPH = 60;
        int color = 100;
        boolean ok = false;
        while (!ok && this.actualPage >= 0) {
            BufferedImage img = pdfRenderer.renderImage(this.actualPage);
            BufferedImage newImage = new BufferedImage(img.getWidth(), img.getHeight(), 4);
            Graphics2D g2d = newImage.createGraphics();
            g2d.drawImage((Image)img, 0, 0, null);
            int varPosX = newImage.getWidth() - 1;
            int varPosY = newImage.getHeight() - 1;
            int imgPosX = varPosX;
            int imgPosY = varPosY;
            for (int line = varPosY; line > 1; --line) {
                for (int colun = varPosX; colun > 1; --colun) {
                    for (int y = line; y > line - 60 && y > 1; --y) {
                        int val = colun - 145;
                        int x = colun;
                        while (x > val && val > 0 && x != 0) {
                            try {
                                color = newImage.getRGB(x, y);
                            }
                            catch (Exception e) {
                                logger.warn("valor de x: " + x + " e y: " + y);
                            }
                            if (color != -1) {
                                ok = false;
                                break;
                            }
                            imgPosX = x--;
                            imgPosY = y;
                            ok = true;
                        }
                        if (!ok) break;
                    }
                    if (!ok) continue;
                    this.posX = imgPosX;
                    this.posY = imgPosY;
                    pdfRenderer = null;
                    return;
                }
            }
            --this.actualPage;
        }
        pdfRenderer = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] makeSignature() throws Exception {
        ByteArrayInputStream target = new ByteArrayInputStream(this.getByteArrayOriginalInputData());
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        byte[] buf = new byte[1024];
        int n = 0;
        String msgErro = "";
        if (SerproSignerConfigurations.getInstance().isFixedStamp()) {
            this.stampPosition = SerproSignerConfigurations.getInstance().getStampPosition();
        }
        if (this.stampPosition[0] > 0) {
            this.replaceStampPos = this.stampPosition;
        }
        while ((n = target.read(buf)) >= 0) {
            baos.write(buf, 0, n);
        }
        byte[] bytes = baos.toByteArray();
        ByteArrayInputStream contentForPDF = null;
        contentForPDF = new ByteArrayInputStream(bytes);
        this.doc = PDDocument.load(contentForPDF);
        this.pages = this.doc.getPages();
        if (!this.settedPositions) {
            this.signaturePosition();
        }
        boolean hasError = false;
        try {
            Main.showLoadingScreen("");
            SignerPDF sPDF = this.invisibleSignature ? new SignerPDF(this.getByteArrayOriginalInputData(), this.policy, this.invisibleSignature, this.batchSignatureContext) : new SignerPDF(this.getByteArrayOriginalInputData(), this.actualPage, this.posX, this.posY, this.policy, this.batchSignatureContext);
            this.setByteArraySigned(sPDF.getSignerContent());
            Main.hideLoadingScreen();
            this.doc.close();
        }
        catch (IOException e2) {
            logger.error(e2.getMessage());
            msgErro = e2.getMessage();
            hasError = true;
        }
        catch (Throwable e1) {
            logger.error(e1.getMessage());
            msgErro = e1.getMessage();
            Main.hideLoadingScreen();
            hasError = true;
        }
        finally {
            if (hasError) {
                logger.error("finally do WebIntegrated");
                throw new Exception("Erro ao assinar " + msgErro);
            }
            Main.hideLoadingScreen();
        }
        return this.getByteArraySigned();
    }

    public byte[] getByteArrayOriginalInputData() {
        return this.byteArrayOriginalInputData;
    }

    public void setByteArrayOriginalInputData(byte[] byteArrayOriginalInputData) {
        this.byteArrayOriginalInputData = byteArrayOriginalInputData;
    }

    public byte[] getByteArraySigned() {
        return this.byteArraySigned;
    }

    public void setByteArraySigned(byte[] byteArraySigned) {
        this.byteArraySigned = byteArraySigned;
    }
}

