/*
 * Decompiled with CFR 0.152.
 */
package org.demoiselle.signer.serpro.desktop.ui.pdf;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import org.apache.pdfbox.cos.COSDictionary;
import org.apache.pdfbox.cos.COSName;
import org.apache.pdfbox.cos.COSString;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.encryption.InvalidPasswordException;
import org.apache.pdfbox.pdmodel.interactive.digitalsignature.PDSignature;
import org.demoiselle.signer.policy.impl.pades.pkcs7.impl.PAdESTimeStampSigner;
import org.demoiselle.signer.serpro.desktop.cert.CertitficateHelper;
import org.demoiselle.signer.serpro.desktop.statistics.Statistics;
import org.demoiselle.signer.timestamp.Timestamp;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VerifyPDFTimeStamp {
    private PDDocument document = null;
    private Timestamp varTimeStamp = null;
    private String fileName;
    private String finalFileLocalPath;
    public byte[] bufContents;
    private static Path PDF_FOLDER = Paths.get(CertitficateHelper.APP_CONF_DIR, "files");
    private static final Logger logger = LoggerFactory.getLogger(VerifyPDFTimeStamp.class);

    public VerifyPDFTimeStamp(String fileName) {
        this.fileName = fileName;
    }

    private String saveFileLocally(String fileName) throws IOException {
        if (fileName.isEmpty()) {
            throw new IOException("O arquivo n\u00e3o \u00e9 um Carimbo do Tempo ou o arquivo n\u00e3o existe");
        }
        if (!Files.exists(PDF_FOLDER, new LinkOption[0]) || !Files.isDirectory(PDF_FOLDER, new LinkOption[0])) {
            Files.createDirectories(PDF_FOLDER, new FileAttribute[0]);
        }
        Path sourcePath = Paths.get(fileName, new String[0]);
        Path targetPath = Paths.get(PDF_FOLDER.toString(), sourcePath.getFileName().toString());
        if (Files.exists(targetPath, new LinkOption[0])) {
            Files.delete(targetPath);
        }
        logger.info("Salvando o arquivo PDF localmente no caminho: " + targetPath);
        Files.copy(sourcePath, targetPath, new CopyOption[0]);
        return targetPath.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Timestamp verifyTimeStamp() throws Exception {
        Statistics instaSta = new Statistics();
        try {
            if (this.document == null) {
                throw new IOException("O arquivo n\u00e3o \u00e9 um Carimbo do Tempo ou o arquivo n\u00e3o existe");
            }
            Integer rangeMax = 0;
            Integer fileLen = (int)new File(this.finalFileLocalPath).length();
            for (PDSignature sig : this.document.getSignatureDictionaries()) {
                int[] byteRange = sig.getByteRange();
                rangeMax = byteRange[byteRange.length - 2] + byteRange[byteRange.length - 1];
                COSDictionary sigDict = sig.getCOSObject();
                COSString contents = (COSString)sigDict.getDictionaryObject(COSName.CONTENTS);
                byte[] buf = null;
                try (FileInputStream fis = new FileInputStream(this.finalFileLocalPath);){
                    buf = sig.getSignedContent(fis);
                }
                instaSta.setAction("verify-ts-PDF");
                instaSta.setLengthOriginalContent(buf.length);
                instaSta.setLengthSignature(contents.getBytes().length);
                instaSta.setStart(System.currentTimeMillis());
                PAdESTimeStampSigner varPAdESTimeStampSigner = new PAdESTimeStampSigner();
                this.setVarTimeStamp(varPAdESTimeStampSigner.checkTimeStampPDFWithContent(contents.getBytes(), buf));
                instaSta.setEnd(System.currentTimeMillis());
                if (this.getVarTimeStamp() == null) continue;
                instaSta.setSuccess(true);
                this.bufContents = contents.getBytes();
                Thread trPdfTimeStamp = new Thread(instaSta);
                trPdfTimeStamp.start();
                break;
            }
            if (fileLen > rangeMax) {
                instaSta.setSuccess(false);
                Thread trPDFTimeStamp2 = new Thread(instaSta);
                trPDFTimeStamp2.start();
                throw new Exception("Foi identificada uma modifica\u00e7\u00e3o incremental ap\u00f3s Carimbo do Tempo do PDF");
            }
        }
        finally {
            this.finishVerification();
        }
        if (this.getVarTimeStamp() == null) {
            instaSta.setSuccess(false);
            Thread trPDFTimeStamp2 = new Thread(instaSta);
            trPDFTimeStamp2.start();
            throw new Exception("Erro no Carimbo do Tempo do PDF");
        }
        return this.getVarTimeStamp();
    }

    public void finishVerification() throws IOException {
        this.document.close();
        if (Files.exists(Paths.get(this.finalFileLocalPath, new String[0]), new LinkOption[0])) {
            Files.delete(Paths.get(this.finalFileLocalPath, new String[0]));
        }
        logger.info("Finalizou o arquivo (LOCAL) [" + this.finalFileLocalPath + "]");
    }

    public byte[] getContent() {
        return this.bufContents;
    }

    public boolean testSignature() throws InvalidPasswordException, IOException {
        this.finalFileLocalPath = this.saveFileLocally(this.fileName);
        this.document = PDDocument.load(new File(this.finalFileLocalPath));
        if (this.document.getSignatureDictionaries().isEmpty()) {
            this.document.close();
            return false;
        }
        return true;
    }

    public Timestamp getVarTimeStamp() {
        return this.varTimeStamp;
    }

    public void setVarTimeStamp(Timestamp varTimeStamp) {
        this.varTimeStamp = varTimeStamp;
    }
}

