/*
 * Decompiled with CFR 0.152.
 */
package org.demoiselle.signer.serpro.desktop.ui.pdf;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.StringTokenizer;
import org.apache.pdfbox.cos.COSDictionary;
import org.apache.pdfbox.cos.COSName;
import org.apache.pdfbox.cos.COSString;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.PDResources;
import org.apache.pdfbox.pdmodel.encryption.InvalidPasswordException;
import org.apache.pdfbox.pdmodel.interactive.digitalsignature.PDSignature;
import org.apache.pdfbox.pdmodel.interactive.form.PDAcroForm;
import org.apache.pdfbox.pdmodel.interactive.form.PDField;
import org.apache.pdfbox.pdmodel.interactive.form.PDNonTerminalField;
import org.apache.pdfbox.pdmodel.interactive.form.PDSignatureField;
import org.demoiselle.signer.policy.impl.cades.SignatureInformations;
import org.demoiselle.signer.policy.impl.cades.SignerAlgorithmEnum;
import org.demoiselle.signer.policy.impl.pades.pkcs7.impl.PAdESChecker;
import org.demoiselle.signer.serpro.desktop.cert.CertitficateHelper;
import org.demoiselle.signer.serpro.desktop.statistics.Statistics;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VerifyPDFSignature {
    private PDDocument document;
    private String fileName;
    private String finalFileLocalPath = "";
    public byte[] bufContents;
    public byte[] pdfContentsFile = null;
    public Statistics instaSta = new Statistics();
    private static Path PDF_FOLDER = Paths.get(CertitficateHelper.APP_CONF_DIR, "files");
    private static final Logger logger = LoggerFactory.getLogger(VerifyPDFSignature.class);

    public VerifyPDFSignature(String fileName) {
        this.fileName = fileName;
    }

    public VerifyPDFSignature(byte[] pdfContent) throws IOException {
        this.document = PDDocument.load(pdfContent);
        this.pdfContentsFile = pdfContent;
    }

    private String saveFileLocally(String fileName) throws IOException {
        if (fileName.isEmpty()) {
            throw new IOException("arquivo inv\u00e1lido ou vazio");
        }
        if (!Files.exists(PDF_FOLDER, new LinkOption[0]) || !Files.isDirectory(PDF_FOLDER, new LinkOption[0])) {
            Files.createDirectories(PDF_FOLDER, new FileAttribute[0]);
        }
        Path sourcePath = Paths.get(fileName, new String[0]);
        Path targetPath = Paths.get(PDF_FOLDER.toString(), sourcePath.getFileName().toString());
        if (Files.exists(targetPath, new LinkOption[0])) {
            Files.delete(targetPath);
        }
        logger.info("Salvando o arquivo localmente no caminho: " + targetPath);
        Files.copy(sourcePath, targetPath, new CopyOption[0]);
        return targetPath.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<SignatureInformations> verifySignature() throws Exception {
        if (this.document == null) {
            throw new IOException("File has not signature or invalid file");
        }
        List<Object> result = new ArrayList<SignatureInformations>();
        ArrayList<SignatureInformations> results = new ArrayList<SignatureInformations>();
        logger.info("Carregando assinadoras do arquivo (LOCAL) [" + this.finalFileLocalPath + "]");
        int indexOfSignatures = 0;
        Integer rangeMax = 0;
        Integer fileLen = (int)new File(this.finalFileLocalPath).length();
        try {
            this.verifyFormFields();
            for (PDSignature sig : this.document.getSignatureDictionaries()) {
                FileInputStream fis = null;
                int[] byteRange = sig.getByteRange();
                rangeMax = byteRange[byteRange.length - 2] + byteRange[byteRange.length - 1];
                COSDictionary sigDict = sig.getCOSObject();
                COSString contents = (COSString)sigDict.getDictionaryObject(COSName.CONTENTS);
                if (!this.finalFileLocalPath.isEmpty() && this.finalFileLocalPath.length() > 1) {
                    fis = new FileInputStream(this.finalFileLocalPath);
                }
                byte[] buf = null;
                try {
                    buf = fis != null ? sig.getSignedContent(fis) : sig.getSignedContent(this.pdfContentsFile);
                }
                finally {
                    if (fis != null) {
                        fis.close();
                    }
                }
                PAdESChecker checker = new PAdESChecker();
                this.instaSta.setAction("verify-pdf");
                this.instaSta.setLengthOriginalContent(buf.length);
                this.instaSta.setLengthSignature(contents.getBytes().length);
                this.instaSta.setStart(System.currentTimeMillis());
                result.clear();
                result = checker.checkDetachedSignature(buf, contents.getBytes());
                this.instaSta.setEnd(System.currentTimeMillis());
                try {
                    SignatureInformations info = (SignatureInformations)result.iterator().next();
                    if (info.getSignaturePolicy() != null) {
                        String policy = info.getSignaturePolicy().getSignPolicyURI();
                        StringTokenizer st = new StringTokenizer(policy);
                        String part = st.nextToken("/");
                        part = st.nextToken("/");
                        part = st.nextToken("/");
                        this.instaSta.setSignaturePolicy(part);
                        this.instaSta.setAlgorithm(SignerAlgorithmEnum.getSignerOIDAlgorithmHashEnum(info.getSignaturePolicy().getSignPolicyHashAlg().getAlgorithm().getValue()).name());
                    }
                    this.instaSta.setCaURL(info.getIcpBrasilcertificate().getAuthorityInfoAccess().iterator().next());
                }
                catch (Throwable info) {
                    // empty catch block
                }
                if (result == null || result.isEmpty()) {
                    this.instaSta.setSuccess(false);
                    Thread trPdfVeri1 = new Thread(this.instaSta);
                    trPdfVeri1.start();
                    continue;
                }
                this.instaSta.setSuccess(true);
                this.bufContents = contents.getBytes();
                results.addAll(indexOfSignatures, result);
                ++indexOfSignatures;
                Thread trPdfVeri2 = new Thread(this.instaSta);
                trPdfVeri2.start();
            }
            if (fileLen > rangeMax) {
                result.clear();
                SignatureInformations varSignatureInformations = new SignatureInformations();
                LinkedList<String> validatorErrors = new LinkedList<String>();
                validatorErrors.add("Foi identificada uma modifica\u00e7\u00e3o incremental ap\u00f3s a assinatura!");
                varSignatureInformations.setValidatorErrors(validatorErrors);
                varSignatureInformations.setInvalidSignature(true);
                result.add(varSignatureInformations);
                results.addAll(indexOfSignatures, result);
            }
        }
        catch (Throwable error) {
            SignatureInformations varSignatureInformations = new SignatureInformations();
            LinkedList<String> validatorErrors = new LinkedList<String>();
            validatorErrors.add(error.getMessage());
            varSignatureInformations.setValidatorErrors(validatorErrors);
            varSignatureInformations.setInvalidSignature(true);
            result.add(varSignatureInformations);
            results.addAll(indexOfSignatures, result);
            ++indexOfSignatures;
            return indexOfSignatures;
        }
        finally {
            this.finishVerification();
            if (results != null && !results.isEmpty()) {
                return results;
            }
        }
        return results;
    }

    public String getFileName() {
        return this.fileName;
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    public String getFinalFileLocalPath() {
        return this.finalFileLocalPath;
    }

    public void setFinalFileLocalPath(String finalFileLocalPath) {
        this.finalFileLocalPath = finalFileLocalPath;
    }

    public void finishVerification() throws IOException {
        this.document.close();
        if (!this.finalFileLocalPath.isEmpty() && this.finalFileLocalPath.length() > 0) {
            if (Files.exists(Paths.get(this.finalFileLocalPath, new String[0]), new LinkOption[0])) {
                Files.delete(Paths.get(this.finalFileLocalPath, new String[0]));
            }
            logger.info("Finalizou o arquivo (LOCAL) [" + this.finalFileLocalPath + "]");
        }
    }

    public byte[] getContent() {
        return this.bufContents;
    }

    public boolean testSignature() throws InvalidPasswordException, IOException {
        this.finalFileLocalPath = this.saveFileLocally(this.fileName);
        this.document = PDDocument.load(new File(this.finalFileLocalPath));
        if (this.document.getSignatureDictionaries().isEmpty()) {
            this.document.close();
            return false;
        }
        return true;
    }

    private List<String> verifyFormFields() {
        ArrayList<String> retList = new ArrayList<String>();
        PDAcroForm acroForm = this.document.getDocumentCatalog().getAcroForm();
        if (acroForm != null) {
            try {
                if (this.document.getSignatureFields().size() == acroForm.getFields().size()) {
                    return retList;
                }
            }
            catch (IOException e) {
                logger.error("Erro verifica\u00e7\u00e3o formul\u00e1rio: " + e.getMessage());
            }
            PDResources resources = new PDResources();
            acroForm.setDefaultResources(resources);
            ArrayList<PDField> fields = new ArrayList<PDField>(acroForm.getFields());
            this.verifyFormFields(fields, resources, retList);
        }
        return retList;
    }

    private void verifyFormFields(List<PDField> fields, PDResources resources, List<String> invalidFields) {
        for (PDField f : fields) {
            if (f instanceof PDSignatureField) {
                return;
            }
            try {
                if (!f.isReadOnly()) {
                    invalidFields.add(f.getValueAsString());
                }
            }
            catch (Exception e) {
                logger.error("Erro na valida\u00e7\u00e3o do formul\u00e1rio: " + e.getMessage());
            }
            if (!(f instanceof PDNonTerminalField)) continue;
            this.verifyFormFields(((PDNonTerminalField)f).getChildren(), resources, invalidFields);
        }
    }
}

