/*
 * Decompiled with CFR 0.152.
 */
package org.demoiselle.signer.serpro.desktop.ui.pdf;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.PrivateKey;
import java.security.cert.Certificate;
import java.util.Calendar;
import org.apache.pdfbox.cos.COSName;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.interactive.digitalsignature.PDSignature;
import org.apache.pdfbox.pdmodel.interactive.digitalsignature.SignatureInterface;
import org.bouncycastle.asn1.ASN1InputStream;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.ASN1Set;
import org.bouncycastle.asn1.cms.Attribute;
import org.demoiselle.signer.policy.impl.cades.pkcs7.impl.CAdESTimeStampSigner;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TimestampPDF
implements SignatureInterface {
    private static final Logger logger = LoggerFactory.getLogger(TimestampPDF.class);
    private PrivateKey privateKey;
    private Certificate[] chain;
    private PDDocument document;

    public TimestampPDF(PDDocument document, PrivateKey privateKey, Certificate[] chain) {
        this.document = document;
        this.privateKey = privateKey;
        this.chain = chain;
    }

    public void toStamp(OutputStream outputStream) throws IOException {
        PDSignature signature = new PDSignature();
        signature.setType(COSName.DOC_TIME_STAMP);
        signature.setFilter(PDSignature.FILTER_ADOBE_PPKLITE);
        signature.setSubFilter(COSName.getPDFName("ETSI.RFC3161"));
        signature.setSignDate(Calendar.getInstance());
        signature.setReason("Assinador Serpro");
        this.document.addSignature(signature, this);
        this.document.saveIncremental(outputStream);
        this.document.close();
    }

    @Override
    public byte[] sign(InputStream inputStream) throws IOException {
        try {
            int nRead;
            CAdESTimeStampSigner timeStampSigner = new CAdESTimeStampSigner();
            timeStampSigner.setCertificates(this.chain);
            timeStampSigner.setPrivateKey(this.privateKey);
            ByteArrayOutputStream buffer = new ByteArrayOutputStream();
            byte[] data = new byte[16384];
            while ((nRead = inputStream.read(data, 0, data.length)) != -1) {
                buffer.write(data, 0, nRead);
            }
            buffer.flush();
            byte[] content = buffer.toByteArray();
            byte[] timeStampForContent = timeStampSigner.doTimeStampForContent(content);
            ASN1InputStream ais = new ASN1InputStream(new ByteArrayInputStream(timeStampForContent));
            ASN1Sequence seq = (ASN1Sequence)ais.readObject();
            ais.close();
            Attribute attributeTimeStamp = new Attribute((ASN1ObjectIdentifier)seq.getObjectAt(0), (ASN1Set)seq.getObjectAt(1));
            byte[] varTimeStamp = attributeTimeStamp.getAttrValues().getObjectAt(0).toASN1Primitive().getEncoded();
            return varTimeStamp;
        }
        catch (Exception e) {
            throw new IOException(e);
        }
    }
}

