/*
 * Decompiled with CFR 0.152.
 */
package org.demoiselle.signer.serpro.desktop.ui.pdf;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.UnrecoverableKeyException;
import java.security.cert.Certificate;
import java.security.cert.CertificateExpiredException;
import java.security.cert.CertificateNotYetValidException;
import java.security.cert.X509Certificate;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import javax.imageio.ImageIO;
import org.apache.commons.io.FileUtils;
import org.apache.pdfbox.cos.COSName;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.PDResources;
import org.apache.pdfbox.pdmodel.interactive.digitalsignature.PDSignature;
import org.apache.pdfbox.pdmodel.interactive.digitalsignature.SignatureInterface;
import org.apache.pdfbox.pdmodel.interactive.digitalsignature.SignatureOptions;
import org.apache.pdfbox.pdmodel.interactive.digitalsignature.visible.PDVisibleSigProperties;
import org.apache.pdfbox.pdmodel.interactive.digitalsignature.visible.PDVisibleSignDesigner;
import org.apache.pdfbox.pdmodel.interactive.form.PDAcroForm;
import org.apache.pdfbox.pdmodel.interactive.form.PDField;
import org.apache.pdfbox.pdmodel.interactive.form.PDNonTerminalField;
import org.apache.pdfbox.pdmodel.interactive.form.PDSignatureField;
import org.demoiselle.signer.core.ca.manager.CAManager;
import org.demoiselle.signer.core.extension.BasicCertificate;
import org.demoiselle.signer.core.keystore.loader.configuration.Configuration;
import org.demoiselle.signer.core.repository.ConfigurationRepo;
import org.demoiselle.signer.core.util.MessagesBundle;
import org.demoiselle.signer.policy.engine.factory.PolicyFactory;
import org.demoiselle.signer.policy.impl.cades.SignerAlgorithmEnum;
import org.demoiselle.signer.policy.impl.pades.pkcs7.impl.PAdESSigner;
import org.demoiselle.signer.serpro.desktop.SerproSignerConfigurations;
import org.demoiselle.signer.serpro.desktop.command.cert.ListCerts;
import org.demoiselle.signer.serpro.desktop.command.cert.ListCertsRequest;
import org.demoiselle.signer.serpro.desktop.command.cert.ListCertsResponse;
import org.demoiselle.signer.serpro.desktop.command.signer.BatchSignatureContext;
import org.demoiselle.signer.serpro.desktop.command.signer.SignResponse;
import org.demoiselle.signer.serpro.desktop.exception.SerproSignerExcetion;
import org.demoiselle.signer.serpro.desktop.statistics.Statistics;
import org.demoiselle.signer.serpro.desktop.ui.ListCertificateData;
import org.demoiselle.signer.serpro.desktop.ui.commons.SignerDialog;
import org.demoiselle.signer.serpro.desktop.utils.NetUtil;
import org.demoiselle.signer.serpro.desktop.utils.PDFBoxUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SignerPDF {
    private PDVisibleSigProperties visibleSignatureProperties = null;
    private PDVisibleSignDesigner visibleSignDesigner;
    private SignatureOptions signatureOptions;
    private PrivateKey privateKey;
    private KeyStore keystore;
    protected int posX = 0;
    protected int posY = 0;
    protected int page = 0;
    protected boolean isPAdES = false;
    private BasicCertificate bc;
    private String typeSignature = "RB";
    private static final Logger logger = LoggerFactory.getLogger(SignerPDF.class);
    private File documentFile;
    private String signedFileName;
    private SerproSignerConfigurations configSigner = SerproSignerConfigurations.getInstance();
    private PDDocument docPdf = null;
    private Statistics instaSta = new Statistics();
    private boolean invisibleSignature = false;
    protected BatchSignatureContext batchSignatureContext = null;
    private SignResponse result = new SignResponse();

    public SignResponse getResult() {
        return this.result;
    }

    public void setResult(SignResponse result) {
        this.result = result;
    }

    public SignerPDF(String fileName, String signedFile, int page, int x, int y, String typeSignature, BatchSignatureContext batchSignatureContext) throws IOException {
        if (this.batchSignatureContext == null) {
            this.batchSignatureContext = batchSignatureContext;
        }
        this.posX = x;
        this.posY = y;
        this.page = page;
        this.typeSignature = typeSignature;
        this.docPdf = this.loadDocument(fileName);
        this.doSigner(fileName, signedFile, this.page, this.docPdf, this.PDFsignature(), false);
        this.docPdf.close();
    }

    public SignerPDF(String fileName, String signedFile, int page, int x, int y, String typeSignature) throws IOException {
        this.posX = x;
        this.posY = y;
        this.typeSignature = typeSignature;
        this.docPdf = this.loadDocument(fileName);
        this.doSigner(fileName, signedFile, page, this.docPdf, this.PDFsignature(), false);
        this.docPdf.close();
    }

    public SignerPDF(byte[] parmByteArrayOriginalInputData, int page, int x, int y, String typeSignature, BatchSignatureContext batchSignatureContext) throws IOException {
        if (this.batchSignatureContext == null) {
            this.batchSignatureContext = batchSignatureContext;
        }
        this.posX = x;
        this.posY = y;
        this.typeSignature = typeSignature;
        this.documentFile = new File(SerproSignerConfigurations.getPathHomeUser().toString() + File.separator + SerproSignerConfigurations.getFolderAssinador().toString() + File.separator + "pdf_original" + new Date().getTime() + ".pdf");
        FileOutputStream os = new FileOutputStream(this.documentFile);
        os.write(parmByteArrayOriginalInputData);
        os.flush();
        os.close();
        this.docPdf = this.loadDocument(this.documentFile.getAbsolutePath());
        String signedFile = SerproSignerConfigurations.getPathHomeUser().toString() + File.separator + SerproSignerConfigurations.getFolderAssinador().toString() + File.separator + "pdf_assinado" + new Date().getTime() + ".pdf";
        this.doSigner(this.documentFile.getAbsolutePath(), signedFile, page, null, this.PDFsignature(), true);
        this.documentFile.deleteOnExit();
        this.docPdf.close();
        this.docPdf = null;
        this.documentFile = null;
    }

    public SignerPDF(byte[] parmByteArrayOriginalInputData, String parmTypeSignature, boolean parmInvisivelSignature, BatchSignatureContext batchSignatureContext) throws IOException {
        if (this.batchSignatureContext == null) {
            this.batchSignatureContext = batchSignatureContext;
        }
        this.typeSignature = parmTypeSignature;
        this.invisibleSignature = parmInvisivelSignature;
        this.documentFile = new File(SerproSignerConfigurations.getPathHomeUser().toString() + File.separator + SerproSignerConfigurations.getFolderAssinador().toString() + File.separator + "pdf_original" + new Date().getTime() + ".pdf");
        FileOutputStream os = new FileOutputStream(this.documentFile);
        os.write(parmByteArrayOriginalInputData);
        os.flush();
        os.close();
        this.docPdf = this.loadDocument(this.documentFile.getAbsolutePath());
        String signedFile = SerproSignerConfigurations.getPathHomeUser().toString() + File.separator + SerproSignerConfigurations.getFolderAssinador().toString() + File.separator + "pdf_assinado" + new Date().getTime() + ".pdf";
        this.doSigner(this.documentFile.getAbsolutePath(), signedFile, this.page, null, this.PDFsignature(), true);
        this.documentFile.deleteOnExit();
        this.docPdf.close();
        this.docPdf = null;
        this.documentFile = null;
    }

    public PDSignature PDFsignature() {
        PDSignature signature = new PDSignature();
        signature.setFilter(PDSignature.FILTER_ADOBE_PPKLITE);
        signature.setSubFilter(PDSignature.SUBFILTER_ADBE_PKCS7_DETACHED);
        return signature;
    }

    protected PDDocument loadDocument(String fileName) throws IOException {
        File documentFile = new File(fileName);
        if (!documentFile.exists()) {
            throw new IOException("Document for signing does not exist");
        }
        return PDDocument.load(documentFile);
    }

    private void convertFormToFlat(List<PDField> fields, PDResources resources) {
        for (PDField f : fields) {
            String val = f.getValueAsString();
            try {
                if (f instanceof PDSignatureField) {
                    return;
                }
                f.setReadOnly(true);
                try {
                    f.setValue(val);
                }
                catch (Exception e) {
                    logger.warn("Erro ao setar valor:" + val + "\n" + e.getMessage());
                }
                if (!(f instanceof PDNonTerminalField)) continue;
                this.convertFormToFlat(((PDNonTerminalField)f).getChildren(), resources);
            }
            catch (Exception e) {
                logger.warn("Erro na convers\u00e3o do formul\u00e1rio:" + val + f.getFullyQualifiedName() + "\n" + e.getMessage());
            }
        }
    }

    public void doSigner(String fileName, String signedFile, int page, PDDocument doc, PDSignature pdfSignature, boolean fromWebsocket) throws IOException {
        String alias;
        this.signedFileName = signedFile;
        if (!fromWebsocket) {
            this.documentFile = new File(fileName);
            if (this.documentFile == null || !this.documentFile.exists()) {
                throw new IOException("Document for signing does not exist");
            }
        }
        doc = PDDocument.load(this.documentFile);
        if (this.docPdf == null) {
            this.docPdf = doc;
        }
        this.validateIfPdfIsFreeForEditionByDocMDP(doc);
        PDAcroForm acroForm = doc.getDocumentCatalog().getAcroForm();
        if (acroForm != null && doc.getSignatureFields().size() != acroForm.getFields().size()) {
            PDResources resources = new PDResources();
            acroForm.setDefaultResources(resources);
            ArrayList<PDField> fields = new ArrayList<PDField>(acroForm.getFields());
            if (!doc.getSignatureFields().isEmpty()) {
                int opt = SignerDialog.showConfirmDialog(null, "Este documento cont\u00e9m campos de formul\u00e1rio, a assinatura existente ser\u00e1 substitu\u00edda pela nova, Deseja continuar", "Formul\u00e1rios", 0);
                if (opt == 1) {
                    return;
                }
                for (int i = 0; i < doc.getSignatureFields().size(); ++i) {
                    doc.getSignatureFields().get(0).getCOSObject().clear();
                }
            }
            this.convertFormToFlat(fields, resources);
            if (acroForm.getNeedAppearances()) {
                try {
                    acroForm.getCOSObject().removeItem(COSName.NEED_APPEARANCES);
                }
                catch (Exception e) {
                    logger.error("Erro de assinatura vis\u00edvel em formul\u00e1rio: " + e.getMessage());
                }
            }
            acroForm.flatten();
            String tmpFile = System.getProperty("java.io.tmpdir") + File.separator + "flatten_file";
            doc.save(tmpFile);
            doc.close();
            this.documentFile = new File(tmpFile);
            doc = PDDocument.load(this.documentFile);
        }
        ListCertsRequest requestCert = new ListCertsRequest();
        requestCert.setUseCertFor("Assinar um Documento");
        ListCerts ls = new ListCerts();
        ListCertsResponse lr = null;
        try {
            lr = ls.doCommand(requestCert, this.batchSignatureContext);
        }
        catch (Exception e1) {
            logger.error(e1.getMessage());
            throw new RuntimeException(e1.getMessage(), e1);
        }
        if (lr.getActionCanceled()) {
            this.result.setActionCanceled(true);
            return;
        }
        if (lr.getCertificates().isEmpty()) {
            throw new RuntimeException("Nenhum certificado foi encontrado, verifique se seu token est\u00e1 conectado ao computador. Caso esteja, feche e abra novamente o Assinador.");
        }
        if (this.batchSignatureContext != null && this.batchSignatureContext.isAliasSelected()) {
            alias = this.batchSignatureContext.getAliasKeyStore();
        } else if (lr.getCertificates().size() == 1) {
            ArrayList list = (ArrayList)lr.getCertificates();
            org.demoiselle.signer.serpro.desktop.command.cert.Certificate cert = (org.demoiselle.signer.serpro.desktop.command.cert.Certificate)list.iterator().next();
            alias = cert.getAlias();
            if (this.batchSignatureContext != null) {
                this.batchSignatureContext.setAliasKeyStore(alias);
            }
        } else {
            ListCertificateData lcd = new ListCertificateData(lr);
            lcd.init();
            alias = lcd.getAlias();
            if (alias == null || alias.equals("")) {
                this.result.setActionCanceled(true);
                return;
            }
            if (this.batchSignatureContext != null) {
                this.batchSignatureContext.setAliasKeyStore(alias);
            }
        }
        String selectedAlias = alias;
        this.keystore = ls.getKeyStore();
        SignatureInterface sigInterface = this.signatureInterface(selectedAlias, ls);
        try {
            Certificate[] certChain = this.keystore.getCertificateChain(selectedAlias);
            this.bc = new BasicCertificate((X509Certificate)certChain[0]);
        }
        catch (KeyStoreException error) {
            logger.error(error.getMessage());
            throw new RuntimeException(error.getMessage(), error);
        }
        if (!this.invisibleSignature) {
            logger.info("Carregando imagem do arquivo: " + fileName);
            this.addImage(new File(fileName), page);
            logger.info("Inserindo selo");
            this.setVisibleSignatureProperties(this.bc.getName(), "Brasil", "Assinador Serpro", 0, page, true);
        }
        if (this.visibleSignatureProperties != null) {
            logger.info("visibleSignatureProperties");
            this.visibleSignatureProperties.buildSignature();
            pdfSignature.setName(this.visibleSignatureProperties.getSignerName());
            pdfSignature.setLocation(this.visibleSignatureProperties.getSignerLocation());
            pdfSignature.setReason(this.visibleSignatureProperties.getSignatureReason());
        }
        pdfSignature.setSignDate(Calendar.getInstance());
        PDFBoxUtil.addDocMDPValue2IfNecessary(doc, pdfSignature);
        if (this.visibleSignatureProperties != null && this.visibleSignatureProperties.isVisualSignEnabled()) {
            this.signatureOptions = new SignatureOptions();
            this.signatureOptions.setVisualSignature(this.visibleSignatureProperties.getVisibleSignature());
            this.signatureOptions.setPage(this.visibleSignatureProperties.getPage());
            logger.info("Assinando com selo vis\u00edvel");
            doc.addSignature(pdfSignature, sigInterface, this.signatureOptions);
        } else {
            logger.info("Assinando sem selo vis\u00edvel");
            doc.addSignature(pdfSignature, sigInterface);
        }
        FileOutputStream fos = new FileOutputStream(signedFile);
        doc.saveIncremental(fos);
        fos.close();
        doc.close();
        if (this.signatureOptions != null) {
            this.signatureOptions.close();
        }
        doc = null;
    }

    private void validateIfPdfIsFreeForEditionByDocMDP(PDDocument doc) throws IOException {
        if (!PDFBoxUtil.isPdfFreeForEditionByDocMDP(doc)) {
            throw new SerproSignerExcetion("DocMDP: O arquivo PDF escolhido foi configurado para n\u00e3o permitir edi\u00e7\u00e3o e n\u00e3o pode ser utilizado no Assinador Serpro. Informe outro arquivo PDF.");
        }
    }

    private SignatureInterface signatureInterface(String selectedAlias, ListCerts listCerts) {
        final ListCerts ls = listCerts;
        final String alias = selectedAlias;
        return new SignatureInterface(){

            @Override
            public byte[] sign(InputStream contentToSign) throws IOException {
                int nRead;
                SignerPDF.this.instaSta.setType("pdf");
                Certificate cert = null;
                try {
                    if (SignerPDF.this.configSigner.isUseCertificateFile() || SignerPDF.this.configSigner.isChooseFileCertificate()) {
                        SignerPDF.this.privateKey = (PrivateKey)SignerPDF.this.keystore.getKey(alias, ls.getPass());
                    } else {
                        SignerPDF.this.privateKey = (PrivateKey)SignerPDF.this.keystore.getKey(alias, null);
                    }
                    SignerPDF.this.instaSta.setToken(SignerPDF.this.keystore.getProvider().getName());
                    Certificate[] certChain = SignerPDF.this.keystore.getCertificateChain(alias);
                    cert = certChain[0];
                    if (cert instanceof X509Certificate) {
                        ((X509Certificate)cert).checkValidity();
                    }
                }
                catch (KeyStoreException | NoSuchAlgorithmException | UnrecoverableKeyException error) {
                    logger.error(error.getMessage());
                    throw new RuntimeException(error.getMessage(), error);
                }
                catch (CertificateExpiredException error) {
                    SimpleDateFormat formatter = new SimpleDateFormat("dd.MM.yyyy");
                    throw new RuntimeException(new MessagesBundle().getString("error.certificate.out.date", formatter.format((Object)((X509Certificate)cert).getNotBefore()), formatter.format((Object)((X509Certificate)cert).getNotAfter()), error));
                }
                catch (CertificateNotYetValidException error) {
                    logger.error(error.getMessage());
                    throw new RuntimeException(error.getMessage(), error);
                }
                if (cert == null) {
                    throw new IOException("Certificado n\u00e3o encontrado");
                }
                ByteArrayOutputStream buffer = new ByteArrayOutputStream();
                byte[] data = new byte[16384];
                while ((nRead = contentToSign.read(data, 0, data.length)) != -1) {
                    buffer.write(data, 0, nRead);
                }
                buffer.flush();
                byte[] content = buffer.toByteArray();
                SignerPDF.this.instaSta.setLengthOriginalContent(content.length);
                try {
                    Certificate[] chain = CAManager.getInstance().getCertificateChainArray((X509Certificate)cert);
                    PAdESSigner signer = new PAdESSigner();
                    if (SerproSignerConfigurations.getInstance().isLcrOff()) {
                        ConfigurationRepo.getInstance().setValidateLCR(false);
                        logger.warn("Assinando sem valida\u00e7\u00e3o de LCR!");
                    }
                    try {
                        signer.setAlgorithm(SignerAlgorithmEnum.SHA512withRSA);
                        if (Configuration.getInstance().getSO().toLowerCase().indexOf("indows") > 0) {
                            logger.info("Windows detected, Algorithm setted to SHA256");
                            signer.setAlgorithm(SignerAlgorithmEnum.SHA256withRSA);
                        }
                    }
                    catch (Exception error) {
                        signer.setAlgorithm(SignerAlgorithmEnum.DEFAULT);
                    }
                    SignerPDF.this.instaSta.setAlgorithm(signer.getAlgorithm());
                    switch (SignerPDF.this.typeSignature) {
                        case "RB": {
                            if (SignerPDF.this.isPAdES) {
                                SignerPDF.this.instaSta.setSignaturePolicy(PolicyFactory.Policies.AD_RB_PADES_1_1.name());
                                signer.setSignaturePolicy(PolicyFactory.Policies.AD_RB_PADES_1_1);
                                break;
                            }
                            SignerPDF.this.instaSta.setSignaturePolicy(PolicyFactory.Policies.AD_RB_CADES_2_3.name());
                            signer.setSignaturePolicy(PolicyFactory.Policies.AD_RB_CADES_2_3);
                            break;
                        }
                        case "RT": {
                            if (SignerPDF.this.isPAdES) {
                                SignerPDF.this.instaSta.setSignaturePolicy(PolicyFactory.Policies.AD_RT_PADES_1_1.name());
                                signer.setSignaturePolicy(PolicyFactory.Policies.AD_RT_PADES_1_1);
                                break;
                            }
                            SignerPDF.this.instaSta.setSignaturePolicy(PolicyFactory.Policies.AD_RT_CADES_2_3.name());
                            signer.setSignaturePolicy(PolicyFactory.Policies.AD_RT_CADES_2_3);
                            break;
                        }
                        case "RV": {
                            if (SignerPDF.this.isPAdES) {
                                throw new RuntimeException("Arquivos em formato PDF n\u00e3o possuem politica de Brasileira (PBAD)\n para refer\u00eancia de valida\u00e7\u00e3o");
                            }
                            SignerPDF.this.instaSta.setSignaturePolicy(PolicyFactory.Policies.AD_RV_CADES_2_3.name());
                            signer.setSignaturePolicy(PolicyFactory.Policies.AD_RV_CADES_2_3);
                            break;
                        }
                        case "RC": {
                            if (SignerPDF.this.isPAdES) {
                                SignerPDF.this.instaSta.setSignaturePolicy(PolicyFactory.Policies.AD_RC_PADES_1_2.name());
                                signer.setSignaturePolicy(PolicyFactory.Policies.AD_RC_PADES_1_2);
                                break;
                            }
                            SignerPDF.this.instaSta.setSignaturePolicy(PolicyFactory.Policies.AD_RC_CADES_2_3.name());
                            signer.setSignaturePolicy(PolicyFactory.Policies.AD_RC_CADES_2_3);
                            break;
                        }
                        case "RA": {
                            if (SignerPDF.this.isPAdES) {
                                SignerPDF.this.instaSta.setSignaturePolicy(PolicyFactory.Policies.AD_RA_PADES_1_2.name());
                                signer.setSignaturePolicy(PolicyFactory.Policies.AD_RA_PADES_1_2);
                                break;
                            }
                            SignerPDF.this.instaSta.setSignaturePolicy(PolicyFactory.Policies.AD_RA_CADES_2_4.name());
                            signer.setSignaturePolicy(PolicyFactory.Policies.AD_RA_CADES_2_4);
                            break;
                        }
                        default: {
                            if (SignerPDF.this.isPAdES) {
                                SignerPDF.this.instaSta.setSignaturePolicy(PolicyFactory.Policies.AD_RB_PADES_1_1.name());
                                signer.setSignaturePolicy(PolicyFactory.Policies.AD_RB_PADES_1_1);
                                break;
                            }
                            SignerPDF.this.instaSta.setSignaturePolicy(PolicyFactory.Policies.AD_RB_CADES_2_3.name());
                            signer.setSignaturePolicy(PolicyFactory.Policies.AD_RB_CADES_2_3);
                        }
                    }
                    signer.setPrivateKey(SignerPDF.this.privateKey);
                    signer.setCertificates(chain);
                    SignerPDF.this.instaSta.setStart(System.currentTimeMillis());
                    byte[] assinatura = signer.doDetachedSign(content);
                    SignerPDF.this.instaSta.setEnd(System.currentTimeMillis());
                    SignerPDF.this.bc = new BasicCertificate((X509Certificate)cert);
                    SignerPDF.this.instaSta.setLengthSignature(assinatura.length);
                    SignerPDF.this.instaSta.setEnd(System.currentTimeMillis());
                    try {
                        SignerPDF.this.instaSta.setCaURL(SignerPDF.this.bc.getAuthorityInfoAccess().iterator().next());
                        SignerPDF.this.instaSta.setSuccess(true);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    byte[] byArray = assinatura;
                    return byArray;
                }
                catch (Exception error) {
                    logger.error(error.getMessage());
                    throw new RuntimeException(error.getMessage(), error);
                }
                finally {
                    Thread trSignerPDF = new Thread(SignerPDF.this.instaSta);
                    trSignerPDF.start();
                }
            }
        };
    }

    private void addImage(File documentFile, int page) throws IOException {
        BufferedImage bi;
        SerproSignerConfigurations config;
        URL imageURL = null;
        imageURL = SerproSignerConfigurations.getInstance().getStampInfo() > 0 ? this.getClass().getClassLoader().getResource("images/stampExtraInfo.png") : this.getClass().getClassLoader().getResource("images/stampInfo.png");
        if (this.typeSignature.equals("RT") || this.typeSignature.equals("RV") || this.typeSignature.equals("RC") || this.typeSignature.equals("RA")) {
            imageURL = this.getClass().getClassLoader().getResource("images/stampExtraInfoTS.png");
        }
        if (!(config = SerproSignerConfigurations.getInstance()).getDefaultTheme().isEmpty()) {
            String configDefaultImage = config.getTheme().get(SerproSignerConfigurations.getInstance().getDefaultTheme() + ".image.stamp");
            if (config.getStampInfo() > 0 && config.getTheme().get(config.getDefaultTheme() + ".image.stamp.extra") != null) {
                configDefaultImage = config.getTheme().get(config.getDefaultTheme() + ".image.stamp.extra");
            }
            bi = configDefaultImage != null ? ImageIO.read(new File(configDefaultImage)) : ImageIO.read(imageURL);
        } else {
            bi = ImageIO.read(imageURL);
        }
        BufferedImage im = bi;
        String docInf = "000000000000";
        String docInfLabel = "CPF";
        try {
            if (this.bc.hasCertificatePF()) {
                docInf = this.bc.getICPBRCertificatePF().getCPF();
            }
            if (this.bc.hasCertificatePJ()) {
                docInf = this.bc.getICPBRCertificatePJ().getCNPJ();
                docInfLabel = "CNPJ";
            }
        }
        catch (Exception e) {
            logger.error(e.getMessage());
        }
        Graphics2D g2 = im.createGraphics();
        g2.setColor(new Color(0, 0, 204));
        int startX = 35;
        if (config.getStampInfo() == 3) {
            startX = 400;
        }
        if (this.typeSignature.equals("RT") || this.typeSignature.equals("RV") || this.typeSignature.equals("RC") || this.typeSignature.equals("RA")) {
            g2.setFont(new Font("SansSerif", 0, 22));
            g2.drawString("Assinado Digitalmente com Carimbo do Tempo", 35, 50);
        }
        g2.setFont(new Font("SansSerif", 1, 25));
        g2.drawString(this.bc.getName(), 35, 80);
        if (config.getStampInfo() == 1 || config.getStampInfo() == 3) {
            g2.setFont(new Font("SansSerif", 0, 25));
            g2.drawString(docInfLabel, 35, 120);
            g2.setColor(new Color(0, 0, 204));
            g2.setFont(new Font("SansSerif", 1, 25));
            g2.drawString(docInf, 35, 150);
        }
        if (config.getStampInfo() == 2 || config.getStampInfo() == 3) {
            g2.setColor(new Color(0, 0, 204));
            g2.setFont(new Font("SansSerif", 0, 25));
            g2.drawString("DATA", startX, 120);
            String varData = DateFormat.getDateInstance(2, Locale.forLanguageTag("pt-BR")).format(Calendar.getInstance().getTime());
            Date ntpDate = NetUtil.NTPDate();
            if (ntpDate == null) {
                this.addDateSource(g2, "Data obtida do computador do assinante.", startX);
                SignerDialog.showMessageDialog(null, "N\u00e3o foi poss\u00edvel consultar a data no servi\u00e7o NTP.BR , \n\n A data do selo ser\u00e1 a data do seu Computador! \n\n Caso esteja usando fun\u00e7\u00e3o com Carimbo do Tempo isso n\u00e3o \u00e9 relevante.", "Aviso!", 2);
            } else {
                this.addDateSource(g2, "Data obtida de um servidor de tempo.", startX);
                varData = DateFormat.getDateInstance(2, Locale.forLanguageTag("pt-BR")).format(ntpDate);
                logger.debug("Data NTP");
            }
            g2.setColor(new Color(0, 0, 204));
            g2.setFont(new Font("SansSerif", 1, 25));
            g2.drawString(varData, startX, 150);
        }
        this.setVisibleSignDesigner(documentFile.getAbsolutePath(), this.posX, this.posY, -80, im, page);
    }

    private void addDateSource(Graphics2D g2, String source, int xPos) {
        g2.setColor(new Color(0, 0, 204));
        g2.setFont(new Font("SansSerif", 0, 14));
        g2.drawString(source, xPos, 170);
    }

    public void setVisibleSignatureProperties(String name, String location, String reason, int preferredSize, int page, boolean visualSignEnabled) {
        this.visibleSignatureProperties = new PDVisibleSigProperties();
        this.visibleSignatureProperties = this.visibleSignatureProperties.signerName(name).signerLocation(location).signatureReason(reason).preferredSize(preferredSize).page(page).visualSignEnabled(visualSignEnabled).setPdVisibleSignature(this.visibleSignDesigner);
    }

    public void setVisibleSignDesigner(String filename, int x, int y, int zoomPercent, BufferedImage im, int page) throws IOException {
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        ImageIO.write((RenderedImage)im, "png", os);
        ByteArrayInputStream imageStream = new ByteArrayInputStream(os.toByteArray());
        this.visibleSignDesigner = new PDVisibleSignDesigner(filename, (InputStream)imageStream, page + 1);
        this.visibleSignDesigner.xAxis(x).yAxis(y).zoom(zoomPercent).adjustForRotation();
    }

    public SignerPDF() throws IOException {
    }

    public byte[] getSignerContent() throws IOException {
        byte[] result = null;
        File file = new File(this.signedFileName);
        FileInputStream is = new FileInputStream(this.signedFileName);
        result = new byte[(int)file.length()];
        is.read(result);
        is.close();
        FileUtils.deleteQuietly(file);
        return result;
    }

    public BasicCertificate getBasicCertificate() {
        return this.bc;
    }

    public void setBc(BasicCertificate bc) {
        this.bc = bc;
    }

    public Date getCertExpDate() {
        return this.bc.getAfterDate();
    }

    public String getTypeSignature() {
        return this.typeSignature;
    }

    public void setTypeSignature(String typeSignature) {
        this.typeSignature = typeSignature;
    }
}

