/*
 * Decompiled with CFR 0.152.
 */
package org.demoiselle.signer.serpro.desktop.ui.pdf;

import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.util.Date;
import java.util.Map;
import javax.imageio.ImageIO;
import javax.swing.AbstractAction;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.KeyStroke;
import javax.swing.LayoutStyle;
import javax.swing.UIManager;
import javax.swing.filechooser.FileNameExtensionFilter;
import org.apache.commons.io.FileUtils;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.PDPageTree;
import org.apache.pdfbox.pdmodel.common.PDRectangle;
import org.apache.pdfbox.pdmodel.font.PDFont;
import org.apache.pdfbox.pdmodel.interactive.annotation.PDAnnotation;
import org.apache.pdfbox.rendering.PDFRenderer;
import org.apache.pdfbox.rendering.PageDrawer;
import org.apache.pdfbox.rendering.PageDrawerParameters;
import org.apache.pdfbox.util.Matrix;
import org.apache.pdfbox.util.Vector;
import org.demoiselle.signer.core.exception.CertificateValidatorCRLException;
import org.demoiselle.signer.serpro.desktop.Main;
import org.demoiselle.signer.serpro.desktop.SerproSignerConfigurations;
import org.demoiselle.signer.serpro.desktop.exception.SerproSignerExcetion;
import org.demoiselle.signer.serpro.desktop.ui.NewToolsInterface;
import org.demoiselle.signer.serpro.desktop.ui.commons.SignerDialog;
import org.demoiselle.signer.serpro.desktop.ui.pdf.SignerPDF;
import org.demoiselle.signer.serpro.desktop.ui.pdf.SignerPDFITI;
import org.demoiselle.signer.serpro.desktop.ui.util.IconUtil;
import org.demoiselle.signer.serpro.desktop.utils.CertNotAfterWarn;
import org.demoiselle.signer.serpro.desktop.utils.PDFBoxUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NewPDFReader
extends JDialog {
    private static final long serialVersionUID = 1L;
    private static final Logger logger = LoggerFactory.getLogger(NewPDFReader.class);
    private String fileName;
    PDPageTree pages;
    private int maxPage = 0;
    private int actualPage = 0;
    private PDFRenderer renderer;
    BufferedImage imagePage = null;
    BufferedImage imgStamp = null;
    int posX = 0;
    int posY = 0;
    private int stampPage = -1;
    PDDocument doc;
    boolean isLandscape = false;
    String typeSignature = "RB";
    boolean isUsePBAD = false;
    boolean oldIterface = false;
    private JButton btnCancel;
    private JButton btnFirst;
    private JButton btnLast;
    private JButton btnNext;
    private JButton btnPrev;
    private JButton btnValidate;
    private JLabel lblImg;
    private JLabel lblStamp;
    private JLabel lblStatus;
    private JPanel pnlButtons;
    private JPanel pnlInternalContent;
    private JScrollPane pnlScrollImage;
    private JLabel txtCli;

    public NewPDFReader(String strFile, String typeSignature, boolean isITIPatern, boolean oldInterface) throws NumberFormatException {
        this.typeSignature = typeSignature;
        this.isUsePBAD = isITIPatern;
        this.oldIterface = oldInterface;
        this.PDFReader(strFile);
    }

    public NewPDFReader(String strFile, String typeSignature, boolean oldInterface) throws NumberFormatException {
        this.typeSignature = typeSignature;
        this.oldIterface = oldInterface;
        this.PDFReader(strFile);
    }

    public NewPDFReader(Dialog parent, String strFile, String typeSignature, boolean oldInterface) throws NumberFormatException {
        super(parent, true);
        this.typeSignature = typeSignature;
        this.oldIterface = oldInterface;
        this.PDFReader(strFile);
    }

    public NewPDFReader(String strFile, boolean oldInterface) throws NumberFormatException {
        this.oldIterface = oldInterface;
        this.PDFReader(strFile);
    }

    public NewPDFReader(Frame parent, String strFile, boolean oldInterface) throws NumberFormatException {
        super(parent, true);
        this.oldIterface = oldInterface;
        this.PDFReader(strFile);
    }

    public void PDFReader(String strFile) {
        IconUtil.setIcon(this);
        Main.showLoadingScreen("");
        this.setUndecorated(true);
        this.initComponents();
        this.lblImg.setText(null);
        this.lblStamp.setText(null);
        this.fileName = strFile;
        try {
            this.validateAndLoadFile();
        }
        catch (SerproSignerExcetion e) {
            Main.hideLoadingScreen();
            throw e;
        }
        catch (Exception e) {
            Main.hideLoadingScreen();
            throw new SerproSignerExcetion("Arquivo com problemas:" + e.getMessage());
        }
        UIManager.put("OptionPane.background", Color.WHITE);
        UIManager.put("Panel.background", Color.WHITE);
        this.isUsePBAD = SerproSignerConfigurations.getInstance().isUsePBAD();
        this.lblStamp.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                NewPDFReader.this.lblStamp.setBounds(0, 0, 0, 0);
                NewPDFReader.this.lblStamp.setIcon(null);
            }
        });
        this.lblImg.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                PDRectangle mediaBox;
                if (NewPDFReader.this.imgStamp == null) {
                    try {
                        Map<String, String> config = SerproSignerConfigurations.getInstance().getTheme();
                        if (!SerproSignerConfigurations.getInstance().getDefaultTheme().isEmpty()) {
                            String configDefaultImage = config.get(SerproSignerConfigurations.getInstance().getDefaultTheme() + ".image.stamp");
                            if (SerproSignerConfigurations.getInstance().getStampInfo() > 0 && config.get(SerproSignerConfigurations.getInstance().getDefaultTheme() + ".image.stamp.extra") != null) {
                                configDefaultImage = config.get(SerproSignerConfigurations.getInstance().getDefaultTheme() + ".image.stamp.extra");
                            }
                            if (configDefaultImage != null) {
                                NewPDFReader.this.imgStamp = ImageIO.read(new File(configDefaultImage));
                            }
                        } else {
                            NewPDFReader.this.imgStamp = SerproSignerConfigurations.getInstance().getStampInfo() > 0 ? ImageIO.read(this.getClass().getClassLoader().getResource("images/stampExtraInfo.png")) : ImageIO.read(this.getClass().getClassLoader().getResource("images/stampInfo.png"));
                        }
                    }
                    catch (IOException e1) {
                        logger.error(e1.getMessage());
                    }
                }
                boolean bl = NewPDFReader.this.isLandscape = (mediaBox = NewPDFReader.this.doc.getPage(NewPDFReader.this.actualPage).getMediaBox()).getWidth() > mediaBox.getHeight();
                if (NewPDFReader.this.isLandscape) {
                    float xco = NewPDFReader.this.pages.get(NewPDFReader.this.actualPage).getMediaBox().getWidth() / (float)NewPDFReader.this.imagePage.getWidth();
                    float yco = NewPDFReader.this.pages.get(NewPDFReader.this.actualPage).getMediaBox().getHeight() / (float)NewPDFReader.this.imagePage.getHeight();
                    NewPDFReader.this.posX = Math.round(xco * (float)(e.getX() - (NewPDFReader.this.lblImg.getWidth() - NewPDFReader.this.imagePage.getWidth()) / 2));
                    NewPDFReader.this.posY = Math.round(yco * (float)(e.getY() - (NewPDFReader.this.lblImg.getHeight() - NewPDFReader.this.imagePage.getHeight()) / 2));
                } else {
                    float xco = NewPDFReader.this.pages.get(NewPDFReader.this.actualPage).getMediaBox().getWidth() / (float)NewPDFReader.this.imagePage.getWidth();
                    float yco = NewPDFReader.this.pages.get(NewPDFReader.this.actualPage).getMediaBox().getHeight() / (float)NewPDFReader.this.imagePage.getHeight();
                    NewPDFReader.this.posX = Math.round(xco * (float)(e.getX() - (NewPDFReader.this.lblImg.getWidth() - NewPDFReader.this.imagePage.getWidth()) / 2));
                    NewPDFReader.this.posY = Math.round(yco * (float)(e.getY() - (NewPDFReader.this.lblImg.getHeight() - NewPDFReader.this.imagePage.getHeight()) / 2));
                }
                NewPDFReader.this.lblStamp.setIcon(new ImageIcon(NewPDFReader.this.zoom(NewPDFReader.this.imgStamp, NewPDFReader.this.actualPage, 0.197f)));
                NewPDFReader.this.lblStamp.setBounds(e.getX() + 10, e.getY() + 8, 170, 55);
                NewPDFReader.this.lblStamp.setVisible(true);
                NewPDFReader.this.stampPage = NewPDFReader.this.actualPage;
                NewPDFReader.this.btnValidate.setEnabled(true);
            }
        });
        this.btnNext.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (NewPDFReader.this.maxPage > NewPDFReader.this.actualPage + 1) {
                    NewPDFReader.this.actualPage++;
                    NewPDFReader.this.lblImg.setIcon(new ImageIcon(NewPDFReader.this.zoom()));
                    if (NewPDFReader.this.stampPage == NewPDFReader.this.actualPage) {
                        NewPDFReader.this.lblStamp.setVisible(true);
                    } else {
                        NewPDFReader.this.lblStamp.setVisible(false);
                    }
                }
            }
        });
        this.btnPrev.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (NewPDFReader.this.actualPage > 0) {
                    NewPDFReader.this.actualPage--;
                    NewPDFReader.this.lblImg.setIcon(new ImageIcon(NewPDFReader.this.zoom()));
                    if (NewPDFReader.this.stampPage == NewPDFReader.this.actualPage) {
                        NewPDFReader.this.lblStamp.setVisible(true);
                    } else {
                        NewPDFReader.this.lblStamp.setVisible(false);
                    }
                }
            }
        });
        this.btnFirst.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                NewPDFReader.this.actualPage = 0;
                NewPDFReader.this.lblImg.setIcon(new ImageIcon(NewPDFReader.this.zoom()));
                if (NewPDFReader.this.stampPage == NewPDFReader.this.actualPage) {
                    NewPDFReader.this.lblStamp.setVisible(true);
                } else {
                    NewPDFReader.this.lblStamp.setVisible(false);
                }
            }
        });
        this.btnLast.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                NewPDFReader.this.actualPage = NewPDFReader.this.maxPage - 1;
                NewPDFReader.this.lblImg.setIcon(new ImageIcon(NewPDFReader.this.zoom()));
                if (NewPDFReader.this.stampPage == NewPDFReader.this.actualPage) {
                    NewPDFReader.this.lblStamp.setVisible(true);
                } else {
                    NewPDFReader.this.lblStamp.setVisible(false);
                }
            }
        });
        AbstractAction escapeAction = new AbstractAction(){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent e) {
                NewPDFReader.this.dispose();
            }
        };
        this.btnCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (!NewPDFReader.this.oldIterface) {
                    NewToolsInterface.getInstance().setVisible(true);
                }
                NewPDFReader.this.dispose();
            }
        });
        this.getRootPane().getInputMap(2).put(KeyStroke.getKeyStroke(27, 0), "ESCAPE_KEY");
        this.getRootPane().getActionMap().put("ESCAPE_KEY", escapeAction);
        this.btnValidate.addActionListener(new ActionListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void actionPerformed(ActionEvent e) {
                NewPDFReader.this.btnValidate.setEnabled(false);
                boolean canceled = false;
                boolean hasError = false;
                String outputFileName = "none";
                if (NewPDFReader.this.lblStamp.getIcon() == null) {
                    SignerDialog.showMessageDialog(null, "Clique sobre o local na p\u00e1gina onde ser\u00e1 inserido o carimbo de assinatura", "Falha", 0);
                    NewPDFReader.this.btnValidate.setEnabled(true);
                    return;
                }
                try {
                    outputFileName = NewPDFReader.this.fileName.replaceAll("(?i).pdf$", "-assinado.pdf");
                    Main.showLoadingScreen("");
                    Date certExpDate = null;
                    if (NewPDFReader.this.isUsePBAD) {
                        logger.debug("Assinando PDF PBAD");
                        SignerPDFITI varSignerPDF_ITI = new SignerPDFITI(NewPDFReader.this.fileName, outputFileName, NewPDFReader.this.actualPage, NewPDFReader.this.posX, NewPDFReader.this.posY, NewPDFReader.this.typeSignature);
                        canceled = varSignerPDF_ITI.getResult().getActionCanceled();
                        if (!canceled) {
                            certExpDate = varSignerPDF_ITI.getCertExpDate();
                        }
                    } else {
                        logger.debug("Assinando PDF");
                        SignerPDF varSignerPDF = new SignerPDF(NewPDFReader.this.fileName, outputFileName, NewPDFReader.this.actualPage, NewPDFReader.this.posX, NewPDFReader.this.posY, NewPDFReader.this.typeSignature);
                        canceled = varSignerPDF.getResult().getActionCanceled();
                        if (!canceled) {
                            certExpDate = varSignerPDF.getCertExpDate();
                        }
                    }
                    Main.hideLoadingScreen();
                    NewPDFReader.this.doc.close();
                    NewPDFReader.this.doc = null;
                    if (!canceled) {
                        try {
                            int result = SignerDialog.showConfirmDialog(null, "O Arquivo original ser\u00e1 substitu\u00eddo pelo arquivo assinado, mas \u00e9 poss\u00edvel criar um novo, com outro nome, deseja criar?", "Criar Novo Arquivo", 0);
                            if (result == 0) {
                                JFileChooser fileChooser = new JFileChooser();
                                fileChooser.setAcceptAllFileFilterUsed(false);
                                FileNameExtensionFilter filter = new FileNameExtensionFilter("Pdf", "pdf", "PDF");
                                fileChooser.addChoosableFileFilter(filter);
                                fileChooser.setApproveButtonText("Salvar");
                                fileChooser.setFileSelectionMode(2);
                                fileChooser.setCurrentDirectory(new File(NewPDFReader.this.fileName));
                                int returnValue = fileChooser.showSaveDialog(fileChooser);
                                if (returnValue == 0) {
                                    NewPDFReader.this.fileName = fileChooser.getSelectedFile().getAbsolutePath();
                                    if (!NewPDFReader.this.fileName.toLowerCase().endsWith(".pdf")) {
                                        NewPDFReader.this.fileName = NewPDFReader.this.fileName + ".pdf";
                                    }
                                }
                            }
                            FileUtils.deleteQuietly(new File(NewPDFReader.this.fileName));
                            FileUtils.moveFile(new File(outputFileName), new File(NewPDFReader.this.fileName));
                            SignerDialog.showMessageDialog(null, "Arquivo gerado com sucesso: " + NewPDFReader.this.fileName, "Sucesso", 1);
                            CertNotAfterWarn.showWarn(certExpDate);
                        }
                        catch (Throwable error) {
                            logger.error("Ocorreu algum erro ao tentar mover o arquivo de assinatura" + error.getMessage());
                            SignerDialog.showMessageDialog(null, "Ocorreu algum erro ao tentar mover o arquivo de assinatura, verifique se o arquivo PDF n\u00e3o est\u00e1 aberto em outro programa e tente novamente", "Falha", 0);
                            hasError = true;
                            NewPDFReader.this.dispose();
                        }
                    }
                }
                catch (IOException e2) {
                    SignerDialog.showMessageDialog(null, "Ocorreu algum erro ao tentar assinar, verifique se o arquivo PDF n\u00e3o est\u00e1 aberto em outro programa e tente novamente", "Falha", 0);
                    hasError = true;
                    NewPDFReader.this.dispose();
                }
                catch (Exception e1) {
                    Main.hideLoadingScreen();
                    hasError = true;
                    File tempFile = new File(outputFileName);
                    if (tempFile != null && tempFile.exists()) {
                        tempFile.delete();
                    }
                    if (e1.getMessage() != null && e1.getMessage().toLowerCase().contains("cancel")) {
                        logger.info(e1.getMessage());
                        SignerDialog.showMessageDialog(null, "A\u00e7\u00e3o cancelada, se necess\u00e1rio tente novamente!", "Cancelado", 2);
                    } else if (e1.getCause() != null && e1.getCause() instanceof CertificateValidatorCRLException) {
                        logger.error(e1.getMessage());
                        SignerDialog.showMessageDialog(null, e1.getMessage() + "<br> Se necess\u00e1rio urg\u00eancia na assinatura, verifique as configura\u00e7\u00f5es para desabilitar essa valida\u00e7\u00e3o!", "Erro ao Assinar", 0);
                    } else if (e1.getMessage() != null) {
                        logger.error(e1.getMessage());
                        SignerDialog.showMessageDialog(null, "Ocorreu algum erro ao tentar assinar \n" + e1.getMessage(), "Falha", 0);
                    } else {
                        logger.error("Erro n\u00e3o identificado" + e1.getCause());
                        SignerDialog.showMessageDialog(null, "Ocorreu algum erro ao tentar assinar", "Falha", 0);
                    }
                }
                finally {
                    Main.hideLoadingScreen();
                    if (!hasError && !canceled) {
                        NewPDFReader.this.dispose();
                    } else {
                        NewPDFReader.this.btnValidate.setEnabled(true);
                    }
                }
            }
        });
        try {
            this.lblImg.setIcon(new ImageIcon(this.zoom()));
            this.setVisible(true);
        }
        catch (Exception e) {
            logger.error("Erro n\u00e3o identificado" + e.getCause());
            SignerDialog.showMessageDialog(null, "Ocorreu algum erro ao tentar abrir o arquivo, tente novamente", "Falha", 0);
        }
    }

    private void validateAndLoadFile() throws IOException, NumberFormatException, InterruptedException {
        File file = new File(this.fileName);
        Main.showLoadingScreen("");
        this.doc = PDDocument.load(file);
        if (!PDFBoxUtil.isPdfFreeForEditionByDocMDP(this.doc)) {
            throw new SerproSignerExcetion("DocMDP: O arquivo PDF escolhido foi configurado para n\u00e3o permitir edi\u00e7\u00e3o e n\u00e3o pode ser utilizado no Assinador Serpro.Informe outro arquivo PDF.");
        }
        int degree = this.doc.getPage(0).getRotation();
        if ((degree == 90 || degree == 270) && this.doc.getVersion() < 1.5f) {
            this.doc.setVersion(1.5f);
        }
        this.pages = this.doc.getPages();
        this.renderer = new MyPDFRenderer(this.doc);
        this.maxPage = this.doc.getNumberOfPages();
        Thread th = new Thread(new Runnable(){

            @Override
            public void run() {
                NewPDFReader.this.zoom();
            }
        });
        Thread.sleep(Long.parseLong("1000"));
        th.start();
        Main.hideLoadingScreen();
        th.interrupt();
    }

    private void initComponents() {
        Main.showLoadingScreen("");
        this.pnlScrollImage = new JScrollPane();
        this.pnlInternalContent = new JPanel();
        this.lblStamp = new JLabel();
        this.lblImg = new JLabel();
        this.pnlButtons = new JPanel();
        this.btnFirst = new JButton();
        this.btnPrev = new JButton();
        this.btnNext = new JButton();
        this.btnLast = new JButton();
        this.btnCancel = new JButton();
        this.btnValidate = new JButton();
        this.lblStatus = new JLabel();
        this.setDefaultCloseOperation(0);
        this.setMaximumSize(new Dimension(500, 600));
        this.setMinimumSize(new Dimension(500, 600));
        this.setName("frmPrincipal");
        this.setResizable(false);
        this.pnlInternalContent.setPreferredSize(new Dimension(500, 600));
        this.pnlInternalContent.setLayout(null);
        this.pnlInternalContent.setBackground(Color.DARK_GRAY);
        this.lblStamp.setText("lblStamp");
        this.pnlInternalContent.add(this.lblStamp);
        this.lblStamp.setBounds(20, 110, 100, 70);
        this.lblImg.setHorizontalAlignment(0);
        this.lblImg.setText("lblImg");
        this.lblImg.setBorder(null);
        this.pnlInternalContent.add(this.lblImg);
        this.lblImg.setBounds(10, 10, 100, 70);
        this.pnlScrollImage.setViewportView(this.pnlInternalContent);
        this.btnFirst.setText("<html>&laquo; &nbsp; Primeira </html>");
        this.btnFirst.setMinimumSize(new Dimension(115, 30));
        this.btnFirst.setPreferredSize(new Dimension(115, 30));
        this.btnFirst.setMaximumSize(new Dimension(115, 30));
        this.btnFirst.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent e) {
                NewPDFReader.this.setCursor(new Cursor(12));
            }

            @Override
            public void mouseExited(MouseEvent e) {
                NewPDFReader.this.setCursor(new Cursor(0));
            }
        });
        this.btnPrev.setText("<html>&lt; &nbsp; Anterior </html>");
        this.btnPrev.setMinimumSize(new Dimension(115, 30));
        this.btnPrev.setPreferredSize(new Dimension(115, 30));
        this.btnPrev.setMaximumSize(new Dimension(115, 30));
        this.btnPrev.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent e) {
                NewPDFReader.this.setCursor(new Cursor(12));
            }

            @Override
            public void mouseExited(MouseEvent e) {
                NewPDFReader.this.setCursor(new Cursor(0));
            }
        });
        this.btnNext.setText("<html>  Pr\u00f3xima &nbsp; &gt;</html>");
        this.btnNext.setMinimumSize(new Dimension(115, 30));
        this.btnNext.setPreferredSize(new Dimension(115, 30));
        this.btnNext.setMaximumSize(new Dimension(115, 30));
        this.btnNext.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent e) {
                NewPDFReader.this.setCursor(new Cursor(12));
            }

            @Override
            public void mouseExited(MouseEvent e) {
                NewPDFReader.this.setCursor(new Cursor(0));
            }
        });
        this.btnLast.setText("<html>  \u00daltima &nbsp;&raquo;</html>");
        this.btnLast.setMinimumSize(new Dimension(115, 30));
        this.btnLast.setPreferredSize(new Dimension(115, 30));
        this.btnLast.setMaximumSize(new Dimension(115, 30));
        this.btnLast.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent e) {
                NewPDFReader.this.setCursor(new Cursor(12));
            }

            @Override
            public void mouseExited(MouseEvent e) {
                NewPDFReader.this.setCursor(new Cursor(0));
            }
        });
        this.btnCancel.setText("Cancelar");
        this.btnCancel.setBackground(Color.RED);
        this.btnCancel.setMinimumSize(new Dimension(10, 25));
        this.btnCancel.setPreferredSize(new Dimension(100, 25));
        this.btnCancel.setMaximumSize(new Dimension(100, 25));
        this.btnCancel.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent e) {
                NewPDFReader.this.setCursor(new Cursor(12));
            }

            @Override
            public void mouseExited(MouseEvent e) {
                NewPDFReader.this.setCursor(new Cursor(0));
            }
        });
        this.btnValidate.setText("Assinar");
        this.btnValidate.setBackground(Color.GREEN);
        this.btnValidate.setMinimumSize(new Dimension(100, 25));
        this.btnValidate.setPreferredSize(new Dimension(100, 25));
        this.btnValidate.setMaximumSize(new Dimension(100, 25));
        this.btnValidate.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent e) {
                if (NewPDFReader.this.btnValidate.isEnabled()) {
                    NewPDFReader.this.setCursor(new Cursor(12));
                } else {
                    NewPDFReader.this.setCursor(new Cursor(3));
                }
            }

            @Override
            public void mouseExited(MouseEvent e) {
                NewPDFReader.this.setCursor(new Cursor(0));
            }
        });
        this.btnValidate.setEnabled(false);
        this.lblStatus.setText("P\u00e1gina 1/1");
        this.txtCli = new JLabel();
        this.txtCli.setFont(new Font("Dialog", 3, 13));
        this.txtCli.setForeground(Color.BLUE);
        this.txtCli.setText("Use o mouse e clique no local do arquivo onde deseja mostrar o selo de refer\u00eancia.");
        GroupLayout pnlButtonsLayout = new GroupLayout(this.pnlButtons);
        pnlButtonsLayout.setHorizontalGroup(pnlButtonsLayout.createParallelGroup(GroupLayout.Alignment.TRAILING).addGroup(pnlButtonsLayout.createSequentialGroup().addContainerGap().addGroup(pnlButtonsLayout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.txtCli, GroupLayout.Alignment.LEADING, -1, 641, Short.MAX_VALUE).addGroup(pnlButtonsLayout.createSequentialGroup().addGroup(pnlButtonsLayout.createParallelGroup(GroupLayout.Alignment.TRAILING).addGroup(pnlButtonsLayout.createSequentialGroup().addComponent(this.btnFirst, -1, -1, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.btnPrev, -1, 115, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.btnNext, -1, 115, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.btnLast, -1, 115, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 63, Short.MAX_VALUE)).addGroup(pnlButtonsLayout.createSequentialGroup().addComponent(this.btnValidate, -2, 142, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED))).addGroup(pnlButtonsLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.lblStatus).addComponent(this.btnCancel, -2, -1, -2)))).addGap(203)));
        pnlButtonsLayout.setVerticalGroup(pnlButtonsLayout.createParallelGroup(GroupLayout.Alignment.TRAILING).addGroup(pnlButtonsLayout.createSequentialGroup().addContainerGap().addComponent(this.txtCli, -1, 17, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(pnlButtonsLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.btnFirst, -2, -1, -2).addComponent(this.btnPrev, -2, -1, -2).addComponent(this.btnNext, -2, -1, -2).addComponent(this.btnLast, -2, -1, -2).addComponent(this.lblStatus)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(pnlButtonsLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.btnCancel, -2, -1, -2).addComponent(this.btnValidate, -1, -1, Short.MAX_VALUE)).addContainerGap()));
        this.pnlButtons.setLayout(pnlButtonsLayout);
        GroupLayout layout = new GroupLayout(this.getContentPane());
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent(this.pnlScrollImage, -2, 716, -2).addComponent(this.pnlButtons, -2, 720, -2));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.CENTER).addGroup(layout.createSequentialGroup().addComponent(this.pnlScrollImage, -1, 589, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.pnlButtons, -2, -1, -2).addContainerGap()));
        this.getContentPane().setLayout(layout);
        this.pack();
        this.setLocationRelativeTo(null);
        Main.hideLoadingScreen();
    }

    private BufferedImage zoom() {
        try {
            this.imagePage = this.renderer.renderImage(this.actualPage, 1.0f);
            this.lblImg.setSize(this.imagePage.getWidth(), this.imagePage.getHeight());
            this.pnlInternalContent.setPreferredSize(this.lblImg.getSize());
            this.lblStatus.setText("P\u00e1gina " + (this.actualPage + 1) + "/" + this.maxPage);
        }
        catch (Throwable error) {
            logger.error(error.getMessage());
        }
        return this.zoom(this.imagePage, this.actualPage, 1.0f);
    }

    private BufferedImage zoom(BufferedImage originalImage, int actualPage, float scale) {
        return this.zoom(originalImage, actualPage, scale, 0.0);
    }

    private BufferedImage zoom(BufferedImage originalImage, int actualPage, float scale, double rotate) {
        try {
            int w = Math.round((float)originalImage.getWidth() * scale);
            int h = Math.round((float)originalImage.getHeight() * scale);
            int type = originalImage.getType() == 0 ? 12 : originalImage.getType();
            BufferedImage resizedImage = new BufferedImage(w, h, type);
            Graphics2D g = resizedImage.createGraphics();
            g.drawImage(originalImage, 0, 0, w, h, null);
            g.dispose();
            g.setComposite(AlphaComposite.Src);
            g.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
            g.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
            g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            if (rotate > 0.0) {
                return NewPDFReader.rotateImage(rotate, resizedImage);
            }
            return resizedImage;
        }
        catch (Throwable error) {
            logger.error(error.getMessage());
            return null;
        }
    }

    public static BufferedImage rotateImage(double angle, BufferedImage img) {
        BufferedImage rotate = null;
        try {
            double radians = Math.toRadians(angle);
            double sin = Math.abs(Math.sin(radians));
            double cos = Math.abs(Math.cos(radians));
            int newWidth = (int)Math.round((double)img.getWidth() * cos + (double)img.getHeight() * sin);
            int newHeight = (int)Math.round((double)img.getWidth() * sin + (double)img.getHeight() * cos);
            rotate = new BufferedImage(newWidth, newHeight, 12);
            Graphics2D g2d = rotate.createGraphics();
            int x = (newWidth - img.getWidth()) / 2;
            int y = (newHeight - img.getHeight()) / 2;
            AffineTransform at = new AffineTransform();
            at.setToRotation(Math.toRadians(angle), x + img.getWidth() / 2, y + img.getHeight() / 2);
            at.translate(x, y);
            g2d.setTransform(at);
            g2d.drawImage((Image)img, 0, 0, null);
            g2d.dispose();
            return rotate;
        }
        catch (Throwable error) {
            logger.error(error.getMessage());
            return rotate;
        }
    }

    private static class MyPageDrawer
    extends PageDrawer {
        public MyPageDrawer(PageDrawerParameters parameters) throws IOException {
            super(parameters);
        }

        @Override
        protected void showGlyph(Matrix textRenderingMatrix, PDFont font, int code, String unicode, Vector displacement) throws IOException {
            super.showGlyph(textRenderingMatrix, font, code, unicode, displacement);
        }

        @Override
        public void showAnnotation(PDAnnotation annotation) throws IOException {
            this.saveGraphicsState();
            this.getGraphicsState().setNonStrokeAlphaConstant(0.35);
            super.showAnnotation(annotation);
            this.restoreGraphicsState();
        }
    }

    private static class MyPDFRenderer
    extends PDFRenderer {
        public MyPDFRenderer(PDDocument document) {
            super(document);
        }

        @Override
        protected PageDrawer createPageDrawer(PageDrawerParameters parameters) throws IOException {
            return new MyPageDrawer(parameters);
        }
    }
}

