/*
 * Decompiled with CFR 0.152.
 */
package org.demoiselle.signer.serpro.desktop.ui.crypto;

import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import javax.imageio.ImageIO;
import javax.swing.DefaultListModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import org.demoiselle.signer.serpro.desktop.Main;
import org.demoiselle.signer.serpro.desktop.cert.CertitficateHelper;
import org.demoiselle.signer.serpro.desktop.crypto.EncrypDecrypt;
import org.demoiselle.signer.serpro.desktop.ui.NewToolsInterface;
import org.demoiselle.signer.serpro.desktop.ui.crypto.CertificateSelection;
import org.demoiselle.signer.serpro.desktop.ui.crypto.DecryptFile;
import org.demoiselle.signer.serpro.desktop.ui.crypto.ImportCertificate;

public class SelectAction
extends JDialog {
    private static final long serialVersionUID = 1L;
    private static boolean oldInterface = false;
    private static SelectAction instanceSelectAction;
    DefaultListModel<String> listModel;
    JList<String> listCert;
    JScrollPane listScroller;
    String RSAKey = "";
    HashMap<String, String> hashKeys;

    public static SelectAction getInstance(boolean parmOldInterface) {
        if (instanceSelectAction == null) {
            instanceSelectAction = new SelectAction();
        }
        SelectAction.setOldInterface(parmOldInterface);
        return instanceSelectAction;
    }

    public SelectAction() {
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosed(WindowEvent e) {
                if (!oldInterface) {
                    NewToolsInterface.getInstance().setVisible(true);
                }
            }
        });
        this.initUi();
    }

    private void initUi() {
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                SelectAction.this.dispose();
            }
        });
        this.setIconImage(this.getImage("images/tools/btnSign.png").getImage());
        this.setTitle("Opera\u00e7\u00f5es seguras");
        this.setSize(220, 350);
        this.setLocationRelativeTo(null);
        this.setResizable(false);
        this.setLayout(null);
        this.setBackground(Color.white);
        final JButton btCriar = this.setButton("Criar Arquivo Seguro", "");
        JButton btAbrir = this.setButton("Abrir Arquivo Seguro", "");
        JButton btGerarChave = this.setButton("Gerar Chave", "");
        JButton btImportarChave = this.setButton("Gerenciar Chaves", "");
        JButton btCancelar = this.setButton("Cancelar", "");
        btGerarChave.setBounds(10, 20, 200, 50);
        btImportarChave.setBounds(10, 75, 200, 50);
        btCriar.setBounds(10, 130, 200, 50);
        btAbrir.setBounds(10, 185, 200, 50);
        btCancelar.setBounds(30, 250, 160, 50);
        final SelectAction me = this;
        btGerarChave.addActionListener(new ActionListener(){
            String retFileName = "";

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    EncrypDecrypt encdec = new EncrypDecrypt();
                    Main.showLoadingScreen("");
                    this.retFileName = encdec.exportPublicKey();
                    Main.hideLoadingScreen();
                }
                catch (Throwable e1) {
                    JOptionPane.showMessageDialog(null, e1.getMessage(), "Falha", 0);
                    return;
                }
                if (this.retFileName == null) {
                    JOptionPane.showMessageDialog(null, "A\u00e7\u00e3o cancelada ou token inv\u00e1lido", "Cancelado", 1);
                } else {
                    JOptionPane.showMessageDialog(null, "Identidade em: " + this.retFileName + " este arquivo \ndeve ser compartilhado com todos que desejarem enviar \nmensagens  criptografadas para voc\u00ea", "Sucesso", 1);
                }
            }
        });
        btImportarChave.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ImportCertificate ic = new ImportCertificate();
                if (ic.isSuccess()) {
                    btCriar.setEnabled(true);
                } else {
                    btCriar.setEnabled(false);
                }
            }
        });
        btCriar.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                new CertificateSelection();
            }
        });
        btAbrir.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                new DecryptFile();
            }
        });
        btCancelar.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                me.dispose();
            }
        });
        btCriar.setEnabled(false);
        this.add(btCriar);
        this.add(btAbrir);
        this.add(btGerarChave);
        this.add(btImportarChave);
        this.add(btCancelar);
        File f = new File(CertitficateHelper.APP_CONF_DIR + "/known_certs");
        if (f.exists() && f.length() > 128L) {
            btCriar.setEnabled(true);
        }
        this.setVisible(true);
    }

    private JButton setButton(String title, String iconPath) {
        JButton btn = new JButton(title);
        btn.setBackground(Color.LIGHT_GRAY);
        btn.setHorizontalAlignment(0);
        btn.setForeground(Color.BLUE);
        this.add(btn);
        return btn;
    }

    private ImageIcon getImage(String iconPath) {
        BufferedImage img = null;
        try {
            InputStream pathSerpro = this.getClass().getClassLoader().getResourceAsStream(iconPath);
            img = ImageIO.read(pathSerpro);
        }
        catch (IOException e1) {
            e1.printStackTrace();
        }
        ImageIcon icon = new ImageIcon(img);
        return icon;
    }

    public static boolean isOldInterface() {
        return oldInterface;
    }

    public static void setOldInterface(boolean parmOldInterface) {
        oldInterface = parmOldInterface;
    }
}

