/*
 * Decompiled with CFR 0.152.
 */
package org.demoiselle.signer.serpro.desktop.ui.crypto;

import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.filechooser.FileFilter;
import org.bouncycastle.util.encoders.Base64;
import org.demoiselle.signer.core.extension.BasicCertificate;
import org.demoiselle.signer.policy.impl.cades.SignatureInformations;
import org.demoiselle.signer.policy.impl.cades.pkcs7.impl.CAdESChecker;
import org.demoiselle.signer.serpro.desktop.cert.CertitficateHelper;
import org.demoiselle.signer.serpro.desktop.ui.SignatureInfo;
import org.demoiselle.signer.serpro.desktop.ui.commons.FileChooserSigner;

public class ImportCertificate
extends JDialog {
    private static final long serialVersionUID = 1L;
    DefaultListModel<String> listModel;
    JList<String> listCert;
    JScrollPane listScroller;
    String RSAKey = "";
    HashMap<String, String> hashKeys;

    public static void main(String[] args) {
        new ImportCertificate();
    }

    public ImportCertificate() {
        this.setModal(true);
        this.initUi();
    }

    private void initUi() {
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                ImportCertificate.this.dispose();
            }
        });
        this.setTitle("Gerenciar Identidades");
        this.setSize(350, 350);
        this.setLocationRelativeTo(null);
        this.setLayout(null);
        try {
            this.showInstaledFiles();
            this.add(this.listCert);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        JButton btOk = new JButton("Importar");
        JButton btCancel = new JButton("Fechar");
        JButton btDelete = new JButton("Excluir");
        btOk.setMargin(new Insets(0, 0, 0, 0));
        btCancel.setMargin(new Insets(0, 0, 0, 0));
        btDelete.setMargin(new Insets(0, 0, 0, 0));
        this.listCert.setBounds(25, 25, this.getWidth() - 45, this.getHeight() - 110);
        btDelete.setBounds(25, this.getHeight() - 70, 80, 30);
        btCancel.setBounds(this.getWidth() - 100, this.getHeight() - 70, 80, 30);
        btOk.setBounds(this.getWidth() - 190, this.getHeight() - 70, 80, 30);
        final ImportCertificate me = this;
        btDelete.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    int confirm = JOptionPane.showConfirmDialog(null, "Confirma a exclus\u00e3o da Identidade", "Confirma\u00e7\u00e3o", 0);
                    if (confirm == 1) {
                        return;
                    }
                    ImportCertificate.this.removeItem(ImportCertificate.this.listCert.getSelectedValue());
                }
                catch (IOException e1) {
                    JOptionPane.showMessageDialog(null, "Ocorreu um erro ao tentar remover a chave", "Falha", 0);
                }
            }
        });
        btCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                me.dispose();
            }
        });
        btOk.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    ImportCertificate.this.showImportDialog();
                }
                catch (IOException ex) {
                    ex.printStackTrace();
                }
            }
        });
        this.add(btOk);
        this.add(btCancel);
        this.add(btDelete);
        this.setVisible(true);
    }

    private void showImportDialog() throws IOException {
        FileChooserSigner fileChooser = new FileChooserSigner();
        fileChooser.setDialogTitle("Selecione o arquivo de Identidade do Emissor");
        fileChooser.setFileFilter(new FileFilter(){

            @Override
            public String getDescription() {
                return "Chave P\u00fablica (.puk)";
            }

            @Override
            public boolean accept(File f) {
                if (f.isDirectory()) {
                    return true;
                }
                return f.getName().endsWith(".puk");
            }
        });
        int returnValue = fileChooser.showOpenDialog(this);
        if (returnValue == 0) {
            File f = fileChooser.getSelectedFile();
            String issuer = "";
            CAdESChecker checker = new CAdESChecker();
            FileInputStream is = new FileInputStream(f);
            byte[] byteFile = new byte[(int)f.length()];
            is.read(byteFile);
            is.close();
            byte[] content = checker.getAttached(byteFile, false).getExtractedContent();
            checker.checkDetachedSignature(content, byteFile);
            SignatureInfo si = new SignatureInfo(null, null);
            List<SignatureInformations> allValues = null;
            allValues = si.getCertData(checker);
            X509Certificate cert = allValues.get(0).getChain().getFirst();
            BasicCertificate bc = new BasicCertificate(cert);
            String serial = bc.getSerialNumber();
            issuer = bc.getName() + "[" + serial + "]";
            this.RSAKey = Base64.toBase64String(checker.getAttached(byteFile, false).getExtractedContent());
            if (this.hashKeys.containsKey(this.RSAKey)) {
                JOptionPane.showMessageDialog(null, "Identifica\u00e7\u00e3o previamente cadastrada para " + this.hashKeys.get(this.RSAKey), "Falha", 0);
                return;
            }
            int confirm = JOptionPane.showConfirmDialog(null, "Confirma o aceite da identifica\u00e7\u00e3o de " + issuer, "Confirma\u00e7\u00e3o", 0);
            if (confirm == 1) {
                return;
            }
            if (this.RSAKey.length() > 1) {
                try {
                    FileWriter fw = new FileWriter(CertitficateHelper.APP_CONF_DIR + "/known_certs", true);
                    fw.write(issuer + "|" + this.RSAKey + "\n");
                    fw.close();
                }
                catch (IOException e1) {
                    e1.printStackTrace();
                }
            }
            this.hashKeys.put(this.RSAKey, issuer);
            ArrayList<String> ordered = new ArrayList<String>();
            for (String key : this.hashKeys.keySet()) {
                ordered.add(this.hashKeys.get(key));
            }
            Collections.sort(ordered);
            this.listModel.clear();
            for (String value : ordered) {
                this.listModel.addElement(value);
            }
        }
    }

    private String getKeyByValue(String value) {
        for (String name : this.hashKeys.keySet()) {
            if (!value.equals(this.hashKeys.get(name))) continue;
            return name;
        }
        return null;
    }

    private void removeItem(String item) throws IOException {
        ArrayList<String> newValues = new ArrayList<String>();
        System.out.println(this.getKeyByValue(item));
        this.hashKeys.remove(this.getKeyByValue(item));
        for (String name : this.hashKeys.keySet()) {
            newValues.add(this.hashKeys.get(name) + "|" + name + "\n");
        }
        Collections.sort(newValues, Collections.reverseOrder());
        RandomAccessFile f = new RandomAccessFile(new File(CertitficateHelper.APP_CONF_DIR + "/known_certs"), "rw");
        f.seek(0L);
        Long newLength = 0L;
        for (String line : newValues) {
            newLength = newLength + (long)line.length();
            f.writeBytes(line);
        }
        f.setLength(newLength);
        f.close();
        this.listModel.clear();
        for (String value : newValues) {
            this.listModel.addElement(value.split("\\|")[0]);
        }
    }

    private void showInstaledFiles() throws IOException {
        this.hashKeys = new HashMap();
        File f = new File(CertitficateHelper.APP_CONF_DIR + "/known_certs");
        this.listModel = new DefaultListModel();
        this.listCert = new JList<String>(this.listModel);
        if (!f.exists()) {
            return;
        }
        BufferedReader b = new BufferedReader(new FileReader(f));
        String readLine = "";
        while ((readLine = b.readLine()) != null) {
            String[] splited = readLine.split("\\|");
            if (splited.length <= 1) continue;
            this.listModel.addElement(splited[0]);
            this.hashKeys.put(splited[1], splited[0]);
        }
        b.close();
    }

    public boolean isSuccess() {
        File f = new File(CertitficateHelper.APP_CONF_DIR + "/known_certs");
        return f.exists() && f.length() > 128L;
    }
}

