/*
 * Decompiled with CFR 0.152.
 */
package org.demoiselle.signer.serpro.desktop.ui.crypto;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.security.GeneralSecurityException;
import java.security.PrivateKey;
import javax.crypto.Cipher;
import javax.crypto.CipherInputStream;
import javax.crypto.spec.SecretKeySpec;
import javax.swing.JOptionPane;
import javax.swing.filechooser.FileFilter;
import org.demoiselle.signer.policy.impl.cades.pkcs7.impl.CAdESChecker;
import org.demoiselle.signer.serpro.desktop.crypto.EncrypDecrypt;
import org.demoiselle.signer.serpro.desktop.ui.commons.FileChooserSigner;

public class DecryptFile {
    public static void main(String[] a) {
        new DecryptFile();
    }

    DecryptFile() {
        FileChooserSigner fileChooserFile = new FileChooserSigner();
        fileChooserFile.setFileFilter(new FileFilter(){

            @Override
            public boolean accept(File f) {
                if (f.isDirectory()) {
                    return true;
                }
                String name = f.getName();
                return name.endsWith(".cry");
            }

            @Override
            public String getDescription() {
                return null;
            }
        });
        fileChooserFile.setDialogTitle("Selecione o Arquivo Criptografado");
        int returnValue = fileChooserFile.showOpenDialog(null);
        if (returnValue == 0) {
            FileChooserSigner fileKeyChooser = new FileChooserSigner();
            fileKeyChooser.setFileFilter(new FileFilter(){

                @Override
                public boolean accept(File f) {
                    if (f.isDirectory()) {
                        return true;
                    }
                    String name = f.getName();
                    return name.endsWith(".key");
                }

                @Override
                public String getDescription() {
                    return null;
                }
            });
            try {
                this.decriptation(fileChooserFile.getSelectedFile(), null, fileKeyChooser.getSelectedFile());
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
        }
    }

    private void decriptation(File in, File outDec, File aes) throws Throwable {
        boolean ignore = false;
        if (outDec == null) {
            outDec = new File(in.getAbsolutePath().replaceAll(".cry$", ""));
            while (outDec.exists() && !ignore) {
                Object[] options = new Object[]{"Sim", "N\u00e3o", "Cancelar"};
                int resp = JOptionPane.showOptionDialog(null, "Arquivo " + outDec.getAbsolutePath() + " j\u00e1 existe, deseja substituir", "Processo de Valida\u00e7\u00e3o de Assinatura", 0, 1, null, options, options[1]);
                if (resp == 0) {
                    ignore = true;
                    continue;
                }
                if (resp == 2) {
                    return;
                }
                FileChooserSigner fileOutputChooser = new FileChooserSigner();
                fileOutputChooser.setControlButtonsAreShown(true);
                fileOutputChooser.setDialogTitle("Selecione o novo nome do arquivo");
                fileOutputChooser.setSelectedFile(outDec);
                int returnValue = fileOutputChooser.showSaveDialog(null);
                if (returnValue != 0) continue;
                outDec = new File(fileOutputChooser.getSelectedFile().getAbsolutePath());
            }
        }
        try {
            EncrypDecrypt me = new EncrypDecrypt();
            me.decryptFile(in, outDec);
        }
        catch (IOException | GeneralSecurityException e) {
            JOptionPane.showMessageDialog(null, "Falha ao decriptografar a mensagem, verifique selecionou o arquivo correto", "Falha", 0);
            e.printStackTrace();
        }
    }

    public void decrypt(File in, File out, PrivateKey privKey) throws IOException, GeneralSecurityException {
        RandomAccessFile f = new RandomAccessFile(in, "rw");
        f.seek(f.length() - 4L);
        long keySize = f.readInt();
        f.seek(f.length() - (keySize + 4L));
        byte[] key = new byte[(int)keySize];
        f.read(key);
        CAdESChecker checker = new CAdESChecker();
        byte[] aes = checker.getAttached(key, false).getExtractedContent();
        RandomAccessFile kf = new RandomAccessFile(new File(in.getAbsolutePath().replaceFirst(".{3}$", "000")), "rw");
        kf.write(key);
        kf.close();
        f.close();
        SecretKeySpec aeskeySpec = new SecretKeySpec(aes, "AES");
        Cipher aesCipher = Cipher.getInstance("AES");
        aesCipher.init(2, aeskeySpec);
        CipherInputStream is = new CipherInputStream(new FileInputStream(in), aesCipher);
        FileOutputStream os = new FileOutputStream(out);
        this.copy(is, os);
        is.close();
        os.close();
    }

    private void copy(InputStream is, OutputStream os) throws IOException {
        int i;
        byte[] b = new byte[1024];
        while ((i = is.read(b)) != -1) {
            os.write(b, 0, i);
        }
    }
}

