/*
 * Decompiled with CFR 0.152.
 */
package org.demoiselle.signer.serpro.desktop.ui.crypto;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.security.PublicKey;
import java.util.HashMap;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import org.demoiselle.signer.serpro.desktop.cert.CertitficateHelper;
import org.demoiselle.signer.serpro.desktop.crypto.EncrypDecrypt;
import org.demoiselle.signer.serpro.desktop.ui.commons.FileChooserSigner;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CertificateSelection
extends JDialog {
    private static final long serialVersionUID = 1L;
    private static final Logger logger = LoggerFactory.getLogger(CertificateSelection.class);
    DefaultListModel<String> listModel;
    JList<String> listCert;
    JScrollPane listScroller;
    String RSAKey = "";
    HashMap<String, String> hashKeys;
    File inputFile;

    public static void main(String[] args) {
        new CertificateSelection();
    }

    public CertificateSelection() {
        FileChooserSigner fileChooser = new FileChooserSigner();
        fileChooser.setDialogTitle("Selecione o Arquivo de Conte\u00fado");
        int returnValue = fileChooser.showOpenDialog(null);
        if (returnValue == 0) {
            this.inputFile = fileChooser.getSelectedFile();
            this.initUi();
        }
    }

    private void initUi() {
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                CertificateSelection.this.dispose();
            }
        });
        this.setTitle("Selecionar Certificado");
        this.setSize(350, 300);
        this.setLocationRelativeTo(null);
        this.setLayout(null);
        try {
            this.showInstaledFiles();
            this.add(this.listCert);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        JButton btOk = new JButton("Criptografar");
        JButton btCancel = new JButton("Fechar");
        this.listCert.setBounds(25, 20, this.getWidth() - 50, this.getHeight() - 110);
        btCancel.setBounds(this.getWidth() - 150, this.getHeight() - 80, 130, 30);
        btOk.setBounds(this.getWidth() - 320, this.getHeight() - 80, 150, 30);
        final CertificateSelection me = this;
        btCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                me.dispose();
            }
        });
        btOk.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                File in = CertificateSelection.this.inputFile;
                String strOut = CertificateSelection.this.inputFile.getAbsolutePath() + ".cry";
                File out = new File(strOut);
                while (out.exists()) {
                    Object[] options = new Object[]{"Sim", "N\u00e3o", "Cancelar"};
                    int resp = JOptionPane.showOptionDialog(null, "Arquivo " + out.getAbsolutePath() + " j\u00e1 existe, deseja substituir", "Criar arquivo seguro", 0, 1, null, options, options[1]);
                    if (resp == 0) break;
                    if (resp == 2) {
                        CertificateSelection.this.dispose();
                        return;
                    }
                    FileChooserSigner fileOutputChooser = new FileChooserSigner();
                    fileOutputChooser.setDialogTitle("Selecione o novo nome do arquivo");
                    int returnValue = fileOutputChooser.showSaveDialog(null);
                    if (returnValue != 0) continue;
                    strOut = fileOutputChooser.getSelectedFile().getAbsolutePath();
                    if (!strOut.endsWith(".cry")) {
                        strOut = strOut + ".cry";
                    }
                    out = new File(strOut);
                }
                if (CertificateSelection.this.listCert.getSelectedValue() == null) {
                    JOptionPane.showMessageDialog(null, "Selecione o nome do destinat\u00e1rio do arquivo", "Selecione", 0);
                    return;
                }
                try {
                    EncrypDecrypt encDec = new EncrypDecrypt();
                    PublicKey pk = null;
                    logger.info("Key to Encrypt: " + CertificateSelection.this.getKeyByValue(CertificateSelection.this.listCert.getSelectedValue()));
                    pk = encDec.getPublicKeyFromBase64(CertificateSelection.this.getKeyByValue(CertificateSelection.this.listCert.getSelectedValue()));
                    encDec.cryptFile(in, out, pk);
                    JOptionPane.showMessageDialog(null, "Arquivo seguro gerado em " + strOut + "\n", "Arquivo Seguro", 1);
                    me.dispose();
                }
                catch (Throwable e1) {
                    JOptionPane.showMessageDialog(null, "Erro ao criptografar o arquivo", "Criptografia", 0);
                }
            }
        });
        this.add(btOk);
        this.add(btCancel);
        this.setVisible(true);
    }

    private String getKeyByValue(String value) {
        for (String name : this.hashKeys.keySet()) {
            if (!value.equals(this.hashKeys.get(name))) continue;
            return name;
        }
        return null;
    }

    private void showInstaledFiles() throws IOException {
        this.hashKeys = new HashMap();
        File f = new File(CertitficateHelper.APP_CONF_DIR + "/known_certs");
        this.listModel = new DefaultListModel();
        this.listCert = new JList<String>(this.listModel);
        if (!f.exists()) {
            return;
        }
        BufferedReader b = new BufferedReader(new FileReader(f));
        String readLine = "";
        while ((readLine = b.readLine()) != null) {
            String[] splited = readLine.split("\\|");
            if (splited.length <= 1) continue;
            this.listModel.addElement(splited[0]);
            this.hashKeys.put(splited[1], splited[0]);
        }
        b.close();
    }
}

