/*
 * Decompiled with CFR 0.152.
 */
package org.demoiselle.signer.serpro.desktop.ui.configuration.tabs;

import java.awt.Color;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.IOException;
import java.util.Properties;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTabbedPane;
import org.demoiselle.signer.serpro.desktop.ReadConfig;
import org.demoiselle.signer.serpro.desktop.ui.MetodoCarimboAPI;
import org.demoiselle.signer.serpro.desktop.ui.commons.SignerDialog;
import org.demoiselle.signer.serpro.desktop.ui.configuration.ConfigProperties;
import org.demoiselle.signer.serpro.desktop.utils.ConfiguracoesVolateis;
import org.demoiselle.signer.serpro.desktop.utils.TimeStampRequestUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TimeStampConfigPanel
extends JPanel {
    private static final long serialVersionUID = 1L;
    private static final Logger logger = LoggerFactory.getLogger(TimeStampConfigPanel.class);
    private static final String FONT_UBUNTU = "Ubuntu";
    private static final Color BACKGROUND_COLOR = new Color(173, 216, 230);
    private static final Color LABEL_COLOR = new Color(0, 0, 51);
    private final JDialog parentDialog;
    private boolean validatedSuccessfully = false;
    private final Properties props;
    private JPasswordField txtConsumerKey;
    private JPasswordField txtConsumerSecret;

    public TimeStampConfigPanel(JDialog parentDialog, Properties props) {
        this.parentDialog = parentDialog;
        this.props = props;
        this.initializeComponents();
        this.setupParentDialogListener();
    }

    public boolean isValidatedSuccessfully() {
        return this.validatedSuccessfully;
    }

    private void setupParentDialogListener() {
        if (this.parentDialog != null) {
            this.parentDialog.addWindowListener(new WindowAdapter(){

                @Override
                public void windowClosing(WindowEvent e) {
                    TimeStampConfigPanel.this.validatedSuccessfully = false;
                    ConfiguracoesVolateis.setMetodoCarimboSelecionado(MetodoCarimboAPI.NENHUM_SELECIONADO);
                    logger.info("TimeStampConfigPanel dialog closed by user (X). API selection reset.");
                }
            });
        }
    }

    public void addToTabbedPane(JTabbedPane tabbedPane) {
        tabbedPane.addTab("Carimbo do Tempo", null, this, "Configurar credenciais da API de Carimbo do Tempo");
    }

    public String getConsumerKey() {
        String key = this.props.getProperty("user.timestamp.api.consumerKey");
        return key != null ? key : "";
    }

    public void setConsumerKey(String key) {
        this.props.setProperty("user.timestamp.api.consumerKey", key);
    }

    public void setConsumerSecret(String secret) {
        ConfiguracoesVolateis.setConsumerSecret(secret);
    }

    public String getConsumerSecret() {
        String secret = ConfiguracoesVolateis.getConsumerSecret();
        return secret != null ? secret : "";
    }

    public String obterToken() {
        String endpoint = "https://gateway.apiserpro.serpro.gov.br/token";
        TimeStampRequestUtil ts = new TimeStampRequestUtil();
        String[] dados = ts.requestToken(endpoint, this.getConsumerKey(), this.getConsumerSecret(), false);
        return dados[0];
    }

    private void setPropertyUsageOfSerproAPI(boolean useSerproAPI) {
        this.props.setProperty("user.api.serpro", String.valueOf(useSerproAPI));
    }

    private void initializeComponents() {
        JLabel lblConsumerKey = new JLabel("Consumer Key:");
        lblConsumerKey.setForeground(LABEL_COLOR);
        this.txtConsumerKey = new JPasswordField();
        this.txtConsumerKey.setColumns(30);
        JLabel lblConsumerSecret = new JLabel("Consumer Secret:");
        lblConsumerSecret.setForeground(LABEL_COLOR);
        this.txtConsumerSecret = new JPasswordField();
        this.txtConsumerSecret.setColumns(30);
        JButton btnSalvar = new JButton("Salvar");
        btnSalvar.setFont(new Font(FONT_UBUNTU, 1, 15));
        btnSalvar.setBackground(new Color(51, 153, 255));
        String consumerKey = this.getConsumerKey();
        String consumerSecret = this.getConsumerSecret();
        this.txtConsumerKey.setText(consumerKey);
        this.txtConsumerSecret.setText(consumerSecret);
        btnSalvar.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    String key = new String(TimeStampConfigPanel.this.txtConsumerKey.getPassword());
                    String secret = new String(TimeStampConfigPanel.this.txtConsumerSecret.getPassword());
                    if (key.isEmpty() || secret.isEmpty()) {
                        TimeStampConfigPanel.this.setPropertyUsageOfSerproAPI(false);
                        TimeStampConfigPanel.this.validatedSuccessfully = false;
                        ConfiguracoesVolateis.setMetodoCarimboSelecionado(MetodoCarimboAPI.NENHUM_SELECIONADO);
                        SignerDialog.showMessageDialog(TimeStampConfigPanel.this.parentDialog, "Preencha ambos os campos.", "Aviso", 2);
                        return;
                    }
                    TimeStampConfigPanel.this.setConsumerSecret(secret);
                    TimeStampConfigPanel.this.setConsumerKey(key);
                    TimeStampConfigPanel.this.testarObtencaoTokenAndClose();
                }
                catch (Exception ex) {
                    TimeStampConfigPanel.this.validatedSuccessfully = false;
                    ConfiguracoesVolateis.setMetodoCarimboSelecionado(MetodoCarimboAPI.NENHUM_SELECIONADO);
                    logger.error("Erro ao salvar credenciais de carimbo de tempo: {}", (Object)ex.getMessage());
                    SignerDialog.showMessageDialog(TimeStampConfigPanel.this.parentDialog, "Erro ao salvar credenciais: " + ex.getMessage(), "Erro", 0);
                }
            }
        });
        this.setBackground(BACKGROUND_COLOR);
        GroupLayout layout = new GroupLayout(this);
        layout.setAutoCreateGaps(true);
        layout.setAutoCreateContainerGaps(true);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(lblConsumerKey).addComponent(lblConsumerSecret)).addGap(18).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.txtConsumerKey, -2, 300, -2).addComponent(this.txtConsumerSecret, -2, 300, -2))).addComponent(btnSalvar, -2, 172, -2)).addContainerGap(-1, Short.MAX_VALUE)));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGap(18).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(lblConsumerKey).addComponent(this.txtConsumerKey, -2, -1, -2)).addGap(18).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(lblConsumerSecret).addComponent(this.txtConsumerSecret, -2, -1, -2)).addGap(18).addComponent(btnSalvar, -2, 41, -2).addContainerGap(-1, Short.MAX_VALUE)));
        this.setLayout(layout);
    }

    private void testarObtencaoTokenAndClose() {
        String accessToken = null;
        try {
            accessToken = this.obterToken();
        }
        catch (Exception e) {
            ConfiguracoesVolateis.setMetodoCarimboSelecionado(MetodoCarimboAPI.NENHUM_SELECIONADO);
            logger.error("Erro ao obter token de acesso: {}", (Object)e.getMessage());
            this.setConsumerSecret("");
            this.txtConsumerSecret.setText("");
            this.validatedSuccessfully = false;
        }
        if (accessToken != null && !accessToken.isEmpty()) {
            this.setPropertyUsageOfSerproAPI(true);
            try {
                ConfigProperties.saveProps(this.props);
                ReadConfig.doConfig();
            }
            catch (IOException ex) {
                logger.error("Erro ao salvar propriedades ap\u00f3s valida\u00e7\u00e3o: {}", (Object)ex.getMessage());
                SignerDialog.showMessageDialog(this.parentDialog, "Erro ao salvar configura\u00e7\u00f5es: " + ex.getMessage(), "Erro de Grava\u00e7\u00e3o", 0);
            }
            this.validatedSuccessfully = true;
            ConfiguracoesVolateis.setMetodoCarimboSelecionado(MetodoCarimboAPI.API_SERPRO);
            SignerDialog.showMessageDialog(this.parentDialog, "Credenciais validadas com sucesso!", "Login da API", 1);
            logger.debug("Token de acesso obtido com sucesso no teste: {}", (Object)accessToken);
            if (this.parentDialog != null) {
                this.parentDialog.dispose();
            }
        } else {
            this.setConsumerSecret("");
            this.txtConsumerSecret.setText("");
            ConfiguracoesVolateis.setMetodoCarimboSelecionado(MetodoCarimboAPI.NENHUM_SELECIONADO);
            this.setPropertyUsageOfSerproAPI(false);
            try {
                ConfigProperties.saveProps(this.props);
            }
            catch (IOException ex) {
                logger.error("Erro ao salvar propriedades ap\u00f3s falha na valida\u00e7\u00e3o: {}", (Object)ex.getMessage());
                SignerDialog.showMessageDialog(this.parentDialog, "Erro ao salvar configura\u00e7\u00f5es (ap\u00f3s falha na valida\u00e7\u00e3o): " + ex.getMessage(), "Erro de Grava\u00e7\u00e3o", 0);
            }
            this.validatedSuccessfully = false;
            SignerDialog.showMessageDialog(this.parentDialog, "N\u00e3o foi poss\u00edvel validar as credenciais.<BR>Verifique os dados informados e a conex\u00e3o de rede.", "Falha no login da API", 2);
            logger.warn("N\u00e3o foi poss\u00edvel obter o token de acesso no teste. Resposta foi nula ou vazia, ou API retornou erro.");
        }
    }
}

