/*
 * Decompiled with CFR 0.152.
 */
package org.demoiselle.signer.serpro.desktop.ui.configuration.tabs;

import java.awt.Color;
import java.awt.Cursor;
import java.awt.Font;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.nio.charset.StandardCharsets;
import java.util.Properties;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import org.demoiselle.signer.core.util.Base64Utils;
import org.demoiselle.signer.serpro.desktop.ui.commons.SignerDialog;
import org.demoiselle.signer.serpro.desktop.ui.configuration.ConfigProperties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProxyAndSocksConfigPanel
extends JPanel {
    private static final long serialVersionUID = 1L;
    private static final Logger logger = LoggerFactory.getLogger(ProxyAndSocksConfigPanel.class);
    private static final String FONT_UBUNTU = "Ubuntu";
    private static final Color BACKGROUND_COLOR = new Color(173, 216, 230);
    private static final Color LABEL_COLOR = new Color(0, 0, 51);
    private final Properties props;
    private JTextField txtHost;
    private JTextField txtPort;
    private JTextField txtUsuario;
    private JPasswordField pwdSenha;
    private JButton btnSalvarProxy;
    private JLabel lblHost;
    private JLabel lblPort;
    private JLabel lblUsuario;
    private JLabel lblSenha;
    private JRadioButton rdbtnDesabilitar;
    private JRadioButton rdbtnProxy;
    private JRadioButton rdbtnSocks;
    private ButtonGroup groupTipoProxy;

    public ProxyAndSocksConfigPanel(Properties props) {
        this.props = props;
        this.initializeComponents();
        String tipoProxy = props.getProperty("user.proxy.type", "none");
        if ("socks".equals(tipoProxy)) {
            this.rdbtnSocks.setSelected(true);
        } else if ("http".equals(tipoProxy)) {
            this.rdbtnProxy.setSelected(true);
        } else {
            this.rdbtnDesabilitar.setSelected(true);
        }
        this.updateFieldsEnabled();
    }

    private void initializeComponents() {
        this.lblHost = new JLabel("Host/IP:");
        this.lblHost.setForeground(LABEL_COLOR);
        this.lblHost.setToolTipText("Digite o endere\u00e7o ou IP do proxy/SOCKS");
        this.txtHost = new JTextField();
        this.txtHost.setBackground(Color.WHITE);
        this.txtHost.setToolTipText("Preencha com o endere\u00e7o do servidor proxy/SOCKS ou n\u00famero do IP");
        this.txtHost.setColumns(10);
        this.lblPort = new JLabel("Porta:");
        this.lblPort.setForeground(LABEL_COLOR);
        this.txtPort = new JTextField();
        this.txtPort.setToolTipText("Digite o n\u00famero da porta do proxy/SOCKS");
        this.txtPort.setColumns(10);
        this.lblUsuario = new JLabel("Usu\u00e1rio: ");
        this.lblUsuario.setForeground(LABEL_COLOR);
        this.txtUsuario = new JTextField();
        this.txtUsuario.setToolTipText("Digite o nome do usu\u00e1rio para o proxy/SOCKS");
        this.txtUsuario.setColumns(10);
        this.lblSenha = new JLabel("Senha: ");
        this.lblSenha.setForeground(LABEL_COLOR);
        this.pwdSenha = new JPasswordField();
        this.pwdSenha.setToolTipText("Digite a senha");
        this.btnSalvarProxy = new JButton("Salvar");
        this.btnSalvarProxy.setFont(new Font(FONT_UBUNTU, 1, 15));
        this.btnSalvarProxy.setToolTipText("Clique para Salvar ou Atualizar os dados");
        this.btnSalvarProxy.setBackground(new Color(51, 153, 255));
        this.btnSalvarProxy.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createLineBorder(new Color(0, 90, 170), 1, true), BorderFactory.createEmptyBorder(5, 10, 5, 10)));
        this.rdbtnDesabilitar = new JRadioButton("Desabilitar Proxy/SOCKS5");
        this.rdbtnProxy = new JRadioButton("Proxy");
        this.rdbtnSocks = new JRadioButton("SOCKS5");
        this.rdbtnDesabilitar.setBackground(BACKGROUND_COLOR);
        this.rdbtnProxy.setBackground(BACKGROUND_COLOR);
        this.rdbtnSocks.setBackground(BACKGROUND_COLOR);
        this.rdbtnDesabilitar.setForeground(LABEL_COLOR);
        this.rdbtnProxy.setForeground(LABEL_COLOR);
        this.rdbtnSocks.setForeground(LABEL_COLOR);
        this.groupTipoProxy = new ButtonGroup();
        this.groupTipoProxy.add(this.rdbtnDesabilitar);
        this.groupTipoProxy.add(this.rdbtnProxy);
        this.groupTipoProxy.add(this.rdbtnSocks);
        String tipoProxy = this.props.getProperty("user.proxy.type", "none");
        if ("socks".equals(tipoProxy)) {
            this.txtHost.setText(this.props.getProperty("user.proxy.host", ""));
            this.txtPort.setText(this.props.getProperty("user.proxy.port", ""));
        } else if ("http".equals(tipoProxy)) {
            this.txtHost.setText(this.props.getProperty("user.proxy.host", ""));
            this.txtPort.setText(this.props.getProperty("user.proxy.port", ""));
        } else {
            this.txtHost.setText("");
            this.txtPort.setText("");
        }
        this.txtUsuario.setText(this.props.getProperty("user.proxy.user", ""));
        String senha = this.props.getProperty("user.proxy.password");
        if (senha != null) {
            byte[] varBytes = Base64Utils.base64Decode(senha);
            senha = new String(varBytes, StandardCharsets.UTF_8);
        }
        this.pwdSenha.setText(senha);
        this.btnSalvarProxy.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent e) {
                ProxyAndSocksConfigPanel.this.setCursor(new Cursor(12));
            }

            @Override
            public void mouseExited(MouseEvent e) {
                ProxyAndSocksConfigPanel.this.setCursor(new Cursor(0));
            }
        });
        this.rdbtnDesabilitar.addActionListener(e -> this.updateFieldsEnabled());
        this.rdbtnProxy.addActionListener(e -> this.updateFieldsEnabled());
        this.rdbtnSocks.addActionListener(e -> this.updateFieldsEnabled());
        this.btnSalvarProxy.addActionListener(e -> {
            try {
                if (this.rdbtnDesabilitar.isSelected()) {
                    this.props.setProperty("user.proxy.type", "none");
                    this.props.remove("user.proxy.host");
                    this.props.remove("user.proxy.port");
                    this.props.remove("user.proxy.user");
                    this.props.remove("user.proxy.password");
                } else {
                    String host = this.txtHost.getText().trim();
                    String port = this.txtPort.getText().trim();
                    if (host.isEmpty() || port.isEmpty()) {
                        SignerDialog.showMessageDialog(this, "Os campos Host e Porta s\u00e3o obrigat\u00f3rios para Proxy ou SOCKS5.", "Aten\u00e7\u00e3o", 2);
                        return;
                    }
                    if (this.rdbtnProxy.isSelected()) {
                        this.props.setProperty("user.proxy.type", "http");
                    } else if (this.rdbtnSocks.isSelected()) {
                        this.props.setProperty("user.proxy.type", "socks");
                    }
                    this.props.setProperty("user.proxy.host", host);
                    this.props.setProperty("user.proxy.port", port);
                    this.props.setProperty("user.proxy.user", this.txtUsuario.getText());
                    String senha1 = new String(this.pwdSenha.getPassword());
                    if (!senha1.isEmpty()) {
                        this.props.setProperty("user.proxy.password", Base64Utils.base64Encode(senha1.getBytes(StandardCharsets.UTF_8)));
                    } else {
                        this.props.remove("user.proxy.password");
                    }
                }
                ConfigProperties.saveProps(this.props);
                SignerDialog.showMessageDialog(this, "Configura\u00e7\u00f5es salvas com sucesso!\n\u00c9 necess\u00e1rio reiniciar o Assinador para aplicar as mudan\u00e7as.", "Sucesso", 1);
            }
            catch (Exception ex) {
                this.showErrorDialogAndLog("Erro ao salvar configura\u00e7\u00f5es de proxy/socks:", ex);
            }
        });
        this.setBackground(BACKGROUND_COLOR);
        try {
            GroupLayout layout = new GroupLayout(this);
            layout.setAutoCreateGaps(true);
            layout.setAutoCreateContainerGaps(true);
            layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.rdbtnDesabilitar).addComponent(this.rdbtnProxy).addComponent(this.rdbtnSocks)).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.lblHost).addComponent(this.lblPort).addComponent(this.lblUsuario).addComponent(this.lblSenha)).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.txtHost).addComponent(this.txtPort).addComponent(this.txtUsuario).addComponent(this.pwdSenha))).addGroup(layout.createSequentialGroup().addGap(0, 0, Short.MAX_VALUE).addComponent(this.btnSalvarProxy).addGap(0, 0, Short.MAX_VALUE)));
            layout.setVerticalGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.rdbtnDesabilitar).addComponent(this.rdbtnProxy).addComponent(this.rdbtnSocks)).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.lblHost).addComponent(this.txtHost)).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.lblPort).addComponent(this.txtPort)).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.lblUsuario).addComponent(this.txtUsuario)).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.lblSenha).addComponent(this.pwdSenha)).addGap(10).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.btnSalvarProxy)));
            this.setLayout(layout);
            this.updateFieldsEnabled();
        }
        catch (Exception ex) {
            logger.error("Erro ao configurar layout do painel de proxy/socks", ex);
            SignerDialog.showMessageDialog(this, "Erro ao configurar layout do painel de proxy/socks:\n" + ex.getMessage(), "Erro", 0);
        }
    }

    private void updateFieldsEnabled() {
        boolean enabled = !this.rdbtnDesabilitar.isSelected();
        this.txtHost.setEnabled(enabled);
        this.txtPort.setEnabled(enabled);
        this.txtUsuario.setEnabled(enabled);
        this.pwdSenha.setEnabled(enabled);
        this.lblHost.setEnabled(enabled);
        this.lblPort.setEnabled(enabled);
        this.lblUsuario.setEnabled(enabled);
        this.lblSenha.setEnabled(enabled);
        this.btnSalvarProxy.setEnabled(true);
    }

    private void showErrorDialogAndLog(String message, Exception e) {
        logger.error(message, e);
        SignerDialog.showMessageDialog(this, message + (e != null ? "\n" + e.getMessage() : ""), "Erro", 0);
    }
}

