/*
 * Decompiled with CFR 0.152.
 */
package org.demoiselle.signer.serpro.desktop.ui.configuration;

import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import java.util.Properties;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JSpinner;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.SpinnerNumberModel;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.filechooser.FileNameExtensionFilter;
import javax.swing.filechooser.FileSystemView;
import org.apache.commons.io.FileUtils;
import org.apache.log4j.Level;
import org.apache.log4j.LogManager;
import org.demoiselle.signer.core.keystore.loader.KeyStoreLoader;
import org.demoiselle.signer.core.keystore.loader.factory.KeyStoreLoaderFactory;
import org.demoiselle.signer.core.util.Base64Utils;
import org.demoiselle.signer.serpro.desktop.ReadConfig;
import org.demoiselle.signer.serpro.desktop.SerproSignerConfigurations;
import org.demoiselle.signer.serpro.desktop.statistics.Statistics;
import org.demoiselle.signer.serpro.desktop.ui.FocusTraversalOnArray;
import org.demoiselle.signer.serpro.desktop.ui.NewToolsInterface;
import org.demoiselle.signer.serpro.desktop.ui.ProgressBar;
import org.demoiselle.signer.serpro.desktop.ui.commons.SignerDialog;
import org.demoiselle.signer.serpro.desktop.ui.configuration.ConfigProperties;
import org.demoiselle.signer.serpro.desktop.ui.configuration.ConfigureStamp;
import org.demoiselle.signer.serpro.desktop.ui.configuration.ConfigureTheme;
import org.demoiselle.signer.serpro.desktop.ui.configuration.tabs.AcessibilityConfigPanel;
import org.demoiselle.signer.serpro.desktop.ui.configuration.tabs.ProxyAndSocksConfigPanel;
import org.demoiselle.signer.serpro.desktop.ui.configuration.tabs.TimeStampConfigPanel;
import org.demoiselle.signer.serpro.desktop.utils.FileUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SignerConfigurations
extends JDialog {
    private static final long serialVersionUID = -705065119423172863L;
    private static final String PATH_HOME_USER = System.getProperty("user.home");
    private static final String FOLDER_ASSINADOR = ".serpro";
    public static final Path FULL_PATH_FOLDER_ASSINADOR = Paths.get(PATH_HOME_USER, ".serpro", "signer_config.properties");
    private static final Path FULL_PATH_FOLDER_ASSINADOR_LCR = Paths.get(PATH_HOME_USER, ".serpro");
    private JTextField txtE = new JTextField();
    private JTextField txtP = new JTextField();
    private JTextField txtUsuario = new JTextField();
    private JPasswordField pwdSenha = new JPasswordField();
    private Properties props;
    private JCheckBox chckbxUsarCacheLCR = new JCheckBox("Usar Cache de LCR");
    private JCheckBox chckbxDesabilitarMscapi = new JCheckBox("Desabilitar MSCAPI");
    private JCheckBox chckbxDesabilitarEstatisticas = new JCheckBox("Desabilitar Estat\u00edsticas");
    private JCheckBox chkSalvarSenha;
    private JButton btnSelecionarArquivo;
    private JButton btFecharAbaCertificadoArquivo;
    private JCheckBox chckbxUsarCertificadoEmArquivo;
    private JPasswordField passCertField = new JPasswordField();
    private JTextField textLocalCertificado = new JTextField();
    private JCheckBox chckbxLogoffDoToken;
    private JCheckBox chckbxSomenteNeoid;
    private JCheckBox chckbxUsarPBAD;
    private boolean restart = false;
    private SerproSignerConfigurations configSigner = SerproSignerConfigurations.getInstance();
    private static SignerConfigurations instanceSignerConfigurations = null;
    private static boolean oldInterface = false;
    private JPanel carregarDriver;
    private ConfigureTheme carregarTema;
    private JTextField txtLocalDriver;
    private JButton btSalvarDriver;
    private JButton btSelecionarDriver;
    private JCheckBox chckbxCarregarDriverLocal;
    private JPanel manutencao;
    private JButton reset;
    private JCheckBox chckbxSelecionarAoAssinar = new JCheckBox("Selecionar ao Assinar");
    private JTabbedPane tabbedPane = new JTabbedPane(1);
    private ProxyAndSocksConfigPanel proxyPanel;
    private JPanel pnlAcessibilidade = new JPanel();
    private transient Statistics instaSta = new Statistics();
    private static final Logger logger = LoggerFactory.getLogger(SignerConfigurations.class);
    private final JSpinner spinnerTamArquivos = new JSpinner(new SpinnerNumberModel(50, 1, 10000, 1));
    private final JLabel lblTamanhoDosArquivos = new JLabel("Tamanho M\u00e1ximo");
    private final JPanel ntpTab = new JPanel();
    private final JLabel lblEnderecoNTP = new JLabel("Endere\u00e7o ou IP:");
    private final JCheckBox chckbxDesabilitarNTP = new JCheckBox("Desabilitar configura\u00e7\u00e3o NTP");
    private final JButton btnSalvarNTP = new JButton("Salvar/Atualizar");
    private final JTextField textFieldNTP = new JTextField();

    public static SignerConfigurations getInstance(Frame parent, boolean parmOldInterfade) {
        ProgressBar pbConfigurations = new ProgressBar("Aguarde...");
        Thread trConfig = new Thread(pbConfigurations);
        trConfig.start();
        if (instanceSignerConfigurations == null) {
            instanceSignerConfigurations = new SignerConfigurations(parent);
        }
        SignerConfigurations.setOldInterface(parmOldInterfade);
        pbConfigurations.dispose();
        trConfig.interrupt();
        return instanceSignerConfigurations;
    }

    private SignerConfigurations(Frame parent) {
        super(parent, "Configura\u00e7\u00f5es do Assinador", true);
        this.setIconImage(Toolkit.getDefaultToolkit().getImage(SignerConfigurations.class.getClassLoader().getResource("images/icon-signer-blue-16x16.png")));
        this.setBackground(new Color(173, 216, 230));
        this.setAlwaysOnTop(true);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosed(WindowEvent e) {
                try {
                    ConfigProperties.saveProps(SignerConfigurations.this.props);
                }
                catch (IOException e1) {
                    logger.error("Houve erro ao gravar no arquivo de propriedades: " + e1.getMessage());
                    Thread th = new Thread(new Runnable(){

                        @Override
                        public void run() {
                            SignerDialog.showMessageDialog(instanceSignerConfigurations, "ATEN\u00c7\u00c3O! \nHouve erro ao gravar no arquivo de propriedades \nExecute novamente o Assinador ", "Aviso", 2);
                            System.exit(0);
                        }
                    });
                    th.start();
                }
                ReadConfig.doConfig();
                if (SignerConfigurations.this.restart) {
                    Thread th = new Thread(new Runnable(){

                        @Override
                        public void run() {
                            SignerDialog.showMessageDialog(instanceSignerConfigurations, "ATEN\u00c7\u00c3O! \nSer\u00e1 preciso reiniciar o aplicativo para que as mudan\u00e7as seja efetivadas \nExecute novamente o Assinador ", "Aviso", 2);
                            System.exit(0);
                        }
                    });
                    th.start();
                }
                if (!oldInterface) {
                    NewToolsInterface.getInstance().setVisible(true);
                }
            }
        });
        this.loadPropertiesFile();
        final SignerConfigurations sc = this;
        this.setTitle("Configura\u00e7\u00f5es do Assinador");
        this.setDefaultCloseOperation(2);
        this.setResizable(false);
        this.setBounds(15, 115, 743, 340);
        this.setLocationRelativeTo(null);
        this.setLocationByPlatform(true);
        UIManager.put("OptionPane.background", new Color(173, 216, 230));
        UIManager.put("Panel.background", new Color(173, 216, 230));
        this.tabbedPane.setBackground(new Color(173, 216, 230));
        this.tabbedPane.setToolTipText("");
        this.getContentPane().add(this.tabbedPane);
        this.proxyPanel = new ProxyAndSocksConfigPanel(this.props);
        this.tabbedPane.addTab("Proxy e SOCKS", null, this.proxyPanel, "Configura\u00e7\u00e3o de Proxy e SOCKS");
        this.textFieldNTP.setForeground(new Color(0, 0, 51));
        this.textFieldNTP.setToolTipText("Preencha com o endere\u00e7o do servidor NTP ou n\u00famero do IP");
        this.textFieldNTP.setText(null);
        this.textFieldNTP.setColumns(10);
        this.btnSalvarNTP.setFont(new Font("Ubuntu", 1, 15));
        this.btnSalvarNTP.setToolTipText("Clique para Salvar ou Atualizar");
        this.btnSalvarNTP.setBorder(BorderFactory.createLineBorder(new Color(0, 90, 170), 1, true));
        this.btnSalvarNTP.setBackground(new Color(51, 153, 255));
        this.chckbxDesabilitarNTP.setForeground(new Color(0, 0, 51));
        this.chckbxDesabilitarNTP.setBackground(new Color(173, 216, 230));
        this.lblEnderecoNTP.setForeground(new Color(0, 0, 51));
        this.lblEnderecoNTP.setToolTipText("Digite o endere\u00e7o ou ip do servidor NTP");
        this.btnSalvarNTP.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent e) {
                SignerConfigurations.this.setCursor(new Cursor(12));
            }

            @Override
            public void mouseExited(MouseEvent e) {
                SignerConfigurations.this.setCursor(new Cursor(0));
            }
        });
        this.btnSalvarNTP.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    String varEndereco = SignerConfigurations.this.textFieldNTP.getText();
                    if (varEndereco == null || varEndereco.isEmpty()) {
                        SignerDialog.showMessageDialog(instanceSignerConfigurations, "Forne\u00e7a o endere\u00e7o do servidor NTP ou desabilite o mesmo!", "Aviso", 2);
                        SignerConfigurations.this.txtE.requestFocus();
                        return;
                    }
                    SignerConfigurations.this.props.setProperty("user.ntp.local", varEndereco);
                    ConfigProperties.saveProps(SignerConfigurations.this.props);
                }
                catch (Exception e1) {
                    logger.error("Erro ao gravar arquivo de configura\u00e7\u00e3o local:" + e1.getMessage());
                    SignerDialog.showMessageDialog(instanceSignerConfigurations, "Erro", "Erro ao gravar arquivo de configura\u00e7\u00e3o local:" + e1.getMessage(), 0);
                }
                sc.dispose();
                if (!oldInterface) {
                    NewToolsInterface.getInstance().setVisible(true);
                }
            }
        });
        this.chckbxDesabilitarNTP.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent e) {
                SignerConfigurations.this.setCursor(new Cursor(12));
            }

            @Override
            public void mouseExited(MouseEvent e) {
                SignerConfigurations.this.setCursor(new Cursor(0));
            }
        });
        this.chckbxDesabilitarNTP.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                try {
                    if (e.getStateChange() == 1) {
                        SignerConfigurations.this.textFieldNTP.setEnabled(false);
                        SignerConfigurations.this.textFieldNTP.setText("");
                        SignerConfigurations.this.props.remove("user.ntp.local");
                    } else {
                        SignerConfigurations.this.textFieldNTP.setEnabled(true);
                        SignerConfigurations.this.textFieldNTP.requestFocus();
                    }
                    ConfigProperties.saveProps(SignerConfigurations.this.props);
                }
                catch (Exception e1) {
                    logger.error("Erro ao gravar arquivo de configura\u00e7\u00e3o local:" + e1.getMessage());
                    SignerDialog.showMessageDialog(instanceSignerConfigurations, "Erro", "Erro ao gravar arquivo de configura\u00e7\u00e3o local:" + e1.getMessage(), 0);
                }
            }
        });
        this.ntpTab.setBackground(new Color(173, 216, 230));
        this.tabbedPane.addTab("NTP", null, this.ntpTab, "Configure um servidor NTP");
        GroupLayout glNtpTab = new GroupLayout(this.ntpTab);
        glNtpTab.setHorizontalGroup(glNtpTab.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(glNtpTab.createSequentialGroup().addContainerGap().addComponent(this.lblEnderecoNTP).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(glNtpTab.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(glNtpTab.createSequentialGroup().addComponent(this.btnSalvarNTP, -2, 190, -2).addContainerGap()).addGroup(glNtpTab.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(glNtpTab.createSequentialGroup().addComponent(this.chckbxDesabilitarNTP).addContainerGap()).addGroup(glNtpTab.createSequentialGroup().addComponent(this.textFieldNTP, -1, 441, Short.MAX_VALUE).addGap(163))))));
        glNtpTab.setVerticalGroup(glNtpTab.createParallelGroup(GroupLayout.Alignment.TRAILING).addGroup(glNtpTab.createSequentialGroup().addContainerGap().addGroup(glNtpTab.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.textFieldNTP, -2, -1, -2).addComponent(this.lblEnderecoNTP)).addGap(26).addComponent(this.chckbxDesabilitarNTP).addGap(38).addComponent(this.btnSalvarNTP, -2, 37, -2).addGap(309)));
        this.ntpTab.setLayout(glNtpTab);
        JPanel pnlConfigAvancadas = new JPanel();
        pnlConfigAvancadas.setBackground(new Color(173, 216, 230));
        this.tabbedPane.addTab("Configura\u00e7\u00f5es Avan\u00e7adas", null, pnlConfigAvancadas, "Outras configura\u00e7\u00f5es");
        String varLCR = this.props.getProperty("user.lcr.cache");
        this.chckbxUsarCacheLCR.setForeground(new Color(0, 0, 51));
        this.chckbxUsarCacheLCR.setBackground(new Color(173, 216, 230));
        this.chckbxUsarCacheLCR.setToolTipText("Marque essa op\u00e7\u00e3o para usar cache local de LCR");
        if (varLCR != null && !varLCR.isEmpty()) {
            this.chckbxUsarCacheLCR.setSelected(Boolean.parseBoolean(varLCR));
        }
        this.chckbxUsarCacheLCR.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                try {
                    if (e.getStateChange() == 1) {
                        SignerConfigurations.this.props.setProperty("user.lcr.cache", "true");
                        SignerConfigurations.this.props.setProperty("user.lcr.cache.local", FULL_PATH_FOLDER_ASSINADOR_LCR.toString());
                    } else {
                        SignerConfigurations.this.props.setProperty("user.lcr.cache", "false");
                    }
                    ConfigProperties.saveProps(SignerConfigurations.this.props);
                }
                catch (Exception e1) {
                    logger.error("Erro ao gravar arquivo de configura\u00e7\u00e3o local:" + e1.getMessage());
                    SignerDialog.showMessageDialog(instanceSignerConfigurations, "Erro", "Erro ao gravar arquivo de configura\u00e7\u00e3o local:" + e1.getMessage(), 0);
                }
            }
        });
        this.chckbxUsarCacheLCR.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent e) {
                SignerConfigurations.this.setCursor(new Cursor(12));
            }

            @Override
            public void mouseExited(MouseEvent e) {
                SignerConfigurations.this.setCursor(new Cursor(0));
            }
        });
        String varPDFSize = this.props.getProperty("user.pdf.size");
        if (varPDFSize != null && !varPDFSize.isEmpty()) {
            this.spinnerTamArquivos.setValue(Integer.valueOf(varPDFSize));
        }
        JButton btnFecharAvancadas = new JButton("Salvar e Fechar");
        btnFecharAvancadas.setFont(new Font("Ubuntu", 1, 15));
        btnFecharAvancadas.setBackground(new Color(51, 153, 255));
        btnFecharAvancadas.setBorder(BorderFactory.createLineBorder(new Color(0, 90, 170), 1, true));
        btnFecharAvancadas.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    SignerConfigurations.this.props.setProperty("user.pdf.size", SignerConfigurations.this.spinnerTamArquivos.getModel().getValue().toString());
                    ConfigProperties.saveProps(SignerConfigurations.this.props);
                }
                catch (IOException e1) {
                    logger.error("Erro ao gravar arquivo de configura\u00e7\u00e3o local:" + e1.getMessage());
                    SignerDialog.showMessageDialog(instanceSignerConfigurations, "Erro", "Erro ao gravar arquivo de configura\u00e7\u00e3o local:" + e1.getMessage(), 0);
                }
                sc.dispose();
            }
        });
        btnFecharAvancadas.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent e) {
                SignerConfigurations.this.setCursor(new Cursor(12));
            }

            @Override
            public void mouseExited(MouseEvent e) {
                SignerConfigurations.this.setCursor(new Cursor(0));
            }
        });
        String varMSCAPI = this.props.getProperty("user.mscapi.off");
        this.chckbxDesabilitarMscapi.setForeground(new Color(0, 0, 51));
        this.chckbxDesabilitarMscapi.setBackground(new Color(173, 216, 230));
        this.chckbxDesabilitarMscapi.setToolTipText("Clique nesta op\u00e7\u00e3o para desabilitar o uso do MSCAPI");
        String varSO = System.getProperty("os.name");
        this.chckbxDesabilitarMscapi.setEnabled(false);
        if (varSO.contains("indows")) {
            this.chckbxDesabilitarMscapi.setEnabled(true);
            this.chckbxDesabilitarMscapi.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseEntered(MouseEvent e) {
                    SignerConfigurations.this.setCursor(new Cursor(12));
                }

                @Override
                public void mouseExited(MouseEvent e) {
                    SignerConfigurations.this.setCursor(new Cursor(0));
                }
            });
        }
        if (varMSCAPI != null && !varMSCAPI.isEmpty()) {
            this.chckbxDesabilitarMscapi.setSelected(Boolean.parseBoolean(varMSCAPI));
        }
        this.chckbxDesabilitarMscapi.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                try {
                    if (SignerConfigurations.this.chckbxDesabilitarMscapi.isSelected()) {
                        SignerConfigurations.this.props.setProperty("user.mscapi.off", "true");
                    } else {
                        if (SignerConfigurations.this.chckbxUsarCertificadoEmArquivo.isSelected()) {
                            SignerDialog.showMessageDialog(instanceSignerConfigurations, "Voc\u00ea configurou um certificado armazenado em arquivo!\n n\u00e3o \u00e9 poss\u00edvel reabilitar o MSCAPI enquanto houver essa configura\u00e7\u00e3o!", "Desabilitar/Habilitar MSCAPI", 0);
                            SignerConfigurations.this.chckbxDesabilitarMscapi.setSelected(true);
                        } else {
                            SignerConfigurations.this.props.setProperty("user.mscapi.off", "false");
                        }
                        if (SignerConfigurations.this.chckbxSomenteNeoid.isSelected()) {
                            SignerDialog.showMessageDialog(instanceSignerConfigurations, "A op\u00e7\u00e3o Somente SerproID est\u00e1 marcada!\n n\u00e3o \u00e9 poss\u00edvel reabilitar o MSCAPI enquanto houver essa configura\u00e7\u00e3o!", "Desabilitar/Habilitar MSCAPI", 0);
                            SignerConfigurations.this.chckbxDesabilitarMscapi.setSelected(true);
                        } else {
                            SignerConfigurations.this.props.setProperty("user.mscapi.off", "false");
                        }
                        if (SignerConfigurations.this.chckbxCarregarDriverLocal.isSelected()) {
                            SignerDialog.showMessageDialog(instanceSignerConfigurations, "A op\u00e7\u00e3o Carregar Driver Local est\u00e1 marcada!\n n\u00e3o \u00e9 poss\u00edvel reabilitar o MSCAPI enquanto houver essa configura\u00e7\u00e3o!", "Desabilitar/Habilitar MSCAPI", 0);
                            SignerConfigurations.this.chckbxDesabilitarMscapi.setSelected(true);
                        } else {
                            SignerConfigurations.this.props.setProperty("user.mscapi.off", "false");
                        }
                    }
                    SignerConfigurations.this.restart = true;
                    ConfigProperties.saveProps(SignerConfigurations.this.props);
                }
                catch (Exception e1) {
                    logger.error("Erro ao gravar arquivo de configura\u00e7\u00e3o local:" + e1.getMessage());
                    SignerDialog.showMessageDialog(instanceSignerConfigurations, "Erro", "Erro ao gravar arquivo de configura\u00e7\u00e3o local:" + e1.getMessage(), 0);
                }
            }
        });
        String varEstatisticas = this.props.getProperty("user.statistics.off");
        this.chckbxDesabilitarEstatisticas.setForeground(new Color(0, 0, 51));
        this.chckbxDesabilitarEstatisticas.setBackground(new Color(173, 216, 230));
        this.chckbxDesabilitarEstatisticas.setToolTipText("Clique nesta op\u00e7\u00e3o para desabilitar o envio de estat\u00edsticas de uso");
        if (varEstatisticas != null && !varEstatisticas.isEmpty()) {
            this.chckbxDesabilitarEstatisticas.setSelected(Boolean.parseBoolean(varEstatisticas));
        }
        this.chckbxDesabilitarEstatisticas.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent e) {
                SignerConfigurations.this.setCursor(new Cursor(12));
            }

            @Override
            public void mouseExited(MouseEvent e) {
                SignerConfigurations.this.setCursor(new Cursor(0));
            }
        });
        this.chckbxDesabilitarEstatisticas.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                try {
                    if (SignerConfigurations.this.chckbxDesabilitarEstatisticas.isSelected()) {
                        Thread th = new Thread(new Runnable(){

                            @Override
                            public void run() {
                                int result = JOptionPane.showConfirmDialog(instanceSignerConfigurations, "A n\u00e3o coleta de estat\u00edsticas, al\u00e9m de prejudicar futuras evolu\u00e7\u00f5es do produto, pode impedir o suporte do produto em caso de problemas.\nDeseja realmente confirmar esta op\u00e7\u00e3o", "Confirmar a\u00e7\u00e3o", 0);
                                if (result == 1) {
                                    SignerConfigurations.this.chckbxDesabilitarEstatisticas.setSelected(false);
                                    SignerConfigurations.this.props.setProperty("user.statistics.off", "false");
                                    SignerConfigurations.this.instaSta.setCollecting(true);
                                } else {
                                    SignerConfigurations.this.props.setProperty("user.statistics.off", "true");
                                    SignerConfigurations.this.instaSta.setCollecting(false);
                                }
                            }
                        });
                        th.start();
                    } else {
                        SignerConfigurations.this.props.setProperty("user.statistics.off", "false");
                        SignerConfigurations.this.instaSta.setCollecting(true);
                    }
                    ConfigProperties.saveProps(SignerConfigurations.this.props);
                }
                catch (Exception e1) {
                    logger.error("Erro ao gravar arquivo de configura\u00e7\u00e3o local:" + e1.getMessage());
                    SignerDialog.showMessageDialog(instanceSignerConfigurations, "Erro", "Erro ao gravar arquivo de configura\u00e7\u00e3o local:" + e1.getMessage(), 0);
                }
            }
        });
        String varLogoffDoToken = this.props.getProperty("user.logoff.token");
        this.chckbxLogoffDoToken = new JCheckBox("LogOff do Token");
        this.chckbxLogoffDoToken.setForeground(new Color(0, 0, 51));
        this.chckbxLogoffDoToken.setToolTipText("Clique nesta op\u00e7\u00e3o para setar LogOff do Token para cada assinatura");
        this.chckbxLogoffDoToken.setBackground(new Color(173, 216, 230));
        if (varLogoffDoToken != null && !varLogoffDoToken.isEmpty()) {
            this.chckbxLogoffDoToken.setSelected(Boolean.parseBoolean(varLogoffDoToken));
        }
        this.chckbxLogoffDoToken.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent e) {
                SignerConfigurations.this.setCursor(new Cursor(12));
            }

            @Override
            public void mouseExited(MouseEvent e) {
                SignerConfigurations.this.setCursor(new Cursor(0));
            }
        });
        this.chckbxLogoffDoToken.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                try {
                    if (SignerConfigurations.this.chckbxLogoffDoToken.isSelected()) {
                        Thread th = new Thread(new Runnable(){

                            @Override
                            public void run() {
                                if (SignerConfigurations.this.chckbxUsarCertificadoEmArquivo.isSelected()) {
                                    SignerDialog.showMessageDialog(instanceSignerConfigurations, "Voc\u00ea configurou um certificado armazenado em arquivo!\nA op\u00e7\u00e3o LogOff n\u00e3o \u00e9 v\u00e1lida enquanto houver essa configura\u00e7\u00e3o!", "LogOff Token", 0);
                                    SignerConfigurations.this.chckbxLogoffDoToken.setSelected(false);
                                } else if (SignerConfigurations.this.chckbxSomenteNeoid.isSelected()) {
                                    SignerDialog.showMessageDialog(instanceSignerConfigurations, "Voc\u00ea configurou a op\u00e7\u00e3o de usar somente SerproID!\nA op\u00e7\u00e3o LogOff n\u00e3o \u00e9 v\u00e1lida enquanto houver essa configura\u00e7\u00e3o!", "LogOff Token", 0);
                                    SignerConfigurations.this.chckbxLogoffDoToken.setSelected(false);
                                } else {
                                    int op = JOptionPane.showConfirmDialog(instanceSignerConfigurations, "Ao marcar essa op\u00e7\u00e3o ser\u00e1 pedida a senha do Token a cada assinatura, n\u00e3o \u00e9 aconselh\u00e1vel caso venha a utilizar a fun\u00e7\u00e3o de Assinatura de arquivos em Lote!", "AVISO", 2);
                                    if (op == 0) {
                                        SignerConfigurations.this.props.setProperty("user.logoff.token", "true");
                                    } else {
                                        SignerConfigurations.this.chckbxLogoffDoToken.setSelected(false);
                                    }
                                }
                            }
                        });
                        th.start();
                    } else {
                        SignerConfigurations.this.props.setProperty("user.logoff.token", "false");
                    }
                    SignerConfigurations.this.restart = true;
                    ConfigProperties.saveProps(SignerConfigurations.this.props);
                }
                catch (Exception ex1) {
                    logger.error("Erro ao setar LogOFF do token: " + ex1.getMessage());
                    SignerDialog.showMessageDialog(null, "Erro", ex1.getMessage(), 0);
                }
            }
        });
        String varSomenteNeoid = this.props.getProperty("user.neoid.on");
        this.chckbxSomenteNeoid = new JCheckBox("Somente SerproID");
        this.chckbxSomenteNeoid.setForeground(new Color(0, 0, 51));
        this.chckbxSomenteNeoid.setToolTipText("Clique nesta op\u00e7\u00e3o para usar somente o SerproID");
        this.chckbxSomenteNeoid.setBackground(new Color(173, 216, 230));
        if (varSomenteNeoid != null && !varSomenteNeoid.isEmpty()) {
            this.chckbxSomenteNeoid.setSelected(Boolean.parseBoolean(varSomenteNeoid));
        }
        this.chckbxSomenteNeoid.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent e) {
                SignerConfigurations.this.setCursor(new Cursor(12));
            }

            @Override
            public void mouseExited(MouseEvent e) {
                SignerConfigurations.this.setCursor(new Cursor(0));
            }
        });
        this.chckbxSomenteNeoid.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                try {
                    if (SignerConfigurations.this.chckbxSomenteNeoid.isSelected()) {
                        Thread th = new Thread(new Runnable(){

                            @Override
                            public void run() {
                                if (SignerConfigurations.this.configSigner.isUseCertificateFile() || SignerConfigurations.this.chckbxUsarCertificadoEmArquivo.isSelected() || SignerConfigurations.this.configSigner.isChooseFileCertificate() || SignerConfigurations.this.chckbxSelecionarAoAssinar.isSelected()) {
                                    int op = JOptionPane.showConfirmDialog(instanceSignerConfigurations, "Voc\u00ea havia configurado um certificado em arquivo que ser\u00e1 desabilitado, confirma ? ", "Somente SerproID", 2);
                                    if (op == 0) {
                                        SignerConfigurations.this.props.remove("user.certificate.file.word");
                                        SignerConfigurations.this.props.remove("user.certificate.file.path");
                                        SignerConfigurations.this.props.remove("user.certificate.file.status");
                                        SignerConfigurations.this.chckbxUsarCertificadoEmArquivo.setSelected(false);
                                        SignerConfigurations.this.configSigner.setUseCertificateFile(false);
                                        SignerConfigurations.this.props.remove("user.certificate.file.choose");
                                        SignerConfigurations.this.configSigner.setChooseFileCertificate(false);
                                        SignerConfigurations.this.chckbxSelecionarAoAssinar.setSelected(false);
                                        SignerConfigurations.this.props.setProperty("user.mscapi.off", "true");
                                        SignerConfigurations.this.props.setProperty("user.neoid.on", "true");
                                        SignerConfigurations.this.chckbxLogoffDoToken.setSelected(false);
                                        SignerConfigurations.this.props.remove("user.logoff.token");
                                    } else {
                                        SignerConfigurations.this.chckbxSomenteNeoid.setSelected(false);
                                    }
                                } else if (SignerConfigurations.this.chckbxCarregarDriverLocal.isSelected()) {
                                    int op = JOptionPane.showConfirmDialog(instanceSignerConfigurations, "Voc\u00ea havia configurado para carregar um driver local, que ser\u00e1 desabilitado, confirma ? ", "Somente SerproID", 2);
                                    if (op == 0) {
                                        SignerConfigurations.this.props.remove("user.driver.file.path");
                                        SignerConfigurations.this.props.remove("user.driver.path.status");
                                        SignerConfigurations.this.chckbxCarregarDriverLocal.setSelected(false);
                                        SignerConfigurations.this.configSigner.setSelectedToken(false);
                                        SignerConfigurations.this.props.setProperty("user.mscapi.off", "true");
                                        SignerConfigurations.this.props.setProperty("user.neoid.on", "true");
                                        SignerConfigurations.this.chckbxDesabilitarMscapi.setSelected(true);
                                        SignerConfigurations.this.chckbxLogoffDoToken.setSelected(false);
                                        SignerConfigurations.this.props.remove("user.logoff.token");
                                    } else {
                                        SignerConfigurations.this.chckbxSomenteNeoid.setSelected(false);
                                    }
                                } else {
                                    SignerConfigurations.this.props.setProperty("user.mscapi.off", "true");
                                    SignerConfigurations.this.chckbxDesabilitarMscapi.setSelected(true);
                                    SignerConfigurations.this.props.setProperty("user.neoid.on", "true");
                                    SignerConfigurations.this.chckbxLogoffDoToken.setSelected(false);
                                    SignerConfigurations.this.props.remove("user.logoff.token");
                                }
                            }
                        });
                        th.start();
                    } else if (SignerConfigurations.this.chckbxCarregarDriverLocal.isSelected() || SignerConfigurations.this.chckbxUsarCertificadoEmArquivo.isSelected() || SignerConfigurations.this.chckbxSelecionarAoAssinar.isSelected()) {
                        SignerConfigurations.this.props.remove("user.neoid.on");
                    } else {
                        SignerConfigurations.this.props.remove("user.mscapi.off");
                        SignerConfigurations.this.chckbxDesabilitarMscapi.setSelected(false);
                        SignerConfigurations.this.configSigner.setMsCAPIOff(false);
                        SignerConfigurations.this.props.remove("user.neoid.on");
                        SignerConfigurations.this.configSigner.setUseNeoId(false);
                    }
                    ConfigProperties.saveProps(SignerConfigurations.this.props);
                }
                catch (Exception ex1) {
                    logger.error("Erro ao setar somente SerproID" + ex1.getMessage());
                    SignerDialog.showMessageDialog(null, "Erro", "Erro ao setar somente SerproID" + ex1.getMessage(), 0);
                }
            }
        });
        String varPBAD = this.props.getProperty("user.pbad.on");
        this.chckbxUsarPBAD = new JCheckBox("Usar PDF PBAD (Sempre que poss\u00edvel)");
        this.chckbxUsarPBAD.setForeground(new Color(0, 0, 51));
        this.chckbxUsarPBAD.setToolTipText("Clique nesta op\u00e7\u00e3o para que documentos produzidos em vers\u00f5es iguais ou superiores a 1.5 utilize o padr\u00e3o PBAD");
        this.chckbxUsarPBAD.setBackground(new Color(173, 216, 230));
        if (varPBAD != null && !varPBAD.isEmpty() && varPBAD.length() > 1) {
            this.chckbxUsarPBAD.setSelected(Boolean.parseBoolean(varPBAD));
        }
        this.chckbxUsarPBAD.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent e) {
                SignerConfigurations.this.setCursor(new Cursor(12));
            }

            @Override
            public void mouseExited(MouseEvent e) {
                SignerConfigurations.this.setCursor(new Cursor(0));
            }
        });
        this.chckbxUsarPBAD.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1) {
                    SignerConfigurations.this.props.setProperty("user.pbad.on", "true");
                } else {
                    SignerConfigurations.this.props.setProperty("user.pbad.on", "false");
                }
            }
        });
        String varLpaOnline = this.props.getProperty("user.lpa.online");
        JCheckBox chckbxLpaOnline = new JCheckBox("LPA Online ");
        chckbxLpaOnline.setForeground(new Color(0, 0, 51));
        chckbxLpaOnline.setToolTipText("Marque essa op\u00e7\u00e3o para definir a busca de LPA como online apenas ");
        chckbxLpaOnline.setBackground(new Color(173, 216, 230));
        if (varLpaOnline != null && !varLpaOnline.isEmpty() && varLpaOnline.length() > 1) {
            chckbxLpaOnline.setSelected(Boolean.parseBoolean(varLpaOnline));
        }
        chckbxLpaOnline.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1) {
                    SignerConfigurations.this.props.setProperty("user.lpa.online", "true");
                } else {
                    SignerConfigurations.this.props.setProperty("user.lpa.online", "false");
                }
            }
        });
        chckbxLpaOnline.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent e) {
                SignerConfigurations.this.setCursor(new Cursor(12));
            }

            @Override
            public void mouseExited(MouseEvent e) {
                SignerConfigurations.this.setCursor(new Cursor(0));
            }
        });
        JCheckBox chckbxDebugON = new JCheckBox("Modo Debug");
        chckbxDebugON.setForeground(new Color(0, 0, 51));
        chckbxDebugON.setVerticalAlignment(1);
        String varDebugON = this.props.getProperty("user.debug.on");
        chckbxDebugON.setToolTipText("Marque essa op\u00e7\u00e3o para gerar logs em modo Debug");
        chckbxDebugON.setBackground(new Color(173, 216, 230));
        if (varDebugON != null && !varDebugON.isEmpty() && varDebugON.length() > 1) {
            chckbxDebugON.setSelected(Boolean.parseBoolean(varDebugON));
        }
        chckbxDebugON.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent e) {
                SignerConfigurations.this.setCursor(new Cursor(12));
            }

            @Override
            public void mouseExited(MouseEvent e) {
                SignerConfigurations.this.setCursor(new Cursor(0));
            }
        });
        chckbxDebugON.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1) {
                    SignerConfigurations.this.props.setProperty("user.debug.on", "true");
                    LogManager.getRootLogger().setLevel(Level.DEBUG);
                } else {
                    SignerConfigurations.this.props.setProperty("user.debug.on", "false");
                    LogManager.getRootLogger().setLevel(Level.INFO);
                }
            }
        });
        final JCheckBox chckbxLcrOff = new JCheckBox("LCR Off");
        chckbxLcrOff.setForeground(new Color(0, 0, 51));
        chckbxLcrOff.setToolTipText("Marque essa op\u00e7\u00e3o para desativar a valida\u00e7\u00e3o de LCR!! ");
        chckbxLcrOff.setBackground(new Color(173, 216, 230));
        String varLcrOff = this.props.getProperty("user.lcr.off");
        if (varLcrOff != null && !varLcrOff.isEmpty()) {
            chckbxLcrOff.setSelected(Boolean.parseBoolean(varLcrOff));
        }
        chckbxLcrOff.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent e) {
                SignerConfigurations.this.setCursor(new Cursor(12));
            }

            @Override
            public void mouseExited(MouseEvent e) {
                SignerConfigurations.this.setCursor(new Cursor(0));
            }
        });
        chckbxLcrOff.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1) {
                    Thread th = new Thread(new Runnable(){

                        @Override
                        public void run() {
                            int result = JOptionPane.showConfirmDialog(instanceSignerConfigurations, "Ao desativar a valida\u00e7\u00e3o de LCR para Assinaturas est\u00e1 assumindo que \n  seu certificado n\u00e3o est\u00e1 revogado.\nAssumindo a inteira responsabilidade sobre essa a\u00e7\u00e3o! \nDeseja realmente confirmar esta op\u00e7\u00e3o?", "Confirmar a\u00e7\u00e3o", 0);
                            if (result == 1) {
                                chckbxLcrOff.setSelected(false);
                                SignerConfigurations.this.props.setProperty("user.lcr.off", "false");
                            } else {
                                SignerConfigurations.this.props.setProperty("user.lcr.off", "true");
                            }
                        }
                    });
                    th.start();
                } else {
                    SignerConfigurations.this.props.setProperty("user.lcr.off", "false");
                }
            }
        });
        GroupLayout glConfigAvancadas = new GroupLayout(pnlConfigAvancadas);
        glConfigAvancadas.setHorizontalGroup(glConfigAvancadas.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(glConfigAvancadas.createSequentialGroup().addContainerGap().addGroup(glConfigAvancadas.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(glConfigAvancadas.createSequentialGroup().addGroup(glConfigAvancadas.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.chckbxUsarCacheLCR).addComponent(this.chckbxLogoffDoToken).addComponent(chckbxLpaOnline)).addGroup(glConfigAvancadas.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(glConfigAvancadas.createSequentialGroup().addGap(18).addGroup(glConfigAvancadas.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.chckbxDesabilitarEstatisticas).addComponent(chckbxDebugON, -2, 129, -2))).addGroup(glConfigAvancadas.createSequentialGroup().addGap(20).addGroup(glConfigAvancadas.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(glConfigAvancadas.createSequentialGroup().addComponent(this.chckbxDesabilitarMscapi).addGap(26).addComponent(this.chckbxUsarPBAD, -2, 294, -2)).addGroup(glConfigAvancadas.createSequentialGroup().addComponent(this.chckbxSomenteNeoid).addGap(65).addComponent(this.lblTamanhoDosArquivos).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(glConfigAvancadas.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(btnFecharAvancadas, -2, 132, -2).addComponent(this.spinnerTamArquivos, -2, -1, -2))))))).addComponent(chckbxLcrOff, -2, 91, -2)).addContainerGap(72, Short.MAX_VALUE)));
        this.lblTamanhoDosArquivos.setForeground(new Color(0, 0, 51));
        this.spinnerTamArquivos.setForeground(new Color(0, 0, 51));
        glConfigAvancadas.setVerticalGroup(glConfigAvancadas.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(glConfigAvancadas.createSequentialGroup().addGap(21).addGroup(glConfigAvancadas.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.chckbxUsarCacheLCR).addComponent(this.chckbxDesabilitarMscapi).addComponent(this.chckbxUsarPBAD)).addGap(18).addGroup(glConfigAvancadas.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(glConfigAvancadas.createSequentialGroup().addGroup(glConfigAvancadas.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.chckbxLogoffDoToken).addComponent(this.chckbxSomenteNeoid)).addGap(18).addGroup(glConfigAvancadas.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(chckbxLpaOnline).addComponent(chckbxDebugON)).addGap(18).addGroup(glConfigAvancadas.createParallelGroup(GroupLayout.Alignment.BASELINE, false).addComponent(chckbxLcrOff).addComponent(this.chckbxDesabilitarEstatisticas)).addGap(4)).addGroup(glConfigAvancadas.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.lblTamanhoDosArquivos).addComponent(this.spinnerTamArquivos, -1, 36, Short.MAX_VALUE))).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(btnFecharAvancadas, -2, 36, -2).addGap(40)));
        this.lblTamanhoDosArquivos.setBackground(new Color(173, 216, 230));
        this.lblTamanhoDosArquivos.setToolTipText("Definir o tamanho m\u00e1ximo do arquivo a ser assinado");
        pnlConfigAvancadas.setLayout(glConfigAvancadas);
        pnlConfigAvancadas.setFocusTraversalPolicy(new FocusTraversalOnArray(new Component[]{this.chckbxUsarCacheLCR, this.chckbxDesabilitarMscapi, btnFecharAvancadas}));
        JPanel pnlCertificadoArquivo = new JPanel();
        pnlCertificadoArquivo.setBackground(new Color(173, 216, 230));
        this.tabbedPane.addTab("Certificado em Arquivo", null, pnlCertificadoArquivo, "Configurar certificado armazenado em arquivo");
        this.btFecharAbaCertificadoArquivo = new JButton("Salvar");
        this.btFecharAbaCertificadoArquivo.setFont(new Font("Ubuntu", 1, 15));
        this.btFecharAbaCertificadoArquivo.setBackground(new Color(51, 153, 255));
        this.btFecharAbaCertificadoArquivo.setBorder(BorderFactory.createLineBorder(new Color(0, 90, 170), 1, true));
        this.btFecharAbaCertificadoArquivo.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent e) {
                SignerConfigurations.this.setCursor(new Cursor(12));
            }

            @Override
            public void mouseExited(MouseEvent e) {
                SignerConfigurations.this.setCursor(new Cursor(0));
            }
        });
        this.chkSalvarSenha = new JCheckBox("Salvar Senha");
        this.chkSalvarSenha.setForeground(new Color(0, 0, 51));
        this.chkSalvarSenha.setEnabled(false);
        this.chkSalvarSenha.setToolTipText("Marque essa op\u00e7\u00e3o para salvar a senha localmente. N\u00e3o ir\u00e1 pedir para assinar.");
        this.chkSalvarSenha.setBackground(new Color(173, 216, 230));
        this.passCertField.setEnabled(false);
        this.btnSelecionarArquivo = new JButton("Selecionar arquivo...");
        this.btnSelecionarArquivo.setForeground(new Color(0, 0, 51));
        this.btnSelecionarArquivo.setEnabled(false);
        this.btnSelecionarArquivo.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent e) {
                SignerConfigurations.this.setCursor(new Cursor(12));
            }

            @Override
            public void mouseExited(MouseEvent e) {
                SignerConfigurations.this.setCursor(new Cursor(0));
            }
        });
        this.textLocalCertificado = new JTextField();
        this.textLocalCertificado.setBackground(new Color(204, 204, 255));
        this.textLocalCertificado.setEditable(false);
        this.textLocalCertificado.setColumns(10);
        this.chckbxUsarCertificadoEmArquivo = new JCheckBox("Definir um certificado em arquivo");
        this.chckbxUsarCertificadoEmArquivo.setForeground(new Color(0, 0, 51));
        this.chckbxUsarCertificadoEmArquivo.setBackground(new Color(173, 216, 230));
        String varUsarCertificado = this.props.getProperty("user.certificate.file.status");
        if (varUsarCertificado != null && !varUsarCertificado.isEmpty()) {
            this.chckbxUsarCertificadoEmArquivo.setSelected(Boolean.parseBoolean(varUsarCertificado));
            String varPath = this.props.getProperty("user.certificate.file.path");
            this.textLocalCertificado.setText(varPath);
            String varWord = this.props.getProperty("user.certificate.file.word");
            this.btnSelecionarArquivo.setEnabled(true);
            this.chkSalvarSenha.setEnabled(true);
            this.chckbxSelecionarAoAssinar.setEnabled(false);
            if (varWord != null && !varWord.isEmpty()) {
                byte[] varBytes = Base64Utils.base64Decode(varWord);
                String strCertPass = new String(varBytes, StandardCharsets.UTF_8);
                this.passCertField.setText(strCertPass);
                this.chkSalvarSenha.setEnabled(true);
                this.chkSalvarSenha.setSelected(true);
                this.passCertField.setEditable(true);
                this.passCertField.setEnabled(true);
                this.btnSelecionarArquivo.setEnabled(false);
            }
        }
        this.chckbxSelecionarAoAssinar.setForeground(new Color(0, 0, 51));
        this.chckbxSelecionarAoAssinar.setBackground(new Color(173, 216, 230));
        String varSelecionarAoAssinar = this.props.getProperty("user.certificate.file.choose");
        if (varSelecionarAoAssinar != null && !varSelecionarAoAssinar.isEmpty()) {
            this.chckbxSelecionarAoAssinar.setSelected(Boolean.parseBoolean(varSelecionarAoAssinar));
            this.chckbxUsarCertificadoEmArquivo.setEnabled(false);
        }
        this.chckbxSelecionarAoAssinar.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                try {
                    if (SignerConfigurations.this.chckbxSelecionarAoAssinar.isSelected()) {
                        SignerConfigurations.this.chckbxUsarCertificadoEmArquivo.setSelected(false);
                        SignerConfigurations.this.chckbxUsarCertificadoEmArquivo.setEnabled(false);
                        SignerConfigurations.this.props.setProperty("user.certificate.file.choose", "true");
                        SignerConfigurations.this.props.remove("user.certificate.file.status");
                        SignerConfigurations.this.props.remove("user.certificate.file.path");
                        SignerConfigurations.this.props.remove("user.certificate.file.word");
                        SignerConfigurations.this.chckbxDesabilitarMscapi.setSelected(true);
                        SignerConfigurations.this.props.setProperty("user.mscapi.off", "true");
                        SignerConfigurations.this.configSigner.setChooseFileCertificate(true);
                    } else {
                        SignerConfigurations.this.props.setProperty("user.certificate.file.choose", "false");
                        SignerConfigurations.this.configSigner.setChooseFileCertificate(false);
                        SignerConfigurations.this.chckbxUsarCertificadoEmArquivo.setEnabled(true);
                    }
                }
                catch (Exception e1) {
                    SignerDialog.showMessageDialog(instanceSignerConfigurations, "Erro", e1.getMessage(), 0);
                }
            }
        });
        GroupLayout glCertificadoArquivo = new GroupLayout(pnlCertificadoArquivo);
        glCertificadoArquivo.setHorizontalGroup(glCertificadoArquivo.createParallelGroup(GroupLayout.Alignment.TRAILING).addGroup(glCertificadoArquivo.createSequentialGroup().addGap(12).addGroup(glCertificadoArquivo.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(glCertificadoArquivo.createSequentialGroup().addComponent(this.chckbxUsarCertificadoEmArquivo).addGap(30).addComponent(this.chckbxSelecionarAoAssinar)).addComponent(this.textLocalCertificado, -2, 578, -2).addComponent(this.btnSelecionarArquivo).addGroup(glCertificadoArquivo.createSequentialGroup().addComponent(this.chkSalvarSenha).addGap(18).addComponent(this.passCertField, -2, 174, -2).addGap(111).addComponent(this.btFecharAbaCertificadoArquivo, -1, 172, Short.MAX_VALUE))).addGap(224)));
        glCertificadoArquivo.setVerticalGroup(glCertificadoArquivo.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(glCertificadoArquivo.createSequentialGroup().addGap(24).addGroup(glCertificadoArquivo.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.chckbxUsarCertificadoEmArquivo).addComponent(this.chckbxSelecionarAoAssinar)).addGap(18).addComponent(this.btnSelecionarArquivo).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.textLocalCertificado, -2, -1, -2).addGroup(glCertificadoArquivo.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(glCertificadoArquivo.createSequentialGroup().addGap(18).addGroup(glCertificadoArquivo.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.chkSalvarSenha).addComponent(this.passCertField, -2, -1, -2))).addGroup(glCertificadoArquivo.createSequentialGroup().addGap(27).addComponent(this.btFecharAbaCertificadoArquivo, -2, 41, -2))).addGap(50)));
        pnlCertificadoArquivo.setLayout(glCertificadoArquivo);
        this.chckbxUsarCertificadoEmArquivo.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                try {
                    if (SignerConfigurations.this.chckbxUsarCertificadoEmArquivo.isSelected()) {
                        SignerConfigurations.this.chckbxSelecionarAoAssinar.setEnabled(false);
                        SignerConfigurations.this.props.remove("user.certificate.file.choose");
                        SignerConfigurations.this.configSigner.setChooseFileCertificate(false);
                        SignerConfigurations.this.chkSalvarSenha.setEnabled(true);
                        SignerConfigurations.this.btnSelecionarArquivo.setEnabled(true);
                        SignerConfigurations.this.chckbxDesabilitarMscapi.setSelected(true);
                        SignerConfigurations.this.props.setProperty("user.mscapi.off", "true");
                    } else if (!SignerConfigurations.this.textLocalCertificado.getText().trim().isEmpty()) {
                        int op = JOptionPane.showConfirmDialog(instanceSignerConfigurations, "Ao desmarcar essa op\u00e7\u00e3o as configura\u00e7\u00f5es abaixo ser\u00e3o apagadas. \n Confirma?", "AVISO", 2);
                        if (op == 0) {
                            SignerConfigurations.this.props.remove("user.certificate.file.status");
                            SignerConfigurations.this.chkSalvarSenha.setEnabled(false);
                            SignerConfigurations.this.chkSalvarSenha.setSelected(false);
                            SignerConfigurations.this.btnSelecionarArquivo.setEnabled(false);
                            SignerConfigurations.this.passCertField.setText("");
                            SignerConfigurations.this.textLocalCertificado.setText("");
                            SignerConfigurations.this.props.remove("user.certificate.file.path");
                            SignerConfigurations.this.props.remove("user.certificate.file.word");
                            SignerConfigurations.this.passCertField.setEditable(false);
                            SignerConfigurations.this.passCertField.setEnabled(false);
                            SignerConfigurations.this.chckbxUsarCertificadoEmArquivo.setSelected(false);
                            SignerConfigurations.this.chckbxDesabilitarMscapi.setSelected(false);
                            SignerConfigurations.this.props.remove("user.mscapi.off");
                        } else {
                            SignerConfigurations.this.chckbxUsarCertificadoEmArquivo.setSelected(true);
                        }
                    } else {
                        SignerConfigurations.this.props.remove("user.certificate.file.status");
                        SignerConfigurations.this.props.remove("user.certificate.file.path");
                        SignerConfigurations.this.props.remove("user.certificate.file.word");
                        SignerConfigurations.this.chckbxUsarCertificadoEmArquivo.setSelected(false);
                        SignerConfigurations.this.chkSalvarSenha.setEnabled(false);
                        SignerConfigurations.this.chkSalvarSenha.setSelected(false);
                        SignerConfigurations.this.btnSelecionarArquivo.setEnabled(false);
                        SignerConfigurations.this.chckbxSelecionarAoAssinar.setEnabled(true);
                    }
                }
                catch (Exception e1) {
                    logger.error("Erro ao setar A1: " + e1.getMessage());
                    SignerDialog.showMessageDialog(instanceSignerConfigurations, "Erro", "Erro ao setar A1 " + e1.getMessage(), 0);
                }
            }
        });
        this.btnSelecionarArquivo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                File selectedFile = FileUtil.selectA1Certificate();
                SignerConfigurations.this.textLocalCertificado.setText(selectedFile.getAbsolutePath());
                SignerConfigurations.this.props.setProperty("user.certificate.file.path", SignerConfigurations.this.textLocalCertificado.getText());
            }
        });
        this.chkSalvarSenha.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                try {
                    if (SignerConfigurations.this.chkSalvarSenha.isSelected()) {
                        SignerConfigurations.this.passCertField.setEditable(true);
                        SignerConfigurations.this.passCertField.setEnabled(true);
                    } else {
                        SignerConfigurations.this.passCertField.setEditable(false);
                        SignerConfigurations.this.passCertField.setEnabled(false);
                        SignerConfigurations.this.passCertField.setText(null);
                    }
                }
                catch (Exception ex1) {
                    logger.error("Erro ao salvar senha: " + ex1.getMessage());
                    SignerDialog.showMessageDialog(instanceSignerConfigurations, "Erro", ex1.getMessage(), 0);
                }
            }
        });
        this.btFecharAbaCertificadoArquivo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (SignerConfigurations.this.chckbxSelecionarAoAssinar.isSelected()) {
                    try {
                        SignerConfigurations.this.chckbxDesabilitarMscapi.setSelected(true);
                        SignerConfigurations.this.props.setProperty("user.mscapi.off", "true");
                        SignerConfigurations.this.configSigner.setMsCAPIOff(true);
                        if (SignerConfigurations.this.chckbxSomenteNeoid.isSelected()) {
                            SignerDialog.showMessageDialog(instanceSignerConfigurations, "Para usar um certificado em Arquivo, desabilitar\u00e1 o uso Exclusivo do SerproID", "Certificado em Arquivo", 2);
                            SignerConfigurations.this.props.setProperty("user.neoid.on", "false");
                            SignerConfigurations.this.chckbxSomenteNeoid.setSelected(false);
                            SignerConfigurations.this.configSigner.setUseNeoId(false);
                        }
                        if (SignerConfigurations.this.chckbxCarregarDriverLocal.isSelected()) {
                            SignerDialog.showMessageDialog(instanceSignerConfigurations, "Para usar um certificado em Arquivo, desabilitar\u00e1 o driver local", "Certificado em Arquivo", 2);
                            SignerConfigurations.this.props.remove("user.driver.file.path");
                            SignerConfigurations.this.props.remove("user.driver.path.status");
                            SignerConfigurations.this.chckbxCarregarDriverLocal.setSelected(false);
                            SignerConfigurations.this.configSigner.setSelectedToken(false);
                        }
                        SignerConfigurations.this.props.remove("user.certificate.file.word");
                        SignerConfigurations.this.props.remove("user.certificate.file.path");
                        SignerConfigurations.this.props.remove("user.certificate.file.status");
                        SignerConfigurations.this.props.setProperty("user.certificate.file.choose", "true");
                        SignerConfigurations.this.configSigner.setUseCertificateFile(false);
                        ConfigProperties.saveProps(SignerConfigurations.this.props);
                        SignerDialog.showMessageDialog(instanceSignerConfigurations, "Configura\u00e7\u00f5es realizadas com sucesso!", "Certificado em Arquivo", 1);
                        sc.dispose();
                    }
                    catch (IOException e1) {
                        logger.error("Erro ao gravar arquivo de configura\u00e7\u00e3o local:" + e1.getMessage());
                        SignerDialog.showMessageDialog(instanceSignerConfigurations, e1.getMessage(), "Erro ao gravar arquivo de configura\u00e7\u00e3o local:", 0);
                    }
                } else if (!SignerConfigurations.this.chckbxUsarCertificadoEmArquivo.isSelected()) {
                    int op = JOptionPane.showConfirmDialog(instanceSignerConfigurations, "Nenhuma configura\u00e7\u00e3o de certificado em arquivo foi marcada, confirma ? ", "Certificado em Arquivo", 2);
                    if (op == 0) {
                        SignerConfigurations.this.props.remove("user.certificate.file.word");
                        SignerConfigurations.this.props.remove("user.certificate.file.path");
                        SignerConfigurations.this.props.remove("user.certificate.file.status");
                        try {
                            ConfigProperties.saveProps(SignerConfigurations.this.props);
                            SignerDialog.showMessageDialog(instanceSignerConfigurations, "Configura\u00e7\u00f5es apagadas!", "Certificado em Arquivo", 0);
                            sc.dispose();
                        }
                        catch (IOException e1) {
                            logger.error("Erro ao gravar arquivo de configura\u00e7\u00e3o local:" + e1.getMessage());
                            SignerDialog.showMessageDialog(instanceSignerConfigurations, e1.getMessage(), "Erro ao gravar arquivo de configura\u00e7\u00e3o local:", 0);
                        }
                    }
                } else if (SignerConfigurations.this.textLocalCertificado.getText().isEmpty()) {
                    SignerDialog.showMessageDialog(instanceSignerConfigurations, "Informe arquivo de Certificado", "Certificado em Arquivo", 2);
                } else {
                    try {
                        String varCharArrayString = String.valueOf(SignerConfigurations.this.passCertField.getPassword());
                        if (varCharArrayString != null && !varCharArrayString.isEmpty()) {
                            try {
                                File filep12 = new File(SignerConfigurations.this.textLocalCertificado.getText());
                                KeyStoreLoader loader = KeyStoreLoaderFactory.factoryKeyStoreLoader(filep12);
                                loader.getKeyStore(String.copyValueOf(SignerConfigurations.this.passCertField.getPassword()));
                            }
                            catch (Exception e1) {
                                logger.error("Erro ao salvar senha do certificado" + e1.getMessage());
                                SignerDialog.showMessageDialog(instanceSignerConfigurations, e1.getMessage(), "Erro ao salvar senha do certificado", 0);
                                return;
                            }
                            String varEncodedBase64 = Base64Utils.base64Encode(varCharArrayString.getBytes());
                            SignerConfigurations.this.props.setProperty("user.certificate.file.word", varEncodedBase64);
                        } else {
                            SignerConfigurations.this.props.remove("user.certificate.file.word");
                        }
                        SignerConfigurations.this.chckbxDesabilitarMscapi.setSelected(true);
                        SignerConfigurations.this.props.setProperty("user.mscapi.off", "true");
                        if (SignerConfigurations.this.chckbxSomenteNeoid.isSelected()) {
                            SignerDialog.showMessageDialog(instanceSignerConfigurations, "Ao configurar um certificado em Arquivo, desabilitar\u00e1 o uso Exclusivo do SerproID", "Certificado em Arquivo", 2);
                            SignerConfigurations.this.props.setProperty("user.neoid.on", "false");
                            SignerConfigurations.this.chckbxSomenteNeoid.setSelected(false);
                        }
                        if (SignerConfigurations.this.chckbxCarregarDriverLocal.isSelected()) {
                            SignerDialog.showMessageDialog(instanceSignerConfigurations, "Ao configurar um certificado em Arquivo, desabilitar\u00e1 o driver local", "Certificado em Arquivo", 2);
                            SignerConfigurations.this.props.remove("user.driver.file.path");
                            SignerConfigurations.this.props.remove("user.driver.path.status");
                            SignerConfigurations.this.chckbxCarregarDriverLocal.setSelected(false);
                        }
                        SignerConfigurations.this.props.setProperty("user.certificate.file.status", "true");
                        ConfigProperties.saveProps(SignerConfigurations.this.props);
                        SignerDialog.showMessageDialog(instanceSignerConfigurations, "Configura\u00e7\u00f5es realizadas com sucesso!", "Certificado em Arquivo", 1);
                        sc.dispose();
                    }
                    catch (Exception e1) {
                        logger.error("Erro ao gravar arquivo de configura\u00e7\u00e3o local:" + e1.getMessage());
                        SignerDialog.showMessageDialog(instanceSignerConfigurations, e1.getMessage(), "Erro ao gravar arquivo de configura\u00e7\u00e3o local:", 0);
                    }
                }
            }
        });
        this.carregarDriver = new JPanel();
        this.carregarDriver.setBackground(new Color(173, 216, 230));
        this.tabbedPane.addTab("Carregar Driver", null, this.carregarDriver, "Definir um driver local ");
        this.txtLocalDriver = new JTextField();
        this.txtLocalDriver.setForeground(new Color(0, 0, 51));
        this.txtLocalDriver.setEditable(false);
        this.txtLocalDriver.setColumns(10);
        this.btSalvarDriver = new JButton("Salvar");
        this.btSalvarDriver.setFont(new Font("Ubuntu", 1, 15));
        this.btSalvarDriver.setBackground(new Color(51, 153, 255));
        this.btSalvarDriver.setBorder(BorderFactory.createLineBorder(new Color(0, 90, 170), 1, true));
        this.btSelecionarDriver = new JButton("Selecionar arquivo (.so ou .dll)...");
        this.btSelecionarDriver.setForeground(new Color(0, 0, 51));
        this.btSelecionarDriver.setEnabled(false);
        this.btSalvarDriver.setEnabled(false);
        this.btSalvarDriver.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent e) {
                SignerConfigurations.this.setCursor(new Cursor(12));
            }

            @Override
            public void mouseExited(MouseEvent e) {
                SignerConfigurations.this.setCursor(new Cursor(0));
            }
        });
        this.chckbxCarregarDriverLocal = new JCheckBox("Carregar driver local");
        this.chckbxCarregarDriverLocal.setForeground(new Color(0, 0, 51));
        this.chckbxCarregarDriverLocal.setBackground(new Color(173, 216, 230));
        String varDriverDefinido = this.props.getProperty("user.driver.path.status");
        if (varDriverDefinido != null && !varDriverDefinido.isEmpty()) {
            this.chckbxCarregarDriverLocal.setSelected(Boolean.parseBoolean(varDriverDefinido));
            if (Boolean.parseBoolean(varDriverDefinido)) {
                this.btSelecionarDriver.setEnabled(true);
                String varDriverFilePah = this.props.getProperty("user.driver.file.path");
                if (varDriverFilePah != null && !varDriverFilePah.isEmpty()) {
                    this.txtLocalDriver.setText(varDriverFilePah);
                }
            }
        }
        GroupLayout glCarregarDriver = new GroupLayout(this.carregarDriver);
        glCarregarDriver.setHorizontalGroup(glCarregarDriver.createParallelGroup(GroupLayout.Alignment.TRAILING).addGroup(glCarregarDriver.createSequentialGroup().addGroup(glCarregarDriver.createParallelGroup(GroupLayout.Alignment.TRAILING).addGroup(glCarregarDriver.createSequentialGroup().addContainerGap().addComponent(this.btSalvarDriver, -2, 117, -2)).addGroup(glCarregarDriver.createParallelGroup(GroupLayout.Alignment.TRAILING).addGroup(glCarregarDriver.createSequentialGroup().addContainerGap().addComponent(this.txtLocalDriver, -2, 578, -2)).addGroup(glCarregarDriver.createSequentialGroup().addGap(41).addGroup(glCarregarDriver.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.chckbxCarregarDriverLocal).addComponent(this.btSelecionarDriver, -1, -1, Short.MAX_VALUE))))).addGap(117)));
        glCarregarDriver.setVerticalGroup(glCarregarDriver.createParallelGroup(GroupLayout.Alignment.TRAILING).addGroup(glCarregarDriver.createSequentialGroup().addGap(22).addComponent(this.chckbxCarregarDriverLocal).addGap(18).addComponent(this.btSelecionarDriver, -1, -1, Short.MAX_VALUE).addGap(27).addComponent(this.txtLocalDriver, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.btSalvarDriver, -2, 26, -2).addGap(73)));
        this.carregarDriver.setLayout(glCarregarDriver);
        this.carregarTema = new ConfigureTheme(this);
        String tableTitle = "Tema Padr\u00e3o";
        this.tabbedPane.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                JTabbedPane jp = (JTabbedPane)e.getSource();
                if ("Tema Padr\u00e3o".equals(jp.getTitleAt(jp.getSelectedIndex()))) {
                    SignerConfigurations.this.carregarTema.getTheme().setSelectedIndex(SignerConfigurations.this.selectedTheme(SignerConfigurations.this.carregarTema.getProfiles()));
                }
            }
        });
        this.carregarTema.getTheme().setSelectedIndex(this.selectedTheme(this.carregarTema.getProfiles()));
        this.tabbedPane.addTab("Tema Padr\u00e3o", null, this.carregarTema, "Defina um tema para os selos em PDF");
        ConfigureStamp configureStamp = new ConfigureStamp(this.props);
        this.tabbedPane.addTab("Configurar Selo", null, configureStamp, "Configurar exibi\u00e7\u00e3o do selo em arquivos PDF");
        TimeStampConfigPanel carimboTempoApiTab = new TimeStampConfigPanel(this, this.props);
        carimboTempoApiTab.addToTabbedPane(this.tabbedPane);
        this.manutencao = new JPanel();
        this.manutencao.setBackground(new Color(173, 216, 230));
        this.tabbedPane.addTab("Manuten\u00e7\u00e3o", null, this.manutencao, "Redefina as configura\u00e7\u00f5es do Assinador Serpro");
        this.reset = new JButton("Reiniciar o Assinador");
        this.reset.setFont(new Font("Ubuntu", 1, 15));
        this.reset.setBackground(new Color(51, 153, 255));
        this.reset.setBorder(BorderFactory.createLineBorder(new Color(0, 90, 170), 1, true));
        this.reset.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent e) {
                SignerConfigurations.this.setCursor(new Cursor(12));
            }

            @Override
            public void mouseExited(MouseEvent e) {
                SignerConfigurations.this.setCursor(new Cursor(0));
            }
        });
        this.reset.setToolTipText("Redefine todas as configura\u00e7\u00f5es e permiss\u00f5es");
        GroupLayout glManutencao = new GroupLayout(this.manutencao);
        glManutencao.setHorizontalGroup(glManutencao.createParallelGroup(GroupLayout.Alignment.TRAILING).addGroup(GroupLayout.Alignment.LEADING, glManutencao.createSequentialGroup().addGap(259).addComponent(this.reset, -2, 164, -2).addContainerGap(313, Short.MAX_VALUE)));
        glManutencao.setVerticalGroup(glManutencao.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(glManutencao.createSequentialGroup().addGap(50).addComponent(this.reset, -2, 39, -2).addContainerGap(156, Short.MAX_VALUE)));
        this.manutencao.setLayout(glManutencao);
        if (!varSO.contains("indows")) {
            AcessibilityConfigPanel acessibilidadePanel = new AcessibilityConfigPanel(this);
            this.tabbedPane.addTab("Acessibilidade", null, acessibilidadePanel, null);
        }
        this.txtE.requestFocus();
        this.reset.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    int op = JOptionPane.showConfirmDialog(instanceSignerConfigurations, "Essa opera\u00e7\u00e3o vai apagar todas configura\u00e7\u00f5es e autoriza\u00e7\u00f5es do Assinador!! \nConfirma?", "AVISO", 2);
                    if (op == 0) {
                        String appConfDir = System.getProperty("user.home") + File.separator + SignerConfigurations.FOLDER_ASSINADOR;
                        File signerDir = new File(appConfDir);
                        if (!signerDir.exists()) {
                            logger.error("O diretorio de configura\u00e7\u00f5es do Assinador Serpro n\u00e3o foi encontrado");
                            SignerDialog.showMessageDialog(null, "O diretorio de configura\u00e7\u00f5es do Assinador Serpro n\u00e3o foi encontrado, reincie o seu computador", "ERRO", 0);
                        } else {
                            logger.info("Resetando todas as configura\u00e7\u00f5es do Assinador!!");
                            FileUtils.forceDeleteOnExit(signerDir);
                            SignerConfigurations.this.restart = true;
                            String html = "<html><body width='%1s'><p>Todas as configura\u00e7\u00f5es e permiss\u00f5es do Assinador foram apagadas <br>e o Assinador ser\u00e1 reiniciado e ser\u00e1 preciso refazer as permiss\u00f5es <br> nos Navegadores caso utilize algum sistema WEB com o Assinador";
                            SignerDialog.showMessageDialog(instanceSignerConfigurations, html, "Aviso", 1);
                            sc.dispose();
                        }
                    }
                }
                catch (Exception ex1) {
                    logger.error(ex1.getMessage());
                    SignerDialog.showMessageDialog(null, "Erro", ex1.getMessage(), 0);
                }
            }
        });
        this.chckbxCarregarDriverLocal.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                try {
                    if (SignerConfigurations.this.chckbxCarregarDriverLocal.isSelected()) {
                        SignerConfigurations.this.btSelecionarDriver.setEnabled(true);
                        SignerConfigurations.this.btSalvarDriver.setEnabled(true);
                    } else if (!SignerConfigurations.this.txtLocalDriver.getText().trim().isEmpty()) {
                        int op = JOptionPane.showConfirmDialog(instanceSignerConfigurations, "Ao desmarcar essa op\u00e7\u00e3o as configura\u00e7\u00f5es abaixo ser\u00e3o apagadas. Confirma?", "AVISO", 2);
                        if (op == 0) {
                            SignerConfigurations.this.props.remove("user.driver.file.path");
                            SignerConfigurations.this.props.remove("user.driver.path.status");
                            SignerConfigurations.this.txtLocalDriver.setText("");
                            SignerConfigurations.this.btSelecionarDriver.setEnabled(false);
                            SignerConfigurations.this.chckbxCarregarDriverLocal.setSelected(false);
                            SignerConfigurations.this.btSalvarDriver.setEnabled(false);
                            SignerConfigurations.this.chckbxDesabilitarMscapi.setSelected(false);
                            SignerConfigurations.this.props.setProperty("user.mscapi.off", "false");
                            ConfigProperties.saveProps(SignerConfigurations.this.props);
                        } else {
                            SignerConfigurations.this.chckbxCarregarDriverLocal.setSelected(true);
                        }
                    } else {
                        SignerConfigurations.this.btSelecionarDriver.setEnabled(false);
                        SignerConfigurations.this.chckbxCarregarDriverLocal.setSelected(false);
                        SignerConfigurations.this.btSalvarDriver.setEnabled(false);
                        SignerConfigurations.this.chckbxDesabilitarMscapi.setSelected(false);
                        SignerConfigurations.this.props.setProperty("user.mscapi.off", "false");
                    }
                }
                catch (Exception e1) {
                    logger.error("Erro definir Driver:" + e1.getMessage());
                    SignerDialog.showMessageDialog(instanceSignerConfigurations, "Erro", "Erro definir Driver:" + e1.getMessage(), 0);
                }
            }
        });
        this.btSelecionarDriver.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    JFileChooser fileChooserDriver = new JFileChooser(FileSystemView.getFileSystemView().getHomeDirectory());
                    fileChooserDriver.setDialogTitle("Selecione o driver do Token ou Leitora");
                    fileChooserDriver.setAcceptAllFileFilterUsed(false);
                    FileNameExtensionFilter filter = new FileNameExtensionFilter("Arquivo de Driver(.so,.dll ou .dylib )", "so", "dll", "dylib");
                    fileChooserDriver.addChoosableFileFilter(filter);
                    int returnValue = fileChooserDriver.showOpenDialog(null);
                    if (returnValue == 0) {
                        File selectedFile = fileChooserDriver.getSelectedFile();
                        SignerConfigurations.this.txtLocalDriver.setText(selectedFile.getAbsolutePath());
                        SignerConfigurations.this.props.setProperty("user.driver.file.path", SignerConfigurations.this.txtLocalDriver.getText());
                    } else if (returnValue == 1) {
                        SignerDialog.showMessageDialog(instanceSignerConfigurations, "A\u00e7\u00e3o cancelada pelo usu\u00e1rio", "Cancelado", 1);
                    }
                }
                catch (Exception e1) {
                    logger.error("Erro ao buscar arquivo do driver:" + e1.getMessage());
                    SignerDialog.showMessageDialog(instanceSignerConfigurations, "Erro", "Erro ao buscar arquivo do driver:" + e1.getMessage(), 0);
                }
            }
        });
        this.btSalvarDriver.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (SignerConfigurations.this.txtLocalDriver.getText().isEmpty()) {
                    SignerDialog.showMessageDialog(instanceSignerConfigurations, "Informe o arquivo de driver", "Carregar Driver", 2);
                } else {
                    try {
                        SignerConfigurations.this.chckbxDesabilitarMscapi.setSelected(true);
                        SignerConfigurations.this.props.setProperty("user.mscapi.off", "true");
                        if (SignerConfigurations.this.chckbxSomenteNeoid.isSelected()) {
                            SignerDialog.showMessageDialog(instanceSignerConfigurations, "Ao configurar Driver, desabilitar\u00e1 o uso Exclusivo do SerproID", "Carregar Driver", 2);
                            SignerConfigurations.this.props.setProperty("user.neoid.on", "false");
                            SignerConfigurations.this.chckbxSomenteNeoid.setSelected(false);
                        }
                        if (SignerConfigurations.this.configSigner.isUseCertificateFile() || SignerConfigurations.this.chckbxUsarCertificadoEmArquivo.isSelected()) {
                            SignerDialog.showMessageDialog(instanceSignerConfigurations, "Ao configurar Driver, desabilitar\u00e1 o uso de certificado em arquivo", "Carregar Driver", 2);
                            SignerConfigurations.this.props.remove("user.certificate.file.word");
                            SignerConfigurations.this.props.remove("user.certificate.file.path");
                            SignerConfigurations.this.props.remove("user.certificate.file.status");
                            SignerConfigurations.this.chckbxUsarCertificadoEmArquivo.setSelected(false);
                        }
                        SignerConfigurations.this.props.setProperty("user.driver.path.status", "true");
                        ConfigProperties.saveProps(SignerConfigurations.this.props);
                        SignerDialog.showMessageDialog(instanceSignerConfigurations, "Configura\u00e7\u00f5es realizadas com sucesso!", "Carregar Driver", 1);
                        sc.dispose();
                    }
                    catch (Exception e1) {
                        logger.error("Erro ao carregar arquivo de Driver" + e1.getMessage());
                        SignerDialog.showMessageDialog(instanceSignerConfigurations, e1.getMessage(), "Erro ao carregar arquivo de Driver", 0);
                    }
                }
            }
        });
    }

    private void loadPropertiesFile() {
        try {
            this.props = new Properties();
            File arqConf = new File(FULL_PATH_FOLDER_ASSINADOR.toString());
            if (!arqConf.exists()) {
                arqConf.createNewFile();
            }
            FileInputStream is = new FileInputStream(arqConf);
            this.props.load(is);
        }
        catch (IOException e1) {
            logger.error("Erro ao criar ou carregar arquivo de properties" + e1.getMessage());
            logger.error(e1.getMessage());
        }
    }

    public static boolean isOldInterface() {
        return oldInterface;
    }

    public static void setOldInterface(boolean oldInterface) {
        SignerConfigurations.oldInterface = oldInterface;
    }

    public int selectedTheme(List<String> profiles) {
        String themeFileDir = SerproSignerConfigurations.DEFAULT_THEME_FILE;
        if (new File(themeFileDir).exists()) {
            try {
                FileReader fr = new FileReader(themeFileDir);
                char[] cbuf = new char[1024];
                int rSize = fr.read(cbuf);
                String result = new String(cbuf).substring(0, rSize);
                fr.close();
                for (int i = 0; i < profiles.size(); ++i) {
                    if (!profiles.get(i).equals(result)) continue;
                    return i;
                }
            }
            catch (IOException e1) {
                logger.error("Erro selecionar Tema:" + e1.getMessage());
                e1.printStackTrace();
            }
        }
        return 0;
    }
}

