/*
 * Decompiled with CFR 0.152.
 */
package org.demoiselle.signer.serpro.desktop.ui.configuration;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonIOException;
import com.google.gson.JsonParser;
import com.google.gson.JsonSyntaxException;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import javax.imageio.ImageIO;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.demoiselle.signer.serpro.desktop.Main;
import org.demoiselle.signer.serpro.desktop.SerproSignerConfigurations;
import org.demoiselle.signer.serpro.desktop.ui.ProgressBar;
import org.demoiselle.signer.serpro.desktop.ui.commons.SignerDialog;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfigureTheme
extends JPanel {
    private static final long serialVersionUID = 1L;
    private final JList<String> themes;
    private final List<String> profiles = new ArrayList<String>();
    private static final Logger logger = LoggerFactory.getLogger(ConfigureTheme.class);
    final JLabel stamp = new JLabel();
    final JLabel extraStamp = new JLabel();
    final JLabel pin = new JLabel();
    final JLabel waiting = new JLabel();

    public ConfigureTheme(JDialog parent) {
        int x = (int)parent.getBounds().getWidth();
        int y = (int)parent.getBounds().getHeight();
        JButton salveTheme = new JButton("Salvar");
        salveTheme.setBackground(new Color(51, 153, 255));
        salveTheme.setBorder(BorderFactory.createLineBorder(new Color(0, 90, 170), 1, true));
        salveTheme.setFont(new Font("Ubuntu", 1, 15));
        salveTheme.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent e) {
                ConfigureTheme.this.setCursor(new Cursor(12));
            }

            @Override
            public void mouseExited(MouseEvent e) {
                ConfigureTheme.this.setCursor(new Cursor(0));
            }
        });
        JLabel title = new JLabel();
        this.setBackground(new Color(173, 216, 230));
        this.profiles.add("Padr\u00e3o");
        try {
            logger.debug("Buscando temas...");
            URL clients = new URL("https://cliente-assinadorserpro.estaleiro.serpro.gov.br//list.json");
            JsonElement root = JsonParser.parseReader(new InputStreamReader((InputStream)clients.getContent()));
            JsonArray jsa = root.getAsJsonObject().getAsJsonArray("clients");
            for (int i = 0; i < jsa.size(); ++i) {
                if (jsa.get(i).isJsonNull()) continue;
                this.profiles.add(jsa.get(i).getAsString());
            }
        }
        catch (MalformedURLException e2) {
            logger.error(e2.getMessage());
        }
        catch (JsonIOException e1) {
            logger.error(e1.getMessage());
        }
        catch (JsonSyntaxException e1) {
            logger.error(e1.getMessage());
        }
        catch (IOException e1) {
            logger.error(e1.getMessage());
        }
        this.themes = new JList<String>(this.profiles.toArray(new String[this.profiles.size()]));
        this.themes.setBackground(new Color(173, 216, 230));
        this.themes.setForeground(new Color(0, 0, 51));
        JScrollPane sp = new JScrollPane(this.themes);
        this.setLayout(null);
        this.setSize(300, 200);
        sp.setBounds(10, 15, 230, 130);
        this.stamp.setBounds(250, 10, 130, 40);
        this.extraStamp.setBounds(250, 65, 130, 70);
        this.pin.setBounds(420, 10, 110, 100);
        this.waiting.setBounds(550, 10, 110, 100);
        title = new JLabel("Selo Padr\u00e3o");
        title.setBounds(270, 55, 150, 15);
        title.setForeground(new Color(0, 0, 51));
        this.add(title);
        title = new JLabel("Selo Com Data");
        title.setForeground(new Color(0, 0, 51));
        title.setBounds(265, 130, 150, 15);
        this.add(title);
        title = new JLabel("Tela de Pin");
        title.setForeground(new Color(0, 0, 51));
        title.setBounds(440, 110, 150, 15);
        this.add(title);
        title = new JLabel("Tela Aguardando");
        title.setForeground(new Color(0, 0, 51));
        title.setBounds(550, 110, 150, 15);
        this.add(title);
        salveTheme.setBounds(x - 250, y - 130, 200, 25);
        this.add(sp);
        this.add(this.extraStamp);
        this.add(this.stamp);
        this.add(this.pin);
        this.add(this.waiting);
        this.add(salveTheme);
        this.themes.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                ConfigureTheme.this.newTheme();
            }
        });
        salveTheme.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ConfigureTheme.this.progressBar();
            }
        });
    }

    private void progressBar() {
        ProgressBar pbTheme2 = new ProgressBar("Aguarde...");
        Thread trTheme2 = new Thread(pbTheme2);
        trTheme2.start();
        String themeFileDir = System.getProperty("user.home") + File.separator + ".serpro";
        themeFileDir = themeFileDir + File.separator + "theme";
        File f = new File(themeFileDir);
        if (!f.exists()) {
            f.mkdirs();
        }
        themeFileDir = themeFileDir + File.separator + ".default";
        if (this.themes.getSelectedIndex() == 0) {
            new File(themeFileDir).delete();
            SignerDialog.showMessageDialog(null, "Tema padr\u00e3o atualizado");
            SerproSignerConfigurations.getInstance().setDefaultTheme("");
            pbTheme2.dispose();
            return;
        }
        String img = SerproSignerConfigurations.getInstance().getTheme().get(this.themes.getSelectedValue() + ".image.stamp");
        if (!Main.validateThemeSignature(img)) {
            SignerDialog.showMessageDialog(null, "Imagem n\u00e3o foi emitida pelo Assinador Serpro");
            pbTheme2.dispose();
            return;
        }
        try {
            FileWriter fw = new FileWriter(themeFileDir);
            String selected = this.themes.getSelectedValue();
            fw.write(selected.toCharArray());
            fw.flush();
            fw.close();
            SerproSignerConfigurations.getInstance().setDefaultTheme(selected);
            pbTheme2.dispose();
            SignerDialog.showMessageDialog(null, "Tema padr\u00e3o atualizado");
        }
        catch (IOException e1) {
            pbTheme2.dispose();
            logger.error(e1.getMessage());
        }
        trTheme2.interrupt();
        pbTheme2.dispose();
    }

    private void newTheme() {
        BufferedImage img = null;
        logger.debug("Listando temas");
        ProgressBar pbTheme = new ProgressBar("Aguarde...");
        Thread trTheme = new Thread(pbTheme);
        trTheme.start();
        try {
            if (this.themes.getSelectedIndex() == 0) {
                InputStream is = this.getClass().getClassLoader().getResourceAsStream("images/logo-signer-hor.png");
                ImageIcon icon = new ImageIcon(new ImageIcon(ImageIO.read(is)).getImage().getScaledInstance(110, 70, 4));
                this.pin.setIcon(icon);
                is = this.getClass().getClassLoader().getResourceAsStream("images/logo_serpro_small.png");
                icon = new ImageIcon(new ImageIcon(ImageIO.read(is)).getImage().getScaledInstance(100, 60, 4));
                this.waiting.setIcon(icon);
                is = this.getClass().getClassLoader().getResourceAsStream("images/stampInfo.png");
                icon = new ImageIcon(new ImageIcon(ImageIO.read(is)).getImage().getScaledInstance(130, 30, 4));
                this.stamp.setIcon(icon);
                is = this.getClass().getClassLoader().getResourceAsStream("images/stampExtraInfo.png");
                icon = new ImageIcon(new ImageIcon(ImageIO.read(is)).getImage().getScaledInstance(130, 50, 4));
                this.extraStamp.setIcon(icon);
                this.extraStamp.setVisible(true);
                trTheme.interrupt();
                pbTheme.dispose();
                return;
            }
            pbTheme.dispose();
            Main.getTheme(this.themes.getSelectedValue());
            String imageFile = SerproSignerConfigurations.getInstance().getTheme().get(this.themes.getSelectedValue() + ".load.image");
            ImageIcon icon = this.setIcon(imageFile, "images/logo_serpro_small.png");
            this.pin.setIcon(icon);
            this.waiting.setIcon(icon);
            imageFile = SerproSignerConfigurations.getInstance().getTheme().get(this.themes.getSelectedValue() + ".pin.image");
            icon = this.setIcon(imageFile, "images/logo-signer-hor.png");
            this.pin.setIcon(icon);
            imageFile = SerproSignerConfigurations.getInstance().getTheme().get(this.themes.getSelectedValue() + ".image.stamp");
            FileInputStream is = new FileInputStream(imageFile);
            img = ImageIO.read(is);
            icon = new ImageIcon(new ImageIcon(img).getImage().getScaledInstance(130, 50, 4));
            this.stamp.setIcon(icon);
            if (SerproSignerConfigurations.getInstance().getTheme().get(this.themes.getSelectedValue() + ".image.stamp.extra") != null) {
                imageFile = SerproSignerConfigurations.getInstance().getTheme().get(this.themes.getSelectedValue() + ".image.stamp");
                is = new FileInputStream(imageFile);
                img = ImageIO.read(is);
                icon = new ImageIcon(new ImageIcon(img).getImage().getScaledInstance(130, 50, 4));
                this.extraStamp.setIcon(icon);
                this.extraStamp.setVisible(true);
            } else {
                this.extraStamp.setVisible(false);
            }
            pbTheme.dispose();
        }
        catch (IOException e1) {
            pbTheme.dispose();
            logger.error(e1.getMessage());
        }
    }

    private ImageIcon setIcon(String imageFile, String defaultImg) throws IOException {
        BufferedImage img = null;
        if (imageFile != null) {
            FileInputStream is = new FileInputStream(imageFile);
            img = ImageIO.read(is);
            return new ImageIcon(new ImageIcon(img).getImage().getScaledInstance(100, 60, 4));
        }
        InputStream is = this.getClass().getClassLoader().getResourceAsStream(defaultImg);
        return new ImageIcon(new ImageIcon(ImageIO.read(is)).getImage().getScaledInstance(110, 70, 4));
    }

    public JList<String> getTheme() {
        return this.themes;
    }

    public List<String> getProfiles() {
        return this.profiles;
    }
}

