/*
 * Decompiled with CFR 0.152.
 */
package org.demoiselle.signer.serpro.desktop.ui.configuration;

import java.awt.Color;
import java.awt.Cursor;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.IOException;
import java.text.NumberFormat;
import java.util.Properties;
import java.util.regex.Pattern;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.border.EmptyBorder;
import javax.swing.border.TitledBorder;
import org.demoiselle.signer.serpro.desktop.SerproSignerConfigurations;
import org.demoiselle.signer.serpro.desktop.ui.commons.BatchConfig;
import org.demoiselle.signer.serpro.desktop.ui.commons.SignerDialog;
import org.demoiselle.signer.serpro.desktop.ui.configuration.ConfigProperties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfigureStamp
extends JPanel {
    public static final short SHOWSTAMPNONE = 0;
    public static final short SHOWSTAMPCPF = 1;
    public static final short SHOWSTAMPDATE = 2;
    public static final short SHOWSTAMPALL = 3;
    public static final String STAMPPROPERTY = "user.pdf.stamp.config";
    private static final Logger logger = LoggerFactory.getLogger(ConfigureStamp.class);
    private static final long serialVersionUID = 1L;

    public ConfigureStamp(Properties properties) {
        final JCheckBox showCPF = new JCheckBox("Mostrar CPF");
        final JCheckBox showSignatureDate = new JCheckBox("Mostrar a data do computador");
        final Properties props = properties;
        JPanel pane = new JPanel();
        pane.setBackground(new Color(173, 216, 230));
        this.setBackground(new Color(173, 216, 230));
        showCPF.setForeground(new Color(0, 0, 51));
        showSignatureDate.setForeground(new Color(0, 0, 51));
        String fixStamp = props.getProperty("user.pdf.fixstamp");
        String stampX = props.getProperty("user.pdf.x");
        String stampY = props.getProperty("user.pdf.y");
        NumberFormat longFormat = NumberFormat.getIntegerInstance();
        final JCheckBox fixBathStamp = new JCheckBox("Fixar posi\u00e7\u00e3o do selo");
        fixBathStamp.setBackground(Color.WHITE);
        fixBathStamp.setForeground(new Color(0, 0, 51));
        JButton btnSeledtStampPosition = new JButton("Selecionar ...");
        btnSeledtStampPosition.setForeground(new Color(0, 0, 51));
        btnSeledtStampPosition.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent e) {
                ConfigureStamp.this.setCursor(new Cursor(12));
            }

            @Override
            public void mouseExited(MouseEvent e) {
                ConfigureStamp.this.setCursor(new Cursor(0));
            }
        });
        final JFormattedTextField txtStampX = new JFormattedTextField(longFormat);
        final JFormattedTextField txtStampY = new JFormattedTextField(longFormat);
        final JLabel fixBathStampX = new JLabel("X");
        final JLabel fixBathStampY = new JLabel("Y");
        fixBathStampX.setForeground(new Color(0, 0, 51));
        fixBathStampY.setForeground(new Color(0, 0, 51));
        JPanel panelPos = new JPanel();
        showSignatureDate.setBackground(new Color(173, 216, 230));
        showCPF.setBackground(new Color(173, 216, 230));
        pane.add(showCPF);
        pane.add(showSignatureDate);
        String result = props.getProperty(STAMPPROPERTY);
        if (result != null && !result.isEmpty()) {
            Short configVal = new Short(result);
            switch (configVal) {
                case 1: {
                    showCPF.setSelected(true);
                    break;
                }
                case 2: {
                    showSignatureDate.setSelected(true);
                    break;
                }
                case 3: {
                    showCPF.setSelected(true);
                    showSignatureDate.setSelected(true);
                    break;
                }
            }
        }
        fixBathStampX.setEnabled(false);
        fixBathStampY.setEnabled(false);
        txtStampX.setEnabled(false);
        txtStampY.setEnabled(false);
        JButton btnSave = new JButton(" Salvar ");
        btnSave.setFont(new Font("Ubuntu", 1, 15));
        btnSave.setToolTipText("Salvar as configura\u00e7\u00f5es do Selo");
        btnSave.setBackground(new Color(51, 153, 255));
        btnSave.setBorder(BorderFactory.createLineBorder(new Color(0, 90, 170), 1, true));
        btnSave.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent e) {
                ConfigureStamp.this.setCursor(new Cursor(12));
            }

            @Override
            public void mouseExited(MouseEvent e) {
                ConfigureStamp.this.setCursor(new Cursor(0));
            }
        });
        JLabel mm = new JLabel("mm");
        mm.setBorder(new EmptyBorder(0, 0, 0, 40));
        mm.setForeground(new Color(0, 0, 51));
        panelPos.add(fixBathStamp);
        panelPos.add(fixBathStampX);
        panelPos.add(txtStampX);
        panelPos.add(mm);
        panelPos.add(fixBathStampY);
        panelPos.add(txtStampY);
        panelPos.add(mm);
        panelPos.add(btnSeledtStampPosition);
        panelPos.setBackground(new Color(173, 216, 230));
        TitledBorder border = BorderFactory.createTitledBorder("Arquivos em lote");
        panelPos.setBorder(border);
        txtStampX.setColumns(3);
        txtStampY.setColumns(3);
        if (fixStamp != null && fixStamp.equals("true")) {
            fixBathStamp.setSelected(true);
            fixBathStamp.setSelected(true);
            fixBathStampX.setEnabled(true);
            fixBathStampY.setEnabled(true);
            txtStampX.setEnabled(true);
            txtStampY.setEnabled(true);
            txtStampX.setText(stampX);
            txtStampY.setText(stampY);
        }
        fixBathStamp.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1) {
                    fixBathStampX.setEnabled(true);
                    fixBathStampY.setEnabled(true);
                    txtStampX.setEnabled(true);
                    txtStampY.setEnabled(true);
                    txtStampX.requestFocus();
                    props.setProperty("user.pdf.fixstamp", "true");
                } else {
                    fixBathStampX.setEnabled(false);
                    fixBathStampY.setEnabled(false);
                    txtStampX.setEnabled(false);
                    txtStampY.setEnabled(false);
                    props.remove("user.pdf.fixstamp");
                    props.remove("user.pdf.x");
                    props.remove("user.pdf.y");
                }
            }
        });
        showSignatureDate.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent e) {
                ConfigureStamp.this.setCursor(new Cursor(12));
            }

            @Override
            public void mouseExited(MouseEvent e) {
                ConfigureStamp.this.setCursor(new Cursor(0));
            }
        });
        showSignatureDate.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                try {
                    if (showSignatureDate.isSelected()) {
                        Thread th = new Thread(new Runnable(){

                            @Override
                            public void run() {
                                int op = JOptionPane.showConfirmDialog(null, "Saiba que ao marcar essa op\u00e7\u00e3o apenas, a data apresentada no selo n\u00e3o possu\u00ed validade j\u00faridica! \n Para os casos de exig\u00eancia de validade j\u00faridica, deve utilizar as fun\u00e7\u00f5es com Carimbo do Tempo ao Assinar!", "AVISO", 2);
                                if (op != 0) {
                                    showSignatureDate.setSelected(false);
                                }
                            }
                        });
                        th.start();
                    }
                }
                catch (Throwable ex1) {
                    logger.error("Erro ao definir mostrar data no Selo: " + ex1.getMessage());
                    SignerDialog.showMessageDialog(null, "Erro", "Erro ao definir mostrar data no Selo:" + ex1.getMessage(), 0);
                }
            }
        });
        showCPF.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent e) {
                ConfigureStamp.this.setCursor(new Cursor(12));
            }

            @Override
            public void mouseExited(MouseEvent e) {
                ConfigureStamp.this.setCursor(new Cursor(0));
            }
        });
        fixBathStamp.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent e) {
                ConfigureStamp.this.setCursor(new Cursor(12));
            }

            @Override
            public void mouseExited(MouseEvent e) {
                ConfigureStamp.this.setCursor(new Cursor(0));
            }
        });
        btnSave.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Short value = 0;
                String posX = txtStampX.getText().replace(".", "");
                String posY = txtStampY.getText().replace(".", "");
                Pattern pattern = Pattern.compile("\\d+");
                if (showCPF.isSelected()) {
                    value = 1;
                }
                if (showSignatureDate.isSelected()) {
                    value = new Short((short)(value + 2));
                }
                if (value == 0) {
                    props.remove(ConfigureStamp.STAMPPROPERTY);
                } else {
                    props.setProperty(ConfigureStamp.STAMPPROPERTY, value.toString());
                }
                if (fixBathStamp.isSelected()) {
                    if (!pattern.matcher(posX).matches()) {
                        SignerDialog.showMessageDialog(null, "Informe um valor inteiro para X", "Erro", 0);
                        return;
                    }
                    if (!pattern.matcher(posY).matches()) {
                        SignerDialog.showMessageDialog(null, "Informe um valor inteiro para Y", "Erro", 0);
                        return;
                    }
                    props.setProperty("user.pdf.x", posX);
                    props.setProperty("user.pdf.y", posY);
                    if (props.getProperty("user.pdf.fixstamp") == null) {
                        SerproSignerConfigurations.getInstance().setFixedStamp(false);
                    } else {
                        SerproSignerConfigurations.getInstance().setFixedStamp(true);
                    }
                    SerproSignerConfigurations.getInstance().setStampPosition(new int[]{Integer.parseInt(posX), Integer.parseInt(posY)});
                }
                SignerDialog.showMessageDialog(null, "Dados cadastrados corretamente", "Sucesso", -1);
                try {
                    ConfigProperties.saveProps(props);
                    SerproSignerConfigurations.getInstance().setStampInfo(value);
                }
                catch (IOException e1) {
                    logger.error(e1.getMessage());
                    SignerDialog.showMessageDialog(null, "Erro ao cadastrar as configura\u00e7\u00f5es", "Erro", 0);
                }
            }
        });
        btnSeledtStampPosition.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int[] result = BatchConfig.showSelectDialog(props);
                if (result[0] > -1 && result[1] > -1) {
                    txtStampX.setText(Integer.toString(result[0]));
                    txtStampY.setText(Integer.toString(result[1]));
                }
                try {
                    ConfigProperties.saveProps(props);
                }
                catch (IOException e1) {
                    logger.error(e1.getMessage());
                }
            }
        });
        this.setLayout(new BoxLayout(this, 1));
        this.setBorder(new EmptyBorder(20, 10, 10, 10));
        this.add(pane);
        this.add(panelPos);
        this.add(new JLabel(" "));
        this.add(btnSave);
    }
}

