/*
 * Decompiled with CFR 0.152.
 */
package org.demoiselle.signer.serpro.desktop.ui.commons;

import java.awt.Color;
import javax.swing.JLabel;
import javax.swing.UIManager;
import org.demoiselle.signer.core.exception.CertificateValidatorCRLException;
import org.demoiselle.signer.serpro.desktop.command.signer.FileCoSignerUsingDefaults;
import org.demoiselle.signer.serpro.desktop.command.signer.Sign;
import org.demoiselle.signer.serpro.desktop.command.signer.SignRequest;
import org.demoiselle.signer.serpro.desktop.command.signer.SignResponse;
import org.demoiselle.signer.serpro.desktop.command.xml.sign.RequestSignXML;
import org.demoiselle.signer.serpro.desktop.command.xml.sign.ResponseSignXML;
import org.demoiselle.signer.serpro.desktop.command.xml.sign.SignXML;
import org.demoiselle.signer.serpro.desktop.ui.commons.SignerDialog;
import org.demoiselle.signer.serpro.desktop.utils.CertNotAfterWarn;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Commons {
    private static final Logger logger = LoggerFactory.getLogger(Commons.class);

    public static void SignOrdinaryFiles(SignRequest request) {
        Sign sign = new Sign();
        SignResponse resp = null;
        UIManager.put("OptionPane.background", Color.WHITE);
        UIManager.put("Panel.background", Color.WHITE);
        try {
            resp = sign.doCommand(request);
            if (resp.getActionCanceled()) {
                logger.info("A\u00e7\u00e3o cancelada pelo usu\u00e1rio");
                SignerDialog.showMessageDialog(null, "A\u00e7\u00e3o cancelada pelo usu\u00e1rio", "Cancelado", 1);
            } else if (!resp.getListOfSignatures().isEmpty()) {
                SignerDialog.showMessageDialog(null, "Arquivo de assinatura dispon\u00edvel em: " + resp.getSignature(), "Sucesso", 4);
                CertNotAfterWarn.showWarn(resp.getNotAfterDateCertificate());
            } else {
                logger.error("Ocorreu algum erro ao tentar assinar, lista de assinaturas vazia");
                SignerDialog.showMessageDialog(null, "Ocorreu algum erro ao tentar assinar, tente novamente", "Falha", 0);
            }
        }
        catch (Throwable e1) {
            if (e1.getCause() != null && e1.getCause() instanceof CertificateValidatorCRLException) {
                logger.error(e1.getMessage());
                SignerDialog.showMessageDialog(null, e1.getMessage() + "<br> Se necess\u00e1rio urg\u00eancia na assinatura, verifique as configura\u00e7\u00f5es para desabilitar essa valida\u00e7\u00e3o!", "Erro ao Assinar", 0);
            }
            logger.error("Erro ao gerar assinatura: ", e1);
            SignerDialog.showMessageDialog(null, "Erro ao gerar assinatura: " + e1.getMessage(), "Cancelado", 0);
        }
    }

    public static void coSigner(SignRequest request) throws Throwable {
        UIManager.put("OptionPane.background", Color.WHITE);
        UIManager.put("Panel.background", Color.WHITE);
        String infoText = "<html><body><h1>CO-Assinatura</h1><p style='margin:5px'>Para Co-Assinar um arquivo \u00e9 necess\u00e1rio seguir os seguintes passos:</p><p style='margin:5px'>1 - Se necess\u00e1rio informe seu PIN e escolha o certificado do token</p><p style='margin:5px'>2 - Selecionar o arquivo do conte\u00fado Assinado</p><p style='margin:5px'>3 - Selecionar o arquivo de Assinatura <b>.p7s</b> anterior</p></body></html>";
        JLabel label = new JLabel();
        label.setText(infoText);
        SignerDialog.showMessageDialog(null, label, "Processo de Co Assinatura", 1);
        FileCoSignerUsingDefaults signer = new FileCoSignerUsingDefaults();
        SignResponse resp = signer.doCommand(request);
        if (resp.getActionCanceled()) {
            SignerDialog.showMessageDialog(null, "A\u00e7\u00e3o cancelada pelo usu\u00e1rio", "Cancelado", 1);
        } else if (!resp.getSignature().equals("")) {
            SignerDialog.showMessageDialog(null, "Arquivo de co-assinatura dispon\u00edvel em: " + resp.getSignature(), "Sucesso", 1);
            CertNotAfterWarn.showWarn(resp.getNotAfterDateCertificate());
        } else {
            SignerDialog.showMessageDialog(null, "Ocorreu algum erro ao tentar assinar, tente novamente", "Falha", 0);
        }
    }

    public static void timeStamp(SignRequest request) {
        Sign sign = new Sign();
        SignResponse resp = null;
        UIManager.put("OptionPane.background", Color.WHITE);
        UIManager.put("Panel.background", Color.WHITE);
        try {
            resp = sign.doCommand(request);
            if (resp.getActionCanceled()) {
                SignerDialog.showMessageDialog(null, "A\u00e7\u00e3o cancelada pelo usu\u00e1rio", "Cancelado", 1);
            } else if (!resp.getSignature().equals("")) {
                SignerDialog.showMessageDialog(null, "Arquivo com Carimbo do Tempo dispon\u00edvel em: " + resp.getSignature(), "Sucesso", 1);
                CertNotAfterWarn.showWarn(resp.getNotAfterDateCertificate());
            } else {
                SignerDialog.showMessageDialog(null, "Ocorreu algum erro ao tentar gerar o Carimbo do tempo, tente novamente", "Falha", 0);
            }
        }
        catch (Throwable e1) {
            SignerDialog.showMessageDialog(null, "Erro ao gerar Carimbo do tempo: " + e1.getMessage(), "Cancelado", 0);
        }
    }

    public static void SignXMLFiles(RequestSignXML requestXML) {
        SignXML signXML = new SignXML();
        ResponseSignXML responseSignXML = null;
        UIManager.put("OptionPane.background", Color.WHITE);
        UIManager.put("Panel.background", Color.WHITE);
        try {
            responseSignXML = signXML.doCommand(requestXML);
            if (responseSignXML.getActionCanceled()) {
                logger.info("A\u00e7\u00e3o cancelada pelo usu\u00e1rio");
                SignerDialog.showMessageDialog(null, "A\u00e7\u00e3o cancelada pelo usu\u00e1rio", "Cancelado", 1);
            } else if (!responseSignXML.getListOfSignatures().isEmpty()) {
                SignerDialog.showMessageDialog(null, "Arquivo de assinatura XML dispon\u00edvel em: " + responseSignXML.getListOfSignatures(), "Sucesso", 1);
                CertNotAfterWarn.showWarn(responseSignXML.getNotAfterDateCertificate());
            } else {
                logger.error("Ocorreu algum erro ao tentar assinar, lista de assinaturas est\u00e1 vazia");
                SignerDialog.showMessageDialog(null, "Ocorreu algum erro ao tentar assinar, tente novamente", "Falha", 0);
            }
        }
        catch (Throwable e1) {
            if (e1.getCause() != null && e1.getCause() instanceof CertificateValidatorCRLException) {
                logger.error(e1.getMessage());
                SignerDialog.showMessageDialog(null, e1.getMessage() + "<br> Se necess\u00e1rio urg\u00eancia na assinatura, verifique as configura\u00e7\u00f5es para desabilitar essa valida\u00e7\u00e3o!", "Erro ao Assinar", 0);
            }
            logger.error(e1.getMessage());
            SignerDialog.showMessageDialog(null, "Erro ao gerar assinatura XML: " + e1.getMessage(), "Cancelado", 0);
        }
    }
}

