/*
 * Decompiled with CFR 0.152.
 */
package org.demoiselle.signer.serpro.desktop.ui.commons;

import java.awt.Color;
import java.awt.Cursor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.InputStream;
import javax.imageio.ImageIO;
import javax.swing.AbstractAction;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.KeyStroke;
import org.demoiselle.signer.serpro.desktop.SerproSignerConfigurations;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BatchSelection
extends JDialog {
    private static final long serialVersionUID = 1L;
    private static final Logger logger = LoggerFactory.getLogger(BatchSelection.class);
    public static final int CANCEL = -1;
    public static final int PDF = 1;
    public static final int ATTACHED = 2;
    public static final int DETACHED = 3;
    public static final int XML = 4;
    private boolean alowRV = true;
    private int selectedButton = 1;
    private String[] options = new String[0];
    private int[] stampPosition = new int[]{-1, -1};

    public BatchSelection(boolean parmIsRV) {
        this.setAlowRV(parmIsRV);
        this.setAlowRV(parmIsRV);
    }

    public int[] getStampPosition() {
        return this.stampPosition;
    }

    public int showSelectDialog() {
        if (SerproSignerConfigurations.getInstance().isFixedStamp()) {
            this.stampPosition = SerproSignerConfigurations.getInstance().getStampPosition();
        }
        this.showDialog("Assinatura em Lote", "", 0, 0);
        return this.selectedButton;
    }

    public void showDialog(String title, String message, int buttons, int iconId) {
        int width = 300;
        int height = 270;
        this.setSize(width, height);
        try {
            InputStream pathSerpro = this.getClass().getClassLoader().getResourceAsStream("images/tools/btnSign.png");
            this.setIconImage(ImageIO.read(pathSerpro));
        }
        catch (IOException e1) {
            e1.printStackTrace();
        }
        this.setDefaultCloseOperation(0);
        this.setTitle(title);
        this.setLocationRelativeTo(null);
        this.setLayout(null);
        this.setResizable(false);
        this.setAlwaysOnTop(true);
        this.setModal(true);
        JPanel pane = (JPanel)this.getContentPane();
        this.setBackground(Color.WHITE);
        pane.setBackground(Color.WHITE);
        try {
            BufferedImage imgLogoSerpro = null;
            InputStream path = this.getClass().getClassLoader().getResourceAsStream("images/logo_serpro_min.png");
            imgLogoSerpro = ImageIO.read(path);
            ImageIcon icon = new ImageIcon(imgLogoSerpro);
            JLabel lblImg = new JLabel(icon);
            lblImg.setHorizontalAlignment(0);
            lblImg.setBounds(this.getWidth() - 95, this.getHeight() - 70, 100, 35);
            pane.add(lblImg);
        }
        catch (IOException imgLogoSerpro) {
            // empty catch block
        }
        ButtonGroup bgroup = new ButtonGroup();
        JRadioButton pdfOnly = new JRadioButton("Arquivos PDF");
        JRadioButton attached = new JRadioButton("Assinaturas com conte\u00fado anexado");
        JRadioButton deattached = new JRadioButton("Assinaturas desanexadas");
        JRadioButton rbXML = new JRadioButton("Assinaturas em XML");
        pdfOnly.setBounds(10, 20, 120, 30);
        attached.setBounds(10, 50, width - 20, 30);
        deattached.setBounds(10, 80, width - 20, 30);
        rbXML.setBounds(10, 110, width - 20, 30);
        pdfOnly.setBackground(Color.white);
        attached.setBackground(Color.white);
        deattached.setBackground(Color.white);
        rbXML.setBackground(Color.white);
        pdfOnly.setEnabled(this.isAlowRV());
        pdfOnly.setSelected(this.isAlowRV());
        rbXML.setEnabled(this.isAlowRV());
        pdfOnly.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                BatchSelection.this.selectedButton = 1;
            }
        });
        attached.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                BatchSelection.this.selectedButton = 2;
            }
        });
        deattached.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                BatchSelection.this.selectedButton = 3;
            }
        });
        rbXML.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                BatchSelection.this.selectedButton = 4;
            }
        });
        bgroup.add(pdfOnly);
        bgroup.add(attached);
        bgroup.add(deattached);
        bgroup.add(rbXML);
        JButton btConfirm = new JButton();
        btConfirm.setIcon(new ImageIcon(this.getClass().getResource("/images/btnConfirmar.png")));
        btConfirm.setToolTipText("Confirmar a opera\u00e7\u00e3o Selecionada");
        btConfirm.setBounds(10, height - 110, 100, 35);
        btConfirm.setBorderPainted(false);
        btConfirm.setContentAreaFilled(false);
        btConfirm.setOpaque(false);
        btConfirm.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent e) {
                BatchSelection.this.setCursor(new Cursor(12));
            }

            @Override
            public void mouseExited(MouseEvent e) {
                BatchSelection.this.setCursor(new Cursor(0));
            }
        });
        btConfirm.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                BatchSelection.this.dispose();
            }
        });
        JButton btCancel = new JButton();
        btCancel.setIcon(new ImageIcon(this.getClass().getResource("/images/btnCancelar.png")));
        btCancel.setToolTipText("Cancelar a opera\u00e7\u00e3o");
        btCancel.setBounds(180, height - 110, 100, 35);
        btCancel.setBorderPainted(false);
        btCancel.setContentAreaFilled(false);
        btCancel.setOpaque(false);
        btCancel.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent e) {
                BatchSelection.this.setCursor(new Cursor(12));
            }

            @Override
            public void mouseExited(MouseEvent e) {
                BatchSelection.this.setCursor(new Cursor(0));
            }
        });
        btCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                BatchSelection.this.selectedButton = -1;
                BatchSelection.this.dispose();
            }
        });
        pane.add(pdfOnly);
        pane.add(attached);
        pane.add(deattached);
        pane.add(rbXML);
        if (SerproSignerConfigurations.getInstance().isFixedStamp()) {
            this.options = SerproSignerConfigurations.getInstance().getStampPositionOptions();
            String[] tmp = new String[this.options.length + 2];
            int[] defaultPos = SerproSignerConfigurations.getInstance().getStampPosition();
            tmp[0] = "Padr\u00e3o|" + defaultPos[0] + "|" + defaultPos[1];
            tmp[1] = "Autom\u00e1tico|-1|-1";
            for (int i = 0; i < this.options.length; ++i) {
                tmp[i + 2] = this.options[i];
            }
            this.options = tmp;
            String[] splitedOptions = new String[this.options.length + 2];
            for (int i = 0; i < this.options.length; ++i) {
                String[] values = this.options[i].split("\\|");
                splitedOptions[i] = values[0] + " (" + values[1] + ", " + values[2] + ")";
            }
            final JComboBox<String> selectPosition = new JComboBox<String>(splitedOptions);
            selectPosition.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (selectPosition.getSelectedIndex() < 1) {
                        ((BatchSelection)BatchSelection.this).stampPosition[0] = -1;
                        ((BatchSelection)BatchSelection.this).stampPosition[1] = -1;
                        return;
                    }
                    String[] value = BatchSelection.this.options[selectPosition.getSelectedIndex()].split("\\|");
                    System.out.println(value[0]);
                    try {
                        ((BatchSelection)BatchSelection.this).stampPosition[0] = Integer.parseInt(value[1]);
                        ((BatchSelection)BatchSelection.this).stampPosition[1] = Integer.parseInt(value[2]);
                        System.out.println(BatchSelection.this.stampPosition[0] + ":" + BatchSelection.this.stampPosition[1]);
                    }
                    catch (Exception ex) {
                        logger.error(ex.getMessage());
                    }
                }
            });
            selectPosition.setBounds(130, 40, 150, 30);
            pane.add(selectPosition);
        }
        pane.add(btConfirm);
        pane.add(btCancel);
        AbstractAction escapeAction = new AbstractAction(){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent e) {
                BatchSelection.this.dispose();
            }
        };
        this.getRootPane().getInputMap(2).put(KeyStroke.getKeyStroke(27, 0), "ESCAPE_KEY");
        this.getRootPane().getActionMap().put("ESCAPE_KEY", escapeAction);
        this.setVisible(true);
    }

    public boolean isAlowRV() {
        return this.alowRV;
    }

    public void setAlowRV(boolean alowRV) {
        this.alowRV = alowRV;
    }
}

