/*
 * Decompiled with CFR 0.152.
 */
package org.demoiselle.signer.serpro.desktop.ui.commons;

import java.awt.Color;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.NumberFormat;
import java.util.Properties;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.demoiselle.signer.serpro.desktop.ui.commons.SignerDialog;

public class BatchConfig
extends JDialog {
    private static final long serialVersionUID = 1L;
    private String[] configValue = new String[0];
    private int[] retPosition = new int[]{-1, -1};
    private Properties props;

    public static void main(String[] args) {
        System.out.println(BatchConfig.showSelectDialog(new Properties()));
    }

    public BatchConfig(Properties props) {
        this.props = props;
        String result = props.getProperty("user.pdf.positions");
        if (result != null && !result.isEmpty()) {
            this.configValue = result.split(",");
        }
    }

    private String formatedValue(String[] values) {
        return values[0] + " (" + values[1] + ", " + values[2] + ")";
    }

    private String[] listValues(String[] configValue) {
        String[] strReg = new String[configValue.length];
        for (int i = 0; i < configValue.length; ++i) {
            String[] values = configValue[i].split("\\|");
            if (values.length <= 2) continue;
            strReg[i] = this.formatedValue(values);
        }
        return strReg;
    }

    public static int[] showSelectDialog(Properties props) {
        BatchConfig bs = new BatchConfig(props);
        bs.showDialog("Assinatura em Lote", "", 0, 0);
        return bs.retPosition;
    }

    public void showDialog(String title, String message, int buttons, int iconId) {
        int width = 400;
        int height = 350;
        this.setSize(width, height);
        NumberFormat longFormat = NumberFormat.getIntegerInstance();
        final JFormattedTextField txtStampX = new JFormattedTextField(longFormat);
        final JFormattedTextField txtStampY = new JFormattedTextField(longFormat);
        final JTextField txtTitle = new JTextField();
        JLabel fixBathStampX = new JLabel("X:");
        fixBathStampX.setForeground(new Color(0, 0, 51));
        JLabel fixBathStampY = new JLabel("Y:");
        fixBathStampY.setForeground(new Color(0, 0, 51));
        JLabel position = new JLabel("Posi\u00e7\u00e3o");
        position.setForeground(new Color(0, 0, 51));
        JLabel titleConfig = new JLabel("Nome:");
        titleConfig.setForeground(new Color(0, 0, 51));
        JButton btnAddStampPosition = new JButton("Salvar Posi\u00e7\u00e3o");
        btnAddStampPosition.setFont(new Font("Ubuntu", 1, 15));
        JButton btnConfirmStampPosition = new JButton("Definir como Padr\u00e3o");
        btnConfirmStampPosition.setFont(new Font("Ubuntu", 1, 15));
        JButton btnDeleteStampPosition = new JButton("Excluir");
        btnDeleteStampPosition.setFont(new Font("Ubuntu", 1, 15));
        final String[] strReg = this.listValues(this.configValue);
        final JList<String> lstReg = new JList<String>(strReg);
        JScrollPane scrReg = new JScrollPane(lstReg);
        lstReg.setVisibleRowCount(2);
        this.setDefaultCloseOperation(2);
        this.setTitle(title);
        this.setLocationRelativeTo(null);
        this.setLayout(null);
        this.setResizable(false);
        this.setAlwaysOnTop(true);
        this.setModal(true);
        JPanel pane = (JPanel)this.getContentPane();
        this.setBackground(Color.WHITE);
        pane.setBackground(Color.WHITE);
        titleConfig.setBounds(10, 10, 45, 25);
        txtTitle.setBounds(65, 10, width - 75, 25);
        position.setBounds(10, 40, 55, 25);
        fixBathStampX.setBounds(65, 40, 15, 25);
        txtStampX.setBounds(90, 40, 45, 25);
        fixBathStampY.setBounds(155, 40, 25, 25);
        txtStampY.setBounds(180, 40, 45, 25);
        btnAddStampPosition.setBounds(width - 150, 80, 145, 30);
        btnConfirmStampPosition.setBounds(width - 180, 210, 185, 30);
        btnDeleteStampPosition.setBounds(10, 210, 100, 30);
        scrReg.setBounds(10, 120, width - 20, 80);
        txtStampX.setBackground(Color.white);
        txtStampY.setBackground(Color.white);
        fixBathStampX.setBackground(Color.white);
        fixBathStampY.setBackground(Color.white);
        pane.add(position);
        pane.add(titleConfig);
        pane.add(txtTitle);
        pane.add(txtStampX);
        pane.add(fixBathStampX);
        pane.add(txtStampY);
        pane.add(fixBathStampY);
        pane.add(scrReg);
        pane.add(btnAddStampPosition);
        pane.add(btnConfirmStampPosition);
        pane.add(btnDeleteStampPosition);
        lstReg.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (lstReg.getSelectedIndex() < 0) {
                    return;
                }
                String[] values = BatchConfig.this.configValue[lstReg.getSelectedIndex()].split("\\|");
                if (values.length < 3) {
                    return;
                }
                txtTitle.setText(values[0]);
                txtStampX.setText(values[1]);
                txtStampY.setText(values[2]);
            }
        });
        btnDeleteStampPosition.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String[] values = BatchConfig.this.configValue;
                int listSize = values.length;
                int pos = 0;
                String configText = "";
                String[] saved = new String[listSize - 1];
                for (int i = 0; i < listSize; ++i) {
                    if (i == lstReg.getSelectedIndex()) continue;
                    saved[pos++] = values[i];
                    configText = configText + values[i];
                    if (i >= listSize - 2) continue;
                    configText = configText + ",";
                }
                BatchConfig.this.props.setProperty("user.pdf.positions", configText);
                BatchConfig.access$002(BatchConfig.this, saved);
                lstReg.setListData(BatchConfig.this.listValues(saved));
            }
        });
        btnAddStampPosition.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String[] values = BatchConfig.this.configValue;
                String configText = "";
                int listSize = values.length;
                if (txtTitle.getText().isEmpty()) {
                    SignerDialog.showMessageDialog(null, "Informe um nome para identificar a configura\u00e7\u00e3o");
                    return;
                }
                if (txtStampX.getText().isEmpty()) {
                    SignerDialog.showMessageDialog(null, "Informe a posi\u00e7\u00e3o X (horizontal)");
                    return;
                }
                if (txtStampY.getText().isEmpty()) {
                    SignerDialog.showMessageDialog(null, "Informe a posi\u00e7\u00e3o Y (vertical)");
                    return;
                }
                int insertNew = 1;
                int updatePos = -1;
                for (int i = 0; i < strReg.length; ++i) {
                    if (!txtTitle.getText().equals(BatchConfig.this.configValue[i].split("\\|")[0])) continue;
                    int opt = SignerDialog.showConfirmDialog(null, "J\u00e1 existe um identificador para estas posi\u00e7\u00f5es, quer substituir os valores", "", 6);
                    if (opt == 1) {
                        return;
                    }
                    insertNew = 0;
                    updatePos = i;
                    System.out.println("Iguais: " + strReg[i]);
                    break;
                }
                String[] saved = new String[listSize + insertNew];
                for (int i = 0; i < listSize; ++i) {
                    saved[i] = values[i];
                    String[] insertValues = values[i].split("\\|");
                    if (updatePos > -1) {
                        if (i == updatePos) {
                            configText = configText + insertValues[0].replace(",", "").replace("|", "") + "|" + txtStampX.getText() + "|" + txtStampY.getText();
                            saved[i] = txtTitle.getText() + "|" + txtStampX.getText() + "|" + txtStampY.getText();
                        } else {
                            configText = configText + insertValues[0].replace(",", "").replace("|", "") + "|" + insertValues[1] + "|" + insertValues[2];
                        }
                    } else {
                        configText = configText + insertValues[0].replace(",", "").replace("|", "") + "|" + insertValues[1] + "|" + insertValues[2];
                    }
                    if (listSize <= 0) continue;
                    configText = configText + ",";
                }
                if (insertNew > 0) {
                    saved[listSize] = txtTitle.getText() + "|" + txtStampX.getText() + "|" + txtStampY.getText();
                    configText = configText + txtTitle.getText().replace(",", "").replace("|", "") + "|" + txtStampX.getText() + "|" + txtStampY.getText();
                }
                BatchConfig.this.props.setProperty("user.pdf.positions", configText);
                BatchConfig.access$002(BatchConfig.this, saved);
                txtTitle.setText("");
                txtStampX.setText("");
                txtStampY.setText("");
                lstReg.setListData(BatchConfig.this.listValues(saved));
            }
        });
        btnConfirmStampPosition.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (lstReg.getSelectedIndex() < 0) {
                    SignerDialog.showMessageDialog(null, "Selecione algum item da lista");
                    return;
                }
                String[] values = BatchConfig.this.configValue[lstReg.getSelectedIndex()].split("\\|");
                if (values.length < 3) {
                    return;
                }
                ((BatchConfig)BatchConfig.this).retPosition[0] = Integer.parseInt(values[1]);
                ((BatchConfig)BatchConfig.this).retPosition[1] = Integer.parseInt(values[2]);
                BatchConfig.this.dispose();
            }
        });
        AbstractAction escapeAction = new AbstractAction(){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent e) {
                BatchConfig.this.dispose();
            }
        };
        this.getRootPane().getInputMap(2).put(KeyStroke.getKeyStroke(27, 0), "ESCAPE_KEY");
        this.getRootPane().getActionMap().put("ESCAPE_KEY", escapeAction);
        this.setVisible(true);
    }

    static /* synthetic */ String[] access$002(BatchConfig x0, String[] x1) {
        x0.configValue = x1;
        return x1;
    }
}

