/*
 * Decompiled with CFR 0.152.
 */
package org.demoiselle.signer.serpro.desktop.ui;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import org.demoiselle.signer.core.extension.BasicCertificate;
import org.demoiselle.signer.policy.impl.xades.util.DocumentUtils;
import org.demoiselle.signer.policy.impl.xades.xml.impl.XMLChecker;
import org.demoiselle.signer.serpro.desktop.command.xmlds.verify.RequestVerifyXML;
import org.demoiselle.signer.serpro.desktop.command.xmlds.verify.ResponseVerifyXML;
import org.demoiselle.signer.serpro.desktop.command.xmlds.verify.VerifyXML;
import org.demoiselle.signer.serpro.desktop.statistics.Statistics;
import org.demoiselle.signer.xmldsig.XMLSignatureInformations;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.NodeList;

public class VerifyXMLSignature {
    private String fileName;
    public Statistics instaSta = new Statistics();
    private static final Logger logger = LoggerFactory.getLogger(VerifyXMLSignature.class);

    public VerifyXMLSignature(String fileName) {
        this.fileName = fileName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<org.demoiselle.signer.policy.impl.xades.XMLSignatureInformations> verifySignature() throws Throwable {
        ArrayList<org.demoiselle.signer.policy.impl.xades.XMLSignatureInformations> results;
        block20: {
            List<Object> result = new ArrayList<org.demoiselle.signer.policy.impl.xades.XMLSignatureInformations>();
            results = new ArrayList<org.demoiselle.signer.policy.impl.xades.XMLSignatureInformations>();
            int indexOfSignatures = 0;
            try {
                if (this.isXades(this.fileName)) {
                    XMLChecker xadesChecker = new XMLChecker();
                    this.instaSta.setAction("verify-xml");
                    this.instaSta.setStart(System.currentTimeMillis());
                    result.clear();
                    xadesChecker.check(true, this.fileName);
                    result = xadesChecker.getSignaturesInfo();
                    this.instaSta.setEnd(System.currentTimeMillis());
                    try {
                        org.demoiselle.signer.policy.impl.xades.XMLSignatureInformations info = (org.demoiselle.signer.policy.impl.xades.XMLSignatureInformations)result.iterator().next();
                        if (info.getSignaturePolicy() != null) {
                            String policy = info.getSignaturePolicy().getIdentifier();
                            this.instaSta.setSignaturePolicy(policy);
                        }
                        this.instaSta.setCaURL(info.getIcpBrasilcertificate().getAuthorityInfoAccess().iterator().next());
                    }
                    catch (Throwable error) {
                        logger.error(error.getMessage());
                    }
                    if (result == null || result.isEmpty()) {
                        this.instaSta.setSuccess(false);
                        logger.info("Assinatura XAdES inv\u00e1lida ou vazia: " + this.fileName);
                        Thread trXMLVeri1 = new Thread(this.instaSta);
                        trXMLVeri1.start();
                    } else {
                        this.instaSta.setSuccess(true);
                        logger.info("Assinatura XAdES v\u00e1lida: " + this.fileName);
                        results.addAll(indexOfSignatures, result);
                        ++indexOfSignatures;
                        Thread trXMLVeri2 = new Thread(this.instaSta);
                        trXMLVeri2.start();
                    }
                    break block20;
                }
                VerifyXML verifyXML = new VerifyXML();
                RequestVerifyXML request = new RequestVerifyXML();
                request.setFileName(this.fileName);
                request.setType("file");
                ResponseVerifyXML response = verifyXML.doCommand(request);
                if (response.isHasError()) {
                    logger.info("Assinatura XMLDsig inv\u00e1lida: " + this.fileName + " - Erro: " + response.getMsgErro());
                } else if (response.isHasWarning()) {
                    logger.info("Assinatura XMLDsig com avisos: " + this.fileName);
                } else if (response.isValid()) {
                    logger.info("Assinatura XMLDsig v\u00e1lida: " + this.fileName);
                } else {
                    logger.info("Assinatura XMLDsig com status desconhecido: " + this.fileName);
                }
                List<XMLSignatureInformations> xmldsigResults = response.getXmlSignatureInformations();
                for (XMLSignatureInformations xmldsigInfo : xmldsigResults) {
                    org.demoiselle.signer.policy.impl.xades.XMLSignatureInformations info = new org.demoiselle.signer.policy.impl.xades.XMLSignatureInformations();
                    info.setChain(xmldsigInfo.getChain());
                    info.setValidatorErrors(xmldsigInfo.getValidatorErrors());
                    info.setInvalidSignature(xmldsigInfo.isInvalidSignature());
                    info.setValidatorWarnins(xmldsigInfo.getValidatorWarnins());
                    if (xmldsigInfo.getChain() != null && !xmldsigInfo.getChain().isEmpty()) {
                        info.setIcpBrasilcertificate(new BasicCertificate(xmldsigInfo.getChain().getFirst()));
                    }
                    results.add(info);
                }
            }
            catch (Throwable error) {
                logger.error(error.getMessage());
                org.demoiselle.signer.policy.impl.xades.XMLSignatureInformations varSignatureInformations = new org.demoiselle.signer.policy.impl.xades.XMLSignatureInformations();
                LinkedList<String> validatorErrors = new LinkedList<String>();
                validatorErrors.add(error.getMessage());
                varSignatureInformations.setValidatorErrors(validatorErrors);
                varSignatureInformations.setInvalidSignature(true);
                result.add(varSignatureInformations);
                results.addAll(indexOfSignatures, result);
                ++indexOfSignatures;
                return indexOfSignatures;
            }
            finally {
                if (results != null && !results.isEmpty()) {
                    return results;
                }
            }
        }
        return results;
    }

    public String getFileName() {
        return this.fileName;
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    public boolean testSignature() {
        Document doc = DocumentUtils.loadXMLDocument(this.fileName);
        NodeList signatureListTags = doc.getElementsByTagNameNS("http://www.w3.org/2000/09/xmldsig#", "Signature");
        int sizeSigList = signatureListTags.getLength();
        return sizeSigList >= 1;
    }

    private boolean isXades(String fileName) {
        Document doc = DocumentUtils.loadXMLDocument(fileName);
        NodeList signatureListTags = doc.getElementsByTagNameNS("http://www.w3.org/2000/09/xmldsig#", "Signature");
        for (int i = 0; i < signatureListTags.getLength(); ++i) {
            NodeList childs = signatureListTags.item(i).getChildNodes();
            for (int j = 0; j < childs.getLength(); ++j) {
                if (!childs.item(j).getNodeName().equals("Object")) continue;
                NodeList childsOfObject = childs.item(j).getChildNodes();
                for (int k = 0; k < childsOfObject.getLength(); ++k) {
                    if (!childsOfObject.item(k).getNodeName().equals("QualifyingProperties")) continue;
                    logger.info("Assinatura \u00e9 XAdES: " + fileName);
                    return true;
                }
            }
        }
        logger.info("Assinatura \u00e9 XMLDsig: " + fileName);
        return false;
    }
}

