/*
 * Decompiled with CFR 0.152.
 */
package org.demoiselle.signer.serpro.desktop.ui;

import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Window;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.net.URL;
import java.util.Properties;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JDialog;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.LayoutStyle;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import org.demoiselle.signer.serpro.desktop.ReadConfig;
import org.demoiselle.signer.serpro.desktop.command.signer.SignRequest;
import org.demoiselle.signer.serpro.desktop.ui.BatchSignature;
import org.demoiselle.signer.serpro.desktop.ui.MetodoCarimboAPI;
import org.demoiselle.signer.serpro.desktop.ui.NewToolsInterface;
import org.demoiselle.signer.serpro.desktop.ui.commons.Commons;
import org.demoiselle.signer.serpro.desktop.ui.commons.SignerDialog;
import org.demoiselle.signer.serpro.desktop.ui.configuration.ConfigProperties;
import org.demoiselle.signer.serpro.desktop.ui.configuration.tabs.TimeStampConfigPanel;
import org.demoiselle.signer.serpro.desktop.utils.ConfiguracoesVolateis;
import org.demoiselle.signer.serpro.desktop.utils.NetUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ValidationTypeOptions
extends JDialog {
    private static final long serialVersionUID = 1L;
    private static ValidationTypeOptions instanceValidationTypeOptions = null;
    private static boolean oldInterface = false;
    private transient SignRequest request = new SignRequest();
    private String typeSignature = "";
    private String typeSignatureDescription = "";
    JRadioButton rdbtnRefVal;
    JRadioButton rdbtnRefComp;
    JRadioButton rdbtnRefArq;
    final JLabel lblAssinarPDF = new JLabel();
    private final JLabel lblAssinarArquivo = new JLabel();
    private final JLabel lblAssinarAtachada = new JLabel();
    private final JLabel lblAssinarLote = new JLabel();
    private JLabel lblCadastrarCredenciais;
    private JLabel lblApiDepreciada;
    private JPanel panelBotoesApi = new JPanel();
    private static final Logger logger = LoggerFactory.getLogger(ValidationTypeOptions.class);

    public static ValidationTypeOptions getInstance(Frame owner, boolean parmOldInteface) {
        if (instanceValidationTypeOptions == null) {
            instanceValidationTypeOptions = new ValidationTypeOptions(owner);
        }
        ValidationTypeOptions.setOldInterface(parmOldInteface);
        return instanceValidationTypeOptions;
    }

    public static ValidationTypeOptions getInstance(boolean parmOldInteface) {
        return ValidationTypeOptions.getInstance(null, parmOldInteface);
    }

    private void setEnabled(JLabel label, boolean enabled) {
        if (label != null) {
            label.setEnabled(enabled);
            label.setForeground(enabled ? new Color(0, 90, 170) : Color.LIGHT_GRAY);
            label.setBorder(BorderFactory.createLineBorder(enabled ? new Color(0, 255, 255) : Color.GRAY, 1));
        }
    }

    private void setVisible(JLabel label, boolean visible) {
        if (label != null) {
            label.setVisible(visible);
        }
    }

    private static boolean isHabilitadoParaCarimbarComSerproApi() {
        return ConfiguracoesVolateis.getMetodoCarimboSelecionado() == MetodoCarimboAPI.API_SERPRO && ReadConfig.getApiSerproCredentials() != null;
    }

    private void atualizarTela() {
        boolean apiSelecionada = ConfiguracoesVolateis.getMetodoCarimboSelecionado() != MetodoCarimboAPI.NENHUM_SELECIONADO;
        this.setVisible(this.lblCadastrarCredenciais, !apiSelecionada);
        this.setVisible(this.lblApiDepreciada, !apiSelecionada);
        if (this.panelBotoesApi != null) {
            this.panelBotoesApi.setVisible(!apiSelecionada);
        }
        this.setEnabled(this.lblAssinarArquivo, apiSelecionada);
        this.setEnabled(this.lblAssinarLote, apiSelecionada);
        this.setEnabled(this.lblAssinarAtachada, apiSelecionada);
        if (!apiSelecionada) {
            this.setEnabled(this.lblAssinarPDF, false);
        } else if (this.rdbtnRefVal != null && this.rdbtnRefVal.isSelected()) {
            this.setEnabled(this.lblAssinarPDF, false);
        } else {
            this.setEnabled(this.lblAssinarPDF, true);
        }
    }

    public ValidationTypeOptions() {
        this((Frame)null);
    }

    public ValidationTypeOptions(Frame owner) {
        super((Window)owner, Dialog.ModalityType.APPLICATION_MODAL);
        this.commonInit();
    }

    private void commonInit() {
        this.setBackground(UIManager.getColor("Menu.acceleratorForeground"));
        this.setTitle("Assinaturas de Longa Dura\u00e7\u00e3o");
        final ValidationTypeOptions me = this;
        this.buildApiSelection();
        this.setDefaultCloseOperation(2);
        this.setResizable(false);
        this.setBounds(15, 115, 900, 100);
        UIManager.put("OptionPane.background", Color.WHITE);
        UIManager.put("Panel.background", Color.WHITE);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                logger.info("Janela ValidationTypeOptions fechada pelo usu\u00e1rio (X). M\u00e9todo de carimbo definido como: {}", (Object)ConfiguracoesVolateis.getMetodoCarimboSelecionado());
                ValidationTypeOptions.this.atualizarTela();
            }

            @Override
            public void windowClosed(WindowEvent e) {
                if (!oldInterface) {
                    NewToolsInterface.getInstance().setVisible(true);
                }
            }
        });
        this.getContentPane().setBackground(new Color(221, 239, 255));
        JPanel panel = new JPanel();
        panel.setBackground(new Color(221, 239, 255));
        String infoText = "<html><head><style>h1{text-align: left; color:#0075dd}p {text-align: left;}div {text-align: left;} p{margin:5px; color:black; text-align: justify; text-justify: inter-word;}</style></head><body><h1 style=\\'text-align: center;\\'>AVISO</h1><p>O carimbo do tempo aplicado a uma assinatura digital prova que ela existia a partir da data de sua emiss\u00e3o.</p><p>Para utiliza\u00e7\u00e3o do Carimbo do Tempo \u00e9 necess\u00e1ria a contrata\u00e7\u00e3o do servi\u00e7o, conforme orienta\u00e7\u00f5es dispon\u00edveis em:</p><p style=\\'text-align: center;\\'><a href=\\'https://loja.serpro.gov.br/carimbodetempo\\'>https://loja.serpro.gov.br/carimbodetempo</a></p></body></html>";
        JEditorPane editorPane = new JEditorPane();
        editorPane.setBackground(new Color(221, 239, 255));
        editorPane.setContentType("text/html");
        editorPane.setText(infoText);
        editorPane.setEditable(false);
        editorPane.addHyperlinkListener(new HyperlinkListener(){

            @Override
            public void hyperlinkUpdate(HyperlinkEvent e) {
                if (e.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                    NetUtil.openLink("https://loja.serpro.gov.br/carimbodetempo");
                }
            }
        });
        editorPane.setBorder(new EmptyBorder(10, 10, 10, 10));
        JPanel panel_1 = new JPanel();
        panel_1.setBackground(new Color(221, 239, 255));
        JPanel panel_2 = new JPanel();
        panel_2.setBackground(new Color(221, 239, 255));
        this.panelBotoesApi = new JPanel();
        this.panelBotoesApi.setBackground(new Color(221, 239, 255));
        if (this.lblCadastrarCredenciais != null) {
            this.panelBotoesApi.add(this.lblCadastrarCredenciais);
        }
        if (this.lblApiDepreciada != null) {
            this.panelBotoesApi.add(this.lblApiDepreciada);
        }
        JLabel lblFechar = new JLabel();
        lblFechar.setFont(new Font("Open Sans", 1, 12));
        lblFechar.setHorizontalAlignment(0);
        lblFechar.setToolTipText("Fechar essa Tela");
        lblFechar.setBackground(new Color(221, 239, 255));
        lblFechar.setOpaque(true);
        lblFechar.setText("<html>Fechar</html>");
        lblFechar.setForeground(new Color(0, 90, 170));
        lblFechar.setBorder(BorderFactory.createLineBorder(new Color(0, 255, 255), 1));
        lblFechar.setMinimumSize(new Dimension(80, 40));
        lblFechar.setPreferredSize(new Dimension(80, 40));
        lblFechar.setMaximumSize(new Dimension(80, 40));
        URL fecharIconUrl = this.getClass().getResource("/images/tools/btnExit.png");
        if (fecharIconUrl != null) {
            lblFechar.setIcon(new ImageIcon(fecharIconUrl));
        } else {
            logger.warn("Recurso de \u00edcone para lblFechar n\u00e3o encontrado: /images/tools/btnExit.png");
        }
        lblFechar.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent e) {
                ValidationTypeOptions.this.setCursor(new Cursor(12));
            }

            @Override
            public void mouseExited(MouseEvent e) {
                ValidationTypeOptions.this.setCursor(new Cursor(0));
            }

            @Override
            public void mouseClicked(MouseEvent e) {
                me.dispose();
            }
        });
        GroupLayout groupLayout = new GroupLayout(this.getContentPane());
        groupLayout.setHorizontalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addContainerGap().addComponent(panel, -2, -1, -2).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, groupLayout.createSequentialGroup().addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(lblFechar, -2, -1, -2).addGap(35)).addGroup(GroupLayout.Alignment.TRAILING, groupLayout.createSequentialGroup().addGap(18).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.panelBotoesApi, GroupLayout.Alignment.LEADING, -1, 548, Short.MAX_VALUE).addComponent(panel_1, GroupLayout.Alignment.LEADING, -1, 548, Short.MAX_VALUE).addComponent(editorPane, GroupLayout.Alignment.LEADING, -1, 548, Short.MAX_VALUE).addComponent(panel_2, GroupLayout.Alignment.LEADING, -1, 548, Short.MAX_VALUE)).addContainerGap()))));
        groupLayout.setVerticalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(panel, -1, 465, Short.MAX_VALUE).addGroup(groupLayout.createSequentialGroup().addComponent(editorPane, -2, 246, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.panelBotoesApi, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(panel_1, -1, 53, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(panel_2, -2, -1, -2).addGap(18).addComponent(lblFechar, -2, -1, -2)));
        this.lblAssinarPDF.setEnabled(false);
        URL assinarPdfIconUrl = this.getClass().getResource("/images/tools/btnSignPDF.png");
        if (assinarPdfIconUrl != null) {
            this.lblAssinarPDF.setIcon(new ImageIcon(assinarPdfIconUrl));
        } else {
            logger.warn("Recurso de \u00edcone para lblAssinarPDF n\u00e3o encontrado: /images/tools/btnSignPDF.png");
        }
        this.lblAssinarPDF.setFont(new Font("Open Sans", 1, 12));
        this.lblAssinarPDF.setHorizontalAlignment(0);
        this.lblAssinarPDF.setVerticalAlignment(0);
        this.lblAssinarPDF.setVerticalTextPosition(0);
        this.lblAssinarPDF.setBackground(new Color(221, 239, 255));
        this.lblAssinarPDF.setOpaque(true);
        this.lblAssinarPDF.setToolTipText("Assinar um arquivo PDF");
        this.lblAssinarPDF.setText("<html> Assinar <br> PDF</html>");
        this.lblAssinarPDF.setForeground(new Color(0, 90, 170));
        this.lblAssinarPDF.setBorder(BorderFactory.createLineBorder(new Color(0, 255, 255), 1));
        this.lblAssinarPDF.setMinimumSize(new Dimension(100, 80));
        this.lblAssinarPDF.setPreferredSize(new Dimension(100, 80));
        this.lblAssinarPDF.setMaximumSize(new Dimension(100, 80));
        panel_2.add(this.lblAssinarPDF);
        this.lblAssinarArquivo.setFont(new Font("Open Sans", 1, 12));
        this.lblAssinarArquivo.setHorizontalAlignment(0);
        this.lblAssinarArquivo.setToolTipText("Gerar uma assinatura Desanexada");
        this.lblAssinarArquivo.setBackground(new Color(221, 239, 255));
        this.lblAssinarArquivo.setOpaque(true);
        this.lblAssinarArquivo.setText("<html>Assinar <br> Arquivo</html>");
        this.lblAssinarArquivo.setForeground(new Color(0, 90, 170));
        this.lblAssinarArquivo.setBorder(BorderFactory.createLineBorder(new Color(0, 255, 255), 1));
        this.lblAssinarArquivo.setMinimumSize(new Dimension(100, 80));
        this.lblAssinarArquivo.setPreferredSize(new Dimension(100, 80));
        this.lblAssinarArquivo.setMaximumSize(new Dimension(100, 80));
        URL assinarArquivoIconUrl = this.getClass().getResource("/images/tools/btnSign.png");
        if (assinarArquivoIconUrl != null) {
            this.lblAssinarArquivo.setIcon(new ImageIcon(assinarArquivoIconUrl));
        } else {
            logger.warn("Recurso de \u00edcone para lblAssinarArquivo n\u00e3o encontrado: /images/tools/btnSign.png");
        }
        this.lblAssinarArquivo.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent e) {
                if (((JLabel)e.getSource()).isEnabled()) {
                    ValidationTypeOptions.this.setCursor(new Cursor(12));
                }
            }

            @Override
            public void mouseExited(MouseEvent e) {
                ValidationTypeOptions.this.setCursor(new Cursor(0));
            }

            @Override
            public void mouseClicked(MouseEvent e) {
                if (((JLabel)e.getSource()).isEnabled() && ValidationTypeOptions.this.typeChecked()) {
                    ValidationTypeOptions.this.request.setType("file");
                    ValidationTypeOptions.this.request.setOutputDataType("file");
                    ValidationTypeOptions.this.setVisible(false);
                    Commons.SignOrdinaryFiles(ValidationTypeOptions.this.request);
                    ValidationTypeOptions.this.dispose();
                }
            }
        });
        panel_2.add(this.lblAssinarArquivo);
        this.lblAssinarAtachada.setFont(new Font("Open Sans", 1, 12));
        this.lblAssinarAtachada.setHorizontalAlignment(0);
        this.lblAssinarAtachada.setToolTipText("Gerar uma assinatura com conte\u00fado anexado");
        this.lblAssinarAtachada.setBackground(new Color(221, 239, 255));
        this.lblAssinarAtachada.setOpaque(true);
        this.lblAssinarAtachada.setText("<html>Assinatura <br> Atachada</html>");
        this.lblAssinarAtachada.setForeground(new Color(0, 90, 170));
        this.lblAssinarAtachada.setBorder(BorderFactory.createLineBorder(new Color(0, 255, 255), 1));
        this.lblAssinarAtachada.setMinimumSize(new Dimension(100, 80));
        this.lblAssinarAtachada.setPreferredSize(new Dimension(100, 80));
        this.lblAssinarAtachada.setMaximumSize(new Dimension(100, 80));
        URL assinarAtachadaIconUrl = this.getClass().getResource("/images/tools/btnAtachedSign.png");
        if (assinarAtachadaIconUrl != null) {
            this.lblAssinarAtachada.setIcon(new ImageIcon(assinarAtachadaIconUrl));
        } else {
            logger.warn("Recurso de \u00edcone para lblAssinarAtachada n\u00e3o encontrado: /images/tools/btnAtachedSign.png");
        }
        this.lblAssinarAtachada.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent e) {
                if (((JLabel)e.getSource()).isEnabled()) {
                    ValidationTypeOptions.this.setCursor(new Cursor(12));
                }
            }

            @Override
            public void mouseExited(MouseEvent e) {
                ValidationTypeOptions.this.setCursor(new Cursor(0));
            }

            @Override
            public void mouseClicked(MouseEvent e) {
                if (((JLabel)e.getSource()).isEnabled() && ValidationTypeOptions.this.typeChecked()) {
                    ValidationTypeOptions.this.request.setType("file");
                    ValidationTypeOptions.this.request.setOutputDataType("file");
                    ValidationTypeOptions.this.request.setAttached("true");
                    ValidationTypeOptions.this.setVisible(false);
                    Commons.SignOrdinaryFiles(ValidationTypeOptions.this.request);
                    ValidationTypeOptions.this.dispose();
                }
            }
        });
        panel_2.add(this.lblAssinarAtachada);
        this.lblAssinarLote.setFont(new Font("Open Sans", 1, 12));
        this.lblAssinarLote.setHorizontalAlignment(0);
        this.lblAssinarLote.setToolTipText("Assinar arquivos em lote");
        this.lblAssinarLote.setBackground(new Color(221, 239, 255));
        this.lblAssinarLote.setOpaque(true);
        this.lblAssinarLote.setText("<html> Assinar <br> em Lote</html>");
        this.lblAssinarLote.setForeground(new Color(0, 90, 170));
        this.lblAssinarLote.setBorder(BorderFactory.createLineBorder(new Color(0, 255, 255), 1));
        this.lblAssinarLote.setMinimumSize(new Dimension(100, 80));
        this.lblAssinarLote.setPreferredSize(new Dimension(100, 80));
        this.lblAssinarLote.setMaximumSize(new Dimension(100, 80));
        URL assinarLoteIconUrl = this.getClass().getResource("/images/tools/btnBatchSign.png");
        if (assinarLoteIconUrl != null) {
            this.lblAssinarLote.setIcon(new ImageIcon(assinarLoteIconUrl));
        } else {
            logger.warn("Recurso de \u00edcone para lblAssinarLote n\u00e3o encontrado: /images/tools/btnBatchSign.png");
        }
        this.lblAssinarLote.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent e) {
                if (((JLabel)e.getSource()).isEnabled()) {
                    ValidationTypeOptions.this.setCursor(new Cursor(12));
                }
            }

            @Override
            public void mouseExited(MouseEvent e) {
                ValidationTypeOptions.this.setCursor(new Cursor(0));
            }

            @Override
            public void mouseClicked(MouseEvent e) {
                if (((JLabel)e.getSource()).isEnabled() && ValidationTypeOptions.this.typeChecked()) {
                    try {
                        ValidationTypeOptions.this.setVisible(false);
                        new BatchSignature(ValidationTypeOptions.this.typeSignature);
                        me.dispose();
                    }
                    catch (Exception ex) {
                        logger.error("Erro na gera\u00e7\u00e3o das Assinaturas com " + ValidationTypeOptions.this.typeSignatureDescription + " em lote:" + ex.getMessage());
                        SignerDialog.showMessageDialog(me, "Erro na gera\u00e7\u00e3o das Assinaturas com " + ValidationTypeOptions.this.typeSignatureDescription + " em lote:" + ex.getMessage(), "Erro", 0);
                        me.dispose();
                    }
                }
            }
        });
        panel_2.add(this.lblAssinarLote);
        this.rdbtnRefVal = new JRadioButton("Refer\u00eancia para Valida\u00e7\u00e3o");
        this.rdbtnRefVal.setFont(new Font("FreeMono", 1, 12));
        this.rdbtnRefVal.setForeground(Color.BLACK);
        panel_1.add(this.rdbtnRefVal);
        this.rdbtnRefComp = new JRadioButton("Refer\u00eancias Completas");
        this.rdbtnRefComp.setFont(new Font("FreeMono", 1, 12));
        panel_1.add(this.rdbtnRefComp);
        this.rdbtnRefArq = new JRadioButton("Refer\u00eancias de Arquivamento");
        this.rdbtnRefArq.setFont(new Font("FreeMono", 1, 12));
        panel_1.add(this.rdbtnRefArq);
        this.rdbtnRefVal.setSelected(true);
        this.rdbtnRefVal.setToolTipText("N\u00e3o permitida para PDF");
        this.rdbtnRefComp.setEnabled(false);
        this.rdbtnRefArq.setEnabled(false);
        this.rdbtnRefVal.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (ValidationTypeOptions.this.rdbtnRefVal.isSelected()) {
                    ValidationTypeOptions.this.lblAssinarPDF.setEnabled(false);
                }
            }
        });
        this.rdbtnRefComp.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (ValidationTypeOptions.this.rdbtnRefComp.isSelected()) {
                    ValidationTypeOptions.this.lblAssinarPDF.setEnabled(true);
                }
            }
        });
        this.rdbtnRefArq.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (ValidationTypeOptions.this.rdbtnRefArq.isSelected()) {
                    ValidationTypeOptions.this.lblAssinarPDF.setEnabled(true);
                }
            }
        });
        groupLayout.setAutoCreateContainerGaps(true);
        this.getContentPane().setLayout(groupLayout);
        this.setSize(735, 570);
        this.setLocationRelativeTo(null);
        this.atualizarTela();
    }

    private void buildApiSelection() {
        this.lblCadastrarCredenciais = new JLabel();
        this.lblCadastrarCredenciais.setText("<html><center>Cadastrar credenciais<br>da API Serpro</center></html>");
        this.lblCadastrarCredenciais.setToolTipText("Cadastrar credenciais da API Serpro para Carimbo do Tempo");
        this.lblCadastrarCredenciais.setHorizontalAlignment(0);
        this.lblCadastrarCredenciais.setForeground(new Color(0, 90, 170));
        this.lblCadastrarCredenciais.setFont(new Font("Open Sans", 1, 12));
        this.lblCadastrarCredenciais.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createLineBorder(new Color(0, 90, 170), 1, true), BorderFactory.createEmptyBorder(5, 10, 5, 10)));
        this.lblCadastrarCredenciais.setOpaque(true);
        this.lblCadastrarCredenciais.setBackground(Color.WHITE);
        this.lblCadastrarCredenciais.setCursor(new Cursor(12));
        this.lblCadastrarCredenciais.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                block10: {
                    try {
                        Properties props = ReadConfig.getProps();
                        if (props == null) {
                            ReadConfig.doConfig();
                            props = ReadConfig.getProps();
                        }
                        if (props == null) {
                            logger.error("Falha ao carregar as propriedades para configurar o carimbo de tempo.");
                            SignerDialog.showMessageDialog(ValidationTypeOptions.this, "Erro cr\u00edtico: N\u00e3o foi poss\u00edvel carregar as configura\u00e7\u00f5es.", "Erro", 0);
                            return;
                        }
                        JDialog configDialog = new JDialog(ValidationTypeOptions.this, "Configurar Carimbo do Tempo", true);
                        TimeStampConfigPanel configPanel = new TimeStampConfigPanel(configDialog, props);
                        configDialog.getContentPane().add(configPanel);
                        configDialog.pack();
                        configDialog.setLocationRelativeTo(ValidationTypeOptions.this);
                        configDialog.setVisible(true);
                        if (configPanel.isValidatedSuccessfully()) {
                            ConfiguracoesVolateis.setMetodoCarimboSelecionado(MetodoCarimboAPI.API_SERPRO);
                            logger.info("Credenciais da API Serpro validadas e configuradas.");
                            try {
                                Properties currentProps = ReadConfig.getProps();
                                if (currentProps == null) {
                                    ReadConfig.doConfig();
                                    currentProps = ReadConfig.getProps();
                                }
                                if (currentProps != null) {
                                    currentProps.setProperty("user.api.serpro", "true");
                                    ConfigProperties.saveProps(currentProps);
                                    logger.info("Configurado para usar API Serpro para carimbo de tempo.");
                                } else {
                                    logger.warn("Properties n\u00e3o puderam ser carregadas para definir USER_API_SERPRO como true.");
                                }
                            }
                            catch (Exception exSave) {
                                logger.error("Erro ao salvar USER_API_SERPRO como true: {}", (Object)exSave.getMessage());
                                SignerDialog.showMessageDialog(ValidationTypeOptions.this, "Erro ao salvar configura\u00e7\u00e3o da API: " + exSave.getMessage(), "Erro de Configura\u00e7\u00e3o", 2);
                            }
                            ValidationTypeOptions.this.atualizarTela();
                            break block10;
                        }
                        logger.info("Configura\u00e7\u00e3o de credenciais da API Serpro n\u00e3o conclu\u00edda ou cancelada.");
                        ConfiguracoesVolateis.setMetodoCarimboSelecionado(MetodoCarimboAPI.NENHUM_SELECIONADO);
                        ValidationTypeOptions.this.atualizarTela();
                    }
                    catch (Exception ex) {
                        logger.error("Erro ao abrir configura\u00e7\u00e3o de carimbo de tempo: {}", (Object)ex.getMessage());
                        SignerDialog.showMessageDialog(ValidationTypeOptions.this, "Erro ao abrir configura\u00e7\u00e3o: " + ex.getMessage(), "Erro", 0);
                    }
                }
            }
        });
        this.lblApiDepreciada = new JLabel();
        this.lblApiDepreciada.setText("<html><center>Prosseguir com API de<br>carimbo do tempo depreciada</center></html>");
        this.lblApiDepreciada.setToolTipText("Usar o m\u00e9todo antigo de Carimbo do Tempo (n\u00e3o recomendado)");
        this.lblApiDepreciada.setHorizontalAlignment(0);
        this.lblApiDepreciada.setForeground(new Color(0, 90, 170));
        this.lblApiDepreciada.setFont(new Font("Open Sans", 1, 12));
        this.lblApiDepreciada.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createLineBorder(new Color(0, 90, 170), 1, true), BorderFactory.createEmptyBorder(5, 10, 5, 10)));
        this.lblApiDepreciada.setOpaque(true);
        this.lblApiDepreciada.setBackground(Color.WHITE);
        this.lblApiDepreciada.setCursor(new Cursor(12));
        this.lblApiDepreciada.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                try {
                    ConfiguracoesVolateis.setMetodoCarimboSelecionado(MetodoCarimboAPI.API_DEPRECIADA);
                    Properties props = ReadConfig.getProps();
                    if (props == null) {
                        ReadConfig.doConfig();
                        props = ReadConfig.getProps();
                    }
                    if (props != null) {
                        props.setProperty("user.api.serpro", "false");
                        ConfigProperties.saveProps(props);
                        logger.info("Configurado para usar API depreciada para carimbo de tempo a partir de ValidationTypeOptions.");
                        SignerDialog.showMessageDialog(ValidationTypeOptions.this, "Configurado para usar a API depreciada de carimbo do tempo.", "Configura\u00e7\u00e3o Alterada", 1);
                    } else {
                        logger.warn("Properties n\u00e3o puderam ser carregadas para definir USER_API_SERPRO como false.");
                        SignerDialog.showMessageDialog(ValidationTypeOptions.this, "N\u00e3o foi poss\u00edvel salvar a prefer\u00eancia da API depreciada.", "Erro de Configura\u00e7\u00e3o", 2);
                    }
                    ValidationTypeOptions.this.atualizarTela();
                }
                catch (Exception ex) {
                    logger.error("Erro ao configurar API depreciada: {}", (Object)ex.getMessage());
                    SignerDialog.showMessageDialog(ValidationTypeOptions.this, "Erro ao configurar API depreciada: " + ex.getMessage(), "Erro", 0);
                }
            }
        });
    }

    private boolean typeChecked() {
        boolean isChecked = true;
        if (!(this.rdbtnRefVal.isSelected() || this.rdbtnRefComp.isSelected() || this.rdbtnRefArq.isSelected())) {
            SignerDialog.showMessageDialog(null, "Nenhum perfil escolhido!", "Erro", 0);
            isChecked = false;
        }
        if (this.rdbtnRefVal.isSelected()) {
            this.request.setSignaturePolicy("RV");
            this.typeSignature = "RV";
            this.typeSignatureDescription = "Refer\u00eancia de Valida\u00e7\u00e3o";
        }
        if (this.rdbtnRefComp.isSelected()) {
            this.request.setSignaturePolicy("RC");
            this.typeSignature = "RC";
            this.typeSignatureDescription = "Refer\u00eancia Completa";
        }
        if (this.rdbtnRefArq.isSelected()) {
            this.request.setSignaturePolicy("RA");
            this.typeSignature = "RA";
            this.typeSignatureDescription = "Refer\u00eancia de Arquivamento";
        }
        return isChecked;
    }

    private static boolean isOldInterface() {
        return oldInterface;
    }

    private static void setOldInterface(boolean oldInterface) {
        ValidationTypeOptions.oldInterface = oldInterface;
    }

    public static void main(String[] args) {
        ValidationTypeOptions.getInstance(true).setVisible(true);
    }
}

