/*
 * Decompiled with CFR 0.152.
 */
package org.demoiselle.signer.serpro.desktop.ui;

import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.util.Properties;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JDialog;
import javax.swing.JEditorPane;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.LayoutStyle;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.filechooser.FileNameExtensionFilter;
import org.demoiselle.signer.serpro.desktop.Main;
import org.demoiselle.signer.serpro.desktop.ReadConfig;
import org.demoiselle.signer.serpro.desktop.UiFunctions;
import org.demoiselle.signer.serpro.desktop.command.signer.SignRequest;
import org.demoiselle.signer.serpro.desktop.command.xml.sign.RequestSignXML;
import org.demoiselle.signer.serpro.desktop.ui.BatchSignature;
import org.demoiselle.signer.serpro.desktop.ui.MetodoCarimboAPI;
import org.demoiselle.signer.serpro.desktop.ui.commons.Commons;
import org.demoiselle.signer.serpro.desktop.ui.commons.SignerDialog;
import org.demoiselle.signer.serpro.desktop.ui.configuration.ConfigProperties;
import org.demoiselle.signer.serpro.desktop.ui.configuration.tabs.TimeStampConfigPanel;
import org.demoiselle.signer.serpro.desktop.ui.pdf.NewPDFReader;
import org.demoiselle.signer.serpro.desktop.utils.ConfiguracoesVolateis;
import org.demoiselle.signer.serpro.desktop.utils.NetUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TimestampOptions
extends JDialog
implements Runnable {
    private static final long serialVersionUID = -2141630684420791536L;
    private static TimestampOptions instanceTimestampOptions = null;
    private static boolean oldInterface = false;
    private static Frame ownerFrame = null;
    private static final Logger logger = LoggerFactory.getLogger(TimestampOptions.class);
    private UiFunctions uiFunctions = new UiFunctions();
    private JPanel panelBotoesApi;
    private JLabel lblCadastrarCredenciais;
    private JLabel lblApiDepreciada;
    private JLabel lblAssinarPDF;
    private JLabel lblAssinarXML;
    private JLabel lblAssinarArquivo;
    private JLabel lblAssinarLote;
    private JLabel lblAssinarAtachada;
    private JLabel lblCoAssinar;
    private JLabel lblCarimboTempo;
    private JLabel lblCarimboPDF;

    private static boolean isHabilitadoParaCarimbarComSerproApi() {
        return ConfiguracoesVolateis.getMetodoCarimboSelecionado() == MetodoCarimboAPI.API_SERPRO && ReadConfig.getApiSerproCredentials() != null;
    }

    public static TimestampOptions getInstance(Frame owner, boolean parmOldInteface) {
        ownerFrame = owner;
        if (instanceTimestampOptions == null) {
            instanceTimestampOptions = new TimestampOptions(ownerFrame);
        }
        TimestampOptions.setOldInterface(parmOldInteface);
        return instanceTimestampOptions;
    }

    public static TimestampOptions getInstance(boolean parmOldInteface) {
        return TimestampOptions.getInstance(null, parmOldInteface);
    }

    private void setEnabled(JLabel label, boolean enabled) {
        if (label != null) {
            label.setEnabled(enabled);
            label.setForeground(enabled ? new Color(0, 90, 170) : Color.LIGHT_GRAY);
            label.setBorder(BorderFactory.createLineBorder(enabled ? new Color(0, 255, 255) : Color.GRAY, 1));
        }
    }

    private void setVisible(JLabel label, boolean visible) {
        if (label != null) {
            label.setVisible(visible);
        }
    }

    private void atualizarTela() {
        boolean apiConfigurada = ConfiguracoesVolateis.getMetodoCarimboSelecionado() != MetodoCarimboAPI.NENHUM_SELECIONADO;
        this.setVisible(this.lblCadastrarCredenciais, !apiConfigurada);
        this.setVisible(this.lblApiDepreciada, !apiConfigurada);
        if (this.panelBotoesApi != null) {
            this.panelBotoesApi.setVisible(!apiConfigurada);
        }
        this.setEnabled(this.lblAssinarPDF, apiConfigurada);
        this.setEnabled(this.lblAssinarXML, apiConfigurada);
        this.setEnabled(this.lblAssinarArquivo, apiConfigurada);
        this.setEnabled(this.lblAssinarLote, apiConfigurada);
        this.setEnabled(this.lblAssinarAtachada, apiConfigurada);
        this.setEnabled(this.lblCoAssinar, apiConfigurada);
        this.setEnabled(this.lblCarimboTempo, apiConfigurada);
        this.setEnabled(this.lblCarimboPDF, apiConfigurada);
    }

    private void buildApiSelection() {
        this.lblCadastrarCredenciais = new JLabel();
        this.lblCadastrarCredenciais.setText("<html><center>Cadastrar credenciais<br>da API Serpro</center></html>");
        this.lblCadastrarCredenciais.setToolTipText("Cadastrar credenciais da API Serpro para Carimbo do Tempo");
        this.lblCadastrarCredenciais.setHorizontalAlignment(0);
        this.lblCadastrarCredenciais.setForeground(new Color(0, 90, 170));
        this.lblCadastrarCredenciais.setFont(new Font("Open Sans", 1, 12));
        this.lblCadastrarCredenciais.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createLineBorder(new Color(0, 90, 170), 1, true), BorderFactory.createEmptyBorder(5, 10, 5, 10)));
        this.lblCadastrarCredenciais.setOpaque(true);
        this.lblCadastrarCredenciais.setBackground(Color.WHITE);
        this.lblCadastrarCredenciais.setCursor(new Cursor(12));
        this.lblCadastrarCredenciais.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                block10: {
                    try {
                        Properties props = ReadConfig.getProps();
                        if (props == null) {
                            ReadConfig.doConfig();
                            props = ReadConfig.getProps();
                        }
                        if (props == null) {
                            logger.error("Falha ao carregar as propriedades para configurar o carimbo de tempo.");
                            SignerDialog.showMessageDialog(TimestampOptions.this, "Erro cr\u00edtico: N\u00e3o foi poss\u00edvel carregar as configura\u00e7\u00f5es.", "Erro", 0);
                            return;
                        }
                        JDialog configDialog = new JDialog(TimestampOptions.this, "Configurar Carimbo do Tempo", true);
                        TimeStampConfigPanel configPanel = new TimeStampConfigPanel(configDialog, props);
                        configDialog.getContentPane().add(configPanel);
                        configDialog.pack();
                        configDialog.setLocationRelativeTo(TimestampOptions.this);
                        configDialog.setVisible(true);
                        if (configPanel.isValidatedSuccessfully()) {
                            ConfiguracoesVolateis.setMetodoCarimboSelecionado(MetodoCarimboAPI.API_SERPRO);
                            logger.info("Credenciais da API Serpro validadas e configuradas.");
                            try {
                                Properties currentProps = ReadConfig.getProps();
                                if (currentProps == null) {
                                    ReadConfig.doConfig();
                                    currentProps = ReadConfig.getProps();
                                }
                                if (currentProps != null) {
                                    currentProps.setProperty("user.api.serpro", "true");
                                    ConfigProperties.saveProps(currentProps);
                                    logger.info("Configurado para usar API Serpro para carimbo de tempo.");
                                } else {
                                    logger.warn("Properties n\u00e3o puderam ser carregadas para definir USER_API_SERPRO como true.");
                                }
                            }
                            catch (Exception exSave) {
                                logger.error("Erro ao salvar USER_API_SERPRO como true: {}", (Object)exSave.getMessage());
                                SignerDialog.showMessageDialog(TimestampOptions.this, "Erro ao salvar configura\u00e7\u00e3o da API: " + exSave.getMessage(), "Erro de Configura\u00e7\u00e3o", 2);
                            }
                            TimestampOptions.this.atualizarTela();
                            break block10;
                        }
                        logger.info("Configura\u00e7\u00e3o de credenciais da API Serpro n\u00e3o conclu\u00edda ou cancelada.");
                        ConfiguracoesVolateis.setMetodoCarimboSelecionado(MetodoCarimboAPI.NENHUM_SELECIONADO);
                        TimestampOptions.this.atualizarTela();
                    }
                    catch (Exception ex) {
                        logger.error("Erro ao abrir configura\u00e7\u00e3o de carimbo de tempo: {}", (Object)ex.getMessage());
                        SignerDialog.showMessageDialog(TimestampOptions.this, "Erro ao abrir configura\u00e7\u00e3o: " + ex.getMessage(), "Erro", 0);
                    }
                }
            }
        });
        this.lblApiDepreciada = new JLabel();
        this.lblApiDepreciada.setText("<html><center>Prosseguir com API de<br>carimbo de tempo depreciada</center></html>");
        this.lblApiDepreciada.setToolTipText("Usar o m\u00e9todo antigo de Carimbo do Tempo (n\u00e3o recomendado)");
        this.lblApiDepreciada.setHorizontalAlignment(0);
        this.lblApiDepreciada.setForeground(new Color(0, 90, 170));
        this.lblApiDepreciada.setFont(new Font("Open Sans", 1, 12));
        this.lblApiDepreciada.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createLineBorder(new Color(0, 90, 170), 1, true), BorderFactory.createEmptyBorder(5, 10, 5, 10)));
        this.lblApiDepreciada.setOpaque(true);
        this.lblApiDepreciada.setBackground(Color.WHITE);
        this.lblApiDepreciada.setCursor(new Cursor(12));
        this.lblApiDepreciada.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                ConfiguracoesVolateis.setMetodoCarimboSelecionado(MetodoCarimboAPI.API_DEPRECIADA);
                try {
                    Properties props = ReadConfig.getProps();
                    if (props == null) {
                        ReadConfig.doConfig();
                        props = ReadConfig.getProps();
                    }
                    if (props != null) {
                        props.setProperty("user.api.serpro", "false");
                        ConfigProperties.saveProps(props);
                        logger.info("Configurado para usar API de carimbo de tempo depreciada.");
                    } else {
                        logger.warn("Properties n\u00e3o puderam ser carregadas para definir API depreciada.");
                    }
                }
                catch (Exception ex) {
                    logger.error("Erro ao salvar configura\u00e7\u00e3o para API depreciada: {}", (Object)ex.getMessage());
                    SignerDialog.showMessageDialog(TimestampOptions.this, "Erro ao salvar configura\u00e7\u00e3o: " + ex.getMessage(), "Erro", 2);
                }
                SignerDialog.showMessageDialog(TimestampOptions.this, "Prosseguindo com API depreciada.", "Informa\u00e7\u00e3o", 1);
                TimestampOptions.this.atualizarTela();
            }
        });
        this.panelBotoesApi = new JPanel();
        this.panelBotoesApi.setBackground(Color.WHITE);
        GroupLayout gl_panelBotoesApi = new GroupLayout(this.panelBotoesApi);
        gl_panelBotoesApi.setHorizontalGroup(gl_panelBotoesApi.createSequentialGroup().addContainerGap(-1, Short.MAX_VALUE).addComponent(this.lblCadastrarCredenciais).addGap(10).addComponent(this.lblApiDepreciada).addContainerGap(-1, Short.MAX_VALUE));
        gl_panelBotoesApi.setVerticalGroup(gl_panelBotoesApi.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent(this.lblCadastrarCredenciais).addComponent(this.lblApiDepreciada));
        this.panelBotoesApi.setLayout(gl_panelBotoesApi);
    }

    public TimestampOptions(Frame owner) {
        super((Window)owner, Dialog.ModalityType.APPLICATION_MODAL);
        this.commonInit();
    }

    public TimestampOptions() {
        this(ownerFrame);
    }

    private void commonInit() {
        this.setBackground(UIManager.getColor("Menu.acceleratorForeground"));
        this.setTitle("Fun\u00e7\u00f5es com Carimbo do Tempo");
        this.setIconImage(Toolkit.getDefaultToolkit().getImage(TimestampOptions.class.getClassLoader().getResource("images/icon-signer-blue-16x16.png")));
        this.setDefaultCloseOperation(2);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                logger.info("Janela TimestampOptions fechada pelo usu\u00e1rio (X).");
            }

            @Override
            public void windowClosed(WindowEvent e) {
                if (oldInterface || TimestampOptions.this.getOwner() != null) {
                    // empty if block
                }
                instanceTimestampOptions = null;
            }
        });
        this.setResizable(false);
        UIManager.put("OptionPane.background", Color.WHITE);
        UIManager.put("Panel.background", Color.WHITE);
        String infoText = "<html><head><style>h1{text-align: left; color:#0075dd}p {text-align: left;}div {text-align: left;} p{margin:5px; color:black; text-align: justify; text-justify: inter-word;}</style></head><body><h1 style='text-align: center;'>AVISO</h1><p>O carimbo do tempo aplicado a uma assinatura digital prova que ela existia a partir da data de sua emiss\u00e3o.</p><p>Para utiliza\u00e7\u00e3o do Carimbo do Tempo \u00e9 necess\u00e1ria a contrata\u00e7\u00e3o do servi\u00e7o, conforme orienta\u00e7\u00f5es dispon\u00edveis em:</p><p style='text-align: center;'><a href='https://loja.serpro.gov.br/carimbodetempo'>https://loja.serpro.gov.br/carimbodetempo</a></p></body></html>";
        this.getContentPane().setBackground(Color.WHITE);
        JEditorPane editorPane = new JEditorPane();
        editorPane.setContentType("text/html");
        editorPane.setText(infoText);
        editorPane.setEditable(false);
        editorPane.setBackground(new Color(255, 255, 255));
        editorPane.addHyperlinkListener(new HyperlinkListener(){

            @Override
            public void hyperlinkUpdate(HyperlinkEvent e) {
                if (e.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                    NetUtil.openLink("https://loja.serpro.gov.br/carimbodetempo");
                }
            }
        });
        editorPane.setBorder(new EmptyBorder(10, 10, 10, 10));
        this.buildApiSelection();
        JPanel panel1 = new JPanel();
        panel1.setBackground(new Color(221, 239, 255));
        JPanel panel2 = new JPanel();
        panel2.setBackground(new Color(221, 239, 255));
        JLabel lblFechar = new JLabel();
        lblFechar.setFont(new Font("Open Sans", 1, 12));
        lblFechar.setHorizontalAlignment(0);
        lblFechar.setToolTipText("Fechar essa Tela");
        lblFechar.setBackground(new Color(255, 255, 255));
        lblFechar.setOpaque(true);
        lblFechar.setText("<html>Fechar</html>");
        lblFechar.setForeground(new Color(0, 90, 170));
        lblFechar.setBorder(BorderFactory.createLineBorder(new Color(0, 255, 255), 1));
        lblFechar.setMinimumSize(new Dimension(80, 40));
        lblFechar.setPreferredSize(new Dimension(80, 40));
        lblFechar.setMaximumSize(new Dimension(80, 40));
        lblFechar.setIcon(new ImageIcon(this.getClass().getResource("/images/tools/btnExit.png")));
        lblFechar.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent e) {
                TimestampOptions.this.setCursor(new Cursor(12));
            }

            @Override
            public void mouseExited(MouseEvent e) {
                TimestampOptions.this.setCursor(new Cursor(0));
            }

            @Override
            public void mouseClicked(MouseEvent e) {
                TimestampOptions.this.dispose();
            }
        });
        GroupLayout groupLayout = new GroupLayout(this.getContentPane());
        groupLayout.setHorizontalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addGap(10).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(editorPane, -2, 545, -2).addGroup(groupLayout.createSequentialGroup().addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(panel2, -1, 528, Short.MAX_VALUE).addComponent(panel1, -1, 528, Short.MAX_VALUE)))).addContainerGap()).addGroup(GroupLayout.Alignment.TRAILING, groupLayout.createSequentialGroup().addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(lblFechar, -2, -1, -2).addGap(19)))).addGroup(groupLayout.createSequentialGroup().addContainerGap().addComponent(this.panelBotoesApi, -1, -1, Short.MAX_VALUE).addContainerGap()));
        groupLayout.setVerticalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addGap(11).addGroup(groupLayout.createSequentialGroup().addComponent(editorPane, -2, 188, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.panelBotoesApi, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(panel1, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(panel2, -2, -1, Short.MAX_VALUE).addGap(18).addComponent(lblFechar, -2, -1, -2).addGap(28))));
        this.lblAssinarAtachada = new JLabel();
        this.lblAssinarAtachada.setFont(new Font("Open Sans", 1, 12));
        this.lblAssinarAtachada.setHorizontalAlignment(0);
        this.lblAssinarAtachada.setToolTipText("Gerar uma assinatura com conte\u00fado anexado");
        this.lblAssinarAtachada.setBackground(new Color(255, 255, 255));
        this.lblAssinarAtachada.setOpaque(true);
        this.lblAssinarAtachada.setText("<html>Assinatura <br> Atachada</html>");
        this.lblAssinarAtachada.setForeground(new Color(0, 90, 170));
        this.lblAssinarAtachada.setBorder(BorderFactory.createLineBorder(new Color(0, 255, 255), 1));
        this.lblAssinarAtachada.setMinimumSize(new Dimension(100, 80));
        this.lblAssinarAtachada.setPreferredSize(new Dimension(100, 80));
        this.lblAssinarAtachada.setMaximumSize(new Dimension(100, 80));
        this.lblAssinarAtachada.setIcon(new ImageIcon(this.getClass().getResource("/images/tools/btnAtachedSign.png")));
        this.lblAssinarAtachada.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent e) {
                if (TimestampOptions.this.lblAssinarAtachada.isEnabled()) {
                    TimestampOptions.this.setCursor(new Cursor(12));
                }
            }

            @Override
            public void mouseExited(MouseEvent e) {
                TimestampOptions.this.setCursor(new Cursor(0));
            }

            @Override
            public void mouseClicked(MouseEvent e) {
                if (!TimestampOptions.this.lblAssinarAtachada.isEnabled()) {
                    return;
                }
                Main.showLoadingScreen("");
                SignRequest request = new SignRequest();
                request.setType("file");
                request.setOutputDataType("file");
                request.setAttached("true");
                request.setSignaturePolicy("RT");
                TimestampOptions.this.setVisible(false);
                Commons.SignOrdinaryFiles(request);
                Main.hideLoadingScreen();
                TimestampOptions.this.dispose();
            }
        });
        panel2.add(this.lblAssinarAtachada);
        this.lblCoAssinar = new JLabel();
        this.lblCoAssinar.setFont(new Font("Open Sans", 1, 12));
        this.lblCoAssinar.setHorizontalAlignment(0);
        this.lblCoAssinar.setToolTipText("Co-Asssinar uma assinatura desanexada");
        this.lblCoAssinar.setBackground(new Color(255, 255, 255));
        this.lblCoAssinar.setOpaque(true);
        this.lblCoAssinar.setText("<html>Co-Assinar <br></html>");
        this.lblCoAssinar.setForeground(new Color(0, 90, 170));
        this.lblCoAssinar.setBorder(BorderFactory.createLineBorder(new Color(0, 255, 255), 1));
        this.lblCoAssinar.setMinimumSize(new Dimension(100, 80));
        this.lblCoAssinar.setPreferredSize(new Dimension(100, 80));
        this.lblCoAssinar.setMaximumSize(new Dimension(100, 80));
        this.lblCoAssinar.setIcon(new ImageIcon(this.getClass().getResource("/images/tools/btnCoSign.png")));
        this.lblCoAssinar.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent e) {
                if (TimestampOptions.this.lblCoAssinar.isEnabled()) {
                    TimestampOptions.this.setCursor(new Cursor(12));
                }
            }

            @Override
            public void mouseExited(MouseEvent e) {
                TimestampOptions.this.setCursor(new Cursor(0));
            }

            @Override
            public void mouseClicked(MouseEvent e) {
                if (!TimestampOptions.this.lblCoAssinar.isEnabled()) {
                    return;
                }
                Main.showLoadingScreen("");
                SignRequest request = new SignRequest();
                request.setSignaturePolicy("RT");
                TimestampOptions.this.setVisible(false);
                try {
                    Commons.coSigner(request);
                    Main.hideLoadingScreen();
                }
                catch (Throwable e1) {
                    Main.hideLoadingScreen();
                    logger.error("Co Assinatura com carimbo do Tempo " + e1.getMessage());
                    SignerDialog.showMessageDialog(TimestampOptions.this, "Erro", "Processo de Co Assinatura:" + e1.getMessage(), 0);
                }
                TimestampOptions.this.dispose();
            }
        });
        panel2.add(this.lblCoAssinar);
        this.lblCarimboTempo = new JLabel();
        this.lblCarimboTempo.setFont(new Font("Open Sans", 1, 12));
        this.lblCarimboTempo.setHorizontalAlignment(0);
        this.lblCarimboTempo.setVerticalAlignment(0);
        this.lblCarimboTempo.setToolTipText("Gerar um Carimbo do Tempo");
        this.lblCarimboTempo.setBackground(new Color(255, 255, 255));
        this.lblCarimboTempo.setOpaque(true);
        this.lblCarimboTempo.setText("<html>Gerar <br> Carimbo <br> do Tempo</html>");
        this.lblCarimboTempo.setForeground(new Color(0, 90, 170));
        this.lblCarimboTempo.setBorder(BorderFactory.createLineBorder(new Color(0, 255, 255), 1));
        this.lblCarimboTempo.setMinimumSize(new Dimension(100, 80));
        this.lblCarimboTempo.setPreferredSize(new Dimension(100, 80));
        this.lblCarimboTempo.setMaximumSize(new Dimension(100, 80));
        this.lblCarimboTempo.setIcon(new ImageIcon(this.getClass().getResource("/images/tools/btnOnlyTimestamp.png")));
        this.lblCarimboTempo.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent e) {
                if (TimestampOptions.this.lblCarimboTempo.isEnabled()) {
                    TimestampOptions.this.setCursor(new Cursor(12));
                }
            }

            @Override
            public void mouseExited(MouseEvent e) {
                TimestampOptions.this.setCursor(new Cursor(0));
            }

            @Override
            public void mouseClicked(MouseEvent e) {
                if (!TimestampOptions.this.lblCarimboTempo.isEnabled()) {
                    return;
                }
                Main.showLoadingScreen("");
                TimestampOptions.this.setVisible(false);
                try {
                    TimestampOptions.this.uiFunctions.fileTimestamp();
                    Main.hideLoadingScreen();
                }
                catch (Exception error) {
                    Main.hideLoadingScreen();
                    logger.error("Erro na gera\u00e7\u00e3o de carimbo do tempo apenas: " + error.getMessage());
                    TimestampOptions.this.uiFunctions.errorMessage("Erro", error.getMessage());
                }
                TimestampOptions.this.dispose();
            }
        });
        panel2.add(this.lblCarimboTempo);
        this.lblCarimboPDF = new JLabel();
        this.lblCarimboPDF.setFont(new Font("Open Sans", 1, 12));
        this.lblCarimboPDF.setHorizontalAlignment(0);
        this.lblCarimboPDF.setVerticalAlignment(0);
        this.lblCarimboPDF.setToolTipText("Inserir um Carimbo do tempo em um arquivo PDF");
        this.lblCarimboPDF.setBackground(new Color(255, 255, 255));
        this.lblCarimboPDF.setOpaque(true);
        this.lblCarimboPDF.setText("<html>Carimbo <br>do Tempo <br> em PDF</html>");
        this.lblCarimboPDF.setForeground(new Color(0, 90, 170));
        this.lblCarimboPDF.setBorder(BorderFactory.createLineBorder(new Color(0, 255, 255), 1));
        this.lblCarimboPDF.setMinimumSize(new Dimension(100, 80));
        this.lblCarimboPDF.setPreferredSize(new Dimension(100, 80));
        this.lblCarimboPDF.setMaximumSize(new Dimension(100, 80));
        this.lblCarimboPDF.setIcon(new ImageIcon(this.getClass().getResource("/images/tools/btnTimestamp.png")));
        this.lblCarimboPDF.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent e) {
                if (TimestampOptions.this.lblCarimboPDF.isEnabled()) {
                    TimestampOptions.this.setCursor(new Cursor(12));
                }
            }

            @Override
            public void mouseExited(MouseEvent e) {
                TimestampOptions.this.setCursor(new Cursor(0));
            }

            @Override
            public void mouseClicked(MouseEvent e) {
                if (!TimestampOptions.this.lblCarimboPDF.isEnabled()) {
                    return;
                }
                TimestampOptions.this.setVisible(false);
                try {
                    TimestampOptions.this.uiFunctions.pdfTimestamp();
                    Main.hideLoadingScreen();
                }
                catch (Exception error) {
                    Main.hideLoadingScreen();
                    logger.error("Erro ao tentar inserir carimbo do tempo em PDF", error);
                    if (error.getMessage() == null || error.getMessage().equals("")) {
                        TimestampOptions.this.uiFunctions.errorMessage("Erro", "Um erro inesperado ocorreu, reinicie o aplicativo.");
                    }
                    TimestampOptions.this.uiFunctions.errorMessage("Erro", error.getMessage());
                }
                TimestampOptions.this.dispose();
            }
        });
        panel2.add(this.lblCarimboPDF);
        this.lblAssinarPDF = new JLabel();
        this.lblAssinarPDF.setIcon(new ImageIcon(this.getClass().getResource("/images/tools/btnSignPDF.png")));
        this.lblAssinarPDF.setFont(new Font("Open Sans", 1, 12));
        this.lblAssinarPDF.setHorizontalAlignment(0);
        this.lblAssinarPDF.setVerticalAlignment(0);
        this.lblAssinarPDF.setVerticalTextPosition(0);
        this.lblAssinarPDF.setBackground(new Color(255, 255, 255));
        this.lblAssinarPDF.setOpaque(true);
        this.lblAssinarPDF.setToolTipText("Assinar um arquivo PDF");
        this.lblAssinarPDF.setText("<html> Assinar <br> PDF</html>");
        this.lblAssinarPDF.setForeground(new Color(0, 90, 170));
        this.lblAssinarPDF.setBorder(BorderFactory.createLineBorder(new Color(0, 255, 255), 1));
        this.lblAssinarPDF.setMinimumSize(new Dimension(100, 80));
        this.lblAssinarPDF.setPreferredSize(new Dimension(100, 80));
        this.lblAssinarPDF.setMaximumSize(new Dimension(100, 80));
        this.lblAssinarPDF.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent e) {
                if (TimestampOptions.this.lblAssinarPDF.isEnabled()) {
                    TimestampOptions.this.setCursor(new Cursor(12));
                }
            }

            @Override
            public void mouseExited(MouseEvent e) {
                TimestampOptions.this.setCursor(new Cursor(0));
            }

            @Override
            public void mouseClicked(MouseEvent e) {
                if (!TimestampOptions.this.lblAssinarPDF.isEnabled()) {
                    return;
                }
                TimestampOptions.this.setVisible(false);
                JFileChooser fileChooser = new JFileChooser();
                fileChooser.setAcceptAllFileFilterUsed(false);
                FileNameExtensionFilter filter = new FileNameExtensionFilter("Pdf", "pdf");
                fileChooser.addChoosableFileFilter(filter);
                int returnValue = fileChooser.showOpenDialog(TimestampOptions.this.getOwner());
                if (returnValue == 0) {
                    File selectedFile = fileChooser.getSelectedFile();
                    String fileName = selectedFile.getAbsolutePath();
                    try {
                        new NewPDFReader((Dialog)TimestampOptions.this, fileName, "RT", oldInterface);
                    }
                    catch (Exception e1) {
                        Main.hideLoadingScreen();
                        logger.error("PDF carimbo do Tempo " + e1.getMessage());
                        TimestampOptions.this.uiFunctions.errorMessage("Erro", e1.getMessage());
                        SignerDialog.showMessageDialog(TimestampOptions.this, "Erro", "Gera\u00e7\u00e3o de PDF Assinado com Carimbo do Tempo :" + e1.getMessage(), 0);
                    }
                }
                Main.hideLoadingScreen();
                TimestampOptions.this.dispose();
            }
        });
        panel1.add(this.lblAssinarPDF);
        this.lblAssinarXML = new JLabel();
        this.lblAssinarXML.setFont(new Font("Open Sans", 1, 12));
        this.lblAssinarXML.setHorizontalAlignment(0);
        this.lblAssinarXML.setToolTipText("Assinar um arquivo XML");
        this.lblAssinarXML.setBackground(new Color(255, 255, 255));
        this.lblAssinarXML.setOpaque(true);
        this.lblAssinarXML.setText("<html>Assinar <br>XML</html>");
        this.lblAssinarXML.setForeground(new Color(0, 90, 170));
        this.lblAssinarXML.setBorder(BorderFactory.createLineBorder(new Color(0, 255, 255), 1));
        this.lblAssinarXML.setMinimumSize(new Dimension(100, 80));
        this.lblAssinarXML.setPreferredSize(new Dimension(100, 80));
        this.lblAssinarXML.setMaximumSize(new Dimension(100, 80));
        this.lblAssinarXML.setIcon(new ImageIcon(this.getClass().getResource("/images/tools/btnXml.png")));
        this.lblAssinarXML.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent e) {
                if (TimestampOptions.this.lblAssinarXML.isEnabled()) {
                    TimestampOptions.this.setCursor(new Cursor(12));
                }
            }

            @Override
            public void mouseExited(MouseEvent e) {
                TimestampOptions.this.setCursor(new Cursor(0));
            }

            @Override
            public void mouseClicked(MouseEvent e) {
                if (!TimestampOptions.this.lblAssinarXML.isEnabled()) {
                    return;
                }
                Main.showLoadingScreen("");
                RequestSignXML requestSignXML = new RequestSignXML();
                requestSignXML.setType("file");
                requestSignXML.setOutputDataType("file");
                requestSignXML.setSignaturePolicy("RT");
                TimestampOptions.this.setVisible(false);
                Commons.SignXMLFiles(requestSignXML);
                Main.hideLoadingScreen();
                TimestampOptions.this.dispose();
            }
        });
        panel1.add(this.lblAssinarXML);
        this.lblAssinarArquivo = new JLabel();
        this.lblAssinarArquivo.setFont(new Font("Open Sans", 1, 12));
        this.lblAssinarArquivo.setHorizontalAlignment(0);
        this.lblAssinarArquivo.setToolTipText("Gerar uma assinatura Desanexada");
        this.lblAssinarArquivo.setBackground(new Color(255, 255, 255));
        this.lblAssinarArquivo.setOpaque(true);
        this.lblAssinarArquivo.setText("<html>Assinar <br> Arquivo</html>");
        this.lblAssinarArquivo.setForeground(new Color(0, 90, 170));
        this.lblAssinarArquivo.setBorder(BorderFactory.createLineBorder(new Color(0, 255, 255), 1));
        this.lblAssinarArquivo.setMinimumSize(new Dimension(100, 80));
        this.lblAssinarArquivo.setPreferredSize(new Dimension(100, 80));
        this.lblAssinarArquivo.setMaximumSize(new Dimension(100, 80));
        this.lblAssinarArquivo.setIcon(new ImageIcon(this.getClass().getResource("/images/tools/btnSign.png")));
        this.lblAssinarArquivo.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent e) {
                if (TimestampOptions.this.lblAssinarArquivo.isEnabled()) {
                    TimestampOptions.this.setCursor(new Cursor(12));
                }
            }

            @Override
            public void mouseExited(MouseEvent e) {
                TimestampOptions.this.setCursor(new Cursor(0));
            }

            @Override
            public void mouseClicked(MouseEvent e) {
                if (!TimestampOptions.this.lblAssinarArquivo.isEnabled()) {
                    return;
                }
                Main.showLoadingScreen("");
                SignRequest request = new SignRequest();
                request.setType("file");
                request.setOutputDataType("file");
                request.setSignaturePolicy("RT");
                TimestampOptions.this.setVisible(false);
                Commons.SignOrdinaryFiles(request);
                Main.hideLoadingScreen();
                TimestampOptions.this.dispose();
            }
        });
        panel1.add(this.lblAssinarArquivo);
        this.lblAssinarLote = new JLabel();
        this.lblAssinarLote.setFont(new Font("Open Sans", 1, 12));
        this.lblAssinarLote.setHorizontalAlignment(0);
        this.lblAssinarLote.setToolTipText("Assinar arquivos em lote");
        this.lblAssinarLote.setBackground(new Color(255, 255, 255));
        this.lblAssinarLote.setOpaque(true);
        this.lblAssinarLote.setText("<html> Assinar <br> em Lote</html>");
        this.lblAssinarLote.setForeground(new Color(0, 90, 170));
        this.lblAssinarLote.setBorder(BorderFactory.createLineBorder(new Color(0, 255, 255), 1));
        this.lblAssinarLote.setMinimumSize(new Dimension(100, 80));
        this.lblAssinarLote.setPreferredSize(new Dimension(100, 80));
        this.lblAssinarLote.setMaximumSize(new Dimension(100, 80));
        this.lblAssinarLote.setIcon(new ImageIcon(this.getClass().getResource("/images/tools/btnBatchSign.png")));
        this.lblAssinarLote.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent e) {
                if (TimestampOptions.this.lblAssinarLote.isEnabled()) {
                    TimestampOptions.this.setCursor(new Cursor(12));
                }
            }

            @Override
            public void mouseExited(MouseEvent e) {
                TimestampOptions.this.setCursor(new Cursor(0));
            }

            @Override
            public void mouseClicked(MouseEvent e) {
                if (!TimestampOptions.this.lblAssinarLote.isEnabled()) {
                    return;
                }
                try {
                    Main.showLoadingScreen("");
                    TimestampOptions.this.setVisible(false);
                    new BatchSignature("RT");
                    Main.hideLoadingScreen();
                }
                catch (Exception ex) {
                    Main.hideLoadingScreen();
                    logger.error("Assinaturas em lote com carimbo do Tempo: " + ex.getMessage());
                    SignerDialog.showMessageDialog(TimestampOptions.this, "Erro", "Gera\u00e7\u00e3o de Assinaturas em lote:" + ex.getMessage(), 0);
                }
                TimestampOptions.this.dispose();
            }
        });
        panel1.add(this.lblAssinarLote);
        this.getContentPane().setLayout(groupLayout);
        this.pack();
        if (this.getOwner() != null) {
            this.setLocationRelativeTo(this.getOwner());
        } else {
            this.setLocationRelativeTo(null);
        }
        this.atualizarTela();
    }

    public static boolean isOldInterface() {
        return oldInterface;
    }

    public static void setOldInterface(boolean oldInterface) {
        TimestampOptions.oldInterface = oldInterface;
    }

    @Override
    public void run() {
        logger.debug("TimestampOptions.run() chamado");
        if (this.getOwner() != null) {
            this.setModalityType(Dialog.ModalityType.APPLICATION_MODAL);
        } else {
            this.setModalityType(Dialog.ModalityType.MODELESS);
        }
        this.setVisible(true);
        MetodoCarimboAPI selectedMethod = ConfiguracoesVolateis.getMetodoCarimboSelecionado();
        logger.info("M\u00e9todo de carimbo selecionado ao final do di\u00e1logo: {}", (Object)selectedMethod);
        if (selectedMethod == MetodoCarimboAPI.NENHUM_SELECIONADO || selectedMethod == null) {
            logger.warn("Nenhum m\u00e9todo de carimbo efetivamente usado para uma a\u00e7\u00e3o, ou di\u00e1logo fechado pelo usu\u00e1rio (X/Fechar) antes de uma a\u00e7\u00e3o.");
            return;
        }
        logger.debug("TimestampOptions.run() conclu\u00eddo. A\u00e7\u00e3o de carimbo (se houver) foi iniciada pelo respectivo bot\u00e3o.");
    }
}

