/*
 * Decompiled with CFR 0.152.
 */
package org.demoiselle.signer.serpro.desktop.ui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.GridBagConstraints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.net.URL;
import javax.swing.AbstractAction;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.KeyStroke;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeCellRenderer;
import org.demoiselle.signer.policy.impl.cades.pkcs7.impl.CAdESTimeStampSigner;
import org.demoiselle.signer.serpro.desktop.Main;
import org.demoiselle.signer.serpro.desktop.statistics.Statistics;
import org.demoiselle.signer.serpro.desktop.ui.pdf.VerifyPDFTimeStamp;
import org.demoiselle.signer.serpro.desktop.utils.FileUtil;
import org.demoiselle.signer.serpro.desktop.utils.NetUtil;
import org.demoiselle.signer.timestamp.Timestamp;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TimeStampInfo
extends JDialog {
    private static final long serialVersionUID = 1L;
    private String contentFileName;
    private String timeStampFileName;
    private boolean isPDF = false;
    private Timestamp varTimestamp = null;
    private VerifyPDFTimeStamp PDFDoc;
    private DefaultMutableTreeNode titleChain;
    private static final Logger logger = LoggerFactory.getLogger(TimeStampInfo.class);

    public void init() {
        this.initUI();
        this.setVisible(true);
    }

    public TimeStampInfo(String contentFileName, String timeStampFileName) {
        this.setDefaultCloseOperation(2);
        this.setModalityType(Dialog.ModalityType.APPLICATION_MODAL);
        this.contentFileName = contentFileName;
        this.timeStampFileName = timeStampFileName;
    }

    public TimeStampInfo(VerifyPDFTimeStamp document) {
        this.PDFDoc = document;
        this.isPDF = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initUI() {
        JPanel pane;
        TimeStampInfo me;
        block12: {
            this.setTitle("Informa\u00e7\u00f5es do Carimbo do Tempo");
            this.setSize(700, 440);
            this.setLocationRelativeTo(null);
            this.getContentPane().setLayout(null);
            this.setResizable(false);
            this.setAlwaysOnTop(true);
            me = this;
            pane = (JPanel)this.getContentPane();
            byte[] varContent = null;
            byte[] varTimeStamp = null;
            CAdESTimeStampSigner varCAdESTimeStampSigner = new CAdESTimeStampSigner();
            try {
                if (!this.isPDF) {
                    Main.showLoadingScreen("");
                    varContent = FileUtil.readContent(this.contentFileName);
                    varTimeStamp = FileUtil.readContent(this.timeStampFileName);
                    this.validateTimeStamp(varContent, varTimeStamp, varCAdESTimeStampSigner);
                    Main.hideLoadingScreen();
                    if (this.getVarTimestamp() == null) {
                        Main.hideLoadingScreen();
                        throw new Exception("Falha ao validar Carimbo do Tempo! <br> O arquivo n\u00e3o corresponde ao carimbo ou foi modificado ap\u00f3s ser carimbado!");
                    }
                    break block12;
                }
                try {
                    Main.showLoadingScreen("");
                    this.setVarTimestamp(this.PDFDoc.verifyTimeStamp());
                    Main.hideLoadingScreen();
                }
                catch (Exception error) {
                    Main.hideLoadingScreen();
                    logger.error(error.getMessage());
                }
                finally {
                    if (this.getVarTimestamp() == null) {
                        Main.hideLoadingScreen();
                        throw new Exception("Falha ao validar Carimbo do Tempo no PDF! <br> O arquivo pode ter sido modificado ap\u00f3s ser carimbado!<br> Ou n\u00e3o possui um Carimbo do tempo");
                    }
                }
            }
            catch (Exception e) {
                Main.hideLoadingScreen();
                logger.error(e.getMessage());
                URL urlCheck = this.getClass().getClassLoader().getResource("images/invalid.png");
                ImageIcon iconCheck = new ImageIcon(urlCheck);
                JLabel check = new JLabel(iconCheck);
                JLabel status = new JLabel("<html><span style='font-size:18px;font-weight: bold; color:#ff0000'> Carimbo do Tempo inv\u00e1lido</span></html>");
                StringBuilder sbTxtInfo = new StringBuilder();
                sbTxtInfo.append("<html><span style='font-size:12px;font-weight: bold; color:#000000'>");
                sbTxtInfo.append(e.getMessage());
                sbTxtInfo.append("</span></html>");
                JLabel info = new JLabel(sbTxtInfo.toString());
                pane.add(status);
                pane.add(check);
                pane.add(info);
                status.setBounds(100, 10, 500, 45);
                info.setBounds(100, 55, 500, 55);
                check.setBounds(20, 10, 50, 55);
                JButton btnOk = new JButton();
                btnOk.setIcon(new ImageIcon(this.getClass().getResource("/images/btnFechar.png")));
                btnOk.setToolTipText("Clique para fechar essa janela");
                btnOk.setContentAreaFilled(false);
                btnOk.setBorderPainted(false);
                btnOk.setOpaque(false);
                btnOk.setBounds(100, 120, 150, 40);
                btnOk.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        TimeStampInfo.this.dispose();
                    }
                });
                btnOk.addMouseListener(new MouseAdapter(){

                    @Override
                    public void mouseEntered(MouseEvent e) {
                        TimeStampInfo.this.setCursor(new Cursor(12));
                    }

                    @Override
                    public void mouseExited(MouseEvent e) {
                        TimeStampInfo.this.setCursor(new Cursor(0));
                    }
                });
                pane.add(btnOk);
                this.setSize(600, 220);
                this.setModal(true);
                return;
            }
        }
        GridBagConstraints cIcon = new GridBagConstraints();
        cIcon.weightx = 0.0;
        cIcon.gridx = 0;
        cIcon.anchor = 21;
        GridBagConstraints cText = new GridBagConstraints();
        cText.weightx = 1.0;
        cText.gridx = 1;
        cText.anchor = 21;
        DefaultMutableTreeNode certTree = null;
        StringBuilder sbText = new StringBuilder();
        sbText.append("<html><span style='font-size:11px;font-weight: normal;'> Carimbo do Tempo Confere");
        sbText.append("</span></html>");
        certTree = new DefaultMutableTreeNode(new Nodes(sbText.toString(), "images/timestamp1.png"));
        sbText = new StringBuilder();
        sbText.append("<html><span style='font-size:11px;font-weight: normal;'>");
        sbText.append("Emitido em :");
        sbText.append(this.getVarTimestamp().getTimeStamp());
        sbText.append("</span></html>");
        certTree.add(new DefaultMutableTreeNode(new Nodes(sbText.toString(), "images/Actions-dialog-ok-icon.png")));
        sbText = new StringBuilder();
        sbText.append("<html><span style='font-size:11px;font-weight: normal;'>");
        sbText.append("Pela autoridade:");
        sbText.append(this.getVarTimestamp().getTimeStampAuthorityInfo());
        sbText.append("</span></html>");
        certTree.add(new DefaultMutableTreeNode(new Nodes(sbText.toString(), "images/Actions-dialog-ok-icon.png")));
        sbText = new StringBuilder();
        sbText.append("<html><span style='font-size:11px;font-weight: normal;'>");
        sbText.append("N\u00famero de s\u00e9rie:");
        sbText.append(this.getVarTimestamp().getSerialNumber());
        sbText.append("</span></html>");
        certTree.add(new DefaultMutableTreeNode(new Nodes(sbText.toString(), "images/Actions-dialog-ok-icon.png")));
        JTree tree = new JTree(certTree);
        tree.setCellRenderer(new NodeTreeCellRenderer());
        tree.setLargeModel(true);
        tree.setBounds(15, 60, 670, 220);
        JScrollPane scroll = new JScrollPane(tree);
        scroll.setBounds(15, 60, 670, 220);
        pane.add(scroll);
        JLabel status = new JLabel("<html><span style='font-size:14px;font-weight: bold; color:#008000ff'> Resultado da valida\u00e7\u00e3o do Carimbo do Tempo </span></html>");
        JButton btnClose = new JButton("Fechar");
        btnClose.setBackground(Color.LIGHT_GRAY);
        status.setBounds(15, 60, 670, 20);
        pane.setBackground(new Color(0xFFFFFF));
        btnClose.setFocusPainted(false);
        btnClose.setContentAreaFilled(false);
        pane.add(status);
        pane.add(btnClose);
        btnClose.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                me.dispose();
            }
        });
        ImageIcon iconProdSerpro = null;
        try {
            iconProdSerpro = new ImageIcon(this.getClass().getClassLoader().getResource("images/solucoesCidadao.gif"));
        }
        catch (Exception error) {
            sbText = new StringBuilder();
            sbText.append("N\u00e3o carregou o gif de solu\u00e7\u00f5es para cidad\u00e3o");
            sbText.append(error.getMessage());
            logger.error(sbText.toString());
        }
        final JLabel lblProdSerpro = new JLabel(iconProdSerpro);
        lblProdSerpro.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent e) {
                lblProdSerpro.setCursor(new Cursor(12));
            }

            @Override
            public void mouseExited(MouseEvent e) {
                lblProdSerpro.setCursor(new Cursor(0));
            }

            @Override
            public void mouseClicked(MouseEvent e) {
                NetUtil.openLink("http://www.serpro.gov.br/menu/nosso-portfolio/por-publico/para-cidadao?source=assinador-serpro");
            }
        });
        lblProdSerpro.setBounds(15, 280, 300, 120);
        lblProdSerpro.setHorizontalAlignment(0);
        pane.add(lblProdSerpro);
        AbstractAction escapeAction = new AbstractAction(){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent e) {
                TimeStampInfo.this.dispose();
            }
        };
        this.getRootPane().getInputMap(2).put(KeyStroke.getKeyStroke(27, 0), "ESCAPE_KEY");
        this.getRootPane().getActionMap().put("ESCAPE_KEY", escapeAction);
        status.setBounds(100, 10, 480, 55);
        btnClose.setBounds(this.getWidth() - 120, 350, 100, 30);
        this.setModal(true);
    }

    public void validateTimeStamp(byte[] parmContent, byte[] parmTimeStamp, CAdESTimeStampSigner parmCAdESTimeStampSigner) {
        try {
            Statistics instaSta = new Statistics();
            long start = System.currentTimeMillis();
            instaSta.setStart(start);
            instaSta.setAction("verify-time-stamp");
            instaSta.setLengthOriginalContent(parmContent != null ? (long)parmContent.length : 0L);
            instaSta.setLengthSignature(parmTimeStamp != null ? (long)parmTimeStamp.length : 0L);
            this.setVarTimestamp(parmCAdESTimeStampSigner.checkTimeStampWithContent(parmTimeStamp, parmContent));
            long end = System.currentTimeMillis();
            instaSta.setEnd(end);
            Thread trTimeStamp = new Thread(instaSta);
            trTimeStamp.start();
        }
        catch (Exception error) {
            StringBuilder msg = new StringBuilder();
            msg.append("Erro ao checar assinatura: \n");
            msg.append(error.getMessage());
            logger.error(msg.toString());
        }
    }

    public String getContentFileName() {
        return this.contentFileName;
    }

    public void setContentFileName(String contentFileName) {
        this.contentFileName = contentFileName;
    }

    public boolean isPDF() {
        return this.isPDF;
    }

    public void setPDF(boolean isPDF) {
        this.isPDF = isPDF;
    }

    public String getTimeStampFileName() {
        return this.timeStampFileName;
    }

    public void setTimeStampFileName(String timeStampFileName) {
        this.timeStampFileName = timeStampFileName;
    }

    public Timestamp getVarTimestamp() {
        return this.varTimestamp;
    }

    public void setVarTimestamp(Timestamp varTimestamp) {
        this.varTimestamp = varTimestamp;
    }

    public VerifyPDFTimeStamp getPDFDoc() {
        return this.PDFDoc;
    }

    public void setPDFDoc(VerifyPDFTimeStamp pDFDoc) {
        this.PDFDoc = pDFDoc;
    }

    public DefaultMutableTreeNode getTitleChain() {
        return this.titleChain;
    }

    public void setTitleChain(DefaultMutableTreeNode titleChain) {
        this.titleChain = titleChain;
    }

    class Nodes {
        private String name;
        private String nodeIcon;

        Nodes(String name, String nodeIcon) {
            this.name = name;
            this.nodeIcon = nodeIcon;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getNodeIcon() {
            return this.nodeIcon;
        }

        public void setNodeIcon(String nodeIcon) {
            this.nodeIcon = nodeIcon;
        }
    }

    class NodeTreeCellRenderer
    implements TreeCellRenderer {
        private JLabel label = new JLabel();

        NodeTreeCellRenderer() {
        }

        @Override
        public Component getTreeCellRendererComponent(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            Object o = ((DefaultMutableTreeNode)value).getUserObject();
            if (o instanceof Nodes) {
                Nodes node = (Nodes)o;
                URL imageUrl = this.getClass().getClassLoader().getResource(node.getNodeIcon());
                if (imageUrl != null) {
                    this.label.setIcon(new ImageIcon(imageUrl));
                }
                this.label.setText(node.getName());
            } else {
                this.label.setIcon(null);
                this.label.setText("" + value);
            }
            return this.label;
        }
    }
}

