/*
 * Decompiled with CFR 0.152.
 */
package org.demoiselle.signer.serpro.desktop.ui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.GridBagConstraints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.IOException;
import java.net.URL;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.text.SimpleDateFormat;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import java.util.StringTokenizer;
import javax.swing.AbstractAction;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.KeyStroke;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeCellRenderer;
import org.demoiselle.signer.core.extension.BasicCertificate;
import org.demoiselle.signer.policy.impl.cades.SignatureInformations;
import org.demoiselle.signer.policy.impl.cades.SignerAlgorithmEnum;
import org.demoiselle.signer.policy.impl.cades.pkcs7.impl.CAdESChecker;
import org.demoiselle.signer.serpro.desktop.Main;
import org.demoiselle.signer.serpro.desktop.statistics.Statistics;
import org.demoiselle.signer.serpro.desktop.ui.pdf.VerifyPDFSignature;
import org.demoiselle.signer.serpro.desktop.utils.FileUtil;
import org.demoiselle.signer.serpro.desktop.utils.NetUtil;
import org.demoiselle.signer.timestamp.Timestamp;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SignatureInfo
extends JDialog {
    private static final long serialVersionUID = 1L;
    private String contentFileName = ".";
    private String signatureFileName;
    private boolean isPDF = false;
    private boolean isAttached = false;
    private VerifyPDFSignature PDFDoc;
    private DefaultMutableTreeNode titleChain;
    private static final Logger logger = LoggerFactory.getLogger(SignatureInfo.class);

    public void init() throws CertificateException, IOException {
        this.initUI();
        this.setVisible(true);
    }

    public SignatureInfo(String contentFileName, String signatureFileName) {
        this.setDefaultCloseOperation(2);
        this.setModalityType(Dialog.ModalityType.APPLICATION_MODAL);
        this.contentFileName = contentFileName;
        this.signatureFileName = signatureFileName;
    }

    public SignatureInfo(VerifyPDFSignature document) {
        this.PDFDoc = document;
        this.isPDF = true;
    }

    public SignatureInfo(String signatureFileName) {
        this.signatureFileName = signatureFileName;
        this.isAttached = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initUI() throws CertificateException, IOException {
        List<SignatureInformations> allValues;
        JPanel pane;
        SignatureInfo me;
        block59: {
            this.setTitle("Informa\u00e7\u00f5es da Assinatura");
            this.setSize(700, 440);
            this.setLocationRelativeTo(null);
            this.getContentPane().setLayout(null);
            this.setResizable(false);
            this.setAlwaysOnTop(true);
            me = this;
            pane = (JPanel)this.getContentPane();
            byte[] content = null;
            byte[] signature = null;
            CAdESChecker checker = new CAdESChecker();
            allValues = null;
            try {
                if (!this.isPDF) {
                    if (this.isAttached) {
                        Main.showLoadingScreen("");
                        signature = FileUtil.readContent(this.signatureFileName);
                        this.validateSignature(signature, checker);
                        allValues = this.getCertData(checker);
                        Main.hideLoadingScreen();
                    } else {
                        Main.showLoadingScreen("");
                        content = FileUtil.readContent(this.contentFileName);
                        signature = FileUtil.readContent(this.signatureFileName);
                        this.validateSignature(content, signature, checker);
                        allValues = this.getCertData(checker);
                        Main.hideLoadingScreen();
                    }
                    break block59;
                }
                try {
                    Main.showLoadingScreen("");
                    allValues = this.PDFDoc.verifySignature();
                    this.contentFileName = this.PDFDoc.getFileName();
                    Main.hideLoadingScreen();
                }
                catch (Throwable error) {
                    Main.hideLoadingScreen();
                    logger.error(error.getMessage());
                }
                finally {
                    if (allValues == null || allValues.isEmpty()) {
                        Main.hideLoadingScreen();
                        throw new Exception("Falha ao validar assinaturas PADeS!");
                    }
                }
            }
            catch (Exception e) {
                Main.hideLoadingScreen();
                logger.error(e.getMessage());
                URL urlCheck = this.getClass().getClassLoader().getResource("images/invalid.png");
                ImageIcon iconCheck = new ImageIcon(urlCheck);
                JLabel check = new JLabel(iconCheck);
                JLabel status = new JLabel("<html><span style='font-size:18px;font-weight: bold; color:#ff0000'> Assinatura digital inv\u00e1lida</span></html>");
                StringBuilder sbTxtInfo = new StringBuilder();
                sbTxtInfo.append("<html><span style='font-size:12px;font-weight: bold; color:#000000'>");
                sbTxtInfo.append(e.getMessage());
                sbTxtInfo.append("</span></html>");
                JLabel info = new JLabel(sbTxtInfo.toString());
                pane.add(status);
                pane.add(check);
                pane.add(info);
                status.setBounds(100, 10, 500, 45);
                info.setBounds(100, 55, 500, 55);
                check.setBounds(20, 10, 50, 55);
                JButton btnOk = new JButton();
                btnOk.setIcon(new ImageIcon(this.getClass().getResource("/images/btnFechar.png")));
                btnOk.setToolTipText("Clique para fechar essa janela");
                btnOk.setBorderPainted(false);
                btnOk.setContentAreaFilled(false);
                btnOk.setOpaque(false);
                btnOk.setBounds(100, 120, 150, 40);
                btnOk.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        SignatureInfo.this.dispose();
                    }
                });
                btnOk.addMouseListener(new MouseAdapter(){

                    @Override
                    public void mouseEntered(MouseEvent e) {
                        SignatureInfo.this.setCursor(new Cursor(12));
                    }

                    @Override
                    public void mouseExited(MouseEvent e) {
                        SignatureInfo.this.setCursor(new Cursor(0));
                    }
                });
                pane.add(btnOk);
                this.setSize(600, 220);
                this.setModal(true);
                return;
            }
        }
        Main.showLoadingScreen("");
        GridBagConstraints cIcon = new GridBagConstraints();
        cIcon.weightx = 0.0;
        cIcon.gridx = 0;
        cIcon.anchor = 21;
        GridBagConstraints cText = new GridBagConstraints();
        cText.weightx = 1.0;
        cText.gridx = 1;
        cText.anchor = 21;
        Collections.sort(allValues, new Comparator<SignatureInformations>(){

            @Override
            public int compare(SignatureInformations m1, SignatureInformations m2) {
                if (m1 == null || m1.getSignDate() == null) {
                    return 0;
                }
                if (m2 == null || m2.getSignDate() == null) {
                    return 0;
                }
                return m1.getSignDate().compareTo(m2.getSignDate());
            }
        });
        String textSig = "<html><span style='font-size:12px;color:blue;font-weight:bold'>" + this.contentFileName + "</span></html>";
        DefaultMutableTreeNode top = new DefaultMutableTreeNode(textSig);
        boolean isNeoSigner = false;
        boolean isITI = false;
        for (SignatureInformations signatureObject : allValues) {
            DefaultMutableTreeNode textMP220;
            DefaultMutableTreeNode textError;
            Nodes node;
            StringBuilder sbText;
            Nodes node2;
            Object text;
            boolean first = true;
            boolean firstChain = true;
            DefaultMutableTreeNode certTree = null;
            LinkedList<String> validatorErros = signatureObject.getValidatorErrors();
            LinkedList<String> validatorWarings = signatureObject.getValidatorWarnins();
            if (signatureObject.getChain() != null && !signatureObject.getChain().isEmpty()) {
                isNeoSigner = signatureObject.getChain().getLast().getSubjectDN().getName().toLowerCase().contains("serpro");
                isITI = signatureObject.getChain().getLast().getSubjectDN().getName().toLowerCase().contains("raiz do governo federal");
                for (X509Certificate cert : signatureObject.getChain()) {
                    DefaultMutableTreeNode textChain;
                    Nodes node3;
                    BasicCertificate bc = new BasicCertificate(cert);
                    if (first) {
                        StringBuilder sbText2 = new StringBuilder();
                        if (validatorErros.isEmpty() && validatorWarings.isEmpty() || isNeoSigner) {
                            sbText2.append("<html><span style='font-size:11px;font-weight:bold;'>");
                            if (bc.hasCertificatePJ()) {
                                sbText2.append(bc.getName() + " (" + bc.getICPBRCertificatePJ().getResponsibleName() + ")");
                            } else if (bc.hasCertificateEquipment()) {
                                sbText2.append(bc.getName() + " (" + bc.getICPBRCertificateEquipment().getResponsibleName() + ")");
                            } else {
                                sbText2.append(bc.getName());
                            }
                            sbText2.append("</span><span style='font-size:11px;color:white;'>________________________________________________________________________</span></html>");
                        } else if (validatorErros.isEmpty() && !validatorWarings.isEmpty() && !isNeoSigner && !isITI) {
                            sbText2.append("<html><span style='font-size:11px;font-weight: bold; color:gray;'>");
                            if (bc.hasCertificatePJ()) {
                                sbText2.append(bc.getName() + " (" + bc.getICPBRCertificatePJ().getResponsibleName() + "){!}");
                            } else if (bc.hasCertificateEquipment()) {
                                sbText2.append(bc.getName() + " (" + bc.getICPBRCertificateEquipment().getResponsibleName() + "){!}");
                            } else {
                                sbText2.append(bc.getName() + "(!)");
                            }
                            sbText2.append("</span><span style='font-size:11px;color:white;'>________________________________________________________________________</span></html>");
                        } else if (signatureObject.isInvalidSignature()) {
                            sbText2.append("<html><span style='font-size:11px;font-weight: bold; color:red;'>");
                            if (bc.hasCertificatePJ()) {
                                sbText2.append(bc.getName() + " (" + bc.getICPBRCertificatePJ().getResponsibleName() + "){Inv\u00e1lida}");
                            } else if (bc.hasCertificateEquipment()) {
                                sbText2.append(bc.getName() + " (" + bc.getICPBRCertificateEquipment().getResponsibleName() + "){Inv\u00e1lida}");
                            } else {
                                sbText2.append(bc.getName() + "(Inv\u00e1lida)");
                            }
                            sbText2.append("</span><span style='font-size:11px;color:white;'>________________________________________________________________________</span></html>");
                        } else {
                            sbText2.append("<html><span style='font-size:11px;font-weight: bold; color:orange;'>");
                            if (bc.hasCertificatePJ()) {
                                sbText2.append(bc.getName() + " (" + bc.getICPBRCertificatePJ().getResponsibleName() + "){!!}");
                            } else if (bc.hasCertificateEquipment()) {
                                sbText2.append(bc.getName() + " (" + bc.getICPBRCertificateEquipment().getResponsibleName() + "){!!}");
                            } else {
                                sbText2.append(bc.getName() + "(!!)");
                            }
                            sbText2.append("</span><span style='font-size:11px;color:white;'>________________________________________________________________________</span></html>");
                        }
                        node3 = new Nodes(sbText2.toString(), "images/icon-signer-blue-22x22.png");
                        certTree = new DefaultMutableTreeNode(node3);
                        if (signatureObject.getSignDate() != null) {
                            String signData = new SimpleDateFormat("dd/MM/yyyy '\u00e0s' HH:mm").format(signatureObject.getSignDate());
                            sbText2 = new StringBuilder();
                            sbText2.append("<html><span style='font-size:11px; font-style:italic; font-weight:normal;'>Data da gera\u00e7\u00e3o: ");
                            sbText2.append(signData);
                            sbText2.append(" (Hor\u00e1rio oficial de Bras\u00edlia)</span></html>");
                            DefaultMutableTreeNode textDate = new DefaultMutableTreeNode(sbText2);
                            certTree.add(textDate);
                        }
                        if (signatureObject.getSignaturePolicy() != null) {
                            String policy = signatureObject.getSignaturePolicy().getSignPolicyURI();
                            StringTokenizer st = new StringTokenizer(policy);
                            String part = st.nextToken("/");
                            part = st.nextToken("/");
                            part = st.nextToken("/");
                            sbText2 = new StringBuilder();
                            sbText2.append("<html><span style='font-size:11px;font-weight: normal;'> Pol\u00edtica da Assinatura: ");
                            sbText2.append(part);
                            sbText2.append("</span></html>");
                            DefaultMutableTreeNode textDate = new DefaultMutableTreeNode(sbText2);
                            certTree.add(textDate);
                        }
                        first = false;
                        continue;
                    }
                    StringBuilder sbText3 = new StringBuilder();
                    if (firstChain) {
                        String text2 = "<html><span style='font-size:11px;font-weight:normal;'>Cadeia do Certificado:</span></html>";
                        node3 = new Nodes(text2, "images/certificate.png");
                        this.titleChain = new DefaultMutableTreeNode(node3);
                        certTree.add(this.titleChain);
                        sbText3.append("<html><span style='font-size:11px;font-weight:normal;'>");
                        sbText3.append(bc.getName());
                        sbText3.append("</span></html>");
                        node3 = new Nodes(sbText3.toString(), "images/certificate.png");
                        textChain = new DefaultMutableTreeNode(node3);
                        this.titleChain.add(textChain);
                        firstChain = false;
                        continue;
                    }
                    sbText3.append("<html><span style='font-size:11px;font-weight:normal;'>");
                    sbText3.append(bc.getName());
                    sbText3.append("</span></html>");
                    node3 = new Nodes(sbText3.toString(), "images/certificate.png");
                    textChain = new DefaultMutableTreeNode(node3);
                    this.titleChain.add(textChain);
                }
                Timestamp varTimeStamp = signatureObject.getTimeStampSigner();
                if (varTimeStamp != null) {
                    StringBuilder sbText4 = new StringBuilder();
                    sbText4.append("<html><span style='font-size:11px;font-weight: normal;'> Carimbo do Tempo[Data com validade jur\u00eddica]  emitido em:");
                    sbText4.append(varTimeStamp.getTimeStamp());
                    sbText4.append(", Pela autoridade:");
                    sbText4.append(varTimeStamp.getTimeStampAuthorityInfo());
                    sbText4.append(") N\u00famero de s\u00e9rie:");
                    sbText4.append(varTimeStamp.getSerialNumber());
                    sbText4.append(")</span></html>");
                    Nodes node4 = new Nodes(sbText4.toString(), "images/timestamp1.png");
                    DefaultMutableTreeNode textTimeStamp = new DefaultMutableTreeNode(node4);
                    certTree.add(textTimeStamp);
                }
            }
            if (validatorWarings.isEmpty() && validatorErros.isEmpty()) {
                text = "<html><span style='font-size:11px;font-weight: normal;'>Assinatura Eletr\u00f4nica v\u00e1lida</span></html>";
                node2 = new Nodes((String)text, "images/icpbrasil_small.png");
                DefaultMutableTreeNode textICPOK = new DefaultMutableTreeNode(node2);
                certTree.add(textICPOK);
            } else if (signatureObject.isInvalidSignature()) {
                for (String valError : validatorErros) {
                    sbText = new StringBuilder();
                    sbText.append("<html><span style='font-size:10px;font-weight: normal color:#ff0000;'>Assinatura Inv\u00e1lida, apresentou o seguintes erros: </br>");
                    sbText.append(valError);
                    sbText.append(")</span></html>");
                    node = new Nodes(sbText.toString(), "images/warn2.png");
                    textError = new DefaultMutableTreeNode(node);
                    if (certTree == null) {
                        certTree = new DefaultMutableTreeNode(node);
                        continue;
                    }
                    certTree.add(textError);
                }
                text = "<html><span style='font-size:11px;font-weight: normal; color:#ff0000'>Assinatura inv\u00e1lida!</span></html>";
                node2 = new Nodes((String)text, "images/Actions-help-about-icon.png");
                textMP220 = new DefaultMutableTreeNode(node2);
                certTree.add(textMP220);
            } else if (!validatorWarings.isEmpty() && validatorErros.isEmpty() && !isNeoSigner && !isITI) {
                for (String valWarn : validatorWarings) {
                    logger.info("Assinatura confere com o documento, por\u00e9m apresenta a seguinte inconformidade com o DOC-IPC-15:" + valWarn);
                    if (!valWarn.contains("fora da data de validade")) continue;
                    sbText = new StringBuilder();
                    sbText.append("<html><span style='font-size:10px;font-weight: normal;'>Assinatura confere com o documento, por\u00e9m apresenta a seguinte inconformidade com o DOC-IPC-15: </br>");
                    sbText.append(valWarn);
                    sbText.append(")</span></html>");
                    node = new Nodes(sbText.toString(), "images/warn2.png");
                    textError = new DefaultMutableTreeNode(node);
                    if (certTree == null) {
                        certTree = new DefaultMutableTreeNode(node);
                        continue;
                    }
                    certTree.add(textError);
                }
                text = "<html><span style='font-size:11px;font-weight: normal;'>Assinatura digital em conformidade com a MP 2.200-2/2001</span></html>";
                node2 = new Nodes((String)text, "images/Actions-help-about-icon.png");
                textMP220 = new DefaultMutableTreeNode(node2);
                certTree.add(textMP220);
            } else if (!(validatorErros.isEmpty() || isNeoSigner || isITI)) {
                for (String valError : validatorErros) {
                    sbText = new StringBuilder();
                    sbText.append("<html><span style='font-size:10px;font-weight: normal color:#ff0000;'>Assinatura confere com o documento, por\u00e9m apresenta a seguinte inconformidade com a MP 2.200-2/2001: </br>");
                    sbText.append(valError);
                    sbText.append(")</span></html>");
                    node = new Nodes(sbText.toString(), "images/warn2.png");
                    textError = new DefaultMutableTreeNode(node);
                    if (certTree == null) {
                        certTree = new DefaultMutableTreeNode(node);
                        continue;
                    }
                    certTree.add(textError);
                }
                text = "<html><span style='font-size:11px;font-weight: normal; color:#ff0000'>Assinatura n\u00e3o p\u00f4de ser validada completamente</span></html>";
                node2 = new Nodes((String)text, "images/Actions-help-about-icon.png");
                textMP220 = new DefaultMutableTreeNode(node2);
                certTree.add(textMP220);
            } else {
                if (isNeoSigner) {
                    text = "<html><span style='font-size:11px;font-weight: normal;'>Assinatura Eletr\u00f4nica v\u00e1lida</span></html>";
                    node2 = new Nodes((String)text, "images/icone-neosigner.png");
                    textMP220 = new DefaultMutableTreeNode(node2);
                    certTree.add(textMP220);
                }
                if (isITI) {
                    text = "<html><span style='font-size:11px;font-weight: normal;'>Assinatura Eletr\u00f4nica v\u00e1lida</span></html>";
                    node2 = new Nodes((String)text, "images/gov_br.jpeg");
                    textMP220 = new DefaultMutableTreeNode(node2);
                    certTree.add(textMP220);
                }
            }
            top.add(certTree);
        }
        JTree tree = new JTree(top);
        tree.setCellRenderer(new NodeTreeCellRenderer());
        tree.setLargeModel(true);
        tree.setBounds(15, 60, 670, 220);
        JScrollPane scroll = new JScrollPane(tree);
        scroll.setBounds(15, 60, 670, 220);
        pane.add(scroll);
        JLabel status = new JLabel("<html><span style='font-size:14px;font-weight: bold; color:#008000ff'> Resultado da valida\u00e7\u00e3o da(s) assinatura(s) </span></html>");
        JButton btnClose = new JButton();
        btnClose.setIcon(new ImageIcon(this.getClass().getResource("/images/btnFechar.png")));
        btnClose.setToolTipText("Clique para fechar essa janela");
        status.setBounds(15, 60, 670, 20);
        pane.setBackground(new Color(0xFFFFFF));
        btnClose.setFocusPainted(false);
        btnClose.setContentAreaFilled(false);
        btnClose.setOpaque(false);
        pane.add(status);
        pane.add(btnClose);
        btnClose.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                me.dispose();
            }
        });
        btnClose.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent e) {
                SignatureInfo.this.setCursor(new Cursor(12));
            }

            @Override
            public void mouseExited(MouseEvent e) {
                SignatureInfo.this.setCursor(new Cursor(0));
            }
        });
        ImageIcon iconProdSerpro = null;
        try {
            iconProdSerpro = new ImageIcon(this.getClass().getClassLoader().getResource("images/solucoesCidadao.gif"));
        }
        catch (Throwable error) {
            StringBuilder sbText = new StringBuilder();
            sbText.append("N\u00e3o carregou o gif de solu\u00e7\u00f5es para cidad\u00e3o");
            sbText.append(error.getMessage());
            logger.error(sbText.toString());
        }
        final JLabel lblProdSerpro = new JLabel(iconProdSerpro);
        lblProdSerpro.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent e) {
                lblProdSerpro.setCursor(new Cursor(12));
            }

            @Override
            public void mouseExited(MouseEvent e) {
                lblProdSerpro.setCursor(new Cursor(0));
            }

            @Override
            public void mouseClicked(MouseEvent e) {
                NetUtil.openLink("http://www.serpro.gov.br/menu/nosso-portfolio/por-publico/para-cidadao?source=assinador-serpro");
            }
        });
        lblProdSerpro.setBounds(15, 280, 300, 120);
        lblProdSerpro.setHorizontalAlignment(0);
        pane.add(lblProdSerpro);
        AbstractAction escapeAction = new AbstractAction(){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent e) {
                SignatureInfo.this.dispose();
            }
        };
        this.getRootPane().getInputMap(2).put(KeyStroke.getKeyStroke(27, 0), "ESCAPE_KEY");
        this.getRootPane().getActionMap().put("ESCAPE_KEY", escapeAction);
        status.setBounds(100, 10, 480, 55);
        btnClose.setBounds(this.getWidth() - 120, 350, 100, 30);
        this.setModal(true);
        Main.hideLoadingScreen();
    }

    public void validateSignature(byte[] content, byte[] signed, CAdESChecker checker) {
        long start = System.currentTimeMillis();
        List<SignatureInformations> result = checker.checkDetachedSignature(content, signed);
        long end = System.currentTimeMillis();
        Statistics instaSta = new Statistics();
        try {
            for (SignatureInformations info : result) {
                instaSta.setAction("verify");
                instaSta.setLengthOriginalContent(content != null ? (long)content.length : 0L);
                instaSta.setLengthSignature(signed != null ? (long)signed.length : 0L);
                if (info.getSignaturePolicy() != null) {
                    String policy = info.getSignaturePolicy().getSignPolicyURI();
                    StringTokenizer st = new StringTokenizer(policy);
                    String part = st.nextToken("/");
                    part = st.nextToken("/");
                    part = st.nextToken("/");
                    instaSta.setSignaturePolicy(part);
                    instaSta.setAlgorithm(SignerAlgorithmEnum.getSignerOIDAlgorithmHashEnum(info.getSignaturePolicy().getSignPolicyHashAlg().getAlgorithm().getValue()).name());
                }
                instaSta.setCaURL(info.getIcpBrasilcertificate().getAuthorityInfoAccess().iterator().next());
                instaSta.setStart(start);
                instaSta.setEnd(end);
                Thread trSigInf1 = new Thread(instaSta);
                trSigInf1.start();
            }
        }
        catch (Throwable error) {
            StringBuilder msg = new StringBuilder();
            msg.append("Erro ao checar assinatura: \n");
            msg.append(error.getMessage());
            logger.error(msg.toString());
        }
    }

    public void validateSignature(byte[] signature, CAdESChecker checker) {
        long start = System.currentTimeMillis();
        List<SignatureInformations> result = checker.checkAttachedSignature(signature);
        long end = System.currentTimeMillis();
        Statistics instaSta = new Statistics();
        try {
            for (SignatureInformations info : result) {
                instaSta.setAction("verify");
                instaSta.setLengthOriginalContent(0L);
                instaSta.setLengthSignature(signature != null ? (long)signature.length : 0L);
                instaSta.setSignaturePolicy(info.getSignaturePolicy().getSignPolicyInfo().getSignPolicyIdentifier().getValue());
                instaSta.setCaURL(info.getIcpBrasilcertificate().getAuthorityInfoAccess().iterator().next());
                instaSta.setStart(start);
                instaSta.setEnd(end);
                Thread trSigInf2 = new Thread(instaSta);
                trSigInf2.start();
            }
        }
        catch (Throwable error) {
            StringBuilder msg = new StringBuilder();
            msg.append("Erro ao checar assinatura: \n");
            msg.append(error.getMessage());
            logger.error(msg.toString());
        }
    }

    public <T> List<SignatureInformations> getCertData(CAdESChecker checker) {
        return checker.getSignaturesInfo();
    }

    public String getContentFileName() {
        return this.contentFileName;
    }

    public void setContentFileName(String contentFileName) {
        this.contentFileName = contentFileName;
    }

    public String getSignatureFileName() {
        return this.signatureFileName;
    }

    public void setSignatureFileName(String signatureFileName) {
        this.signatureFileName = signatureFileName;
    }

    public boolean isPDF() {
        return this.isPDF;
    }

    public void setPDF(boolean isPDF) {
        this.isPDF = isPDF;
    }

    public boolean isAttached() {
        return this.isAttached;
    }

    public void setAttached(boolean isAttached) {
        this.isAttached = isAttached;
    }

    class Nodes {
        private String name;
        private String nodeIcon;

        Nodes(String name, String nodeIcon) {
            this.name = name;
            this.nodeIcon = nodeIcon;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getNodeIcon() {
            return this.nodeIcon;
        }

        public void setNodeIcon(String nodeIcon) {
            this.nodeIcon = nodeIcon;
        }
    }

    class NodeTreeCellRenderer
    implements TreeCellRenderer {
        private JLabel label = new JLabel();

        NodeTreeCellRenderer() {
        }

        @Override
        public Component getTreeCellRendererComponent(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            Object o = ((DefaultMutableTreeNode)value).getUserObject();
            if (o instanceof Nodes) {
                Nodes node = (Nodes)o;
                URL imageUrl = this.getClass().getClassLoader().getResource(node.getNodeIcon());
                if (imageUrl != null) {
                    this.label.setIcon(new ImageIcon(imageUrl));
                }
                this.label.setText(node.getName());
            } else {
                this.label.setIcon(null);
                this.label.setText("" + value);
            }
            return this.label;
        }
    }
}

