/*
 * Decompiled with CFR 0.152.
 */
package org.demoiselle.signer.serpro.desktop.ui;

import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.InputStream;
import javax.imageio.ImageIO;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProgressBar
extends JDialog
implements Runnable {
    private static final long serialVersionUID = -851969049439257531L;
    private static final Logger logger = LoggerFactory.getLogger(ProgressBar.class);
    private JPanel painel = null;
    private int qtTotal;
    private int qtPassed;
    JProgressBar pbar = null;
    String varSO = System.getProperty("os.name");

    @Override
    public void run() {
    }

    public ProgressBar() {
        if (this.pbar == null) {
            this.pbar = new JProgressBar();
            this.pbar.setStringPainted(true);
            this.pbar.setCursor(new Cursor(3));
        }
    }

    public ProgressBar(String text) {
        this();
        this.pbar.setIndeterminate(true);
        this.pbar.setString(text);
        this.init();
    }

    public ProgressBar(int qtTotal) {
        this();
        this.qtTotal = qtTotal;
        this.pbar.setIndeterminate(false);
        this.pbar.setMaximum(this.qtTotal);
        this.init();
    }

    public void setFont(String fontName) {
        this.pbar.setFont(new Font(fontName, 0, 12));
    }

    public void setBackgroudColor(Color backgroudColor) {
        this.pbar.setBackground(backgroudColor);
    }

    public void setForegroundColor(Color foregroundColor) {
        this.pbar.setForeground(foregroundColor);
    }

    public int getQtTotal() {
        return this.qtTotal;
    }

    public void setQtTotal(int qtTotal) {
        this.qtTotal = qtTotal;
    }

    public int getQtPassed() {
        return this.qtPassed;
    }

    public void setQtPassed(int qtPassed) {
        this.pbar.setValue(qtPassed);
    }

    public void setText(String text) {
        this.pbar.setString(text);
    }

    private void init() {
        this.initialize();
        if (this.varSO.contains("indows")) {
            this.setAlwaysOnTop(false);
        } else {
            this.setAlwaysOnTop(true);
        }
        Dimension dim = Toolkit.getDefaultToolkit().getScreenSize();
        int hor = dim.width / 2 - 150;
        int ver = dim.height / 2 - 100;
        this.setUndecorated(true);
        GraphicsDevice gd = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice();
        boolean isUniformTranslucencySupported = gd.isWindowTranslucencySupported(GraphicsDevice.WindowTranslucency.TRANSLUCENT);
        if (isUniformTranslucencySupported) {
            this.setOpacity(0.7f);
        }
        this.setBounds(hor, ver, 305, 155);
        this.setVisible(true);
    }

    private void initialize() {
        this.painel = (JPanel)this.getContentPane();
        this.painel.setLayout(null);
        this.painel.setOpaque(true);
        Color oraRed = new Color(255, 255, 255);
        this.painel.setBorder(BorderFactory.createLineBorder(oraRed, 10));
        this.painel.setBounds(1, 1, 300, 150);
        this.pbar.setBounds(25, 115, 255, 25);
        try {
            BufferedImage imgLogoSerpro = null;
            InputStream pathSerpro = this.getClass().getClassLoader().getResourceAsStream("images/logo_serpro_min.png");
            imgLogoSerpro = ImageIO.read(pathSerpro);
            ImageIcon iconSerpro = new ImageIcon(imgLogoSerpro);
            Image img = iconSerpro.getImage();
            this.setIconImage(img);
            JLabel lblImgSerpro = new JLabel(iconSerpro);
            lblImgSerpro.setHorizontalAlignment(0);
            lblImgSerpro.setBounds(1, 1, 300, 150);
            this.painel.add(lblImgSerpro);
        }
        catch (IOException e1) {
            logger.error(e1.getMessage());
        }
        this.painel.add(this.pbar);
        this.setContentPane(this.painel);
        this.pbar.setVisible(true);
        this.painel.setVisible(true);
    }
}

