/*
 * Decompiled with CFR 0.152.
 */
package org.demoiselle.signer.serpro.desktop.ui;

import java.awt.Color;
import java.awt.Cursor;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.imageio.ImageIO;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.KeyStroke;
import org.demoiselle.signer.serpro.desktop.SerproSignerConfigurations;
import org.demoiselle.signer.serpro.desktop.ui.commons.SignerDialog;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PinHandler
extends JDialog
implements CallbackHandler {
    private static final long serialVersionUID = 1L;
    private static final Logger logger = LoggerFactory.getLogger(PinHandler.class);
    private char[] pwd = new char[0];
    private String action;
    private String fromWeb = "";
    private boolean actionCanceled = false;
    private String certificateAlias = "";

    public void init() {
        this.initUI();
        this.setVisible(true);
    }

    public PinHandler(String action, String connectedHost) {
        this.action = action;
        this.fromWeb = connectedHost;
        this.setAlwaysOnTop(true);
    }

    private void initUI() {
        this.setTitle("Informe Sua Senha Para [" + this.action + "]");
        this.setSize(500, 360);
        this.setLocationRelativeTo(null);
        this.setLayout(null);
        this.setResizable(false);
        this.setDefaultCloseOperation(0);
        this.setForeground(new Color(0, 0, 51));
        final PinHandler me = this;
        JPanel pane = (JPanel)this.getContentPane();
        pane.setForeground(new Color(0, 0, 51));
        final JPasswordField text = new JPasswordField();
        JLabel lblPin = new JLabel("Informe o PIN (Senha):");
        lblPin.setFont(new Font("Arial", 0, 12));
        lblPin.setForeground(new Color(0, 0, 51));
        JLabel lblAction = new JLabel("Para: " + this.certificateAlias + " Solicita a a\u00e7\u00e3o:");
        lblAction.setHorizontalAlignment(0);
        lblAction.setFont(new Font("Arial", 0, 12));
        lblAction.setForeground(new Color(0, 0, 51));
        JLabel lblFromAction = new JLabel("Assinador Desktop");
        if (this.fromWeb != null && !this.fromWeb.isEmpty()) {
            lblFromAction.setText(this.fromWeb);
        }
        lblFromAction.setHorizontalAlignment(0);
        lblFromAction.setFont(new Font("Arial", 1, 12));
        lblFromAction.setForeground(new Color(0, 0, 51));
        JLabel lblActionUser = new JLabel(this.action);
        lblActionUser.setHorizontalAlignment(0);
        lblActionUser.setFont(new Font("Arial", 1, 14));
        lblActionUser.setForeground(new Color(0, 0, 51));
        final JButton btnValidate = new JButton("Confirmar");
        btnValidate.setFont(new Font("Arial", 1, 12));
        btnValidate.setForeground(new Color(0, 0, 51));
        btnValidate.setIcon(new ImageIcon(PinHandler.class.getResource("/images/check_small.png")));
        btnValidate.setBorder(BorderFactory.createLineBorder(new Color(0, 90, 170), 1, true));
        final JButton btnCancel = new JButton("Cancelar");
        btnCancel.setFont(new Font("Arial", 1, 12));
        btnValidate.setForeground(new Color(0, 0, 51));
        btnCancel.setIcon(new ImageIcon(PinHandler.class.getResource("/images/cancel.png")));
        btnCancel.setBorder(BorderFactory.createLineBorder(new Color(0, 90, 170), 1, true));
        pane.setBackground(new Color(173, 216, 230));
        BufferedImage img = null;
        try {
            boolean testWeb;
            InputStream path = null;
            boolean bl = testWeb = this.fromWeb != null && !this.fromWeb.isEmpty();
            if (SerproSignerConfigurations.getInstance().getTheme().get(this.fromWeb + ".pin.image") == null) {
                String configDefaultImage;
                path = !SerproSignerConfigurations.getInstance().getDefaultTheme().isEmpty() ? ((configDefaultImage = SerproSignerConfigurations.getInstance().getTheme().get(SerproSignerConfigurations.getInstance().getDefaultTheme() + ".pin.image")) != null ? new FileInputStream(configDefaultImage) : this.getClass().getClassLoader().getResourceAsStream("images/logo-signer-hor.png")) : this.getClass().getClassLoader().getResourceAsStream("images/logo-signer-hor.png");
            } else {
                try {
                    path = new File(SerproSignerConfigurations.getInstance().getTheme().get(this.fromWeb + ".pin.image")).exists() && testWeb ? new FileInputStream(SerproSignerConfigurations.getInstance().getTheme().get(this.fromWeb + ".pin.image")) : this.getClass().getClassLoader().getResourceAsStream("images/logo-signer-hor.png");
                }
                catch (Exception e) {
                    logger.error("Erro ao carregar imagem do tema: " + e.getMessage());
                }
            }
            img = ImageIO.read(path);
        }
        catch (IOException e1) {
            logger.error(e1.getMessage());
        }
        ImageIcon icon = new ImageIcon(img);
        JLabel lblImg = new JLabel(icon);
        lblImg.setHorizontalAlignment(0);
        btnValidate.setFocusPainted(false);
        btnValidate.setContentAreaFilled(false);
        btnCancel.setFocusPainted(false);
        btnCancel.setContentAreaFilled(false);
        pane.add(lblImg);
        pane.add(btnValidate);
        pane.add(btnCancel);
        pane.add(lblAction);
        pane.add(lblFromAction);
        pane.add(lblActionUser);
        pane.add(lblPin);
        pane.add(text);
        lblImg.setBounds(0, 0, 500, 200);
        lblFromAction.setBounds(0, 175, 500, 20);
        lblAction.setBounds(0, 200, 500, 15);
        lblActionUser.setBounds(0, 225, 500, 20);
        lblPin.setBounds(100, 260, 155, 25);
        text.setBounds(245, 260, this.getWidth() - (180 + lblPin.getWidth()), 25);
        btnCancel.setBounds((int)(text.getBounds().getMaxX() - 210.0), 290, 100, 30);
        btnValidate.setBounds((int)(text.getBounds().getMaxX() - 100.0), 290, 100, 30);
        btnCancel.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent e) {
                btnCancel.setCursor(new Cursor(12));
            }

            @Override
            public void mouseExited(MouseEvent e) {
                btnCancel.setCursor(new Cursor(0));
            }

            @Override
            public void mouseClicked(MouseEvent e) {
                PinHandler.this.actionCanceled = true;
                PinHandler.this.dispose();
            }
        });
        this.getRootPane().setDefaultButton(btnValidate);
        AbstractAction escapeAction = new AbstractAction(){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent e) {
                PinHandler.this.actionCanceled = true;
                PinHandler.this.dispose();
            }
        };
        this.getRootPane().getInputMap(2).put(KeyStroke.getKeyStroke(27, 0), "ESCAPE_KEY");
        this.getRootPane().getActionMap().put("ESCAPE_KEY", escapeAction);
        btnValidate.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent e) {
                btnValidate.setCursor(new Cursor(12));
            }

            @Override
            public void mouseExited(MouseEvent e) {
                btnValidate.setCursor(new Cursor(0));
            }

            @Override
            public void mouseClicked(MouseEvent e) {
                PinHandler.access$102(PinHandler.this, text.getPassword());
                if (PinHandler.this.pwd != null && PinHandler.this.pwd.length < 1) {
                    SignerDialog.showMessageDialog(null, "Deve informar a senha!", "Erro", 0);
                    text.requestFocusInWindow();
                } else {
                    me.dispose();
                }
            }
        });
        this.setModal(true);
    }

    public char[] getPwd() {
        return this.pwd;
    }

    public boolean getActionCanceled() {
        return this.actionCanceled;
    }

    public void setActionCanceled(boolean actionCanceled) {
        this.actionCanceled = actionCanceled;
    }

    @Override
    public void handle(Callback[] callbacks) throws IOException, UnsupportedCallbackException {
        for (Callback callback : callbacks) {
            if (!(callback instanceof PasswordCallback)) {
                throw new UnsupportedCallbackException(callback, "Callback not supported " + callback.getClass().getName());
            }
            this.initUI();
            this.setVisible(true);
            ((PasswordCallback)callback).setPassword(this.pwd);
        }
    }

    public String getCertificateAlias() {
        return this.certificateAlias;
    }

    public void setCertificateAlias(String certificateAlias) {
        this.certificateAlias = certificateAlias;
    }

    static /* synthetic */ char[] access$102(PinHandler x0, char[] x1) {
        x0.pwd = x1;
        return x1;
    }
}

