/*
 * Decompiled with CFR 0.152.
 */
package org.demoiselle.signer.serpro.desktop.ui;

import java.util.ArrayList;
import java.util.List;
import org.demoiselle.signer.policy.impl.cades.SignatureInformations;
import org.demoiselle.signer.policy.impl.cades.pkcs7.impl.CAdESChecker;
import org.demoiselle.signer.serpro.desktop.ui.SignatureInfo;

public class OlderSignatureInfo
extends SignatureInfo {
    private static final long serialVersionUID = 1L;

    public OlderSignatureInfo(String contentFileName, String signedFileName) {
        super(contentFileName, signedFileName);
    }

    @Override
    public void validateSignature(byte[] content, byte[] signature, CAdESChecker checker) {
        byte[] novaAssinatura = checker.getAttached(signature, false).getExtractedContent();
        if (novaAssinatura != null) {
            checker.checkDetachedSignature(novaAssinatura, signature);
            this.validateSignature(content, novaAssinatura, checker);
        } else {
            checker.checkDetachedSignature(content, signature);
        }
    }

    public List<SignatureInformations> getCertData(byte[] content, byte[] signed, CAdESChecker checker) {
        byte[] novaAssinatura = checker.getAttached(signed, false).getExtractedContent();
        ArrayList<SignatureInformations> all = new ArrayList<SignatureInformations>();
        try {
            all.addAll(super.getCertData(checker));
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (novaAssinatura != null) {
            all.addAll(this.getCertData(content, novaAssinatura, checker));
        }
        return all;
    }
}

