/*
 * Decompiled with CFR 0.152.
 */
package org.demoiselle.signer.serpro.desktop.ui;

import java.awt.Color;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JDialog;
import javax.swing.JEditorPane;
import javax.swing.JFileChooser;
import javax.swing.JRadioButton;
import javax.swing.LayoutStyle;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.filechooser.FileNameExtensionFilter;
import org.demoiselle.signer.serpro.desktop.command.signer.SignRequest;
import org.demoiselle.signer.serpro.desktop.ui.BatchSignature;
import org.demoiselle.signer.serpro.desktop.ui.NewToolsInterface;
import org.demoiselle.signer.serpro.desktop.ui.SignerJButton;
import org.demoiselle.signer.serpro.desktop.ui.ValidationTypeOptions;
import org.demoiselle.signer.serpro.desktop.ui.commons.Commons;
import org.demoiselle.signer.serpro.desktop.ui.commons.SignerDialog;
import org.demoiselle.signer.serpro.desktop.ui.pdf.NewPDFReader;
import org.demoiselle.signer.serpro.desktop.utils.NetUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OldValidationTypeOptions
extends JDialog {
    private static final long serialVersionUID = 1L;
    private static OldValidationTypeOptions instanceValidationTypeOptions = null;
    private static boolean oldInterface = false;
    private SignRequest request = new SignRequest();
    private String typeSignature = "";
    private String typeSignatureDescription = "";
    private final JRadioButton rdbtnRefVal = new JRadioButton("Refer\u00eancia para Valida\u00e7\u00e3o");
    private final JRadioButton rdbtnRefComp = new JRadioButton("Refer\u00eancias Completas");
    private final JRadioButton rdbtnRefArq = new JRadioButton("Refer\u00eancias de Arquivamento");
    private static final Logger logger = LoggerFactory.getLogger(ValidationTypeOptions.class);

    public static OldValidationTypeOptions getInstance(boolean parmOldInteface) {
        if (instanceValidationTypeOptions == null) {
            instanceValidationTypeOptions = new OldValidationTypeOptions();
        }
        OldValidationTypeOptions.setOldInterface(parmOldInteface);
        return instanceValidationTypeOptions;
    }

    public OldValidationTypeOptions() {
        this.setBackground(UIManager.getColor("Menu.acceleratorForeground"));
        this.setTitle("Assinaturas para Valida\u00e7\u00e3o de Longa Dura\u00e7\u00e3o");
        this.setAlwaysOnTop(true);
        this.setIconImage(Toolkit.getDefaultToolkit().getImage(OldValidationTypeOptions.class.getClassLoader().getResource("images/icon-signer-blue-16x16.png")));
        final OldValidationTypeOptions me = this;
        this.setDefaultCloseOperation(2);
        this.setResizable(false);
        this.setBounds(15, 115, 900, 100);
        UIManager.put("OptionPane.background", Color.WHITE);
        UIManager.put("Panel.background", Color.WHITE);
        SignerJButton ordinaryFile = new SignerJButton("Assinar Arquivo");
        ordinaryFile.setIcon(new ImageIcon(ValidationTypeOptions.class.getClassLoader().getResource("images/tools/btnSign.png")));
        ordinaryFile.setOpaque(true);
        ordinaryFile.setFocusPainted(false);
        final SignerJButton pdfFile = new SignerJButton("Assinar PDF");
        pdfFile.setIcon(new ImageIcon(ValidationTypeOptions.class.getClassLoader().getResource("images/tools/btnSignPDF.png")));
        pdfFile.setOpaque(true);
        pdfFile.setFocusPainted(false);
        pdfFile.setEnabled(false);
        SignerJButton fileBatch = new SignerJButton("Assinar Arquivos em lote");
        fileBatch.setIcon(new ImageIcon(ValidationTypeOptions.class.getClassLoader().getResource("images/tools/btnBatchSign.png")));
        fileBatch.setOpaque(true);
        fileBatch.setFocusPainted(false);
        SignerJButton btnConteudoAnexado = new SignerJButton("Assinatura Atachada");
        btnConteudoAnexado.setIcon(new ImageIcon(ValidationTypeOptions.class.getClassLoader().getResource("images/tools/btnAtachedSign.png")));
        btnConteudoAnexado.setOpaque(true);
        btnConteudoAnexado.setFocusPainted(false);
        SignerJButton cancel = new SignerJButton("Cancelar");
        cancel.setIcon(new ImageIcon(ValidationTypeOptions.class.getResource("/javax/swing/plaf/metal/icons/ocean/close.gif")));
        cancel.setOpaque(true);
        cancel.setFocusPainted(false);
        this.rdbtnRefVal.setSelected(true);
        this.rdbtnRefVal.setToolTipText("N\u00e3o permitida para PDF");
        this.rdbtnRefComp.setEnabled(false);
        this.rdbtnRefArq.setEnabled(false);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosed(WindowEvent e) {
                if (!oldInterface) {
                    NewToolsInterface.getInstance().setVisible(true);
                }
            }
        });
        ordinaryFile.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (OldValidationTypeOptions.this.typeChecked()) {
                    OldValidationTypeOptions.this.request.setType("file");
                    OldValidationTypeOptions.this.request.setOutputDataType("file");
                    OldValidationTypeOptions.this.setVisible(false);
                    Commons.SignOrdinaryFiles(OldValidationTypeOptions.this.request);
                    OldValidationTypeOptions.this.dispose();
                }
            }
        });
        pdfFile.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (OldValidationTypeOptions.this.typeChecked()) {
                    OldValidationTypeOptions.this.setVisible(false);
                    JFileChooser fileChooser = new JFileChooser();
                    fileChooser.setAcceptAllFileFilterUsed(false);
                    FileNameExtensionFilter filter = new FileNameExtensionFilter("Pdf", "pdf");
                    fileChooser.addChoosableFileFilter(filter);
                    int returnValue = fileChooser.showOpenDialog(null);
                    if (returnValue == 0) {
                        File selectedFile = fileChooser.getSelectedFile();
                        String fileName = selectedFile.getAbsolutePath();
                        try {
                            new NewPDFReader(fileName, OldValidationTypeOptions.this.typeSignature, oldInterface);
                        }
                        catch (NumberFormatException e1) {
                            logger.error("Gera\u00e7\u00e3o de PDF Assinado com :" + e1.getMessage());
                            SignerDialog.showMessageDialog(me, "Gera\u00e7\u00e3o de PDF Assinado com :" + OldValidationTypeOptions.this.typeSignatureDescription + e1.getMessage(), "Erro", 0);
                            OldValidationTypeOptions.this.dispose();
                        }
                    }
                }
            }
        });
        fileBatch.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (OldValidationTypeOptions.this.typeChecked()) {
                    try {
                        OldValidationTypeOptions.this.setVisible(false);
                        new BatchSignature(OldValidationTypeOptions.this.typeSignature);
                        me.dispose();
                    }
                    catch (Exception ex) {
                        SignerDialog.showMessageDialog(me, "Gera\u00e7\u00e3o das Assinaturas com " + OldValidationTypeOptions.this.typeSignatureDescription + " em lote:" + ex.getMessage(), "Erro", 0);
                        me.dispose();
                    }
                }
            }
        });
        btnConteudoAnexado.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (OldValidationTypeOptions.this.typeChecked()) {
                    OldValidationTypeOptions.this.request.setType("file");
                    OldValidationTypeOptions.this.request.setOutputDataType("file");
                    OldValidationTypeOptions.this.request.setAttached("true");
                    OldValidationTypeOptions.this.setVisible(false);
                    Commons.SignOrdinaryFiles(OldValidationTypeOptions.this.request);
                    OldValidationTypeOptions.this.dispose();
                }
            }
        });
        cancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                me.dispose();
            }
        });
        this.rdbtnRefVal.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (OldValidationTypeOptions.this.rdbtnRefVal.isSelected()) {
                    pdfFile.setEnabled(false);
                }
            }
        });
        this.rdbtnRefComp.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (OldValidationTypeOptions.this.rdbtnRefComp.isSelected()) {
                    pdfFile.setEnabled(true);
                }
            }
        });
        this.rdbtnRefArq.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (OldValidationTypeOptions.this.rdbtnRefArq.isSelected()) {
                    pdfFile.setEnabled(true);
                }
            }
        });
        JEditorPane infoLabel = new JEditorPane();
        infoLabel.setContentType("text/html");
        infoLabel.setText("<html><p style='margin:0 5px 0 5px'>Assinaturas de longa dura\u00e7\u00e3o dependem do uso de Carimbo do Tempo .</p><p style='margin:5px'>Para utilizar o carimbo do tempo \u00e9 necess\u00e1rio o cadastramento do certificado na Autoridade Certificadora de Tempo do SERPRO (<a href='https://act.serpro.gov.br'>https://act.serpro.gov.br</a>)</p><p style='margin:5px'>  Maiores informa\u00e7\u00f5es acesse: <a href='http://carimbodotempo.serpro.gov.br/act/'>http://carimbodotempo.serpro.gov.br/act/</a><br> <p style='font-size:100%' 'font-weight: bold'> Escolha o perfil abaixo:</p>");
        infoLabel.setEditable(false);
        infoLabel.addHyperlinkListener(new HyperlinkListener(){

            @Override
            public void hyperlinkUpdate(HyperlinkEvent e) {
                if (e.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                    NetUtil.openLink("http://carimbodotempo.serpro.gov.br/act/");
                }
            }
        });
        infoLabel.setBorder(new EmptyBorder(10, 10, 10, 10));
        this.getContentPane().setBackground(Color.WHITE);
        GroupLayout groupLayout = new GroupLayout(this.getContentPane());
        groupLayout.setHorizontalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addGap(43).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addComponent(this.rdbtnRefVal).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.rdbtnRefComp).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.rdbtnRefArq)).addGroup(groupLayout.createSequentialGroup().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(btnConteudoAnexado, -1, -1, Short.MAX_VALUE).addComponent(ordinaryFile, -2, 249, -2)).addGap(18).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(pdfFile, -1, -1, Short.MAX_VALUE).addComponent(fileBatch, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 32, Short.MAX_VALUE).addComponent(cancel, -2, 120, -2)))).addGroup(groupLayout.createSequentialGroup().addContainerGap().addComponent(infoLabel, -2, 692, -2).addContainerGap(31, Short.MAX_VALUE)));
        groupLayout.setVerticalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addGap(3).addComponent(infoLabel, -2, 160, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.rdbtnRefVal).addComponent(this.rdbtnRefComp).addComponent(this.rdbtnRefArq)).addGap(29).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(pdfFile, -1, -1, Short.MAX_VALUE).addComponent(ordinaryFile, -1, -1, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(fileBatch, -1, -1, Short.MAX_VALUE).addComponent(btnConteudoAnexado, -1, -1, Short.MAX_VALUE).addComponent(cancel, -1, 46, Short.MAX_VALUE)).addGap(40)));
        groupLayout.setAutoCreateContainerGaps(true);
        this.getContentPane().setLayout(groupLayout);
        this.setSize(735, 391);
        this.setLocationRelativeTo(null);
    }

    private boolean typeChecked() {
        boolean isChecked = true;
        if (!(this.rdbtnRefVal.isSelected() || this.rdbtnRefComp.isSelected() || this.rdbtnRefArq.isSelected())) {
            SignerDialog.showMessageDialog(null, "Nenhum perfil escolhido!", "Erro", 0);
            isChecked = false;
        }
        if (this.rdbtnRefVal.isSelected()) {
            this.request.setSignaturePolicy("RV");
            this.typeSignature = "RV";
            this.typeSignatureDescription = "Refer\u00eancia de Valida\u00e7\u00e3o";
        }
        if (this.rdbtnRefComp.isSelected()) {
            this.request.setSignaturePolicy("RC");
            this.typeSignature = "RC";
            this.typeSignatureDescription = "Refer\u00eancia Completa";
        }
        if (this.rdbtnRefArq.isSelected()) {
            this.request.setSignaturePolicy("RA");
            this.typeSignature = "RA";
            this.typeSignatureDescription = "Refer\u00eancia de Arquivamento";
        }
        return isChecked;
    }

    private static boolean isOldInterface() {
        return oldInterface;
    }

    private static void setOldInterface(boolean oldInterface) {
        OldValidationTypeOptions.oldInterface = oldInterface;
    }

    public static void main(String[] args) {
        OldValidationTypeOptions.getInstance(true).setVisible(true);
    }
}

