/*
 * Decompiled with CFR 0.152.
 */
package org.demoiselle.signer.serpro.desktop.ui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.FocusTraversalPolicy;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.GridLayout;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.FileInputStream;
import java.net.URL;
import java.util.ArrayList;
import javax.imageio.ImageIO;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import javax.swing.plaf.basic.BasicButtonUI;
import org.demoiselle.signer.serpro.desktop.About;
import org.demoiselle.signer.serpro.desktop.SerproSignerConfigurations;
import org.demoiselle.signer.serpro.desktop.UiFunctions;
import org.demoiselle.signer.serpro.desktop.ViewLog;
import org.demoiselle.signer.serpro.desktop.command.signer.SignRequest;
import org.demoiselle.signer.serpro.desktop.ui.BatchSignature;
import org.demoiselle.signer.serpro.desktop.ui.TimestampOptions;
import org.demoiselle.signer.serpro.desktop.ui.ValidationTypeOptions;
import org.demoiselle.signer.serpro.desktop.ui.commons.Commons;
import org.demoiselle.signer.serpro.desktop.ui.commons.SignerDialog;
import org.demoiselle.signer.serpro.desktop.ui.configuration.SignerConfigurations;
import org.demoiselle.signer.serpro.desktop.ui.crypto.SelectAction;
import org.demoiselle.signer.serpro.desktop.ui.util.IconUtil;
import org.demoiselle.signer.serpro.desktop.utils.MessagesBundle;
import org.demoiselle.signer.serpro.desktop.utils.NetUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NewToolsInterface
extends JFrame {
    private static final long serialVersionUID = 6358331822262773727L;
    private static boolean oldInterface = false;
    private static final Logger logger = LoggerFactory.getLogger(NewToolsInterface.class);
    private boolean calledByApp = false;
    private static NewToolsInterface instanceToolsInterface = null;
    private UiFunctions functions = new UiFunctions();
    private JLabel lblMenuOpcoes = new JLabel();
    private static final MessagesBundle assinadorMessagesBundle = new MessagesBundle();
    static final Color COR_FUNDO = new Color(246, 245, 244);
    private final BotaoDescricao[] botoesPainelDireito = new BotaoDescricao[]{new BotaoDescricao("Logs", "/images/tools/btnLog.png", new Runnable(){

        @Override
        public void run() {
            NewToolsInterface.this.setAlwaysOnTop(false);
            ViewLog varViewLog = new ViewLog();
            varViewLog.setOldInterface(false);
            varViewLog.setVisible(true);
        }
    }), new BotaoDescricao("Configura\u00e7\u00f5es", "/images/tools/btnConfig.png", new Runnable(){

        @Override
        public void run() {
            try {
                NewToolsInterface.this.setAlwaysOnTop(false);
                SignerConfigurations.getInstance(NewToolsInterface.this, false).setVisible(true);
            }
            catch (Throwable error) {
                logger.error("Erro na op\u00e7\u00e3o Configura\u00e7\u00f5es: " + error.getMessage(), error);
                error.printStackTrace();
                NewToolsInterface.this.functions.errorMessage("Erro", error.getMessage());
            }
        }
    }), new BotaoDescricao("Tutorial", "/images/tools/btnTutorial.png", new Runnable(){

        @Override
        public void run() {
            SignerDialog.showMessageDialog(null, "Sera aberta uma p\u00e1gina no seu navegador padr\u00e3o!", "Informa\u00e7\u00e3o", 1);
            NetUtil.openLink("https://tutorial.assinadorserpro.estaleiro.serpro.gov.br/html/");
        }
    }), new BotaoDescricao("Arquivos\nSeguros", "/images/tools/btnArqSeguro.png", new Runnable(){

        @Override
        public void run() {
            try {
                NewToolsInterface.this.setAlwaysOnTop(false);
                SelectAction.getInstance(false).setVisible(true);
            }
            catch (Throwable error) {
                logger.error("Erro na op\u00e7\u00e3o Arquivos Seguros: " + error.getMessage(), error);
                error.printStackTrace();
                NewToolsInterface.this.functions.errorMessage("Erro", error.getMessage());
            }
        }
    }), new BotaoDescricao("Sobre", "/images/tools/btnSobre.png", new Runnable(){

        @Override
        public void run() {
            NewToolsInterface.this.setAlwaysOnTop(false);
            About.getInstance(false).setVisible(true);
        }
    })};
    private final BotaoDescricao[] botoesPainelEsquerdo = new BotaoDescricao[]{new BotaoDescricao("Assinar\nPDF", "/images/tools/btnSignPDF.png", new Runnable(){

        @Override
        public void run() {
            try {
                NewToolsInterface.this.setAlwaysOnTop(false);
                NewToolsInterface.this.functions.pdfSigner(NewToolsInterface.this);
            }
            catch (Exception error) {
                logger.error("Erro na op\u00e7\u00e3o Assinar PDF: " + error.getMessage(), error);
                error.printStackTrace();
                NewToolsInterface.this.functions.errorMessage("Erro", error.getMessage());
            }
        }
    }), new BotaoDescricao("Assinar\nXML", "/images/tools/btnXml.png", new Runnable(){

        @Override
        public void run() {
            try {
                NewToolsInterface.this.setAlwaysOnTop(false);
                NewToolsInterface.this.functions.signXML();
            }
            catch (Throwable error) {
                logger.error("Erro ao tentar assinar um documento XML", error);
                error.printStackTrace();
                if (error.getMessage() == null || error.getMessage().equals("")) {
                    NewToolsInterface.this.functions.errorMessage("Erro", "Um erro inesperado ocorreu, reinicie o aplicativo.");
                }
                NewToolsInterface.this.functions.errorMessage("Erro", error.getMessage());
            }
        }
    }), new BotaoDescricao("Assinar\nArquivo", "/images/tools/btnSign.png", new Runnable(){

        @Override
        public void run() {
            try {
                NewToolsInterface.this.setAlwaysOnTop(false);
                NewToolsInterface.this.functions.sign();
            }
            catch (Throwable error) {
                logger.error("Erro ao tentar assinar um arquivo", error);
                error.printStackTrace();
                if (error.getMessage() == null || error.getMessage().equals("")) {
                    NewToolsInterface.this.functions.errorMessage("Erro", "Um erro inesperado ocorreu, reinicie o aplicativo.");
                }
                NewToolsInterface.this.functions.errorMessage("Erro", error.getMessage());
            }
        }
    }), new BotaoDescricao("Assinar\nem Lote", "/images/tools/btnBatchSign.png", new Runnable(){

        @Override
        public void run() {
            try {
                NewToolsInterface.this.setAlwaysOnTop(false);
                new BatchSignature("RB");
            }
            catch (Throwable error) {
                logger.error("Erro na op\u00e7\u00e3o Assinar em Lote: " + error.getMessage(), error);
                error.printStackTrace();
                NewToolsInterface.this.functions.errorMessage("Erro", error.getMessage());
            }
        }
    }), new BotaoDescricao("Assinatura\nAtachada", "/images/tools/btnAtachedSign.png", new Runnable(){

        @Override
        public void run() {
            try {
                NewToolsInterface.this.setAlwaysOnTop(false);
                NewToolsInterface.this.functions.sign("true");
            }
            catch (Throwable error) {
                logger.error("Erro ao tentar assinar com assinatura atachada", error);
                error.printStackTrace();
                if (error.getMessage() == null || error.getMessage().equals("")) {
                    NewToolsInterface.this.functions.errorMessage("Erro", "Um erro inesperado ocorreu, reinicie o aplicativo.");
                }
                NewToolsInterface.this.functions.errorMessage("Erro", error.getMessage());
            }
        }
    }), new BotaoDescricao("Co-Assinar", "/images/tools/btnCoSign.png", new Runnable(){

        @Override
        public void run() {
            try {
                NewToolsInterface.this.setAlwaysOnTop(false);
                Commons.coSigner(new SignRequest());
            }
            catch (Throwable error) {
                logger.error("Erro ao tentar co-assinar um documento", error);
                error.printStackTrace();
                if (error.getMessage() == null) {
                    NewToolsInterface.this.functions.errorMessage("Erro", "Um erro inesperado ocorreu, reinicie o aplicativo.");
                }
                NewToolsInterface.this.functions.errorMessage("Erro", error.getMessage());
            }
        }
    }), new BotaoDescricao("Utilizar\nCarimbo\ndo Tempo", "/images/tools/btnTimestamp.png", new Runnable(){

        @Override
        public void run() {
            try {
                NewToolsInterface.this.setAlwaysOnTop(false);
                TimestampOptions.getInstance(false).setVisible(true);
            }
            catch (Exception error) {
                logger.error("Erro na op\u00e7\u00e3o Utilizar Carimbo do Tempo: " + error.getMessage(), error);
                error.printStackTrace();
                NewToolsInterface.this.functions.errorMessage("Erro", error.getMessage());
            }
        }
    }), new BotaoDescricao("Assinatura\nde Longa\nDura\u00e7\u00e3o", "/images/tools/btnAssinarLongaDuracao.png", new Runnable(){

        @Override
        public void run() {
            try {
                NewToolsInterface.this.setAlwaysOnTop(false);
                ValidationTypeOptions.getInstance(false).setVisible(true);
            }
            catch (Throwable error) {
                logger.error("Erro na op\u00e7\u00e3o Longa Dura\u00e7\u00e3o: " + error.getMessage(), error);
                error.printStackTrace();
                NewToolsInterface.this.functions.errorMessage("Erro", error.getMessage());
            }
        }
    }), new BotaoDescricao("Validar\nAssinatura", "/images/tools/btnValidate.png", new Runnable(){

        @Override
        public void run() {
            try {
                NewToolsInterface.this.setAlwaysOnTop(false);
                NewToolsInterface.this.functions.validate();
            }
            catch (Throwable error) {
                logger.error("Erro ao tentar validar assinatura", error);
                error.printStackTrace();
                if (error.getMessage() == null || error.getMessage().equals("")) {
                    NewToolsInterface.this.functions.errorMessage("Erro", "Um erro inesperado ocorreu, reinicie o aplicativo.");
                }
                NewToolsInterface.this.functions.errorMessage("Erro", error.getMessage());
            }
        }
    }), new BotaoDescricao("Validar\nCarimbo\ndo Tempo", "/images/tools/btnTimestamp.png", new Runnable(){

        @Override
        public void run() {
            try {
                NewToolsInterface.this.setAlwaysOnTop(false);
                NewToolsInterface.this.functions.validateTimeStamp();
            }
            catch (Throwable error) {
                logger.error("Erro na op\u00e7\u00e3o Validar Carimbo do Tempo: " + error.getMessage(), error);
                error.printStackTrace();
                NewToolsInterface.this.functions.errorMessage("Erro", error.getMessage());
            }
        }
    }), new BotaoDescricao("", null, new Runnable(){

        @Override
        public void run() {
        }
    }), new BotaoDescricao("Sair", "/images/tools/btnExit.png", new Runnable(){

        @Override
        public void run() {
            NewToolsInterface.confirmAndExit(NewToolsInterface.this);
        }
    })};
    static final int JANELA_LARGURA = 700;
    static final int JANELA_ALTURA = 500;
    static final Dimension TAMANHO_BOTAO_DIREITA = new Dimension(120, 90);

    public static NewToolsInterface getInstance() {
        if (instanceToolsInterface == null) {
            instanceToolsInterface = new NewToolsInterface(true);
        } else {
            instanceToolsInterface.verifyIcon();
        }
        return instanceToolsInterface;
    }

    private void verifyIcon() {
        block5: {
            String dt = SerproSignerConfigurations.getInstance().getDefaultTheme();
            if (!dt.isEmpty()) {
                try {
                    if (SerproSignerConfigurations.getInstance().getTheme().containsKey(dt + ".tools.image")) {
                        FileInputStream fps = new FileInputStream(SerproSignerConfigurations.getInstance().getTheme().get(dt + ".tools.image"));
                        this.lblMenuOpcoes.setIcon(new ImageIcon(ImageIO.read(fps)));
                        break block5;
                    }
                    this.lblMenuOpcoes.setIcon(new ImageIcon(this.getClass().getResource("/newImages/logoMenuOpcoes.png")));
                }
                catch (Exception e) {
                    logger.error("Erro carregando imagem de tema no NewToolsInterface");
                    e.printStackTrace();
                }
            } else {
                this.lblMenuOpcoes.setIcon(new ImageIcon(this.getClass().getResource("/newImages/logoMenuOpcoes.png")));
            }
        }
    }

    public static void confirmAndExit(Component parent) {
        Object[] options = new Object[]{"Sair", "Apenas minimizar"};
        int choice = JOptionPane.showOptionDialog(parent, "<html>Tem certeza que deseja sair?<br><br>Caso saia as integra\u00e7\u00f5es que usam o Assinador Serpro n\u00e3o funcionar\u00e3o.</html>", "Confirmar Sa\u00edda", 0, 3, null, options, options[1]);
        if (choice == 0) {
            System.exit(0);
        } else if (parent instanceof JFrame) {
            ((JFrame)parent).setState(1);
        }
    }

    private void minimize() {
        this.setState(1);
    }

    public NewToolsInterface(boolean calledByApp) {
        super("Assinador Serpro");
        System.setProperty("sun.awt.X11.XFrame.awt_wm_class", "Assinador Serpro");
        IconUtil.setIcon(this);
        this.calledByApp = calledByApp;
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                NewToolsInterface.confirmAndExit(NewToolsInterface.this);
            }
        });
        try {
            JRootPane rootPane = this.getRootPane();
            rootPane.putClientProperty("Window.style", "small");
            Component[] components = rootPane.getComponents();
            if (components.length > 0 && components[0] instanceof JComponent) {
                Component[] titlePaneComponents;
                JComponent titlePane = (JComponent)components[0];
                for (Component c : titlePaneComponents = titlePane.getComponents()) {
                    JButton btn;
                    if (!(c instanceof JButton) || (btn = (JButton)c).getAction() == null || !btn.getAction().getValue("Name").equals("Close")) continue;
                    btn.getParent().remove(btn);
                }
            }
        }
        catch (Exception e) {
            logger.error("Error removing close button", e);
        }
        this.setSize(700, 500);
        this.setResizable(false);
        this.setLocationRelativeTo(null);
        this.getContentPane().setBackground(COR_FUNDO);
        this.setCursor(Cursor.getDefaultCursor());
        JPanel mainPanel = new JPanel(new BorderLayout());
        mainPanel.setBackground(COR_FUNDO);
        int borda = 14;
        JPanel centralPanel = new JPanel(new BorderLayout());
        centralPanel.setBorder(BorderFactory.createEmptyBorder(borda, borda, borda, borda));
        centralPanel.setBackground(COR_FUNDO);
        JPanel logoPanel = this.criarPainelLogo();
        centralPanel.add((Component)logoPanel, "North");
        JPanel rightPanel = this.criarPainelDireito();
        JPanel leftPanel = this.criarPainelEsquerdo();
        JPanel separatorPanel = this.criarPainelSeparador(borda);
        JPanel innerCenterPanel = new JPanel();
        innerCenterPanel.setLayout(new BoxLayout(innerCenterPanel, 0));
        innerCenterPanel.setBackground(COR_FUNDO);
        innerCenterPanel.add(leftPanel);
        innerCenterPanel.add(separatorPanel);
        innerCenterPanel.add(rightPanel);
        centralPanel.add((Component)innerCenterPanel, "Center");
        mainPanel.add((Component)centralPanel, "Center");
        this.setContentPane(mainPanel);
    }

    private JPanel criarPainelLogo() {
        JLabel logoLabel;
        JPanel logoPanel = new JPanel(new FlowLayout(1, 0, 0));
        logoPanel.setBackground(COR_FUNDO);
        ImageIcon logoIcon = new ImageIcon(NewToolsInterface.class.getResource("/images/logo-signer-hor.png"));
        int width = logoIcon.getIconWidth();
        int height = logoIcon.getIconHeight();
        if (width > 0 && height > 0) {
            int newWidth = width / 2;
            int newHeight = height / 2;
            Image scaledImg = logoIcon.getImage().getScaledInstance(newWidth, newHeight, 4);
            logoLabel = new JLabel(new ImageIcon(scaledImg));
        } else {
            logoLabel = new JLabel("Logo");
        }
        logoLabel.setBorder(BorderFactory.createEmptyBorder(0, 0, 7, 10));
        logoPanel.add(logoLabel);
        return logoPanel;
    }

    private JPanel criarPainelEsquerdo() {
        JPanel leftPanel = new JPanel(new GridLayout(3, 4, 4, 4));
        leftPanel.setBackground(COR_FUNDO);
        leftPanel.setAlignmentY(0.0f);
        final ArrayList<JButton> btnList = new ArrayList<JButton>();
        for (int i = 1; i <= 12; ++i) {
            BotaoDescricao desc = this.botoesPainelEsquerdo[i - 1];
            if (desc.texto == null || desc.texto.trim().isEmpty()) {
                JButton invisibleBtn = new JButton();
                invisibleBtn.setVisible(false);
                invisibleBtn.setEnabled(false);
                invisibleBtn.setPreferredSize(TAMANHO_BOTAO_DIREITA);
                invisibleBtn.setMinimumSize(TAMANHO_BOTAO_DIREITA);
                invisibleBtn.setMaximumSize(TAMANHO_BOTAO_DIREITA);
                btnList.add(invisibleBtn);
                leftPanel.add(invisibleBtn);
                continue;
            }
            JButton btn = this.criarBotaoPainelEsquerdo(desc);
            btnList.add(btn);
            leftPanel.add(btn);
        }
        leftPanel.setFocusTraversalPolicy(new FocusTraversalPolicy(){

            @Override
            public Component getComponentAfter(Container aContainer, Component aComponent) {
                int idx = btnList.indexOf(aComponent);
                for (int i = 1; i <= btnList.size(); ++i) {
                    int next = (idx + i) % btnList.size();
                    if (!((JButton)btnList.get(next)).isFocusable() || !((JButton)btnList.get(next)).isEnabled()) continue;
                    return (Component)btnList.get(next);
                }
                return (Component)btnList.get(0);
            }

            @Override
            public Component getComponentBefore(Container aContainer, Component aComponent) {
                int idx = btnList.indexOf(aComponent);
                for (int i = 1; i <= btnList.size(); ++i) {
                    int prev = (idx - i + btnList.size()) % btnList.size();
                    if (!((JButton)btnList.get(prev)).isFocusable() || !((JButton)btnList.get(prev)).isEnabled()) continue;
                    return (Component)btnList.get(prev);
                }
                return (Component)btnList.get(0);
            }

            @Override
            public Component getFirstComponent(Container aContainer) {
                for (JButton b : btnList) {
                    if (!b.isFocusable() || !b.isEnabled()) continue;
                    return b;
                }
                return (Component)btnList.get(0);
            }

            @Override
            public Component getLastComponent(Container aContainer) {
                for (int i = btnList.size() - 1; i >= 0; --i) {
                    if (!((JButton)btnList.get(i)).isFocusable() || !((JButton)btnList.get(i)).isEnabled()) continue;
                    return (Component)btnList.get(i);
                }
                return (Component)btnList.get(btnList.size() - 1);
            }

            @Override
            public Component getDefaultComponent(Container aContainer) {
                return this.getFirstComponent(aContainer);
            }
        });
        leftPanel.setFocusTraversalPolicyProvider(true);
        return leftPanel;
    }

    private void adicionarCursorDeMao(final JButton btn) {
        btn.addMouseListener(new MouseAdapter(){
            private Cursor cursorAnterior;

            @Override
            public void mouseEntered(MouseEvent e) {
                this.cursorAnterior = btn.getCursor();
                btn.setCursor(Cursor.getPredefinedCursor(12));
            }

            @Override
            public void mouseExited(MouseEvent e) {
                if (this.cursorAnterior != null) {
                    btn.setCursor(this.cursorAnterior);
                } else {
                    btn.setCursor(Cursor.getDefaultCursor());
                }
            }
        });
    }

    private JButton criarBotaoPainelEsquerdo(final BotaoDescricao desc) {
        JButton btn;
        if (desc.texto != null && !desc.texto.trim().isEmpty()) {
            btn = new JButton("<html>" + desc.texto.replace("\n", "<br>") + "</html>");
            if (desc.iconePath != null) {
                URL iconUrl = NewToolsInterface.class.getResource(desc.iconePath);
                if (iconUrl != null) {
                    btn.setIcon(new ImageIcon(iconUrl));
                } else {
                    logger.warn("\u00cdcone n\u00e3o encontrado: " + desc.iconePath);
                }
                btn.setHorizontalTextPosition(4);
                btn.setIconTextGap(8);
            }
            btn.setFont(new Font("Arial", 1, 14));
            btn.setBackground(Color.WHITE);
            btn.setOpaque(true);
            btn.setContentAreaFilled(true);
            btn.setBorderPainted(true);
            btn.setUI(new BasicButtonUI());
            btn.setForeground(new Color(0, 90, 170));
            btn.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createLineBorder(new Color(0, 90, 170), 1, true), BorderFactory.createEmptyBorder(0, 8, 0, 0)));
            btn.setHorizontalAlignment(2);
            btn.setPreferredSize(TAMANHO_BOTAO_DIREITA);
            btn.setMinimumSize(TAMANHO_BOTAO_DIREITA);
            btn.setMaximumSize(TAMANHO_BOTAO_DIREITA);
            btn.setFocusPainted(true);
            btn.setFocusable(true);
            if (desc.acao != null) {
                btn.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        desc.acao.run();
                    }
                });
            }
            this.adicionarCursorDeMao(btn);
        } else {
            btn = new JButton();
            btn.setEnabled(false);
            btn.setBorder(BorderFactory.createEmptyBorder());
            btn.setPreferredSize(TAMANHO_BOTAO_DIREITA);
            btn.setMinimumSize(TAMANHO_BOTAO_DIREITA);
            btn.setMaximumSize(TAMANHO_BOTAO_DIREITA);
            btn.setFocusable(false);
            btn.setOpaque(false);
            btn.setContentAreaFilled(true);
            btn.setBackground(Color.WHITE);
        }
        return btn;
    }

    private JPanel criarPainelDireito() {
        JPanel rightPanel = new JPanel(new BorderLayout());
        rightPanel.setBackground(COR_FUNDO);
        rightPanel.setAlignmentY(0.0f);
        JPanel leftTopPanel = new JPanel(new GridLayout(5, 1, 4, 4));
        leftTopPanel.setBackground(COR_FUNDO);
        for (int i = 1; i <= 5; ++i) {
            BotaoDescricao desc = this.botoesPainelDireito[i - 1];
            JButton btn = this.criarBotaoPainelDireito(desc);
            leftTopPanel.add(btn);
        }
        rightPanel.add((Component)leftTopPanel, "North");
        JPanel leftBottomPanel = this.criarPainelLogoEmpresa();
        rightPanel.add((Component)leftBottomPanel, "Center");
        JPanel infoPanel = new JPanel();
        infoPanel.setBackground(COR_FUNDO);
        infoPanel.setLayout(new BoxLayout(infoPanel, 1));
        infoPanel.setBorder(BorderFactory.createEmptyBorder(0, 0, 5, 0));
        String version = SerproSignerConfigurations.version;
        String envName = SerproSignerConfigurations.envName;
        if (version != null && !version.isEmpty()) {
            JLabel versionLabel = new JLabel("<html><div style='font-size:8px; color:#000000; text-align:center'>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;v" + version + "</div></html>");
            infoPanel.add(versionLabel);
        }
        if ("hom".equalsIgnoreCase(envName)) {
            JLabel envLabel = new JLabel("<html><div style='font-size:8px; color:#000000; text-align:center'>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Homologa\u00e7\u00e3o</div></html>");
            infoPanel.add(envLabel);
        }
        rightPanel.add((Component)infoPanel, "South");
        return rightPanel;
    }

    private JButton criarBotaoPainelDireito(final BotaoDescricao desc) {
        JButton btn = new JButton("<html>" + desc.texto.replace("\n", "<br>") + "</html>");
        if (desc.iconePath != null) {
            ImageIcon logoIcon = new ImageIcon(NewToolsInterface.class.getResource(desc.iconePath));
            btn.setIcon(logoIcon);
            btn.setHorizontalTextPosition(4);
            btn.setIconTextGap(2);
        }
        btn.setFont(new Font("Arial", 0, 13));
        btn.setBackground(Color.WHITE);
        btn.setOpaque(true);
        btn.setContentAreaFilled(true);
        btn.setBorderPainted(true);
        btn.setUI(new BasicButtonUI());
        btn.setForeground(new Color(0, 90, 170));
        btn.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createLineBorder(new Color(0, 90, 170), 1, true), BorderFactory.createEmptyBorder(0, 4, 0, 0)));
        btn.setHorizontalAlignment(2);
        btn.setIconTextGap(2);
        if (desc.acao != null) {
            btn.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    desc.acao.run();
                }
            });
        }
        this.adicionarCursorDeMao(btn);
        return btn;
    }

    private JPanel criarPainelLogoEmpresa() {
        JLabel logoEmpresa;
        JPanel leftBottomPanel = new JPanel(new FlowLayout(1));
        leftBottomPanel.setBackground(COR_FUNDO);
        ImageIcon logoEmpresaIcon = new ImageIcon(NewToolsInterface.class.getResource("/newImages/logoSerproMenu.png"));
        int imgWidth = logoEmpresaIcon.getIconWidth();
        int imgHeight = logoEmpresaIcon.getIconHeight();
        if (imgWidth > 0 && imgHeight > 0) {
            double scale = 0.6;
            int newWidth = (int)((double)imgWidth * scale);
            int newHeight = (int)((double)imgHeight * scale);
            Image scaledImg = logoEmpresaIcon.getImage().getScaledInstance(newWidth, newHeight, 4);
            logoEmpresa = new JLabel(new ImageIcon(scaledImg)){

                @Override
                protected void paintComponent(Graphics g) {
                    g.setColor(COR_FUNDO);
                    g.fillRect(0, 0, this.getWidth(), this.getHeight());
                    super.paintComponent(g);
                }
            };
        } else {
            logoEmpresa = new JLabel("Serpro");
        }
        logoEmpresa.setOpaque(true);
        logoEmpresa.setBackground(COR_FUNDO);
        leftBottomPanel.add(logoEmpresa);
        leftBottomPanel.setBorder(BorderFactory.createEmptyBorder(20, 0, 0, 0));
        return leftBottomPanel;
    }

    private JPanel criarPainelSeparador(int borda) {
        JPanel separatorPanel = new JPanel();
        separatorPanel.setOpaque(true);
        separatorPanel.setBackground(COR_FUNDO);
        separatorPanel.setPreferredSize(new Dimension(borda, 0));
        return separatorPanel;
    }

    static class BotaoDescricao {
        String texto;
        String iconePath;
        Runnable acao;

        BotaoDescricao(String texto, String iconePath, Runnable acao) {
            this.texto = texto;
            this.iconePath = iconePath;
            this.acao = acao;
        }
    }
}

