/*
 * Decompiled with CFR 0.152.
 */
package org.demoiselle.signer.serpro.desktop.ui;

import java.awt.Color;
import java.awt.Cursor;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.demoiselle.signer.serpro.desktop.command.cert.Certificate;
import org.demoiselle.signer.serpro.desktop.command.cert.ListCertsResponse;

public class ListCertificateData
extends JDialog {
    private String alias;
    private String provider;
    private static final long serialVersionUID = 1L;
    private List<CertificateData> certs;
    private List<CertificateData> allCerts;
    private boolean selected = false;
    private JPanel panelScroll;
    private ButtonGroup bG;
    private JTextField searchField;
    private JPanel topPanel;

    public static void main(String[] args) {
        new ListCertificateData(null).init();
    }

    public void init() {
        this.initUI();
        this.setVisible(true);
    }

    public ListCertificateData(ListCertsResponse certificates) {
        this.getContentPane().setFont(new Font("FreeMono", 3, 12));
        this.getContentPane().setBackground(new Color(173, 216, 230));
        this.getContentPane().setForeground(new Color(0, 0, 51));
        this.setTitle("Sele\u00e7\u00e3o de Certificado");
        this.getRootPane().setBackground(new Color(173, 216, 230));
        this.getRootPane().setForeground(new Color(0, 0, 51));
        this.setForeground(new Color(0, 0, 51));
        this.setBackground(new Color(173, 216, 230));
        this.setDefaultCloseOperation(0);
        this.getRootPane().setBorder(BorderFactory.createLineBorder(new Color(204, 255, 255)));
        this.certs = new ArrayList<CertificateData>();
        this.allCerts = new ArrayList<CertificateData>();
        if (certificates != null && certificates.getCertificates() != null) {
            for (Certificate c : certificates.getCertificates()) {
                CertificateData cd = new CertificateData(c);
                this.certs.add(cd);
                this.allCerts.add(cd);
            }
        }
    }

    private String getIssuer(String issuer) {
        String[] nIssuerAux;
        for (String s : nIssuerAux = issuer.split(",")) {
            if (s.indexOf("CN=") == -1) continue;
            return s.replace("CN=", "");
        }
        return issuer;
    }

    private void initUI() {
        this.setTitle("Sele\u00e7\u00e3o de Certificado");
        this.setSize(700, 400);
        this.setLocationRelativeTo(null);
        this.setAlwaysOnTop(true);
        this.setForeground(new Color(0, 0, 51));
        this.setBackground(new Color(173, 216, 230));
        this.getContentPane().setLayout(null);
        this.getContentPane().setBackground(new Color(173, 216, 230));
        this.getContentPane().setForeground(new Color(0, 0, 51));
        this.setResizable(false);
        final ListCertificateData me = this;
        JPanel pane = (JPanel)this.getContentPane();
        this.topPanel = new JPanel(new FlowLayout(0));
        this.topPanel.setBackground(new Color(173, 216, 230));
        JLabel searchLabel = new JLabel("Buscar:");
        searchLabel.setForeground(new Color(0, 0, 51));
        this.searchField = new JTextField(30);
        this.topPanel.add(searchLabel);
        this.topPanel.add(this.searchField);
        this.topPanel.setBounds(20, 10, 660, 35);
        pane.add(this.topPanel);
        JLabel title = new JLabel("<html><span style=\\'font-size:15px;\\'>Selecione um dos certificados</span></html>");
        title.setForeground(new Color(0, 0, 51));
        pane.setBackground(new Color(173, 216, 230));
        pane.setForeground(new Color(0, 0, 51));
        JButton btnValidate = new JButton("Selecionar");
        btnValidate.setBackground(Color.GREEN);
        btnValidate.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent e) {
                ListCertificateData.this.setCursor(new Cursor(12));
            }

            @Override
            public void mouseExited(MouseEvent e) {
                ListCertificateData.this.setCursor(new Cursor(0));
            }
        });
        JButton btnCancel = new JButton("Cancelar");
        btnCancel.setBackground(Color.RED);
        btnCancel.setBorderPainted(true);
        btnCancel.setContentAreaFilled(true);
        btnCancel.setFocusPainted(true);
        btnCancel.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent e) {
                ListCertificateData.this.setCursor(new Cursor(12));
            }

            @Override
            public void mouseExited(MouseEvent e) {
                ListCertificateData.this.setCursor(new Cursor(0));
            }
        });
        btnCancel.setSelected(true);
        this.bG = new ButtonGroup();
        this.panelScroll = new JPanel(new GridLayout(0, 1));
        this.panelScroll.setBackground(new Color(173, 216, 230));
        this.panelScroll.setForeground(new Color(0, 0, 51));
        this.updateCertificateList();
        JScrollPane scrollPane = new JScrollPane(this.panelScroll);
        scrollPane.setBounds(20, 55, 660, 240);
        scrollPane.setBackground(new Color(173, 216, 230));
        scrollPane.setForeground(new Color(0, 0, 51));
        pane.add(scrollPane);
        pane.add(btnCancel);
        pane.add(btnValidate);
        btnCancel.setBounds(this.getWidth() - 270, this.getHeight() - 75, 120, 30);
        btnValidate.setBounds(this.getWidth() - 140, this.getHeight() - 75, 120, 30);
        this.searchField.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                ListCertificateData.this.filterCertificates();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                ListCertificateData.this.filterCertificates();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                ListCertificateData.this.filterCertificates();
            }
        });
        btnCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                me.dispose();
            }
        });
        btnValidate.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                for (int i = 0; i < ListCertificateData.this.certs.size(); ++i) {
                    if (!((CertificateData)((ListCertificateData)ListCertificateData.this).certs.get((int)i)).sentBy.isSelected()) continue;
                    ListCertificateData.this.alias = ((CertificateData)((ListCertificateData)ListCertificateData.this).certs.get((int)i)).alias;
                    ListCertificateData.this.setSelected(true);
                    me.dispose();
                }
            }
        });
        this.getRootPane().setDefaultButton(btnValidate);
        AbstractAction escapeAction = new AbstractAction(){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent e) {
                ListCertificateData.this.dispose();
            }
        };
        this.getRootPane().getInputMap(2).put(KeyStroke.getKeyStroke(27, 0), "ESCAPE_KEY");
        this.getRootPane().getActionMap().put("ESCAPE_KEY", escapeAction);
        this.setModal(true);
    }

    public String getAlias() {
        return this.alias;
    }

    public String getProvider() {
        return this.provider;
    }

    public boolean isSelected() {
        return this.selected;
    }

    public void setSelected(boolean selected) {
        this.selected = selected;
    }

    private void filterCertificates() {
        String searchText = this.searchField.getText().toLowerCase();
        this.certs.clear();
        if (searchText.isEmpty()) {
            this.certs.addAll(this.allCerts);
        } else {
            for (CertificateData cd : this.allCerts) {
                if (!cd.certificate.getCn().toLowerCase().contains(searchText)) continue;
                this.certs.add(cd);
            }
        }
        this.updateCertificateList();
    }

    private void updateCertificateList() {
        this.panelScroll.removeAll();
        this.bG = new ButtonGroup();
        int ypos = 0;
        for (int i = 0; i < this.certs.size(); ++i) {
            this.bG.add(this.certs.get((int)i).sentBy);
            this.certs.get((int)i).sentBy.setBounds(0, ypos, 600, 20);
            this.panelScroll.add(this.certs.get((int)i).sentBy);
        }
        this.panelScroll.revalidate();
        this.panelScroll.repaint();
    }

    private class CertificateData {
        public JRadioButton sentBy;
        public JLabel provider;
        public String alias;
        private Certificate certificate;

        public CertificateData(Certificate certificate) {
            this.certificate = certificate;
            String nameStyle = "font-size:12px; font-weight: bold;";
            String issuerStyle = "font-size:8px;";
            String notBeforeAfterStyle = "font-size:8px; font-style:italic;";
            String certificateTypeStyle = "font-size:10px; font-weight: bold; color: #0066CC;";
            String certificateTypeText = "";
            if (this.certificate.getCertificatePersonType() != null) {
                String type = this.certificate.getCertificatePersonType();
                if ("PF".equals(type)) {
                    certificateTypeText = "<br/><span style='" + certificateTypeStyle + "'>[PESSOA F\u00cdSICA]</span>";
                } else if ("PJ".equals(type)) {
                    certificateTypeText = "<br/><span style='" + certificateTypeStyle + "'>[PESSOA JUR\u00cdDICA]</span>";
                } else if (!"DESCONHECIDO".equals(type)) {
                    certificateTypeText = "<br/><span style='" + certificateTypeStyle + "'>[" + type + "]</span>";
                }
            }
            String labelText = "<html><span style='" + nameStyle + "'>" + this.certificate.getCn() + "</span>" + certificateTypeText + "<br/><span style='" + issuerStyle + "'>(Expedido por " + ListCertificateData.this.getIssuer(this.certificate.getIssuer()) + ")</span><br/><span style='" + notBeforeAfterStyle + "'>V\u00e1lido de " + this.certificate.getNotBefore() + " at\u00e9 " + this.certificate.getNotAfter() + "</span>" + (this.certificate.isExpired() ? "<br/><span style='font-weight:bold;'>(EXPIRADO)</span>" : "") + "</html>";
            this.sentBy = new JRadioButton(labelText);
            this.sentBy.setEnabled(!this.certificate.isExpired());
            this.sentBy.setBackground(new Color(173, 216, 230));
            this.sentBy.setForeground(new Color(0, 0, 51));
            this.provider = new JLabel("<html><span style='font-size:8px;'>" + this.certificate.getProvider() + "</span></html>");
            this.provider.setBackground(new Color(173, 216, 230));
            this.provider.setForeground(new Color(0, 0, 51));
            this.alias = this.certificate.getAlias();
        }
    }
}

