/*
 * Decompiled with CFR 0.152.
 */
package org.demoiselle.signer.serpro.desktop.ui;

import java.awt.Component;
import java.awt.Container;
import java.awt.FocusTraversalPolicy;

public class FocusTraversalOnArray
extends FocusTraversalPolicy {
    private final Component[] m_Components;

    public FocusTraversalOnArray(Component[] components) {
        this.m_Components = components;
    }

    private int indexCycle(int index, int delta) {
        int size = this.m_Components.length;
        int next = (index + delta + size) % size;
        return next;
    }

    private Component cycle(Component currentComponent, int delta) {
        int newIndex;
        int index = -1;
        block0: for (int i = 0; i < this.m_Components.length; ++i) {
            Component component = this.m_Components[i];
            for (Component c = currentComponent; c != null; c = c.getParent()) {
                if (component != c) continue;
                index = i;
                break block0;
            }
        }
        int initialIndex = index;
        while ((newIndex = this.indexCycle(index, delta)) != initialIndex) {
            index = newIndex;
            Component component = this.m_Components[newIndex];
            if (!component.isEnabled() || !component.isVisible() || !component.isFocusable()) continue;
            return component;
        }
        return currentComponent;
    }

    @Override
    public Component getComponentAfter(Container container, Component component) {
        return this.cycle(component, 1);
    }

    @Override
    public Component getComponentBefore(Container container, Component component) {
        return this.cycle(component, -1);
    }

    @Override
    public Component getFirstComponent(Container container) {
        return this.m_Components[0];
    }

    @Override
    public Component getLastComponent(Container container) {
        return this.m_Components[this.m_Components.length - 1];
    }

    @Override
    public Component getDefaultComponent(Container container) {
        return this.getFirstComponent(container);
    }
}

