/*
 * Decompiled with CFR 0.152.
 */
package org.demoiselle.signer.serpro.desktop.ui;

import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.filechooser.FileNameExtensionFilter;
import org.apache.commons.io.FileUtils;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.PDPageTree;
import org.apache.pdfbox.rendering.PDFRenderer;
import org.demoiselle.signer.serpro.desktop.Main;
import org.demoiselle.signer.serpro.desktop.SerproSignerConfigurations;
import org.demoiselle.signer.serpro.desktop.command.signer.BatchSignatureContext;
import org.demoiselle.signer.serpro.desktop.command.signer.Sign;
import org.demoiselle.signer.serpro.desktop.command.signer.SignRequest;
import org.demoiselle.signer.serpro.desktop.command.xml.sign.RequestSignXML;
import org.demoiselle.signer.serpro.desktop.command.xml.sign.SignXML;
import org.demoiselle.signer.serpro.desktop.ui.ProgressBar;
import org.demoiselle.signer.serpro.desktop.ui.commons.BatchSelection;
import org.demoiselle.signer.serpro.desktop.ui.commons.SignerDialog;
import org.demoiselle.signer.serpro.desktop.ui.pdf.SignerPDF;
import org.demoiselle.signer.serpro.desktop.ui.pdf.SignerPDFITI;
import org.demoiselle.signer.serpro.desktop.utils.CertNotAfterWarn;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BatchSignature
extends JFrame {
    private static final long serialVersionUID = 1L;
    private static final Logger logger = LoggerFactory.getLogger(BatchSignature.class);
    transient PDPageTree pages;
    private int actualPage = 0;
    transient BufferedImage imagePage = null;
    transient BufferedImage imgStamp = null;
    int posX = 2000;
    int posY = 2000;
    transient PDDocument doc;
    private String policy = "RB";
    boolean isUsePBAD = false;
    private Date certExpDate = null;
    private boolean attached = false;
    private boolean detached = false;
    private int[] replaceStampPos = new int[]{-1, -1};
    private SerproSignerConfigurations configSigner = SerproSignerConfigurations.getInstance();

    public BatchSignature(String policy) throws Exception {
        try {
            if (policy != null) {
                this.policy = policy;
            }
            JFileChooser fileChooser = new JFileChooser();
            BatchSelection bs = this.policy.contentEquals("RV") ? new BatchSelection(false) : new BatchSelection(true);
            int op = bs.showSelectDialog();
            if (bs.getStampPosition()[0] > 0) {
                this.replaceStampPos = bs.getStampPosition();
            }
            switch (op) {
                case 1: {
                    fileChooser.setAcceptAllFileFilterUsed(false);
                    FileNameExtensionFilter filter = new FileNameExtensionFilter("pdf", "Pdf", "pDf", "pdF", "PDF", "pDF", "PdF", "PDf");
                    fileChooser.addChoosableFileFilter(filter);
                    break;
                }
                case 4: {
                    fileChooser.setAcceptAllFileFilterUsed(false);
                    FileNameExtensionFilter filterXML = new FileNameExtensionFilter("xml", "XML");
                    fileChooser.addChoosableFileFilter(filterXML);
                    break;
                }
                case -1: {
                    return;
                }
                case 2: {
                    this.attached = true;
                    break;
                }
                case 3: {
                    this.detached = true;
                    break;
                }
            }
            fileChooser.setMultiSelectionEnabled(true);
            int returnValue = fileChooser.showOpenDialog(null);
            if (returnValue == 0) {
                File[] files;
                for (File f : files = fileChooser.getSelectedFiles()) {
                    long fileLimite;
                    long fileSize = f.length();
                    if (fileSize <= (fileLimite = (long)(0x100000 * this.configSigner.getSizePDF()))) continue;
                    throw new Exception("O arquivo " + f.getName() + " \u00e9 maior que " + this.configSigner.getSizePDF() + " MB!\n Verifique suas configura\u00e7\u00f5es para definir um limite maior!");
                }
                this.startBatchSignature(files);
            }
        }
        catch (Exception error) {
            logger.error(error.getMessage());
            throw new RuntimeException(error.getMessage());
        }
    }

    public void startBatchSignature(File[] files) {
        int i;
        ArrayList<String> listErrors = new ArrayList<String>();
        ProgressBar pbBatch = new ProgressBar(files.length);
        Thread trBatch = new Thread(pbBatch);
        trBatch.start();
        BatchSignatureContext batchSignatureContext = new BatchSignatureContext();
        for (i = 0; i < files.length; ++i) {
            pbBatch.setQtPassed(i);
            String fileName = files[i].getAbsolutePath();
            files[i] = null;
            try {
                if (fileName.toLowerCase().endsWith("pdf") && !this.detached && !this.attached) {
                    this.makePDFSignature(fileName, batchSignatureContext);
                    continue;
                }
                if (fileName.toLowerCase().endsWith("xml") && !this.detached && !this.attached) {
                    this.makeXMLSignature(fileName, batchSignatureContext);
                    continue;
                }
                this.makeSignature(fileName, batchSignatureContext);
                continue;
            }
            catch (Exception e) {
                logger.error("Erro ao assinar o arquivo:" + fileName + "\n" + e.getMessage());
                listErrors.add("<span style='font-size:9px;'>" + i + "- Erro ao assinar o arquivo:<br>" + fileName + "<br> Erro:" + e.getMessage() + "<br>");
            }
        }
        pbBatch.dispose();
        trBatch.interrupt();
        if (!listErrors.isEmpty()) {
            logger.error("Ocorreram os seguintes erros: \n" + listErrors.toString());
            SignerDialog.showMessageDialog(null, "Ocorreram os seguintes erros: <br>" + listErrors.toString(), "Falha", 0);
        }
        if (i - listErrors.size() > 1) {
            SignerDialog.showMessageDialog(null, i - listErrors.size() + " arquivos assinados", "Sucesso", -1);
        } else if (i - listErrors.size() > 0) {
            SignerDialog.showMessageDialog(null, i - listErrors.size() + " arquivo assinado", "Sucesso", -1);
            CertNotAfterWarn.showWarn(this.certExpDate);
        }
    }

    private void signaturePosition() throws Exception {
        if (SerproSignerConfigurations.getInstance().isFixedStamp() && this.replaceStampPos[0] > 0) {
            int[] pos = this.replaceStampPos;
            this.posX = (int)((double)pos[0] * 2.54);
            this.posY = (int)((double)pos[1] * 2.54);
            return;
        }
        this.actualPage = this.doc.getNumberOfPages() - 1;
        PDFRenderer pdfRenderer = new PDFRenderer(this.doc);
        int STAMPW = 145;
        int STAMPH = 60;
        int color = 100;
        boolean ok = false;
        while (!ok && this.actualPage >= 0) {
            BufferedImage img = pdfRenderer.renderImage(this.actualPage);
            BufferedImage newImage = new BufferedImage(img.getWidth(), img.getHeight(), 4);
            Graphics2D g2d = newImage.createGraphics();
            g2d.drawImage((Image)img, 0, 0, null);
            int varPosX = newImage.getWidth() - 1;
            int varPosY = newImage.getHeight() - 1;
            int imgPosX = varPosX;
            int imgPosY = varPosY;
            for (int line = varPosY; line > 1; --line) {
                for (int colun = varPosX; colun > 1; --colun) {
                    for (int y = line; y > line - 60 && y > 1; --y) {
                        int val = colun - 145;
                        int x = colun;
                        while (x > val && val > 0 && x != 0) {
                            try {
                                color = newImage.getRGB(x, y);
                            }
                            catch (Exception e) {
                                logger.warn("valor de x: " + x + " e y: " + y);
                            }
                            if (color != -1) {
                                ok = false;
                                break;
                            }
                            imgPosX = x--;
                            imgPosY = y;
                            ok = true;
                        }
                        if (!ok) break;
                    }
                    if (!ok) continue;
                    this.posX = imgPosX;
                    this.posY = imgPosY;
                    pdfRenderer = null;
                    return;
                }
            }
            --this.actualPage;
            if (this.actualPage >= 0) continue;
            this.actualPage = this.doc.getNumberOfPages() - 1;
            this.posX = newImage.getWidth() - 1 - 145;
            this.posY = newImage.getHeight() - 1 - 60;
            return;
        }
        pdfRenderer = null;
    }

    private void makeSignature(String fileName, BatchSignatureContext batchSignatureContext) throws Exception {
        SignRequest request = new SignRequest();
        request.setType("file");
        request.setOutputDataType("file");
        request.setFileName(fileName);
        if (this.attached) {
            request.setAttached("true");
        }
        request.setSignaturePolicy(this.policy);
        Sign sign = new Sign();
        try {
            sign.doCommand(request, batchSignatureContext);
            this.certExpDate = sign.getCertExpDate();
        }
        catch (Exception e) {
            logger.error("Erro ao tentar assinar o documento" + fileName + "em lote \n" + e.getMessage(), e);
            throw new Exception("Erro ao tentar assinar o documento" + fileName + e.getMessage());
        }
    }

    private void makePDFSignature(String fileName, BatchSignatureContext batchSignatureContext) throws Exception {
        this.isUsePBAD = SerproSignerConfigurations.getInstance().isUsePBAD();
        this.loadFile(fileName);
        this.signaturePosition();
        SignerPDF sPDF = null;
        String outputFileName = fileName.replaceAll("(?i).pdf$", "-assinado.pdf");
        if (this.isUsePBAD) {
            this.doc.close();
            sPDF = new SignerPDFITI(fileName, outputFileName, this.actualPage, this.posX, this.posY, this.policy, batchSignatureContext);
            this.certExpDate = sPDF.getCertExpDate();
        } else {
            this.doc.close();
            sPDF = new SignerPDF(fileName, outputFileName, this.actualPage, this.posX, this.posY, this.policy, batchSignatureContext);
            this.certExpDate = sPDF.getCertExpDate();
        }
        File tmpFile = new File(fileName);
        if (tmpFile.delete()) {
            FileUtils.moveFile(new File(outputFileName), new File(fileName));
        }
    }

    private void makeXMLSignature(String fileName, BatchSignatureContext batchSignatureContext) throws Exception {
        RequestSignXML requestXML = new RequestSignXML();
        requestXML.setType("file");
        requestXML.setOutputDataType("file");
        requestXML.setFileName(fileName);
        requestXML.setSignaturePolicy(this.policy);
        SignXML signXML = new SignXML();
        try {
            signXML.doCommand(requestXML, batchSignatureContext);
            this.certExpDate = signXML.getCertExpDate();
        }
        catch (Exception e) {
            logger.error("Erro ao tentar assinar o documento " + fileName + " em lote \n" + e.getMessage(), e);
            throw new Exception("Erro ao tentar assinar o documento " + fileName + " em lote \n" + e.getMessage());
        }
    }

    private void loadFile(String fileName) throws IOException {
        File file = new File(fileName);
        try {
            Main.showLoadingScreen("");
            this.doc = PDDocument.load(file);
            this.setPages(this.doc.getPages());
        }
        finally {
            Main.hideLoadingScreen();
        }
    }

    public PDPageTree getPages() {
        return this.pages;
    }

    public void setPages(PDPageTree pages) {
        this.pages = pages;
    }

    public BufferedImage getImagePage() {
        return this.imagePage;
    }

    public void setImagePage(BufferedImage imagePage) {
        this.imagePage = imagePage;
    }

    public BufferedImage getImgStamp() {
        return this.imgStamp;
    }

    public void setImgStamp(BufferedImage imgStamp) {
        this.imgStamp = imgStamp;
    }

    public BatchSignature(File file) {
        try {
            this.doc = PDDocument.load(file);
            this.signaturePosition();
        }
        catch (Exception e) {
            logger.error(e.getMessage());
        }
        this.setPages(this.doc.getPages());
    }
}

