/*
 * Decompiled with CFR 0.152.
 */
package org.demoiselle.signer.serpro.desktop.statistics;

import com.google.gson.JsonObject;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.net.MalformedURLException;
import java.net.ProtocolException;
import java.net.URL;
import java.util.ResourceBundle;
import javax.net.ssl.HttpsURLConnection;
import org.demoiselle.signer.core.keystore.loader.configuration.Configuration;
import org.demoiselle.signer.serpro.desktop.AppVersion;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class Statistics
implements Runnable {
    private static ResourceBundle resourceBundle = ResourceBundle.getBundle("agent-desktop");
    private static final Logger logger = LoggerFactory.getLogger(Statistics.class);
    private static final String URL_BASE = resourceBundle.getString("urlStatistics") + "statistics";
    private final String UNKNOW = "";
    private boolean collecting = true;
    private String agent = "";
    private String origin = "desktop";
    private String type = "";
    private String version = AppVersion.VERSION;
    private String so = Configuration.getInstance().getSO().toLowerCase();
    private String token = "";
    private String caURL = "";
    private String algorithm = "";
    private String source = "desktop";
    private String signaturePolicy = "";
    private long lengthOriginalContent = 0L;
    private long lengthSignature = 0L;
    private String action = "signer";
    private long start = 0L;
    private long end = 0L;
    private boolean success = false;
    private String host = "desktop";
    private boolean isWeb = false;

    public Statistics() {
        this.clean();
    }

    public String toURL() {
        StringBuilder result = new StringBuilder();
        result.append("?");
        JsonObject jso = new JsonObject();
        if (this.end < 1L) {
            this.end = System.currentTimeMillis();
        }
        jso.addProperty("source", this.source);
        jso.addProperty("type", this.type);
        jso.addProperty("token", this.token);
        jso.addProperty("algorithm", this.algorithm);
        jso.addProperty("signaturePolicy", this.signaturePolicy);
        jso.addProperty("caURL", this.caURL);
        jso.addProperty("action", this.action);
        jso.addProperty("lengthOriginalContent", this.lengthOriginalContent);
        jso.addProperty("lengthSignature", this.lengthSignature);
        jso.addProperty("start", this.start);
        jso.addProperty("end", this.end);
        jso.addProperty("version", this.version);
        jso.addProperty("so", this.so);
        jso.addProperty("success", this.success);
        jso.addProperty("origin", this.origin);
        jso.addProperty("agent", this.agent);
        jso.addProperty("host", this.host);
        return jso.toString();
    }

    public void clean() {
        this.type = "";
        this.token = "";
        this.caURL = "";
        this.algorithm = "";
        this.signaturePolicy = "";
        this.lengthOriginalContent = 0L;
        this.lengthSignature = 0L;
        this.action = "signer";
        this.start = 0L;
        this.end = 0L;
        this.success = false;
        this.origin = "desktop";
        this.host = "desktop";
        this.version = AppVersion.VERSION;
        this.so = Configuration.getInstance().getSO().toLowerCase();
        this.source = "desktop";
    }

    public void doCollect() {
        String mainOrigin = this.origin;
        if (!this.isWeb) {
            this.origin = "desktop";
        }
        this.collect();
        this.origin = mainOrigin;
    }

    private void collect() {
        if (this.isCollecting()) {
            String statURL = URL_BASE;
            try {
                URL url = new URL(statURL);
                HttpsURLConnection urlConn = (HttpsURLConnection)url.openConnection();
                urlConn.setDoOutput(true);
                urlConn.setRequestMethod("POST");
                urlConn.setRequestProperty("Content-Type", "application/json; charset=utf-8");
                urlConn.setReadTimeout(30000);
                urlConn.connect();
                OutputStreamWriter osw = new OutputStreamWriter(urlConn.getOutputStream());
                osw.write(this.toURL());
                osw.close();
                if (urlConn.getResponseCode() != 200) {
                    logger.debug("Erro " + urlConn.getResponseCode() + " ao enviar estat\u00edsticas para: " + statURL);
                }
            }
            catch (MalformedURLException e) {
                logger.warn(e.getMessage());
            }
            catch (ProtocolException e) {
                logger.warn(e.getMessage());
            }
            catch (IOException e) {
                logger.warn(e.getMessage());
            }
            catch (Exception e) {
                logger.warn(e.getMessage());
            }
        }
    }

    public boolean isCollecting() {
        return this.collecting;
    }

    public void setCollecting(boolean collecting) {
        this.collecting = collecting;
    }

    public String getAgent() {
        return this.agent;
    }

    public void setAgent(String agent) {
        this.agent = agent;
    }

    public String getOrigin() {
        return this.origin;
    }

    public void setOrigin(String origin) {
        this.origin = origin;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public String getSo() {
        return this.so;
    }

    public void setSo(String so) {
        this.so = so;
    }

    public String getToken() {
        return this.token;
    }

    public void setToken(String token) {
        this.token = token;
    }

    public String getCaURL() {
        return this.caURL;
    }

    public void setCaURL(String caURL) {
        this.caURL = caURL;
    }

    public String getAlgorithm() {
        return this.algorithm;
    }

    public void setAlgorithm(String algorithm) {
        this.algorithm = algorithm;
    }

    public String getSource() {
        return this.source;
    }

    public void setSource(String source) {
        this.source = source;
    }

    public String getSignaturePolicy() {
        return this.signaturePolicy;
    }

    public void setSignaturePolicy(String signaturePolicy) {
        this.signaturePolicy = signaturePolicy;
    }

    public long getLengthOriginalContent() {
        return this.lengthOriginalContent;
    }

    public void setLengthOriginalContent(long lengthOriginalContent) {
        this.lengthOriginalContent = lengthOriginalContent;
    }

    public long getLengthSignature() {
        return this.lengthSignature;
    }

    public void setLengthSignature(long lengthSignature) {
        this.lengthSignature = lengthSignature;
    }

    public String getAction() {
        return this.action;
    }

    public void setAction(String action) {
        this.action = action;
    }

    public long getStart() {
        return this.start;
    }

    public void setStart(long start) {
        this.start = start;
    }

    public long getEnd() {
        return this.end;
    }

    public void setEnd(long end) {
        this.end = end;
    }

    public boolean isSuccess() {
        return this.success;
    }

    public void setSuccess(boolean success) {
        this.success = success;
    }

    public String getHost() {
        return this.host;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public boolean isWeb() {
        return this.isWeb;
    }

    public void setWeb(boolean isWeb) {
        this.isWeb = isWeb;
    }

    @Override
    public void run() {
        this.doCollect();
    }
}

