/*
 * Decompiled with CFR 0.152.
 */
package org.demoiselle.signer.serpro.desktop.pkcs11info;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.demoiselle.signer.core.extension.BasicCertificate;
import org.demoiselle.signer.core.extension.CertificateExtra;
import org.demoiselle.signer.core.keystore.loader.configuration.Configuration;
import org.demoiselle.signer.serpro.desktop.pkcs11info.DeviceInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import sun.security.pkcs11.wrapper.CK_ATTRIBUTE;
import sun.security.pkcs11.wrapper.CK_C_INITIALIZE_ARGS;
import sun.security.pkcs11.wrapper.CK_TOKEN_INFO;
import sun.security.pkcs11.wrapper.PKCS11;
import sun.security.pkcs11.wrapper.PKCS11Exception;

public class LoadLib {
    private Hashtable<Long, Map<String, String>> tokenInfo = new Hashtable();
    private Hashtable<Long, List<String>> certificateAlias;
    private List<DeviceInfo> devicesInfo = new ArrayList<DeviceInfo>();
    private HashMap<String, String> tokenImages = new HashMap();
    private static final Logger logger = LoggerFactory.getLogger(LoadLib.class);
    List<HashMap<String, String>> certificateInfo;

    public static void main(String[] args) throws CertificateException {
        for (DeviceInfo di : new LoadLib().getDevicesInfo()) {
            System.out.println(di.getDriver() + ", " + di.getLabel() + "," + di.getModel());
        }
    }

    public String getTokenImage(String driver) {
        if (!this.tokenImages.containsKey(driver)) {
            return "no_image.png";
        }
        return this.tokenImages.get(driver);
    }

    private void loadImages() {
        String winRoot = System.getenv("SystemRoot") == null ? "" : System.getenv("SystemRoot").replaceAll("\\\\", "/");
        this.tokenImages.put(winRoot.concat("/system32/ngp11v211.dll"), "no_image.png");
        this.tokenImages.put(winRoot.concat("/system32/aetpkss1.dll"), "GDBurtiSuporte3.png");
        this.tokenImages.put(winRoot.concat("/system32/gclib.dll"), "no_image.png");
        this.tokenImages.put(winRoot.concat("/system32/pk2priv.dll"), "no_image.png");
        this.tokenImages.put(winRoot.concat("/system32/w32pk2ig.dll"), "no_image.png");
        this.tokenImages.put(winRoot.concat("/system32/eTPkcs11.dll"), "no_image.png");
        this.tokenImages.put(winRoot.concat("/system32/dkck201.dll"), "no_image.png");
        this.tokenImages.put(winRoot.concat("/system32/dkck201.dll"), "no_image.png");
        this.tokenImages.put(winRoot.concat("/system32/dkck232.dll"), "no_image.png");
        this.tokenImages.put(winRoot.concat("/system32/cryptoki22.dll"), "no_image.png");
        this.tokenImages.put(winRoot.concat("/system32/slbck.dll"), "no_image.png");
        this.tokenImages.put(winRoot.concat("/system32/cmP11.dll"), "no_image.png");
        this.tokenImages.put(winRoot.concat("/system32/WDPKCS.dll"), "no_image.png");
        this.tokenImages.put(winRoot.concat("/System32/Watchdata/Watchdata Brazil CSP v1.0/WDPKCS.dll"), "token_serpro.png");
        this.tokenImages.put("/Arquivos de programas/Gemplus/GemSafe Libraries/BIN/gclib.dll", "no_image.png");
        this.tokenImages.put("/Program Files/Gemplus/GemSafe Libraries/BIN/gclib.dll", "no_image.png");
        this.tokenImages.put(winRoot.concat("/System32/WDICP_P11_CCID_v34.dll"), "no_image.png");
        this.tokenImages.put(winRoot.concat("/SysWOW64/WDICP_P11_CCID_v34.dll"), "no_image.png");
        this.tokenImages.put(winRoot.concat("/Program File (x86)/Oberthur Technologies/AWP/DLLs/OcsCryptoki.dll"), "no_image.png");
        this.tokenImages.put("/usr/lib/libaetpkss.so", "GDBurtiSuporte3.png");
        this.tokenImages.put("/usr/lib/libgpkcs11.so", "token-aladdin.png");
        this.tokenImages.put("/usr/lib/libgpkcs11.so.2", "no_image.png");
        this.tokenImages.put("/usr/lib/libepsng_p11.so", "ePass2003.png");
        this.tokenImages.put("usr/lib/libepsng_p11.so.1", "ePass2003.png");
        this.tokenImages.put("/usr/local/ngsrv/libepsng_p11.so.1", "ePass2003.png");
        this.tokenImages.put("/usr/lib/libeTPkcs11.so", "etoken5100.png");
        this.tokenImages.put("/usr/lib/libeToken.so", "etoken5100.png");
        this.tokenImages.put("/usr/lib/libcmP11.so", "etoken.png");
        this.tokenImages.put("/usr/lib/libwdpkcs.so", "etoken.png");
        this.tokenImages.put("/usr/local/lib64/libwdpkcs.so", "etoken.png");
        this.tokenImages.put("/usr/local/lib/libwdpkcs.so", "etoken.png");
        this.tokenImages.put("/usr/lib/watchdata/ICP/lib/libwdpkcs_icp.so", "token_serpro.png");
        this.tokenImages.put("/usr/lib/watchdata/lib/libwdpkcs.so", "token_serpro.png");
        this.tokenImages.put("/opt/watchdata/lib64/libwdpkcs.so", "token_serpro.png");
        this.tokenImages.put("/usr/lib/opensc-pkcs11.so", "no_image.png");
        this.tokenImages.put("/usr/lib/pkcs11/opensc-pkcs11.so", "no_image.png");
        this.tokenImages.put("/usr/local/ngsrv/libepsng_p11.so.1.2.2", "no_image.png");
        this.tokenImages.put("/usr/local/AWP/lib/libOcsCryptoki.so", "oberthur.png");
        this.tokenImages.put("/usr/lib/libwdpkcs.dylib", "no_image.png");
        this.tokenImages.put("/usr/local/lib/libwdpkcs.dylib", "no_image.png");
        this.tokenImages.put("//Applications//WatchKey USB Token Admin Tool.app//Contents//MacOS//lib//libWDP11_BR_GOV.dylib", "no_image.png");
        this.tokenImages.put("//usr//local//lib//libetpkcs11.dylib", "no_image.png");
        this.tokenImages.put("//usr//local//lib//libaetpkss.dylib", "GDBurtiSuporte3.png");
        this.tokenImages.put(winRoot.concat("/system32/SerproPkcs11.dll"), "neoid.png");
        this.tokenImages.put("/usr/lib/libneoidp11.so", "neoid.png");
        this.tokenImages.put("//Applications//NeoID Desktop.app//Contents//Java//tools//macos//libneoidp11.dylib", "neoid.png");
        this.tokenImages.put("//usr/lib64/libeToken.so", "no_image.png");
        this.tokenImages.put("/opt/ePass2003-Castle-20141128/i386/redist/libcastle.so.1.0.0", "no_image.png");
    }

    public LoadLib() throws CertificateException {
        Iterator<Map.Entry<String, String>> it = Configuration.getInstance().getDrivers().entrySet().iterator();
        this.loadImages();
        ArrayList<String> alreadyLoad = new ArrayList<String>();
        while (it.hasNext()) {
            Map.Entry<String, String> item = it.next();
            if (alreadyLoad.contains(item.getValue())) continue;
            alreadyLoad.add(item.getValue());
            this.certificateInfo = new ArrayList<HashMap<String, String>>();
            this.certificateAlias = new Hashtable();
            this.Load(item.getValue());
            List<Long> slots = this.getSlots();
            if (slots.isEmpty()) continue;
            for (Long s : slots) {
                boolean register = true;
                DeviceInfo device = new DeviceInfo();
                device.setDriver(item.getValue());
                device.setSlot(s);
                device.setLabel(this.getTokenInfo().get(s).get("label"));
                device.setModel(this.getTokenInfo().get(s).get("model"));
                device.setSerial(this.getTokenInfo().get(s).get("serial"));
                device.setCertificates(this.certificateAlias.get(s));
                device.setCertificatesInfo(this.certificateInfo);
                for (DeviceInfo di : this.devicesInfo) {
                    if (!di.getSerial().equals(device.getSerial())) continue;
                    register = false;
                    break;
                }
                if (!register) continue;
                this.devicesInfo.add(device);
            }
            this.tokenInfo = new Hashtable();
        }
    }

    public List<DeviceInfo> getDevicesInfo() {
        return this.devicesInfo;
    }

    public void Load(String driver) throws CertificateException {
        CK_C_INITIALIZE_ARGS pInitArgs = new CK_C_INITIALIZE_ARGS();
        long[] list = null;
        CK_ATTRIBUTE[] attrs = new CK_ATTRIBUTE[1];
        CK_ATTRIBUTE attr = new CK_ATTRIBUTE();
        CK_TOKEN_INFO ckti = null;
        try {
            PKCS11 pk = PKCS11.getInstance(driver, "C_GetFunctionList", pInitArgs, false);
            try {
                list = pk.C_GetSlotList(true);
            }
            catch (Exception e) {
                logger.error("Get token certificate: " + driver + " : " + e.getMessage());
                return;
            }
            if (list.length < 1) {
                return;
            }
            try {
                pk.C_GetMechanismList(list[0]);
            }
            catch (Exception e) {
                logger.error("Get token certificate: " + driver + " : " + e.getMessage());
                return;
            }
            for (long token : list) {
                ckti = pk.C_GetTokenInfo(token);
                HashMap<String, String> tokenAttributes = new HashMap<String, String>();
                tokenAttributes.put("label", new String(ckti.label).trim());
                tokenAttributes.put("model", new String(ckti.model).trim());
                tokenAttributes.put("serial", new String(ckti.serialNumber).trim());
                this.tokenInfo.put(token, tokenAttributes);
                long session = pk.C_OpenSession(token, 4L, null, null);
                attr = new CK_ATTRIBUTE();
                attrs = new CK_ATTRIBUTE[1];
                attr.type = 1L;
                attr.pValue = 1L;
                attrs[0] = attr;
                try {
                    pk.C_FindObjectsInit(session, attrs);
                }
                catch (PKCS11Exception e) {
                    logger.error(e.getMessage());
                    return;
                }
                long[] certs = pk.C_FindObjects(session, 999L);
                this.certificateAlias.put(token, new ArrayList());
                for (long l : certs) {
                    int a;
                    HashMap<String, String> hm = new HashMap<String, String>();
                    CK_ATTRIBUTE[] alias = new CK_ATTRIBUTE[]{new CK_ATTRIBUTE(3L), new CK_ATTRIBUTE(1L)};
                    pk.C_GetAttributeValue(session, l, alias);
                    for (a = 0; a < alias.length; ++a) {
                        if (alias[a].type != 3L || alias[a].pValue == null || this.certificateAlias.get(token).contains(new String((char[])alias[a].pValue).trim())) continue;
                        this.certificateAlias.get(token).add(new String((char[])alias[a].pValue).trim());
                    }
                    if (alias[0].pValue == null) continue;
                    alias = new CK_ATTRIBUTE[]{new CK_ATTRIBUTE(17L)};
                    try {
                        pk.C_GetAttributeValue(session, l, alias);
                    }
                    catch (PKCS11Exception e) {
                        e.printStackTrace();
                        continue;
                    }
                    for (a = 0; a < alias.length; ++a) {
                        byte[] x509 = (byte[])alias[a].pValue;
                        if (x509 == null) continue;
                        CertificateFactory certFactory = CertificateFactory.getInstance("X.509");
                        Certificate cert = certFactory.generateCertificate(new ByteArrayInputStream(x509));
                        BasicCertificate bc = new BasicCertificate((X509Certificate)cert);
                        CertificateExtra ce = new CertificateExtra((X509Certificate)cert);
                        hm.put("docName", bc.getName());
                        if (bc.hasCertificatePF()) {
                            hm.put("docNumber", ce.getOID_2_16_76_1_3_1().getCPF());
                            continue;
                        }
                        if (!bc.hasCertificatePJ()) continue;
                        hm.put("docNumber", ce.getOID_2_16_76_1_3_3().getCNPJ());
                    }
                    if (hm.isEmpty()) continue;
                    this.certificateInfo.add(hm);
                    hm.put("driver", driver);
                }
                pk.C_FindObjectsFinal(session);
            }
        }
        catch (IOException | PKCS11Exception e) {
            e.printStackTrace();
        }
    }

    private List<Long> getSlots() {
        return Collections.list(this.tokenInfo.keys());
    }

    private Hashtable<Long, Map<String, String>> getTokenInfo() {
        return this.tokenInfo;
    }
}

