/*
 * Decompiled with CFR 0.152.
 */
package org.demoiselle.signer.serpro.desktop.pkcs11info;

import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.List;
import javax.imageio.ImageIO;
import javax.swing.AbstractAction;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.KeyStroke;
import org.demoiselle.signer.serpro.desktop.pkcs11info.DeviceInfo;
import org.demoiselle.signer.serpro.desktop.pkcs11info.LoadLib;

public class ListCertificateDevices
extends JDialog {
    private String driver;
    public static List<String> drivers;
    private static final long serialVersionUID = 1L;
    private boolean selected = false;
    private String label;
    List<DeviceInfo> di;
    LoadLib loadLib;
    HashMap<JRadioButton, DeviceInfo> diButtons = new HashMap();

    public ListCertificateDevices(LoadLib loadLib) {
        this.loadLib = loadLib;
        this.di = loadLib.getDevicesInfo();
    }

    public void init() {
        this.initUI();
        this.setVisible(true);
    }

    private void initUI() {
        this.setTitle("Sele\u00e7\u00e3o de Certificado");
        this.setSize(700, 330);
        this.setLocationRelativeTo(null);
        this.setForeground(new Color(0, 0, 51));
        this.setBackground(new Color(173, 216, 230));
        this.setAlwaysOnTop(true);
        this.setLayout(null);
        this.setResizable(false);
        final ListCertificateDevices me = this;
        JPanel pane = (JPanel)this.getContentPane();
        pane.setForeground(new Color(0, 0, 51));
        pane.setBackground(new Color(173, 216, 230));
        JLabel title = new JLabel("<html><span style='font-size:15px;'>Selecione o dispositivo</span></html>");
        title.setForeground(new Color(0, 0, 51));
        title.setBackground(new Color(173, 216, 230));
        JButton btnValidate = new JButton("Selecionar");
        btnValidate.setBackground(Color.GREEN);
        btnValidate.setBorderPainted(true);
        btnValidate.setFocusPainted(true);
        btnValidate.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent e) {
                ListCertificateDevices.this.setCursor(new Cursor(12));
            }

            @Override
            public void mouseExited(MouseEvent e) {
                ListCertificateDevices.this.setCursor(new Cursor(0));
            }
        });
        JButton btnCancel = new JButton("Cancelar");
        btnCancel.setBackground(Color.RED);
        btnCancel.setBorderPainted(true);
        btnCancel.setFocusPainted(true);
        btnCancel.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent e) {
                ListCertificateDevices.this.setCursor(new Cursor(12));
            }

            @Override
            public void mouseExited(MouseEvent e) {
                ListCertificateDevices.this.setCursor(new Cursor(0));
            }
        });
        pane.setBackground(new Color(0xFFFFFF));
        JPanel panelScroll = new JPanel(new GridBagLayout());
        panelScroll.setForeground(new Color(0, 0, 51));
        panelScroll.setBackground(new Color(173, 216, 230));
        GridBagConstraints c = new GridBagConstraints();
        ButtonGroup bg = new ButtonGroup();
        panelScroll.setBackground(new Color(0xFFFFFF));
        panelScroll.setForeground(new Color(0, 0, 51));
        panelScroll.setBackground(new Color(173, 216, 230));
        int i = 0;
        while (i < this.di.size()) {
            JRadioButton btn = new JRadioButton(this.di.get(i).getLabel() + " : " + this.di.get(i).getModel());
            btn.setForeground(new Color(0, 0, 51));
            btn.setBackground(new Color(173, 216, 230));
            bg.add(btn);
            this.diButtons.put(btn, this.di.get(i));
            JLabel picLabel = new JLabel("");
            try {
                String img = this.loadLib.getTokenImage(this.di.get(i).getDriver());
                BufferedImage myPicture = ImageIO.read(this.getClass().getClassLoader().getResource("images/e_tokens/" + img));
                picLabel.setIcon(new ImageIcon(new ImageIcon(myPicture).getImage().getScaledInstance(30, 30, 1)));
                picLabel.setBackground(new Color(0xFFFFFF));
            }
            catch (IOException e1) {
                e1.printStackTrace();
            }
            c.weightx = 0.5;
            c.gridy = i;
            c.gridx = 0;
            c.anchor = 17;
            panelScroll.add((Component)btn, c);
            c.weightx = 1.5;
            c.gridy = i++;
            c.gridx = 1;
            panelScroll.add((Component)picLabel, c);
        }
        JScrollPane scrollPane = new JScrollPane(panelScroll);
        scrollPane.setBounds(20, 45, 660, 180);
        this.setForeground(new Color(0, 0, 51));
        this.setBackground(new Color(173, 216, 230));
        pane.add(scrollPane);
        pane.add(title);
        pane.add(btnValidate);
        pane.add(btnCancel);
        title.setBounds(22, 10, 500, 25);
        btnCancel.setBounds(this.getWidth() - 270, this.getHeight() - 80, 120, 30);
        btnValidate.setBounds(this.getWidth() - 140, this.getHeight() - 80, 120, 30);
        btnCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                me.dispose();
            }
        });
        btnValidate.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                for (JRadioButton jb : ListCertificateDevices.this.diButtons.keySet()) {
                    if (!jb.isSelected()) continue;
                    me.driver = ListCertificateDevices.this.diButtons.get(jb).getDriver();
                    me.label = ListCertificateDevices.this.diButtons.get(jb).getLabel();
                    ListCertificateDevices.this.setSelected(true);
                    me.dispose();
                }
            }
        });
        this.getRootPane().setDefaultButton(btnValidate);
        AbstractAction escapeAction = new AbstractAction(){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent e) {
                ListCertificateDevices.this.dispose();
            }
        };
        this.getRootPane().getInputMap(2).put(KeyStroke.getKeyStroke(27, 0), "ESCAPE_KEY");
        this.getRootPane().getActionMap().put("ESCAPE_KEY", escapeAction);
        BufferedImage imgLogoSerpro = null;
        InputStream path = this.getClass().getClassLoader().getResourceAsStream("images/logo_serpro_min.png");
        try {
            imgLogoSerpro = ImageIO.read(path);
        }
        catch (IOException e1) {
            e1.printStackTrace();
        }
        ImageIcon icon = new ImageIcon(imgLogoSerpro);
        JLabel lblImg = new JLabel(icon);
        lblImg.setBounds(20, this.getHeight() - 80, 70, 30);
        pane.add(lblImg);
        this.setModal(true);
    }

    public String getDriver() {
        return this.driver;
    }

    public boolean isSelected() {
        return this.selected;
    }

    public void setSelected(boolean selected) {
        this.selected = selected;
    }

    public String getLabel() {
        return this.label;
    }

    public void setLabel(String label) {
        this.label = label;
    }
}

