/*
 * Decompiled with CFR 0.152.
 */
package org.demoiselle.signer.serpro.desktop.pkcs11info;

import java.security.KeyStore;
import java.security.cert.CertificateException;
import java.util.ArrayList;
import java.util.List;
import org.demoiselle.signer.core.keystore.loader.InvalidPinException;
import org.demoiselle.signer.core.keystore.loader.KeyStoreLoader;
import org.demoiselle.signer.core.keystore.loader.KeyStoreLoaderException;
import org.demoiselle.signer.core.keystore.loader.factory.KeyStoreLoaderFactory;
import org.demoiselle.signer.core.keystore.loader.implementation.DriverKeyStoreLoader;
import org.demoiselle.signer.serpro.desktop.Main;
import org.demoiselle.signer.serpro.desktop.SerproSignerConfigurations;
import org.demoiselle.signer.serpro.desktop.command.signer.BatchSignatureContext;
import org.demoiselle.signer.serpro.desktop.exception.ActionCanceledException;
import org.demoiselle.signer.serpro.desktop.pkcs11info.ListCertificateDevices;
import org.demoiselle.signer.serpro.desktop.pkcs11info.LoadLib;
import org.demoiselle.signer.serpro.desktop.ui.PinHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KeystoreSelection {
    private static final Logger logger = LoggerFactory.getLogger(KeystoreSelection.class);
    private KeyStoreLoader loader;
    private KeyStore keyStore;

    public KeystoreSelection(PinHandler pinToken) throws CertificateException, ActionCanceledException {
        this.getKeystoreSelection(pinToken, null);
    }

    public KeystoreSelection(PinHandler pinToken, BatchSignatureContext batchSignatureContext) throws CertificateException, ActionCanceledException {
        this.getKeystoreSelection(pinToken, batchSignatureContext);
    }

    private void getKeystoreSelection(PinHandler pinToken, BatchSignatureContext batchSignatureContext) throws CertificateException, ActionCanceledException {
        LoadLib loadLib = null;
        List<Object> di = new ArrayList();
        if (SerproSignerConfigurations.getInstance().isMsCAPIOff()) {
            loadLib = new LoadLib();
            di = loadLib.getDevicesInfo();
        }
        this.loader = KeyStoreLoaderFactory.factoryKeyStoreLoader();
        if (SerproSignerConfigurations.getInstance().isMsCAPIOff() && di.size() > 1) {
            if (batchSignatureContext != null && batchSignatureContext.isKeyStoreSelected()) {
                this.keyStore = ((DriverKeyStoreLoader)this.loader).getKeyStoreFromDriver(batchSignatureContext.getKeyStore());
                return;
            }
            ListCertificateDevices dialog = new ListCertificateDevices(loadLib);
            dialog.init();
            String driver = dialog.getDriver();
            if (driver == null) {
                this.loader = null;
                return;
            }
            pinToken.setCertificateAlias(dialog.getLabel());
            this.loader.setCallbackHandler(pinToken);
            Main.hideLoadingScreen();
            this.keyStore = ((DriverKeyStoreLoader)this.loader).getKeyStoreFromDriver(driver);
            if (batchSignatureContext != null && !batchSignatureContext.isKeyStoreSelected()) {
                batchSignatureContext.setKeyStore(driver);
            }
        } else {
            Main.hideLoadingScreen();
            KeyStoreLoaderException ex = null;
            try {
                this.loader.setCallbackHandler(pinToken);
                this.keyStore = this.loader.getKeyStore();
            }
            catch (InvalidPinException ip) {
                throw new RuntimeException(ip.getMessage());
            }
            catch (KeyStoreLoaderException e) {
                ex = e;
            }
            if (pinToken.getActionCanceled()) {
                throw new ActionCanceledException();
            }
            if (this.keyStore == null) {
                if (ex != null) {
                    logger.error("Erro grave", ex);
                }
                throw new RuntimeException("Ocorreu um erro ao acessar o token, verifique se esta conectado ao computador.");
            }
        }
    }

    public KeyStoreLoader getKeyStoreLoader() throws Exception {
        if (this.loader == null) {
            throw new RuntimeException("A\u00e7\u00e3o cancelada pelo usu\u00e1rio");
        }
        return this.loader;
    }

    public KeyStore getKeyStore() {
        return this.keyStore;
    }
}

