/*
 * Decompiled with CFR 0.152.
 */
package org.demoiselle.signer.serpro.desktop.crypto;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.security.GeneralSecurityException;
import java.security.InvalidKeyException;
import java.security.KeyFactory;
import java.security.KeyStore;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.cert.X509Certificate;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.X509EncodedKeySpec;
import java.util.List;
import javax.crypto.Cipher;
import javax.crypto.CipherInputStream;
import javax.crypto.CipherOutputStream;
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;
import javax.swing.JOptionPane;
import org.bouncycastle.util.encoders.Base64;
import org.demoiselle.signer.core.extension.BasicCertificate;
import org.demoiselle.signer.policy.impl.cades.SignatureInformations;
import org.demoiselle.signer.policy.impl.cades.pkcs7.impl.CAdESChecker;
import org.demoiselle.signer.serpro.desktop.Main;
import org.demoiselle.signer.serpro.desktop.cert.CertitficateHelper;
import org.demoiselle.signer.serpro.desktop.command.crypto.CryptoCommand;
import org.demoiselle.signer.serpro.desktop.command.crypto.CryptoRequest;
import org.demoiselle.signer.serpro.desktop.command.signer.Sign;
import org.demoiselle.signer.serpro.desktop.command.signer.SignRequest;
import org.demoiselle.signer.serpro.desktop.command.signer.SignResponse;
import org.demoiselle.signer.serpro.desktop.pkcs11info.KeystoreSelection;
import org.demoiselle.signer.serpro.desktop.ui.PinHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EncrypDecrypt {
    PublicKey pubKey = null;
    PrivateKey privateKey = null;
    final int keySize = 2048;
    public static final int AES_Key_Size = 128;
    private static final Logger logger = LoggerFactory.getLogger(EncrypDecrypt.class);

    public static void main(String[] args) throws IOException, GeneralSecurityException {
    }

    public void decryptFile(File in, File out) throws Throwable {
        RandomAccessFile f = new RandomAccessFile(in, "rw");
        f.seek(f.length() - 4L);
        long keySize = f.readInt();
        f.seek(f.length() - (keySize + 4L));
        if (keySize < 0L) {
            JOptionPane.showMessageDialog(null, "Arquivo n\u00e3o cont\u00e9m informa\u00e7\u00f5es protegidas", "Erro", 0);
            f.close();
            return;
        }
        byte[] key = new byte[(int)keySize];
        f.read(key);
        CAdESChecker checker = new CAdESChecker();
        byte[] attachedRSA = checker.getAttached(key, false).getExtractedContent();
        List<SignatureInformations> allValues = null;
        try {
            allValues = checker.checkAttachedSignature(key);
            X509Certificate cert = allValues.get(0).getChain().getFirst();
            BasicCertificate bc = new BasicCertificate(cert);
            int confirm = JOptionPane.showConfirmDialog(null, "Este aquivo foi gerado por: " + bc.getName() + " a informa\u00e7\u00e3o est\u00e1 correta?", "Confirma\u00e7\u00e3o", 0);
            if (confirm == 1) {
                f.close();
                return;
            }
            Main.showLoadingScreen("");
        }
        catch (Exception e) {
            logger.error(e.getMessage());
            JOptionPane.showMessageDialog(null, "Erro ao validar o arquivo", "Erro", 0);
            f.close();
            return;
        }
        byte[] aesKey = new CryptoCommand().decriptByte(Base64.toBase64String(attachedRSA), new CryptoRequest().getAlgotithm());
        Cipher aesCipher = Cipher.getInstance("AES");
        SecretKeySpec aeskeySpec = new SecretKeySpec(aesKey, "AES");
        try {
            aesCipher.init(2, aeskeySpec);
        }
        catch (InvalidKeyException e) {
            logger.error(e.getMessage());
            JOptionPane.showMessageDialog(null, "Este arquivo n\u00e3o foi gerado para sua chave", "Erro", 0);
            f.close();
            return;
        }
        f.setLength(f.length() - (keySize + 4L));
        f.close();
        CipherInputStream is = new CipherInputStream(new FileInputStream(in), aesCipher);
        FileOutputStream os = new FileOutputStream(out);
        this.copy(is, os);
        is.close();
        os.close();
        f = new RandomAccessFile(in, "rw");
        f.seek(f.length());
        f.write(key);
        f.writeInt(key.length);
        f.close();
        JOptionPane.showMessageDialog(null, "Arquivo gerado em " + out.getAbsolutePath(), "Sucesso", 1);
    }

    public void cryptFile(File in, File out, PublicKey pk) throws Throwable {
        byte[] aesKey = this.makeKey();
        SecretKeySpec aeskeySpec = new SecretKeySpec(aesKey, "AES");
        Cipher aesCipher = Cipher.getInstance("AES");
        aesCipher.init(1, aeskeySpec);
        CryptoCommand crypto = new CryptoCommand();
        byte[] RSAKey = crypto.encript(Base64.toBase64String(aesKey), new CryptoRequest().getAlgotithm(), pk);
        SignRequest request = new SignRequest();
        request.setType("text");
        request.setOutputDataType("text");
        byte[] signadFile = null;
        try {
            signadFile = this.makeSignatureFile(RSAKey, "Arquivo seguro");
        }
        catch (Throwable e) {
            logger.info(e.getMessage());
        }
        if (signadFile.length <= 0) {
            return;
        }
        FileInputStream is = new FileInputStream(in);
        CipherOutputStream os = new CipherOutputStream(new FileOutputStream(out), aesCipher);
        this.copy(is, os);
        os.close();
        RandomAccessFile f = new RandomAccessFile(out, "rw");
        byte[] data = new byte[(int)f.length()];
        f.read(data);
        f.seek(f.length());
        f.write(signadFile);
        f.writeInt(signadFile.length);
        f.close();
    }

    private void copy(InputStream is, OutputStream os) throws IOException {
        int i;
        byte[] b = new byte[1024];
        while ((i = is.read(b)) != -1) {
            os.write(b, 0, i);
        }
    }

    public byte[] makeKey() throws NoSuchAlgorithmException {
        KeyGenerator kgen = KeyGenerator.getInstance("AES");
        kgen.init(128);
        SecretKey key = kgen.generateKey();
        byte[] aesKey = key.getEncoded();
        return aesKey;
    }

    private byte[] makeSignatureFile(byte[] inputData, String pinHandlerInfo) throws Throwable {
        SignRequest request = new SignRequest();
        request.setType("securefile");
        request.setAttached("true");
        request.setInputData(Base64.toBase64String(inputData));
        Sign sign = new Sign();
        SignResponse resp = null;
        resp = sign.doCommand(request);
        if (resp.getActionCanceled()) {
            throw new Exception("Ac\u00e3o cancelada pelo usu\u00e1rio");
        }
        return Base64.decode(resp.getSignature());
    }

    public PublicKey getPublicKeyFromBase64(String publicPem) throws IOException, NoSuchAlgorithmException, InvalidKeySpecException {
        KeyFactory factory = KeyFactory.getInstance("RSA");
        System.out.println(publicPem);
        byte[] publicBytes = Base64.decode(publicPem.getBytes());
        X509EncodedKeySpec ks = new X509EncodedKeySpec(publicBytes);
        return factory.generatePublic(ks);
    }

    public String exportPublicKey() throws Throwable {
        KeyStore keyStore = null;
        PinHandler pinToken = new PinHandler("", "");
        KeystoreSelection ks = new KeystoreSelection(pinToken);
        keyStore = ks.getKeyStore();
        if (keyStore == null) {
            return null;
        }
        CryptoCommand cc = new CryptoCommand();
        String aliasUsado = cc.getAlias("", keyStore);
        PublicKey publicKey = keyStore.getCertificate(aliasUsado).getPublicKey();
        String fileName = this.generateSignatureCertificateFile(publicKey.getEncoded(), CertitficateHelper.USER_HOME_DIR + System.getProperty("file.separator") + "_public_key.puk");
        return fileName;
    }

    public String generateSignatureCertificateFile(byte[] inputData, String outFile) throws Throwable {
        String[] values;
        byte[] signatureBytes = this.generateSignatureFile(inputData, "Assinar Identificador");
        CAdESChecker check = new CAdESChecker();
        for (String val : values = check.checkAttachedSignature(signatureBytes).get(0).getChain().get(0).getSubjectDN().getName().split(",")) {
            if (!val.startsWith("CN") || val.split("=").length <= 0) continue;
            String fn = val.split("=")[1].replace(" ", "_").replaceAll("[^a-zA-Z0-9_-]", "_");
            outFile = outFile.replace("_public_", fn + "_public_");
            break;
        }
        if (signatureBytes.length <= 0) {
            throw new Exception("Erro ao gerar assinatura");
        }
        FileOutputStream os = new FileOutputStream(outFile);
        os.write(signatureBytes);
        os.flush();
        os.close();
        return outFile;
    }

    public byte[] generateSignatureFile(byte[] inputData, String pinHeadlerInfo) throws Throwable {
        return this.makeSignatureFile(inputData, pinHeadlerInfo);
    }
}

