/*
 * Decompiled with CFR 0.152.
 */
package org.demoiselle.signer.serpro.desktop.command.xmlds.verify;

import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.security.cert.X509Certificate;
import java.util.List;
import javax.swing.filechooser.FileNameExtensionFilter;
import org.demoiselle.signer.core.extension.BasicCertificate;
import org.demoiselle.signer.core.util.Base64Utils;
import org.demoiselle.signer.serpro.desktop.Main;
import org.demoiselle.signer.serpro.desktop.SerproSignerConfigurations;
import org.demoiselle.signer.serpro.desktop.command.AbstractCommand;
import org.demoiselle.signer.serpro.desktop.command.verifier.VerifySignerResponse;
import org.demoiselle.signer.serpro.desktop.command.xmlds.verify.RequestVerifyXML;
import org.demoiselle.signer.serpro.desktop.command.xmlds.verify.ResponseVerifyXML;
import org.demoiselle.signer.serpro.desktop.statistics.Statistics;
import org.demoiselle.signer.serpro.desktop.ui.commons.FileChooserSigner;
import org.demoiselle.signer.xmldsig.Checker;
import org.demoiselle.signer.xmldsig.XMLSignatureInformations;
import org.demoiselle.signer.xmldsig.impl.XMLDsigChecker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VerifyXML
extends AbstractCommand<RequestVerifyXML, ResponseVerifyXML> {
    private static final Logger logger = LoggerFactory.getLogger(VerifyXML.class);
    private Statistics instaSta;

    @Override
    public String getCommandName() {
        return "verifyxmldsig";
    }

    @Override
    public ResponseVerifyXML doCommand(RequestVerifyXML request) throws Throwable {
        boolean fromWeb = request.getHostConnected() != null && !request.getHostConnected().isEmpty();
        try {
            this.validateRequest(request);
            Main.showLoadingScreen(request.getHostConnectedPrefix());
            this.instaSta = new Statistics();
            XMLDsigChecker xmlChecker = new XMLDsigChecker();
            String varTipo = request.getType();
            switch (varTipo.toLowerCase()) {
                case "xml": {
                    this.verifyXML(xmlChecker, request);
                    break;
                }
                case "xmlbase64": {
                    this.verifyXMLBase64(xmlChecker, request);
                    break;
                }
                case "file": {
                    this.verifyFile(xmlChecker, request);
                }
            }
            ResponseVerifyXML response = this.buildResponse(xmlChecker, request);
            this.instaSta.setWeb(fromWeb);
            Thread trVerify = new Thread(this.instaSta);
            trVerify.start();
            Main.hideLoadingScreen();
            return response;
        }
        catch (Throwable error) {
            Main.hideLoadingScreen();
            return this.handleCommandException(error, fromWeb);
        }
    }

    private void validateRequest(RequestVerifyXML request) throws RuntimeException {
        if (request.getType().isEmpty()) {
            throw new RuntimeException("N\u00e3o foi informado um tipo para assinatura em XML, use: file||xml||hash||xmlBase64||contentBase64 ");
        }
        switch (request.getType().toLowerCase()) {
            case "file": {
                break;
            }
            case "xml": {
                if (!request.getInputData().isEmpty()) break;
                throw new RuntimeException("N\u00e3o foi fornecido nenhum cont\u00e9udo a ser assinado");
            }
            case "xmlbase64": {
                if (!request.getInputData().isEmpty()) break;
                throw new RuntimeException("N\u00e3o foi fornecido nenhum cont\u00e9udo a ser assinado");
            }
            default: {
                throw new RuntimeException("Tipo n\u00e3o reconhecido! Use: file||xml||xmlBase64");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean verifyXML(Checker xmlChecker, RequestVerifyXML request) {
        logger.info("verificando XML");
        this.instaSta.setType("verify XML");
        try {
            this.instaSta.setStart(System.currentTimeMillis());
            boolean bl = xmlChecker.check(request.getInputData());
            return bl;
        }
        finally {
            this.instaSta.setEnd(System.currentTimeMillis());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean verifyXMLBase64(Checker xmlChecker, RequestVerifyXML request) {
        logger.info("verificando xmlBase64");
        this.instaSta.setType("verify xmlBase64");
        try {
            this.instaSta.setStart(System.currentTimeMillis());
            boolean bl = xmlChecker.check(Base64Utils.base64Decode(request.getInputData()));
            return bl;
        }
        finally {
            this.instaSta.setEnd(System.currentTimeMillis());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean verifyFile(Checker xmlChecker, RequestVerifyXML request) {
        logger.info("verificando File XML");
        this.instaSta.setType("verify File XML");
        FileChooserSigner fileChooser = new FileChooserSigner();
        fileChooser.setDialogTitle("Escolha o arquivo XML a ser validado");
        fileChooser.setAcceptAllFileFilterUsed(false);
        FileNameExtensionFilter filter = new FileNameExtensionFilter("Arquivo XML(.xml)", "xml", "XML");
        fileChooser.addChoosableFileFilter(filter);
        fileChooser.addChoosableFileFilter(null);
        int returnValue = -1;
        if (request.getFileName().isEmpty()) {
            returnValue = fileChooser.showOpenDialog(null);
        } else {
            fileChooser.setSelectedFile(new File(request.getFileName()));
            returnValue = 0;
        }
        if (returnValue == 0) {
            String prefix = request.getHostConnectedPrefix();
            Main.showLoadingScreen(prefix);
            File selectedFile = fileChooser.getSelectedFile();
            String fileName = selectedFile.getAbsolutePath();
            File file = new File(fileName);
            if (file.length() == 0L) {
                Main.hideLoadingScreen();
                throw new RuntimeException("O arquivo selecionado est\u00e1 vazio, favor verificar.");
            }
            SerproSignerConfigurations configSigner = SerproSignerConfigurations.getInstance();
            if (file.length() > (long)(0x100000 * configSigner.getSizePDF())) {
                Main.hideLoadingScreen();
                throw new RuntimeException("O arquivo n\u00e3o pode ser maior que " + configSigner.getSizePDF() + " MB!Verifique suas configura\u00e7\u00f5es");
            }
            try {
                this.instaSta.setStart(System.currentTimeMillis());
                boolean bl = xmlChecker.check(true, file.getPath());
                return bl;
            }
            finally {
                this.instaSta.setEnd(System.currentTimeMillis());
            }
        }
        return false;
    }

    private ResponseVerifyXML buildResponse(Checker xmlChecker, RequestVerifyXML request) {
        ResponseVerifyXML responseVerifyXML = new ResponseVerifyXML();
        responseVerifyXML.setRequestId(request.getRequestId());
        List<XMLSignatureInformations> results = xmlChecker.getSignaturesInfo();
        responseVerifyXML.setXmlSignatureInformations(results);
        if (!results.isEmpty()) {
            this.instaSta.setSuccess(true);
            int numberOfSignature = 0;
            for (XMLSignatureInformations si : results) {
                VerifySignerResponse verifySignerResponse = new VerifySignerResponse();
                if (!si.getValidatorErrors().isEmpty()) {
                    verifySignerResponse.setValidatorErrors(si.getValidatorErrors());
                    verifySignerResponse.setHasError(true);
                }
                if (!si.getValidatorWarnins().isEmpty()) {
                    verifySignerResponse.setValidatorWarnings(si.getValidatorWarnins());
                    verifySignerResponse.setHasWarning(true);
                }
                if (si.getIcpBrasilcertificate() != null) {
                    BasicCertificate signerBasicCertificate = si.getIcpBrasilcertificate();
                    if (signerBasicCertificate.hasCertificatePF()) {
                        verifySignerResponse.setPF(true);
                        verifySignerResponse.setValCPF_CNPJ(signerBasicCertificate.getICPBRCertificatePF().getCPF());
                    } else if (signerBasicCertificate.hasCertificatePJ()) {
                        verifySignerResponse.setPF(false);
                        verifySignerResponse.setValCPF_CNPJ(signerBasicCertificate.getICPBRCertificatePJ().getCNPJ());
                    }
                    verifySignerResponse.setAssinante(signerBasicCertificate.getName());
                }
                if (si.getChain() == null) continue;
                for (X509Certificate cert : si.getChain()) {
                    BasicCertificate certificateCA = new BasicCertificate(cert);
                    if (!certificateCA.isCACertificate()) continue;
                    verifySignerResponse.getCadeiaCertificado().add(certificateCA.getName());
                }
                ++numberOfSignature;
                responseVerifyXML.getSignerSignatureValidations().add(verifySignerResponse);
            }
            responseVerifyXML.setNumberOfSignatures(numberOfSignature);
            responseVerifyXML.setValid(true);
        } else {
            logger.error("Erro na valida\u00e7\u00e3o do XML, arquivo parece n\u00e3o conter uma assinatura!");
            responseVerifyXML.setMsgErro("Erro na valida\u00e7\u00e3o do XML, arquivo parece n\u00e3o conter uma assinatura!");
            responseVerifyXML.setValid(false);
            responseVerifyXML.setHasError(true);
            this.instaSta.setSuccess(false);
        }
        return responseVerifyXML;
    }

    private ResponseVerifyXML handleCommandException(Throwable error, boolean fromWeb) {
        if (error.getCause() != null && error.getCause() instanceof InvocationTargetException) {
            logger.error(error.getMessage());
            if (!fromWeb) {
                throw new RuntimeException(error.getMessage(), error);
            }
            ResponseVerifyXML responseVerifyXML = new ResponseVerifyXML();
            responseVerifyXML.setActionCanceled(true);
            responseVerifyXML.setHasError(true);
            responseVerifyXML.setMsgErro(error.getMessage());
            return responseVerifyXML;
        }
        logger.error("Erro na valida\u00e7\u00e3o da assinatura XML" + error.getMessage());
        if (!fromWeb) {
            throw new RuntimeException(error.getMessage(), error);
        }
        ResponseVerifyXML responseVerifyXML = new ResponseVerifyXML();
        responseVerifyXML.setActionCanceled(true);
        responseVerifyXML.setHasError(true);
        responseVerifyXML.setMsgErro(error.getMessage());
        return responseVerifyXML;
    }
}

