/*
 * Decompiled with CFR 0.152.
 */
package org.demoiselle.signer.serpro.desktop.command.xmlds.sign;

import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.StringWriter;
import java.lang.reflect.InvocationTargetException;
import java.security.KeyStore;
import java.security.PrivateKey;
import java.security.cert.X509Certificate;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Iterator;
import java.util.Map;
import java.util.SimpleTimeZone;
import javax.security.auth.login.LoginException;
import javax.swing.filechooser.FileNameExtensionFilter;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.bouncycastle.util.encoders.Base64;
import org.demoiselle.signer.core.extension.BasicCertificate;
import org.demoiselle.signer.core.keystore.loader.KeyStoreLoader;
import org.demoiselle.signer.core.keystore.loader.configuration.Configuration;
import org.demoiselle.signer.core.keystore.loader.factory.KeyStoreLoaderFactory;
import org.demoiselle.signer.core.repository.ConfigurationRepo;
import org.demoiselle.signer.core.util.Base64Utils;
import org.demoiselle.signer.serpro.desktop.Main;
import org.demoiselle.signer.serpro.desktop.SerproSignerConfigurations;
import org.demoiselle.signer.serpro.desktop.command.AbstractCommand;
import org.demoiselle.signer.serpro.desktop.command.cert.CertUtils;
import org.demoiselle.signer.serpro.desktop.command.cert.Certificate;
import org.demoiselle.signer.serpro.desktop.command.signer.BatchSignatureContext;
import org.demoiselle.signer.serpro.desktop.command.xmlds.sign.RequestSignXML;
import org.demoiselle.signer.serpro.desktop.command.xmlds.sign.ResponseSignXML;
import org.demoiselle.signer.serpro.desktop.pkcs11info.KeystoreSelection;
import org.demoiselle.signer.serpro.desktop.statistics.Statistics;
import org.demoiselle.signer.serpro.desktop.ui.PinHandler;
import org.demoiselle.signer.serpro.desktop.ui.PinHandlerFile;
import org.demoiselle.signer.serpro.desktop.ui.commons.FileChooserSigner;
import org.demoiselle.signer.serpro.desktop.utils.FileUtil;
import org.demoiselle.signer.xmldsig.Signer;
import org.demoiselle.signer.xmldsig.impl.XMLDsigSigner;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;

public class SignXML
extends AbstractCommand<RequestSignXML, ResponseSignXML> {
    private static final Logger logger = LoggerFactory.getLogger(SignXML.class);
    private Date certExpDate;
    private Statistics instaSta;
    private PinHandlerFile pinFile;
    private PinHandler pinToken;
    private KeyStore keyStore;
    private X509Certificate cert;
    private PrivateKey privateKey;
    private String alias;

    @Override
    public String getCommandName() {
        return "signxmldsig";
    }

    @Override
    public ResponseSignXML doCommand(RequestSignXML request) throws Exception {
        return this.doCommand(request, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ResponseSignXML doCommand(RequestSignXML request, BatchSignatureContext batchSignatureContext) throws Exception {
        ResponseSignXML response;
        block8: {
            block7: {
                Main.showLoadingScreen("");
                this.validateRequest(request);
                Main.hideLoadingScreen();
                response = new ResponseSignXML();
                this.instaSta = new Statistics();
                this.loadCertificate(request, batchSignatureContext, response);
                if (!response.getActionCanceled()) break block7;
                ResponseSignXML responseSignXML = response;
                ConfigurationRepo.getInstance().setValidateLCR(true);
                boolean fromWeb = request.getHostConnected() != null && !request.getHostConnected().isEmpty();
                this.instaSta.setWeb(fromWeb);
                Thread trSign = new Thread(this.instaSta);
                trSign.start();
                Main.hideLoadingScreen();
                return responseSignXML;
            }
            this.sign(request, response);
            if (!response.getActionCanceled()) break block8;
            ResponseSignXML responseSignXML = response;
            ConfigurationRepo.getInstance().setValidateLCR(true);
            boolean fromWeb = request.getHostConnected() != null && !request.getHostConnected().isEmpty();
            this.instaSta.setWeb(fromWeb);
            Thread trSign = new Thread(this.instaSta);
            trSign.start();
            Main.hideLoadingScreen();
            return responseSignXML;
        }
        try {
            this.prepareResponseAfterSign(request, response);
            Main.hideLoadingScreen();
            if (logger.isInfoEnabled()) {
                logger.info("Assinado por: " + this.cert.getSubjectDN().getName());
            }
            ConfigurationRepo.getInstance().setValidateLCR(true);
        }
        catch (Throwable error) {
            try {
                this.handleCommandException(error, response);
                ConfigurationRepo.getInstance().setValidateLCR(true);
            }
            catch (Throwable throwable) {
                ConfigurationRepo.getInstance().setValidateLCR(true);
                boolean fromWeb = request.getHostConnected() != null && !request.getHostConnected().isEmpty();
                this.instaSta.setWeb(fromWeb);
                Thread trSign = new Thread(this.instaSta);
                trSign.start();
                Main.hideLoadingScreen();
                throw throwable;
            }
            boolean fromWeb = request.getHostConnected() != null && !request.getHostConnected().isEmpty();
            this.instaSta.setWeb(fromWeb);
            Thread trSign = new Thread(this.instaSta);
            trSign.start();
            Main.hideLoadingScreen();
        }
        boolean fromWeb = request.getHostConnected() != null && !request.getHostConnected().isEmpty();
        this.instaSta.setWeb(fromWeb);
        Thread trSign = new Thread(this.instaSta);
        trSign.start();
        Main.hideLoadingScreen();
        return response;
    }

    private void validateRequest(RequestSignXML request) throws RuntimeException {
        if (request.getType().isEmpty()) {
            throw new RuntimeException("N\u00e3o foi informado um tipo para assinatura em XML, use: file||xml||xmlBase64 ");
        }
        if (!(request.getOutputDataType().equalsIgnoreCase("file") || request.getOutputDataType().equalsIgnoreCase("xml") || request.getOutputDataType().equalsIgnoreCase("base64"))) {
            throw new RuntimeException("Formato de saida desconhecido, use xml||hash||base64");
        }
        switch (request.getType().toLowerCase()) {
            case "xml": {
                if (request.getListOfInputData().isEmpty()) {
                    throw new RuntimeException("N\u00e3o foi fornecido  nenhum XML para ser assinado");
                }
                if (!request.getOutputDataType().equalsIgnoreCase("file")) break;
                throw new RuntimeException("Tipo XML n\u00e3o permite formato de saida file");
            }
            case "xmlbase64": {
                if (request.getListOfInputData().isEmpty()) {
                    throw new RuntimeException("N\u00e3o foi fornecido o base64 do XML para ser assinado");
                }
                if (!request.getOutputDataType().equalsIgnoreCase("file")) break;
                throw new RuntimeException("Tipo xmlBase64 n\u00e3o permite formato de saida file");
            }
            case "file": {
                break;
            }
            default: {
                throw new RuntimeException("Tipo n\u00e3o reconhecido! Use: file||xml||xmlBase64");
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void loadCertificate(RequestSignXML request, BatchSignatureContext batchSignatureContext, ResponseSignXML response) throws Throwable {
        String prefix = request.getHostConnectedPrefix();
        String varAction = "Assinar";
        this.pinFile = new PinHandlerFile(varAction + this.getStringType(request.getType()), request.getHostConnectedPrefix());
        this.pinToken = new PinHandler(varAction + this.getStringType(request.getType()), request.getHostConnectedPrefix());
        char[] pass = null;
        SerproSignerConfigurations configSigner = SerproSignerConfigurations.getInstance();
        Main.showLoadingScreen(prefix);
        if (configSigner.isUseCertificateFile() || configSigner.isChooseFileCertificate()) {
            File filep12;
            this.pinToken = null;
            Main.hideLoadingScreen();
            if (configSigner.isChooseFileCertificate()) {
                if (batchSignatureContext != null && batchSignatureContext.isKeyStoreSelected()) {
                    filep12 = new File(batchSignatureContext.getKeyStore());
                    pass = configSigner.getCertificateFilePass();
                } else {
                    filep12 = FileUtil.selectA1Certificate();
                    this.pinFile.init();
                    if (this.pinFile.getActionCanceled()) throw new RuntimeException("Assinatura XML, com A1, cancelada pelo usu\u00e1rio");
                    pass = this.pinFile.getPwd();
                    configSigner.setCertificateFilePass(pass);
                }
            } else {
                filep12 = new File(configSigner.getCertificateFilePath());
                if (configSigner.isSaveCertificateFilePass()) {
                    pass = configSigner.getCertificateFilePass();
                } else {
                    this.pinFile.init();
                    if (this.pinFile.getActionCanceled()) throw new RuntimeException("Assinatura XML,com A1, cancelada pelo usu\u00e1rio");
                    pass = this.pinFile.getPwd();
                }
            }
            KeyStoreLoader loader = KeyStoreLoaderFactory.factoryKeyStoreLoader(filep12);
            this.keyStore = loader.getKeyStore(String.copyValueOf(pass));
            if (batchSignatureContext != null && !batchSignatureContext.isKeyStoreSelected()) {
                batchSignatureContext.setKeyStore(filep12.getAbsolutePath());
            }
        } else {
            Map.Entry<String, String> item;
            Iterator<Map.Entry<String, String>> it;
            this.pinFile = null;
            if (configSigner.isUseNeoId()) {
                it = Configuration.getInstance().getDrivers().entrySet().iterator();
                while (it.hasNext()) {
                    item = it.next();
                    if (item.getKey().contains("neoid")) continue;
                    it.remove();
                }
            }
            if (configSigner.isSelectedToken()) {
                it = Configuration.getInstance().getDrivers().entrySet().iterator();
                while (it.hasNext()) {
                    item = it.next();
                    if (item.getKey().equalsIgnoreCase(configSigner.getTokenNameSelected())) continue;
                    it.remove();
                }
            }
            KeystoreSelection ks = new KeystoreSelection(this.pinToken, batchSignatureContext);
            this.keyStore = ks.getKeyStore();
            if (this.keyStore == null) {
                response.setActionCanceled(true);
                return;
            }
        }
        if (response.getActionCanceled()) {
            return;
        }
        this.alias = CertUtils.getAlias(request.getAlias(), this.keyStore, batchSignatureContext);
        this.cert = (X509Certificate)this.keyStore.getCertificate(this.alias);
        this.privateKey = configSigner.isUseCertificateFile() || configSigner.isChooseFileCertificate() ? (PrivateKey)this.keyStore.getKey(this.alias, pass) : (PrivateKey)this.keyStore.getKey(this.alias, null);
    }

    private String getStringType(String type) {
        if (type.equalsIgnoreCase("xml")) {
            return " XML";
        }
        if (type.equalsIgnoreCase("file")) {
            return " Arquivo";
        }
        if (type.equalsIgnoreCase("xmlBase64")) {
            return " Arquivo XML codificado em Base64";
        }
        return "Desconhecido";
    }

    private void sign(RequestSignXML request, ResponseSignXML response) throws Exception {
        XMLDsigSigner signerXML = new XMLDsigSigner();
        signerXML.setCertificateChain(this.keyStore.getCertificateChain(this.alias));
        signerXML.setPrivateKey(this.privateKey);
        signerXML.setReferenceId(request.getReferenceId());
        try {
            signerXML.setSignatureAlgorithm(request.getAlgorithm());
        }
        catch (Throwable error) {
            signerXML.setSignatureAlgorithm("SHA1withRSA");
        }
        this.instaSta.setAlgorithm(signerXML.getSignatureAlgorithm());
        if (SerproSignerConfigurations.getInstance().isLcrOff()) {
            ConfigurationRepo.getInstance().setValidateLCR(false);
            logger.warn("Assinando sem valida\u00e7\u00e3o de LCR!");
        }
        if (request.getType().equalsIgnoreCase("xml")) {
            this.signXML(signerXML, request, response);
        } else if (request.getType().equalsIgnoreCase("file")) {
            this.signXMLFile(signerXML, request, response);
        } else if (request.getType().equalsIgnoreCase("xmlBase64")) {
            this.signXMLBase64(signerXML, request, response);
        }
    }

    private void signXML(Signer signerXML, RequestSignXML request, ResponseSignXML response) throws Exception {
        logger.info("assinando XML");
        String prefix = request.getHostConnectedPrefix();
        for (String xml : request.getListOfInputData()) {
            this.instaSta.setType("xml");
            Main.showLoadingScreen(prefix);
            this.instaSta.setStart(System.currentTimeMillis());
            Document docAss = signerXML.signEnveloped(xml);
            this.instaSta.setEnd(System.currentTimeMillis());
            TransformerFactory tf = TransformerFactory.newInstance();
            Transformer trans = tf.newTransformer();
            StringWriter writer = new StringWriter();
            trans.transform(new DOMSource(docAss), new StreamResult(writer));
            if (request.getOutputDataType().equalsIgnoreCase("xml")) {
                response.getListOfSignatures().add(writer.getBuffer().toString());
            } else {
                response.getListOfSignatures().add(Base64.toBase64String(writer.getBuffer().toString().getBytes()));
            }
            writer.close();
            response.getListOfOriginalContents().add(xml);
            this.instaSta.setSuccess(true);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void signXMLFile(Signer signerXML, RequestSignXML request, ResponseSignXML response) throws Exception {
        String fileName = null;
        Document docAss = null;
        String prefix = request.getHostConnectedPrefix();
        this.instaSta.setType("fileXML");
        FileChooserSigner fileChooser = new FileChooserSigner();
        fileChooser.setDialogTitle("Escolha o arquivo XML que ser\u00e1 assinado");
        fileChooser.setAcceptAllFileFilterUsed(false);
        FileNameExtensionFilter filter = new FileNameExtensionFilter("Arquivo XML(.xml)", "xml", "XML");
        fileChooser.addChoosableFileFilter(filter);
        fileChooser.addChoosableFileFilter(null);
        int returnValue = -1;
        if (request.getFileName().isEmpty()) {
            returnValue = fileChooser.showOpenDialog(null);
        } else {
            fileChooser.setSelectedFile(new File(request.getFileName()));
            returnValue = 0;
        }
        if (returnValue == 0) {
            Main.showLoadingScreen(prefix);
            File selectedFile = fileChooser.getSelectedFile();
            fileName = selectedFile.getAbsolutePath();
            File file = new File(fileName);
            if (file.length() == 0L) {
                throw new Exception("O arquivo selecionado est\u00e1 vazio, favor verificar.");
            }
            SerproSignerConfigurations configSigner = SerproSignerConfigurations.getInstance();
            if (file.length() > (long)(0x100000 * configSigner.getSizePDF())) {
                throw new Exception("O arquivo n\u00e3o pode ser maior que " + configSigner.getSizePDF() + " MB! \n Verifique suas configura\u00e7\u00f5es");
            }
            this.instaSta.setLengthOriginalContent(file.length());
            this.instaSta.setStart(System.currentTimeMillis());
            logger.info("Assinando Arquivo local" + file.getPath());
            docAss = signerXML.signEnveloped(true, file.getPath());
        } else if (returnValue == 1) {
            response.setActionCanceled(true);
            this.instaSta.setEnd(System.currentTimeMillis());
            this.instaSta.setSuccess(false);
            return;
        }
        if (request.getOutputDataType().equalsIgnoreCase("file") && request.getType().equalsIgnoreCase("file")) {
            if (docAss == null) throw new RuntimeException("Erro ao gerar Assinatura a partir de um arquivo local");
            String signedFile = fileName.replaceFirst(".xml$", "_assinado.xml");
            FileOutputStream os = new FileOutputStream(signedFile);
            TransformerFactory tf = TransformerFactory.newInstance();
            Transformer trans = tf.newTransformer();
            trans.transform(new DOMSource(docAss), new StreamResult(os));
            ((OutputStream)os).close();
            response.getListOfOriginalContents().add(fileName);
            response.getListOfSignatures().add(signedFile);
            this.instaSta.setEnd(System.currentTimeMillis());
            this.instaSta.setSuccess(true);
            return;
        } else {
            TransformerFactory tf = TransformerFactory.newInstance();
            Transformer trans = tf.newTransformer();
            StringWriter writer = new StringWriter();
            trans.transform(new DOMSource(docAss), new StreamResult(writer));
            if (request.getOutputDataType().equalsIgnoreCase("xml")) {
                response.getListOfSignatures().add(writer.getBuffer().toString());
            } else {
                response.getListOfSignatures().add(Base64.toBase64String(writer.getBuffer().toString().getBytes()));
            }
            response.getListOfOriginalContents().add(fileName);
            writer.close();
            this.instaSta.setEnd(System.currentTimeMillis());
            this.instaSta.setSuccess(true);
        }
    }

    private void signXMLBase64(Signer signerXML, RequestSignXML request, ResponseSignXML response) throws Exception {
        logger.info("Assinando xmlBase64");
        Main.showLoadingScreen(request.getHostConnectedPrefix());
        for (String xmlBase64 : request.getListOfInputData()) {
            this.instaSta.setType("xmlBase64");
            byte[] byteArrayOriginalInputData = Base64Utils.base64Decode(xmlBase64);
            this.instaSta.setLengthOriginalContent(byteArrayOriginalInputData.length);
            this.instaSta.setStart(System.currentTimeMillis());
            Document docAss = signerXML.signEnveloped(byteArrayOriginalInputData);
            TransformerFactory tf = TransformerFactory.newInstance();
            Transformer trans = tf.newTransformer();
            StringWriter writer = new StringWriter();
            trans.transform(new DOMSource(docAss), new StreamResult(writer));
            if (request.getOutputDataType().equalsIgnoreCase("xml")) {
                response.getListOfSignatures().add(writer.getBuffer().toString());
            } else {
                response.getListOfSignatures().add(Base64.toBase64String(writer.getBuffer().toString().getBytes()));
            }
            writer.close();
            response.getListOfOriginalContents().add(xmlBase64);
            this.instaSta.setEnd(System.currentTimeMillis());
            this.instaSta.setSuccess(true);
        }
    }

    private void prepareResponseAfterSign(RequestSignXML request, ResponseSignXML response) {
        response.setRequestId(request.getRequestId());
        response.setPublicKey(Base64Utils.base64Encode(this.cert.getPublicKey().getEncoded()));
        Certificate by = new Certificate();
        by.setAlias(this.alias);
        by.setProvider(this.keyStore.getProvider().getName());
        by.setSubject(this.cert.getSubjectDN().getName());
        SimpleDateFormat sdf = new SimpleDateFormat();
        sdf.setTimeZone(new SimpleTimeZone(0, "GMT"));
        sdf.applyPattern("dd MMM yyyy HH:mm:ss z");
        by.setNotAfter(sdf.format(this.cert.getNotAfter()));
        by.setNotBefore(sdf.format(this.cert.getNotBefore()));
        response.setNotAfterDateCertificate(this.cert.getNotAfter());
        this.setCertExpDate(this.cert.getNotAfter());
        response.setBy(by);
        response.setNotAfterDateCertificate(this.cert.getNotAfter());
        this.instaSta.setToken(this.keyStore.getProvider().getName());
        this.instaSta.setSuccess(true);
        BasicCertificate bc = new BasicCertificate(this.cert);
        try {
            this.instaSta.setCaURL(bc.getAuthorityInfoAccess().iterator().next());
        }
        catch (Throwable error) {
            logger.error(error.getMessage());
        }
        ConfigurationRepo.getInstance().setValidateLCR(true);
    }

    private void handleCommandException(Throwable error, ResponseSignXML response) {
        this.instaSta.setSuccess(false);
        ConfigurationRepo.getInstance().setValidateLCR(true);
        if (error.getMessage().toLowerCase().contains("cancel")) {
            if (this.pinToken != null) {
                this.pinToken.setActionCanceled(true);
            } else {
                response.setActionCanceled(true);
                return;
            }
        }
        if (error.getCause() != null && error.getCause() instanceof InvocationTargetException) {
            InvocationTargetException targetException = (InvocationTargetException)error.getCause();
            if (this.pinFile != null && this.pinFile.getActionCanceled()) {
                response.setActionCanceled(true);
                return;
            }
            if (this.pinToken != null && this.pinToken.getActionCanceled()) {
                response.setActionCanceled(true);
                return;
            }
            if (targetException.getTargetException() != null && targetException.getTargetException() instanceof LoginException) {
                response.setActionCanceled(true);
                return;
            }
            logger.error(error.getMessage());
            throw new RuntimeException(error.getMessage(), error);
        }
        if (this.pinFile != null && this.pinFile.getActionCanceled()) {
            response.setActionCanceled(true);
            return;
        }
        if (this.pinToken != null && this.pinToken.getActionCanceled()) {
            response.setActionCanceled(true);
            return;
        }
        logger.error(error.getMessage());
        throw new RuntimeException(error.getMessage(), error);
    }

    public Date getCertExpDate() {
        return this.certExpDate;
    }

    public void setCertExpDate(Date certExpDate) {
        this.certExpDate = certExpDate;
    }
}

