/*
 * Decompiled with CFR 0.152.
 */
package org.demoiselle.signer.serpro.desktop.command.xml.verify;

import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.security.cert.X509Certificate;
import java.util.List;
import javax.swing.filechooser.FileNameExtensionFilter;
import org.demoiselle.signer.core.extension.BasicCertificate;
import org.demoiselle.signer.core.util.Base64Utils;
import org.demoiselle.signer.policy.engine.factory.PolicyFactory;
import org.demoiselle.signer.policy.impl.xades.XMLSignatureInformations;
import org.demoiselle.signer.policy.impl.xades.util.PolicyUtils;
import org.demoiselle.signer.policy.impl.xades.xml.impl.XMLChecker;
import org.demoiselle.signer.serpro.desktop.Main;
import org.demoiselle.signer.serpro.desktop.SerproSignerConfigurations;
import org.demoiselle.signer.serpro.desktop.command.AbstractCommand;
import org.demoiselle.signer.serpro.desktop.command.verifier.VerifySignerResponse;
import org.demoiselle.signer.serpro.desktop.command.xml.verify.RequestVerifyXML;
import org.demoiselle.signer.serpro.desktop.command.xml.verify.ResponseVerifyXML;
import org.demoiselle.signer.serpro.desktop.statistics.Statistics;
import org.demoiselle.signer.serpro.desktop.ui.commons.FileChooserSigner;
import org.demoiselle.signer.timestamp.Timestamp;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VerifyXML
extends AbstractCommand<RequestVerifyXML, ResponseVerifyXML> {
    private static final Logger logger = LoggerFactory.getLogger(VerifyXML.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ResponseVerifyXML doCommand(RequestVerifyXML request) throws Throwable {
        SerproSignerConfigurations configSigner = SerproSignerConfigurations.getInstance();
        boolean fromWeb = request.getHostConnected() != null && !request.getHostConnected().isEmpty();
        try {
            this.validateRequest(request);
            Main.showLoadingScreen(request.getHostConnectedPrefix());
            XMLChecker xadesChecker = new XMLChecker();
            String varTipo = request.getType();
            String prefix = request.getHostConnectedPrefix();
            Statistics instaSta = new Statistics();
            switch (varTipo.toLowerCase()) {
                case "xml": {
                    logger.info("verificando XML");
                    instaSta.setType("verify XML");
                    instaSta.setStart(System.currentTimeMillis());
                    xadesChecker.check(request.getInputData());
                    instaSta.setEnd(System.currentTimeMillis());
                    break;
                }
                case "hash": {
                    logger.info("verificando HASH xml");
                    instaSta.setType("verify HASH XML");
                    instaSta.setStart(System.currentTimeMillis());
                    xadesChecker.checkHash(Base64Utils.base64Decode(request.getInputData()), Base64Utils.base64Decode(request.getInputSignature()));
                    instaSta.setEnd(System.currentTimeMillis());
                    break;
                }
                case "xmlbase64": {
                    logger.info("verificando xmlBase64");
                    instaSta.setType("verify xmlBase64");
                    instaSta.setStart(System.currentTimeMillis());
                    xadesChecker.check(Base64Utils.base64Decode(request.getInputData()));
                    instaSta.setEnd(System.currentTimeMillis());
                    break;
                }
                case "contentbase64": {
                    logger.info("verificando contentBase64 XML");
                    instaSta.setType("verify contentBase64 XML");
                    instaSta.setStart(System.currentTimeMillis());
                    xadesChecker.check(Base64Utils.base64Decode(request.getInputData()), Base64Utils.base64Decode(request.getInputSignature()));
                    instaSta.setEnd(System.currentTimeMillis());
                    break;
                }
                case "file": {
                    logger.info("verificando File XML");
                    instaSta.setType("verify File XML");
                    FileChooserSigner fileChooser = new FileChooserSigner();
                    fileChooser.setDialogTitle("Escolha o arquivo XML a ser validado");
                    fileChooser.setAcceptAllFileFilterUsed(false);
                    FileNameExtensionFilter filter = new FileNameExtensionFilter("Arquivo XML(.xml)", "xml", "XML");
                    fileChooser.addChoosableFileFilter(filter);
                    fileChooser.addChoosableFileFilter(null);
                    int returnValue = -1;
                    if (request.getFileName().isEmpty()) {
                        returnValue = fileChooser.showOpenDialog(null);
                    } else {
                        fileChooser.setSelectedFile(new File(request.getFileName()));
                        returnValue = 0;
                    }
                    if (returnValue != 0) break;
                    Main.showLoadingScreen(prefix);
                    File selectedFile = fileChooser.getSelectedFile();
                    String fileName = selectedFile.getAbsolutePath();
                    File file = new File(fileName);
                    if (file.length() == 0L) {
                        Main.hideLoadingScreen();
                        throw new RuntimeException("O arquivo selecionado est\u00e1 vazio, favor verificar.");
                    }
                    if (file.length() > (long)(0x100000 * configSigner.getSizePDF())) {
                        Main.hideLoadingScreen();
                        throw new RuntimeException("O arquivo n\u00e3o pode ser maior que " + configSigner.getSizePDF() + " MB!Verifique suas configura\u00e7\u00f5es");
                    }
                    instaSta.setStart(System.currentTimeMillis());
                    xadesChecker.check(true, file.getPath());
                    instaSta.setEnd(System.currentTimeMillis());
                }
            }
            ResponseVerifyXML responseVerifyXML = new ResponseVerifyXML();
            responseVerifyXML.setRequestId(request.getRequestId());
            List<XMLSignatureInformations> results = xadesChecker.getSignaturesInfo();
            if (!results.isEmpty()) {
                instaSta.setSuccess(true);
                int numberOfSignature = 0;
                for (XMLSignatureInformations si : results) {
                    Timestamp varTimeStamp;
                    VerifySignerResponse verifySignerResponse = new VerifySignerResponse();
                    if (!si.getValidatorErrors().isEmpty()) {
                        verifySignerResponse.setValidatorErrors(si.getValidatorErrors());
                        verifySignerResponse.setHasError(true);
                    }
                    if (!si.getValidatorWarnins().isEmpty()) {
                        verifySignerResponse.setValidatorWarnings(si.getValidatorWarnins());
                        verifySignerResponse.setHasWarning(true);
                    }
                    if ((varTimeStamp = si.getTimeStampSigner()) != null) {
                        String text = "Carimbo do Tempo emitido em:" + varTimeStamp.getTimeStamp() + ", Pela autoridade:" + varTimeStamp.getTimeStampAuthorityInfo() + ") N\u00famero de s\u00e9rie:" + varTimeStamp.getSerialNumber();
                        verifySignerResponse.setTimeStampSigner(text);
                    }
                    if (si.getSignDateGMT() != null && !si.getSignDateGMT().isEmpty()) {
                        verifySignerResponse.setSignDate(si.getSignDateGMT());
                    }
                    if (si.getSignaturePolicy() != null) {
                        String policyOID = si.getSignaturePolicy().getIdentifier();
                        if (policyOID.contains("urn:oid:")) {
                            policyOID = policyOID.substring(policyOID.lastIndexOf(":") + 1, policyOID.length());
                        }
                        PolicyFactory.Policies policy = PolicyUtils.getPolicyByOid(policyOID);
                        verifySignerResponse.setSignaturePolicy(policy.name());
                    }
                    if (si.getIcpBrasilcertificate() != null) {
                        BasicCertificate signerBasicCertificate = si.getIcpBrasilcertificate();
                        if (signerBasicCertificate.hasCertificatePF()) {
                            verifySignerResponse.setPF(true);
                            verifySignerResponse.setValCPF_CNPJ(signerBasicCertificate.getICPBRCertificatePF().getCPF());
                        } else if (signerBasicCertificate.hasCertificatePJ()) {
                            verifySignerResponse.setPF(false);
                            verifySignerResponse.setValCPF_CNPJ(signerBasicCertificate.getICPBRCertificatePJ().getCNPJ());
                        }
                        verifySignerResponse.setAssinante(signerBasicCertificate.getName());
                    }
                    if (si.getChain() == null) continue;
                    for (X509Certificate cert : si.getChain()) {
                        BasicCertificate certificateCA = new BasicCertificate(cert);
                        if (!certificateCA.isCACertificate()) continue;
                        verifySignerResponse.getCadeiaCertificado().add(certificateCA.getName());
                    }
                    ++numberOfSignature;
                    responseVerifyXML.getSignerSignatureValidations().add(verifySignerResponse);
                }
                responseVerifyXML.setNumberOfSignatures(numberOfSignature);
                responseVerifyXML.setValid(true);
            } else {
                logger.error("Erro na valida\u00e7\u00e3o do XML, arquivo parece n\u00e3o conter uma assinatura!");
                responseVerifyXML.setMsgErro("Erro na valida\u00e7\u00e3o do XML, arquivo parece n\u00e3o conter uma assinatura!");
                responseVerifyXML.setValid(false);
                responseVerifyXML.setHasError(true);
                instaSta.setSuccess(false);
            }
            instaSta.setWeb(fromWeb);
            Thread trVerify = new Thread(instaSta);
            trVerify.start();
            Main.hideLoadingScreen();
            ResponseVerifyXML responseVerifyXML2 = responseVerifyXML;
            return responseVerifyXML2;
        }
        catch (Throwable error) {
            Main.hideLoadingScreen();
            if (error.getCause() != null && error.getCause() instanceof InvocationTargetException) {
                logger.error(error.getMessage());
                if (!fromWeb) {
                    throw new RuntimeException(error.getMessage(), error);
                }
                ResponseVerifyXML responseVerifyXML = new ResponseVerifyXML();
                responseVerifyXML.setActionCanceled(true);
                responseVerifyXML.setHasError(true);
                responseVerifyXML.setMsgErro(error.getMessage());
                ResponseVerifyXML responseVerifyXML3 = responseVerifyXML;
                return responseVerifyXML3;
            }
            logger.error("Erro na valida\u00e7\u00e3o da assinatura XML" + error.getMessage());
            if (!fromWeb) {
                throw new RuntimeException(error.getMessage(), error);
            }
            ResponseVerifyXML responseVerifyXML = new ResponseVerifyXML();
            responseVerifyXML.setActionCanceled(true);
            responseVerifyXML.setHasError(true);
            responseVerifyXML.setMsgErro(error.getMessage());
            ResponseVerifyXML responseVerifyXML4 = responseVerifyXML;
            return responseVerifyXML4;
        }
        finally {
            Main.hideLoadingScreen();
        }
    }

    private void validateRequest(RequestVerifyXML request) throws RuntimeException {
        if (request.getType().isEmpty()) {
            throw new RuntimeException("N\u00e3o foi informado um tipo para assinatura em XML, use: file||xml||hash||xmlBase64||contentBase64 ");
        }
        switch (request.getType().toLowerCase()) {
            case "file": {
                break;
            }
            case "xml": {
                if (!request.getInputData().isEmpty()) break;
                throw new RuntimeException("N\u00e3o foi fornecido nenhum cont\u00e9udo a ser assinado");
            }
            case "hash": {
                if (request.getInputData().isEmpty()) {
                    throw new RuntimeException("N\u00e3o foi fornecido nenhum cont\u00e9udo a ser assinado");
                }
                if (!request.getInputSignature().isEmpty()) break;
                throw new RuntimeException("N\u00e3o foi fornecida nenhuma Assinatura XML para ser validada com o cont\u00e9udo!");
            }
            case "xmlbase64": {
                if (!request.getInputData().isEmpty()) break;
                throw new RuntimeException("N\u00e3o foi fornecido nenhum cont\u00e9udo a ser assinado");
            }
            case "contentbase64": {
                if (request.getInputData().isEmpty()) {
                    throw new RuntimeException("N\u00e3o foi fornecido nenhum cont\u00e9udo a ser assinado");
                }
                if (!request.getInputSignature().isEmpty()) break;
                throw new RuntimeException("N\u00e3o foi fornecida nenhuma Assinatura XML para ser validada com o cont\u00e9udo!");
            }
            default: {
                throw new RuntimeException("Tipo n\u00e3o reconhecido! Use: file||xml||hash||xmlBase64||contentBase64");
            }
        }
    }
}

