/*
 * Decompiled with CFR 0.152.
 */
package org.demoiselle.signer.serpro.desktop.command.xml.sign;

import java.io.File;
import java.io.StringWriter;
import java.lang.reflect.InvocationTargetException;
import java.security.KeyStore;
import java.security.PrivateKey;
import java.security.cert.X509Certificate;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Iterator;
import java.util.Map;
import java.util.SimpleTimeZone;
import javax.security.auth.login.LoginException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.bouncycastle.util.encoders.Base64;
import org.demoiselle.signer.core.extension.BasicCertificate;
import org.demoiselle.signer.core.keystore.loader.KeyStoreLoader;
import org.demoiselle.signer.core.keystore.loader.configuration.Configuration;
import org.demoiselle.signer.core.keystore.loader.factory.KeyStoreLoaderFactory;
import org.demoiselle.signer.core.repository.ConfigurationRepo;
import org.demoiselle.signer.core.util.Base64Utils;
import org.demoiselle.signer.policy.engine.factory.PolicyFactory;
import org.demoiselle.signer.policy.impl.xades.XMLPoliciesOID;
import org.demoiselle.signer.policy.impl.xades.xml.impl.XMLSignedAttributes;
import org.demoiselle.signer.serpro.desktop.Main;
import org.demoiselle.signer.serpro.desktop.SerproSignerConfigurations;
import org.demoiselle.signer.serpro.desktop.command.AbstractCommand;
import org.demoiselle.signer.serpro.desktop.command.cert.CertUtils;
import org.demoiselle.signer.serpro.desktop.command.cert.Certificate;
import org.demoiselle.signer.serpro.desktop.command.signer.BatchSignatureContext;
import org.demoiselle.signer.serpro.desktop.command.xml.sign.RequestSignedPropertiesXML;
import org.demoiselle.signer.serpro.desktop.command.xml.sign.ResponseSignedPropertiesXML;
import org.demoiselle.signer.serpro.desktop.pkcs11info.KeystoreSelection;
import org.demoiselle.signer.serpro.desktop.statistics.Statistics;
import org.demoiselle.signer.serpro.desktop.ui.PinHandler;
import org.demoiselle.signer.serpro.desktop.ui.PinHandlerFile;
import org.demoiselle.signer.serpro.desktop.utils.FileUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;

public class SignedPropertiesXML
extends AbstractCommand<RequestSignedPropertiesXML, ResponseSignedPropertiesXML> {
    private static final Logger logger = LoggerFactory.getLogger(SignedPropertiesXML.class);
    private Date certExpDate;

    @Override
    public ResponseSignedPropertiesXML doCommand(RequestSignedPropertiesXML request) throws Throwable {
        return this.doCommand(request, null);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public ResponseSignedPropertiesXML doCommand(RequestSignedPropertiesXML request, BatchSignatureContext batchSignatureContext) throws Throwable {
        Main.showLoadingScreen("");
        this.validateRequest(request);
        KeyStore keyStore = null;
        SerproSignerConfigurations configSigner = SerproSignerConfigurations.getInstance();
        ResponseSignedPropertiesXML response = new ResponseSignedPropertiesXML();
        boolean fromWeb = request.getHostConnected() != null && !request.getHostConnected().isEmpty();
        String prefix = request.getHostConnectedPrefix();
        String varAction = "Assinar";
        PinHandlerFile pinFile = new PinHandlerFile(varAction + this.getStringType(request.getType()), request.getHostConnectedPrefix());
        PinHandler pinToken = new PinHandler(varAction + this.getStringType(request.getType()), request.getHostConnectedPrefix());
        char[] pass = null;
        Statistics instaSta = new Statistics();
        Main.hideLoadingScreen();
        try {
            byte[] byteArrayOriginalInputData;
            TransformerFactory tf;
            Document docAss;
            Map.Entry<String, String> item;
            Main.showLoadingScreen(prefix);
            if (configSigner.isUseCertificateFile() || configSigner.isChooseFileCertificate()) {
                File filep12;
                pinToken = null;
                Main.hideLoadingScreen();
                if (configSigner.isChooseFileCertificate()) {
                    if (batchSignatureContext != null && batchSignatureContext.isKeyStoreSelected()) {
                        filep12 = new File(batchSignatureContext.getKeyStore());
                        pass = configSigner.getCertificateFilePass();
                    } else {
                        filep12 = FileUtil.selectA1Certificate();
                        pinFile.init();
                        if (pinFile.getActionCanceled()) throw new RuntimeException("Assinatura XML, com A1, cancelada pelo usu\u00e1rio");
                        pass = pinFile.getPwd();
                        configSigner.setCertificateFilePass(pass);
                    }
                } else {
                    filep12 = new File(configSigner.getCertificateFilePath());
                    if (configSigner.isSaveCertificateFilePass()) {
                        pass = configSigner.getCertificateFilePass();
                    } else {
                        pinFile.init();
                        if (pinFile.getActionCanceled()) throw new RuntimeException("Assinatura XML,com A1, cancelada pelo usu\u00e1rio");
                        pass = pinFile.getPwd();
                    }
                }
                KeyStoreLoader loader = KeyStoreLoaderFactory.factoryKeyStoreLoader(filep12);
                keyStore = loader.getKeyStore(String.copyValueOf(pass));
                if (batchSignatureContext != null && !batchSignatureContext.isKeyStoreSelected()) {
                    batchSignatureContext.setKeyStore(filep12.getAbsolutePath());
                }
            } else {
                KeystoreSelection ks;
                Iterator<Map.Entry<String, String>> it;
                pinFile = null;
                if (configSigner.isUseNeoId()) {
                    it = Configuration.getInstance().getDrivers().entrySet().iterator();
                    while (it.hasNext()) {
                        item = it.next();
                        if (item.getKey().contains("neoid")) continue;
                        it.remove();
                    }
                }
                if (configSigner.isSelectedToken()) {
                    it = Configuration.getInstance().getDrivers().entrySet().iterator();
                    while (it.hasNext()) {
                        item = it.next();
                        if (item.getKey().equalsIgnoreCase(configSigner.getTokenNameSelected())) continue;
                        it.remove();
                    }
                }
                if ((keyStore = (ks = new KeystoreSelection(pinToken, batchSignatureContext)).getKeyStore()) == null) {
                    response.setActionCanceled(true);
                    item = response;
                    return item;
                }
            }
            String alias = CertUtils.getAlias(request.getAlias(), keyStore, batchSignatureContext);
            if (response.getActionCanceled()) {
                item = response;
                return item;
            }
            X509Certificate cert = (X509Certificate)keyStore.getCertificate(alias);
            PrivateKey privateKey = null;
            privateKey = configSigner.isUseCertificateFile() || configSigner.isChooseFileCertificate() ? (PrivateKey)keyStore.getKey(alias, pass) : (PrivateKey)keyStore.getKey(alias, null);
            XMLSignedAttributes signedAttributes = new XMLSignedAttributes();
            signedAttributes.setCertificateChain(keyStore.getCertificateChain(alias));
            signedAttributes.setPrivateKey(privateKey);
            try {
                signedAttributes.setSignatureAlgorithm(request.getAlgorithm());
                String varSO = System.getProperty("os.name");
                if (varSO.contains("indows")) {
                    logger.info("Windows detectado, definindo algoritmo para SHA256");
                    signedAttributes.setSignatureAlgorithm("SHA256withRSA");
                }
            }
            catch (Throwable error) {
                signedAttributes.setSignatureAlgorithm("SHA256withRSA");
            }
            switch (request.getSignaturePolicy()) {
                case "RB": {
                    instaSta.setSignaturePolicy(PolicyFactory.Policies.AD_RB_XADES_2_4.name());
                    signedAttributes.setPolicyId(XMLPoliciesOID.AD_RB_XADES_2_4.getOID());
                    break;
                }
                case "RT": {
                    instaSta.setSignaturePolicy(PolicyFactory.Policies.AD_RT_XADES_2_4.name());
                    signedAttributes.setPolicyId(XMLPoliciesOID.AD_RT_XADES_2_4.getOID());
                    break;
                }
                case "RV": {
                    instaSta.setSignaturePolicy(PolicyFactory.Policies.AD_RV_XADES_2_4.name());
                    signedAttributes.setPolicyId(XMLPoliciesOID.AD_RV_XADES_2_4.getOID());
                    break;
                }
                case "RC": {
                    instaSta.setSignaturePolicy(PolicyFactory.Policies.AD_RC_XADES_2_4.name());
                    signedAttributes.setPolicyId(XMLPoliciesOID.AD_RC_XADES_2_4.getOID());
                    break;
                }
                case "RA": {
                    instaSta.setSignaturePolicy(PolicyFactory.Policies.AD_RA_XADES_2_4.name());
                    signedAttributes.setPolicyId(XMLPoliciesOID.AD_RA_XADES_2_4.getOID());
                    break;
                }
                default: {
                    instaSta.setSignaturePolicy(PolicyFactory.Policies.AD_RB_XADES_2_4.name());
                    signedAttributes.setPolicyId(XMLPoliciesOID.AD_RA_XADES_2_4.getOID());
                }
            }
            if (configSigner.isLcrOff()) {
                ConfigurationRepo.getInstance().setValidateLCR(false);
                logger.warn("Assinando sem valida\u00e7\u00e3o de LCR!");
            }
            if (request.getType().equalsIgnoreCase("hash")) {
                logger.info("assinando hashXML");
                Main.showLoadingScreen(prefix);
                for (String hash : request.getListOfInputData()) {
                    instaSta.setType("hashXML");
                    byte[] byteHash = Base64Utils.base64Decode(hash);
                    instaSta.setLengthOriginalContent(byteHash.length);
                    instaSta.setStart(System.currentTimeMillis());
                    docAss = signedAttributes.signEnveloped(byteHash);
                    tf = TransformerFactory.newInstance();
                    Transformer trans = tf.newTransformer();
                    StringWriter writer = new StringWriter();
                    trans.transform(new DOMSource(docAss), new StreamResult(writer));
                    if (request.getOutputDataType().equalsIgnoreCase("xml")) {
                        response.getListOfSignedProperties().add(writer.getBuffer().toString());
                    } else {
                        response.getListOfSignedProperties().add(Base64.toBase64String(writer.getBuffer().toString().getBytes()));
                    }
                    instaSta.setEnd(System.currentTimeMillis());
                    response.getListOfOriginalContents().add(hash);
                }
            } else if (request.getType().equalsIgnoreCase("xml")) {
                logger.info("assinando XML");
                for (String xml : request.getListOfInputData()) {
                    instaSta.setType("xml");
                    Main.showLoadingScreen(prefix);
                    instaSta.setStart(System.currentTimeMillis());
                    Document docAss2 = signedAttributes.signEnveloped(xml);
                    instaSta.setEnd(System.currentTimeMillis());
                    TransformerFactory tf2 = TransformerFactory.newInstance();
                    Transformer trans = tf2.newTransformer();
                    StringWriter writer = new StringWriter();
                    trans.transform(new DOMSource(docAss2), new StreamResult(writer));
                    if (request.getOutputDataType().equalsIgnoreCase("xml")) {
                        response.getListOfSignedProperties().add(writer.getBuffer().toString());
                    } else {
                        response.getListOfSignedProperties().add(Base64.toBase64String(writer.getBuffer().toString().getBytes()));
                    }
                    writer.close();
                    response.getListOfOriginalContents().add(xml);
                    instaSta.setSuccess(true);
                }
            } else if (request.getType().equalsIgnoreCase("xmlBase64")) {
                logger.info("Assinando xmlBase64");
                Main.showLoadingScreen(prefix);
                for (String xmlBase64 : request.getListOfInputData()) {
                    instaSta.setType("xmlBase64");
                    byteArrayOriginalInputData = Base64Utils.base64Decode(xmlBase64);
                    instaSta.setLengthOriginalContent(byteArrayOriginalInputData.length);
                    instaSta.setStart(System.currentTimeMillis());
                    docAss = signedAttributes.signEnveloped(byteArrayOriginalInputData);
                    tf = TransformerFactory.newInstance();
                    Transformer trans = tf.newTransformer();
                    StringWriter writer = new StringWriter();
                    trans.transform(new DOMSource(docAss), new StreamResult(writer));
                    if (request.getOutputDataType().equalsIgnoreCase("xml")) {
                        response.getListOfSignedProperties().add(writer.getBuffer().toString());
                    } else {
                        response.getListOfSignedProperties().add(Base64.toBase64String(writer.getBuffer().toString().getBytes()));
                    }
                    writer.close();
                    response.getListOfOriginalContents().add(xmlBase64);
                    instaSta.setEnd(System.currentTimeMillis());
                    instaSta.setSuccess(true);
                }
            } else if (request.getType().equalsIgnoreCase("contentBase64")) {
                logger.info("Assinando contentBase64");
                Main.showLoadingScreen(prefix);
                for (String contentBase64 : request.getListOfInputData()) {
                    instaSta.setType("contentBase64");
                    byteArrayOriginalInputData = Base64Utils.base64Decode(contentBase64);
                    instaSta.setLengthOriginalContent(byteArrayOriginalInputData.length);
                    instaSta.setStart(System.currentTimeMillis());
                    docAss = signedAttributes.signDetachedEnveloped(byteArrayOriginalInputData, "contentBase64");
                    tf = TransformerFactory.newInstance();
                    Transformer trans = tf.newTransformer();
                    StringWriter writer = new StringWriter();
                    trans.transform(new DOMSource(docAss), new StreamResult(writer));
                    if (request.getOutputDataType().equalsIgnoreCase("xml")) {
                        response.getListOfSignedProperties().add(writer.getBuffer().toString());
                    } else {
                        response.getListOfSignedProperties().add(Base64.toBase64String(writer.getBuffer().toString().getBytes()));
                    }
                    writer.close();
                    response.getListOfOriginalContents().add(contentBase64);
                    instaSta.setEnd(System.currentTimeMillis());
                    instaSta.setSuccess(true);
                }
            }
            response.setRequestId(request.getRequestId());
            response.setPublicKey(Base64Utils.base64Encode(cert.getPublicKey().getEncoded()));
            Certificate by = new Certificate();
            by.setAlias(alias);
            by.setProvider(keyStore.getProvider().getName());
            by.setSubject(cert.getSubjectDN().getName());
            SimpleDateFormat sdf = new SimpleDateFormat();
            sdf.setTimeZone(new SimpleTimeZone(0, "GMT"));
            sdf.applyPattern("dd MMM yyyy HH:mm:ss z");
            by.setNotAfter(sdf.format(cert.getNotAfter()));
            by.setNotBefore(sdf.format(cert.getNotBefore()));
            response.setNotAfterDateCertificate(cert.getNotAfter());
            this.setCertExpDate(cert.getNotAfter());
            response.setBy(by);
            response.setNotAfterDateCertificate(cert.getNotAfter());
            instaSta.setToken(keyStore.getProvider().getName());
            instaSta.setAlgorithm(signedAttributes.getSignatureAlgorithm());
            instaSta.setSuccess(true);
            BasicCertificate bc = new BasicCertificate(cert);
            try {
                instaSta.setCaURL(bc.getAuthorityInfoAccess().iterator().next());
            }
            catch (Throwable error) {
                logger.error(error.getMessage());
            }
            Main.hideLoadingScreen();
            logger.info("Assinado por: " + cert.getSubjectDN().getName());
            ConfigurationRepo.getInstance().setValidateLCR(true);
            ResponseSignedPropertiesXML responseSignedPropertiesXML = response;
            return responseSignedPropertiesXML;
        }
        catch (Throwable error) {
            instaSta.setSuccess(false);
            ConfigurationRepo.getInstance().setValidateLCR(true);
            if (error.getCause() != null && error.getCause() instanceof InvocationTargetException) {
                InvocationTargetException targetException = (InvocationTargetException)error.getCause();
                if (pinFile != null && pinFile.getActionCanceled()) {
                    response.setActionCanceled(true);
                    ResponseSignedPropertiesXML responseSignedPropertiesXML = response;
                    return responseSignedPropertiesXML;
                }
                if (pinToken != null && pinToken.getActionCanceled()) {
                    response.setActionCanceled(true);
                    ResponseSignedPropertiesXML responseSignedPropertiesXML = response;
                    return responseSignedPropertiesXML;
                }
                if (pinToken != null && !pinToken.getActionCanceled()) {
                    response.setActionCanceled(false);
                    throw new RuntimeException(error.getMessage(), error);
                }
                if (targetException.getTargetException() != null && targetException.getTargetException() instanceof LoginException) {
                    response.setActionCanceled(true);
                    ResponseSignedPropertiesXML responseSignedPropertiesXML = response;
                    return responseSignedPropertiesXML;
                }
                logger.error(error.getMessage());
                throw new RuntimeException(error.getMessage(), error);
            }
            logger.error(error.getMessage());
            throw new RuntimeException(error.getMessage(), error);
        }
        finally {
            ConfigurationRepo.getInstance().setValidateLCR(true);
            instaSta.setWeb(fromWeb);
            Thread trSign = new Thread(instaSta);
            trSign.start();
            Main.hideLoadingScreen();
        }
    }

    private String getStringType(String type) {
        if (type.equalsIgnoreCase("xml")) {
            return " XML";
        }
        if (type.equalsIgnoreCase("hash")) {
            return " Somente Resumo (Hash)";
        }
        if (type.equalsIgnoreCase("xmlBase64")) {
            return " Arquivo XML codificado em Base64";
        }
        if (type.equalsIgnoreCase("contentBase64")) {
            return " conte\u00fado em base64";
        }
        return "Desconhecido";
    }

    private void validateRequest(RequestSignedPropertiesXML request) throws RuntimeException {
        if (request.getType().isEmpty()) {
            throw new RuntimeException("N\u00e3o foi informado um tipo para assinatura em XML, use: xml||hash||xmlBase64||contentBase64 ");
        }
        if (!(request.getOutputDataType().equalsIgnoreCase("file") || request.getOutputDataType().equalsIgnoreCase("xml") || request.getOutputDataType().equalsIgnoreCase("base64"))) {
            throw new RuntimeException("Formato de saida desconhecido, use xml||hash||base64");
        }
        switch (request.getType().toLowerCase()) {
            case "xml": {
                if (request.getListOfInputData().isEmpty()) {
                    throw new RuntimeException("N\u00e3o foi fornecido  nenhum XML para ser assinado");
                }
                if (!request.getOutputDataType().equalsIgnoreCase("file")) break;
                throw new RuntimeException("Tipo XML n\u00e3o permite formato de saida file");
            }
            case "xmlbase64": {
                if (request.getListOfInputData().isEmpty()) {
                    throw new RuntimeException("N\u00e3o foi fornecido o base64 do XML para ser assinado");
                }
                if (!request.getOutputDataType().equalsIgnoreCase("file")) break;
                throw new RuntimeException("Tipo xmlBase64 n\u00e3o permite formato de saida file");
            }
            case "hash": {
                if (request.getListOfInputData().isEmpty()) {
                    throw new RuntimeException("N\u00e3o foi fornecido um resumo (Hash) para ser assinado");
                }
                if (!request.getOutputDataType().equalsIgnoreCase("file")) break;
                throw new RuntimeException("Tipo hash n\u00e3o permite formato de saida file");
            }
            case "contentbase64": {
                if (request.getListOfInputData().isEmpty()) {
                    throw new RuntimeException("N\u00e3o foi fornecido o base64 de um conte\u00fado para ser assinado");
                }
                if (!request.getOutputDataType().equalsIgnoreCase("file")) break;
                throw new RuntimeException("Tipo contentBase64 n\u00e3o permite formato de saida file");
            }
            default: {
                throw new RuntimeException("Tipo n\u00e3o reconhecido! Use: xml||hash||xmlBase64||contentBase64");
            }
        }
    }

    public Date getCertExpDate() {
        return this.certExpDate;
    }

    public void setCertExpDate(Date certExpDate) {
        this.certExpDate = certExpDate;
    }
}

