/*
 * Decompiled with CFR 0.152.
 */
package org.demoiselle.signer.serpro.desktop.command.verifier;

import java.lang.reflect.InvocationTargetException;
import java.security.cert.X509Certificate;
import java.util.List;
import java.util.StringTokenizer;
import org.demoiselle.signer.core.extension.BasicCertificate;
import org.demoiselle.signer.core.util.Base64Utils;
import org.demoiselle.signer.policy.impl.cades.SignatureInformations;
import org.demoiselle.signer.policy.impl.cades.pkcs7.impl.CAdESChecker;
import org.demoiselle.signer.serpro.desktop.Main;
import org.demoiselle.signer.serpro.desktop.command.AbstractCommand;
import org.demoiselle.signer.serpro.desktop.command.verifier.VerifyRequest;
import org.demoiselle.signer.serpro.desktop.command.verifier.VerifyResponse;
import org.demoiselle.signer.serpro.desktop.command.verifier.VerifySignerResponse;
import org.demoiselle.signer.serpro.desktop.statistics.Statistics;
import org.demoiselle.signer.serpro.desktop.ui.pdf.VerifyPDFSignature;
import org.demoiselle.signer.timestamp.Timestamp;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Verify
extends AbstractCommand<VerifyRequest, VerifyResponse> {
    private static final Logger logger = LoggerFactory.getLogger(Verify.class);

    @Override
    public VerifyResponse doCommand(VerifyRequest request) throws Throwable {
        this.validateRequest(request);
        try {
            CAdESChecker checker = new CAdESChecker();
            List<SignatureInformations> signaturesInfo = null;
            String varTipo = request.getType();
            boolean fromWeb = request.getHostConnected() != null && !request.getHostConnected().isEmpty();
            Statistics instaSta = new Statistics();
            switch (varTipo.toLowerCase()) {
                case "hash": {
                    logger.info("verificando Hash");
                    instaSta.setType("verify hash");
                    String hash = request.getInputData();
                    String varSignature = request.getInputSignature();
                    String varOidHash = request.getAlgorithmOIDHash();
                    byte[] byteArrayOriginalInputData = Base64Utils.base64Decode(hash);
                    byte[] byteArrayOriginalInputSignature = Base64Utils.base64Decode(varSignature);
                    instaSta.setStart(System.currentTimeMillis());
                    if (varOidHash != null && varOidHash.length() > 0) {
                        logger.info("verificando Hash com algoritimo:" + varOidHash);
                        signaturesInfo = checker.checkSignatureByHash(varOidHash, byteArrayOriginalInputData, byteArrayOriginalInputSignature);
                    } else {
                        logger.info("verificando Hash");
                        signaturesInfo = checker.checkSignatureByHash(byteArrayOriginalInputData, byteArrayOriginalInputSignature);
                    }
                    instaSta.setEnd(System.currentTimeMillis());
                    break;
                }
                case "text": {
                    logger.info("verificando Texto");
                    instaSta.setType("verify text");
                    byte[] byteArrayOriginalInputData = this.contentToBytes(request.getInputData(), request.getTextEncoding());
                    byte[] byteArrayOriginalInputSignature = Base64Utils.base64Decode(request.getInputSignature());
                    instaSta.setStart(System.currentTimeMillis());
                    signaturesInfo = checker.checkDetachedSignature(byteArrayOriginalInputData, byteArrayOriginalInputSignature);
                    instaSta.setEnd(System.currentTimeMillis());
                    break;
                }
                case "base64": {
                    byte[] byteArrayOriginalInputData;
                    logger.info("verificando Base64");
                    instaSta.setType("verify Base64");
                    byte[] byteArrayOriginalInputSignature = Base64Utils.base64Decode(request.getInputSignature());
                    if (request.getInputData() != null && !request.getInputData().isEmpty()) {
                        byteArrayOriginalInputData = Base64Utils.base64Decode(request.getInputData());
                        logger.info("verificando Base64 com cont\u00e9udo desanexado");
                        instaSta.setStart(System.currentTimeMillis());
                        signaturesInfo = checker.checkDetachedSignature(byteArrayOriginalInputData, byteArrayOriginalInputSignature);
                        instaSta.setEnd(System.currentTimeMillis());
                        break;
                    }
                    logger.info("verificando Base64 anexada");
                    instaSta.setStart(System.currentTimeMillis());
                    signaturesInfo = checker.checkAttachedSignature(byteArrayOriginalInputSignature);
                    instaSta.setEnd(System.currentTimeMillis());
                    break;
                }
                case "pdf": {
                    logger.info("verificando pdf assinado");
                    instaSta.setType("verify PDF");
                    byte[] byteArrayOriginalInputData = Base64Utils.base64Decode(request.getInputData());
                    instaSta.setStart(System.currentTimeMillis());
                    VerifyPDFSignature verifyPDF = new VerifyPDFSignature(byteArrayOriginalInputData);
                    instaSta.setEnd(System.currentTimeMillis());
                    signaturesInfo = verifyPDF.verifySignature();
                    break;
                }
            }
            VerifyResponse verifyResponse = new VerifyResponse();
            verifyResponse.setRequestId(request.getRequestId());
            if (signaturesInfo != null) {
                instaSta.setSuccess(true);
                int numberOfSignature = 0;
                for (SignatureInformations si : signaturesInfo) {
                    Timestamp varTimeStamp;
                    VerifySignerResponse verifySignerResponse = new VerifySignerResponse();
                    if (!si.getValidatorErrors().isEmpty()) {
                        verifySignerResponse.setValidatorErrors(si.getValidatorErrors());
                        verifySignerResponse.setHasError(true);
                        verifyResponse.setHasError(true);
                    }
                    if (!si.getValidatorWarnins().isEmpty()) {
                        verifySignerResponse.setValidatorWarnings(si.getValidatorWarnins());
                        verifySignerResponse.setHasWarning(true);
                        verifyResponse.setHasWaring(true);
                    }
                    if ((varTimeStamp = si.getTimeStampSigner()) != null) {
                        String text = "Carimbo do Tempo emitido em:" + varTimeStamp.getTimeStamp() + ", Pela autoridade:" + varTimeStamp.getTimeStampAuthorityInfo() + ") N\u00famero de s\u00e9rie:" + varTimeStamp.getSerialNumber();
                        verifySignerResponse.setTimeStampSigner(text);
                    }
                    if (si.getSignDateGMT() != null && !si.getSignDateGMT().isEmpty()) {
                        verifySignerResponse.setSignDate(si.getSignDateGMT());
                    }
                    if (si.getSignaturePolicy() != null) {
                        String policy = si.getSignaturePolicy().getSignPolicyURI();
                        StringTokenizer st = new StringTokenizer(policy);
                        String part = st.nextToken("/");
                        part = st.nextToken("/");
                        part = st.nextToken("/");
                        verifySignerResponse.setSignaturePolicy(part);
                    }
                    if (si.getIcpBrasilcertificate() != null) {
                        BasicCertificate signerBasicCertificate = si.getIcpBrasilcertificate();
                        if (signerBasicCertificate.hasCertificatePF()) {
                            verifySignerResponse.setPF(true);
                            verifySignerResponse.setValCPF_CNPJ(signerBasicCertificate.getICPBRCertificatePF().getCPF());
                        } else {
                            verifySignerResponse.setPF(false);
                            verifySignerResponse.setValCPF_CNPJ(signerBasicCertificate.getICPBRCertificatePJ().getCNPJ());
                        }
                        verifySignerResponse.setAssinante(signerBasicCertificate.getName());
                    }
                    if (si.getChain() == null) continue;
                    for (X509Certificate cert : si.getChain()) {
                        BasicCertificate certificateCA = new BasicCertificate(cert);
                        if (!certificateCA.isCACertificate()) continue;
                        verifySignerResponse.getCadeiaCertificado().add(certificateCA.getName());
                    }
                    ++numberOfSignature;
                    verifyResponse.getSignerSignatureValidations().add(verifySignerResponse);
                }
                verifyResponse.setNumberOfSignatures(numberOfSignature);
            } else {
                verifyResponse.setValid(false);
                verifyResponse.setHasError(true);
                instaSta.setSuccess(false);
            }
            instaSta.setWeb(fromWeb);
            Thread trVerify = new Thread(instaSta);
            trVerify.start();
            VerifyResponse verifyResponse2 = verifyResponse;
            return verifyResponse2;
        }
        catch (Throwable error) {
            Main.hideLoadingScreen();
            if (error.getCause() != null && error.getCause() instanceof InvocationTargetException) {
                logger.error(error.getMessage());
                throw new RuntimeException(error.getMessage(), error);
            }
            logger.error("Erro na valida\u00e7\u00e3o" + error.getMessage());
            throw new RuntimeException(error.getMessage(), error);
        }
        finally {
            Main.hideLoadingScreen();
        }
    }

    private void validateRequest(VerifyRequest request) throws Exception {
        if (request.getType().isEmpty()) {
            logger.error("N\u00e3o foi informado um tipo para assinatura em XML, use: file||pdf||hash||text||base64 ");
            throw new Exception("N\u00e3o foi informado um tipo (type) para assinatura em XML, use: file||pdf||hash||text||base64 ");
        }
        if (!request.getType().equalsIgnoreCase("pdf") && request.getInputSignature().equals("")) {
            logger.error("N\u00e3o foi fornecida (inputSignature) a assinatura (em Base64) para ser validada");
            throw new Exception("N\u00e3o foi fornecida (inputSignature) a assinatura (em Base64) para ser validada");
        }
        if (request.getType().equalsIgnoreCase("hash") && request.getInputData().equals("")) {
            logger.error("N\u00e3o foi fornecido (inputData)com um resumo  de arquivo (Hash) para ser validado");
            throw new Exception("N\u00e3o foi fornecido (inputData)com um resumo  de arquivo (Hash) para ser validado");
        }
        if (request.getType().equalsIgnoreCase("text") && request.getInputData().equals("")) {
            logger.error("N\u00e3o foi fornecido (inputData) um texto para ser validado");
            throw new Exception("N\u00e3o foi fornecido um texto para ser validado");
        }
        if (request.getType().equalsIgnoreCase("pdf") && request.getInputData().equals("")) {
            logger.error("N\u00e3o foi fornecido (inputData) o arquivo PDF (em base64) para ser validado");
            throw new Exception("N\u00e3o foi fornecido (inputData) o arquivo PDF (em base64) para ser validado");
        }
    }
}

